/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlSchedule;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.grammar.host.DeltaHostGraph;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.lts.AbstractGraphState;
import groove.lts.DefaultGraphNextState;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.GraphTransitionKey;
import groove.lts.GraphTransitionStub;
import groove.lts.MatchCollector;
import groove.lts.MatchResult;
import groove.lts.MatchResultSet;
import groove.lts.RecipeTransition;
import groove.lts.RuleTransition;
import groove.transform.DeltaApplier;
import groove.transform.Record;
import groove.transform.RuleApplication;
import groove.util.Pair;
import groove.util.collect.KeySet;
import groove.util.collect.SetView;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class StateCache {
    private MatchCollector matcher;
    private MatchResultSet matches;
    private List<MatchResult> latestMatches;
    private Set<GraphTransitionStub> stubSet;
    private final AbstractGraphState state;
    private final Record record;
    private DeltaApplier delta;
    private KeySet<GraphTransitionKey, GraphTransition> transitionMap;
    private DeltaHostGraph graph;
    private final List<Pair<StateCache, RuleTransition>> rawParents = new ArrayList<Pair<StateCache, RuleTransition>>();
    private final Set<GraphState> transientOpens = new HashSet<GraphState>();
    private final Set<RuleTransition> partials = new HashSet<RuleTransition>();
    private boolean present;
    private final boolean freezeGraphs;
    private final DeltaHostGraph graphFactory;
    private static final int FREEZE_BOUND = 10;
    private static final List<MatchResult> EMPTY_MATCH_SET = Collections.emptyList();

    protected StateCache(AbstractGraphState state) {
        this.state = state;
        this.present = !state.isTransient();
        this.record = state.getRecord();
        this.freezeGraphs = this.record.isCollapse();
        this.graphFactory = DeltaHostGraph.getInstance(this.record.isCopyGraphs());
    }

    boolean addTransition(GraphTransition trans) {
        assert (trans.source() == this.getState());
        boolean result = this.getStubSet().add(trans.toStub());
        if (result && this.transitionMap != null) {
            this.transitionMap.add(trans);
        }
        if (trans instanceof RuleTransition) {
            this.matches.remove(trans.getKey());
            if (trans.isPartial()) {
                this.addOutPartial((RuleTransition)trans);
            }
        }
        this.maybeSetClosed();
        return result;
    }

    Set<? extends GraphTransition> getTransitions(final GraphTransition.Class claz) {
        if (claz == GraphTransition.Class.ANY) {
            return this.getTransitionMap();
        }
        return new SetView<GraphTransition>(this.getTransitionMap()){

            @Override
            public boolean approves(Object obj) {
                return obj instanceof GraphTransition && claz.admits((GraphTransition)obj);
            }
        };
    }

    private void addOutPartial(RuleTransition partial) {
        this.notifyPartial(partial, partial);
        GraphState child = partial.target();
        StateCache childCache = child.getCache();
        this.present |= childCache.present;
        if (child.isTransient()) {
            if (!child.isDone()) {
                childCache.rawParents.add(Pair.newPair(this, partial));
            }
            for (RuleTransition childPartial : child.getCache().partials) {
                this.notifyPartial(childPartial, partial);
            }
        }
    }

    private void notifyPartial(RuleTransition partial, RuleTransition initial) {
        GraphState target = partial.target();
        if (target.isTransient() && !target.isClosed()) {
            this.transientOpens.add(target);
        }
        if (this.getState().isTransient()) {
            if (this.partials.add(partial)) {
                this.present |= !target.isTransient();
                for (Pair<StateCache, RuleTransition> parent : this.rawParents) {
                    parent.one().notifyPartial(partial, parent.two());
                }
            }
        } else if (!target.isTransient()) {
            this.getState().getGTS().addTransition(new RecipeTransition(this.getState(), initial, target));
        }
    }

    void notifyClosed() {
        if (this.getState().isTransient()) {
            this.fireChanged(this.getState());
        }
        if (this.transientOpens.isEmpty()) {
            this.setStateDone();
        }
    }

    private void notifyChildChanged(GraphState child, RuleTransition initial) {
        if (this.transientOpens.remove(child)) {
            this.present |= !child.isTransient();
            if (this.getState().isTransient()) {
                this.fireChanged(child);
            }
        }
        if (!this.getState().isTransient() && !child.isTransient()) {
            this.getState().getGTS().addTransition(new RecipeTransition(this.getState(), initial, child));
        }
        if (this.transientOpens.isEmpty() && this.getState().isClosed()) {
            this.setStateDone();
        }
    }

    void notifyDone() {
        this.rawParents.clear();
    }

    void fireChanged(GraphState state) {
        for (Pair<StateCache, RuleTransition> parent : this.rawParents) {
            parent.one().notifyChildChanged(state, parent.two());
        }
    }

    private void setStateDone() {
        this.getState().setDone(this.present);
    }

    final AbstractGraphState getState() {
        return this.state;
    }

    final DeltaHostGraph getGraph() {
        if (this.graph == null) {
            this.graph = this.computeGraph();
        }
        return this.graph;
    }

    final boolean hasGraph() {
        return this.graph != null;
    }

    final DeltaApplier getDelta() {
        if (this.delta == null) {
            this.delta = this.createDelta();
        }
        return this.delta;
    }

    final boolean isPresent() {
        return this.present;
    }

    private DeltaApplier createDelta() {
        DeltaApplier result = null;
        if (this.state instanceof DefaultGraphNextState) {
            DefaultGraphNextState state = (DefaultGraphNextState)this.state;
            return new RuleApplication(state.getEvent(), state.source().getGraph(), state.getAddedNodes());
        }
        return result;
    }

    private DeltaHostGraph computeGraph() {
        DeltaHostGraph result;
        HostElement[] frozenGraph = this.state.getFrozenGraph();
        if (frozenGraph != null) {
            result = this.graphFactory.newGraph(this.getState().toString(), frozenGraph, this.record.getFactory());
        } else {
            if (!(this.state instanceof GraphNextState)) {
                throw new IllegalStateException("Underlying state does not have information to reconstruct the graph");
            }
            int depth = 0;
            DefaultGraphNextState state = (DefaultGraphNextState)this.state;
            AbstractGraphState backward = state.source();
            LinkedList<DefaultGraphNextState> stateChain = new LinkedList<DefaultGraphNextState>();
            while (backward instanceof GraphNextState && !backward.hasCache() && backward.getFrozenGraph() == null) {
                stateChain.add(0, (DefaultGraphNextState)backward);
                backward = ((DefaultGraphNextState)backward).source();
                ++depth;
            }
            result = (DeltaHostGraph)backward.getGraph();
            for (DefaultGraphNextState forward : stateChain) {
                result = this.graphFactory.newGraph(state.toString(), result, forward.getDelta());
            }
            result = this.graphFactory.newGraph(state.toString(), result, this.getDelta());
            if (this.getState().isClosed() && this.isFreezeGraph(depth)) {
                state.setFrozenGraph(this.computeFrozenGraph(result));
            }
        }
        return result;
    }

    private boolean isFreezeGraph(int freezeCount) {
        return this.freezeGraphs && freezeCount > 10;
    }

    HostElement[] computeFrozenGraph(HostGraph graph) {
        HostElement[] result = new HostElement[graph.size()];
        int index = 0;
        for (HostNode node : graph.nodeSet()) {
            result[index] = node;
            ++index;
        }
        for (HostEdge edge : graph.edgeSet()) {
            result[index] = edge;
            ++index;
        }
        return result;
    }

    RuleTransition getRuleTransition(MatchResult match) {
        return (RuleTransition)this.getTransitionMap().get(match);
    }

    KeySet<GraphTransitionKey, GraphTransition> getTransitionMap() {
        if (this.transitionMap == null) {
            this.transitionMap = this.computeTransitionMap();
        }
        return this.transitionMap;
    }

    private KeySet<GraphTransitionKey, GraphTransition> computeTransitionMap() {
        KeySet<GraphTransitionKey, GraphTransition> result = new KeySet<GraphTransitionKey, GraphTransition>(){

            @Override
            protected GraphTransitionKey getKey(Object value) {
                return ((GraphTransition)value).getKey();
            }
        };
        for (GraphTransitionStub stub : this.getStubSet()) {
            GraphTransition trans = stub.toTransition(this.state);
            result.add(trans);
        }
        return result;
    }

    Set<GraphTransitionStub> getStubSet() {
        if (this.stubSet == null) {
            this.stubSet = this.computeStubSet();
        }
        return this.stubSet;
    }

    void clearStubSet() {
        this.stubSet = null;
    }

    private Set<GraphTransitionStub> computeStubSet() {
        Set<GraphTransitionStub> result = this.createStubSet();
        result.addAll(this.state.getStoredTransitionStubs());
        return result;
    }

    private Set<GraphTransitionStub> createStubSet() {
        return new TreeHashSet<GraphTransitionStub>(){

            @Override
            protected boolean areEqual(GraphTransitionStub stub, GraphTransitionStub otherStub) {
                return this.getKey(stub).equals(this.getKey(otherStub));
            }

            @Override
            protected int getCode(GraphTransitionStub stub) {
                GraphTransitionKey keyEvent = this.getKey(stub);
                return keyEvent == null ? 0 : keyEvent.hashCode();
            }

            private GraphTransitionKey getKey(GraphTransitionStub stub) {
                return stub.getKey(StateCache.this.getState());
            }
        };
    }

    MatchResultSet getMatches() {
        if (this.matches == null) {
            this.matches = new MatchResultSet();
        }
        while (this.trySchedule()) {
        }
        return this.matches;
    }

    MatchResult getMatch() {
        MatchResult result = null;
        if (this.matches == null) {
            this.matches = new MatchResultSet();
        }
        while (this.matches.isEmpty() && this.trySchedule()) {
        }
        if (!this.matches.isEmpty()) {
            result = (MatchResult)this.matches.iterator().next();
        }
        return result;
    }

    private boolean trySchedule() {
        boolean result = false;
        CtrlSchedule schedule = this.getState().getSchedule();
        boolean isTransient = schedule.isTransient();
        if (schedule.isTried()) {
            boolean allAbsent = true;
            boolean somePresent = false;
            Iterator<MatchResult> matchIter = this.latestMatches.iterator();
            while (matchIter.hasNext()) {
                MatchResult m = matchIter.next();
                GraphTransition t = this.getTransitionMap().get(m);
                if (t == null) {
                    allAbsent = false;
                    continue;
                }
                GraphState target = t.target();
                if (target.isPresent()) {
                    somePresent = true;
                    break;
                }
                if (target.isAbsent()) {
                    matchIter.remove();
                    continue;
                }
                allAbsent = false;
            }
            if (somePresent || allAbsent) {
                schedule = schedule.next(somePresent);
                this.getState().setSchedule(schedule);
                this.latestMatches = EMPTY_MATCH_SET;
            }
        }
        if (schedule.isFinished()) {
            this.maybeSetClosed();
        } else if (!schedule.isTried()) {
            CtrlSchedule nextSchedule;
            boolean transientTargets = false;
            LinkedList<MatchResult> latestMatches = new LinkedList<MatchResult>();
            for (CtrlTransition ct : schedule.getTransitions()) {
                latestMatches.addAll(this.getMatchCollector().computeMatches(ct));
                transientTargets |= ((CtrlState)ct.target()).isTransient();
            }
            if (latestMatches.isEmpty()) {
                nextSchedule = schedule.next(false);
            } else if (schedule.next(true) == schedule.next(false)) {
                nextSchedule = schedule.next(false);
            } else if (schedule.isTransient() || !transientTargets) {
                nextSchedule = schedule.next(true);
            } else {
                nextSchedule = schedule.toTriedSchedule();
                this.latestMatches = latestMatches;
            }
            this.getState().setSchedule(nextSchedule);
            this.matches.addAll(latestMatches);
            result = true;
        }
        if (isTransient && !this.getState().isTransient()) {
            this.present = true;
            this.fireChanged(this.getState());
        }
        return result;
    }

    private MatchCollector getMatchCollector() {
        if (this.matcher == null) {
            this.matcher = this.createMatchCollector();
        }
        return this.matcher;
    }

    protected MatchCollector createMatchCollector() {
        return new MatchCollector(this.getState());
    }

    private void maybeSetClosed() {
        if (this.matches.isEmpty() && this.getState().getSchedule().isFinished()) {
            this.getState().setClosed(true);
        }
    }

    public String toString() {
        return "StateCache [state=" + this.state + "]";
    }
}

