/*
 * Decompiled with CFR 0.152.
 */
package groove.match;

import groove.grammar.Condition;
import groove.grammar.host.AnchorValue;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.RuleToHostMap;
import groove.transform.Proof;
import groove.util.Fixable;
import groove.util.Property;
import groove.util.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TreeMatch
implements Fixable {
    private final Condition.Op op;
    private final Condition condition;
    private final RuleToHostMap patternMap;
    private final Collection<TreeMatch> subMatches;
    private final Visitor.Collector<Proof, List<Proof>> collector;
    private final ProofWrapperVisitor wrapper = new ProofWrapperVisitor();
    private int hashCode;

    public TreeMatch(Condition condition, RuleToHostMap patternMap) {
        this.condition = condition;
        this.op = condition.getOp();
        this.subMatches = this.createSubMatches(condition.getOp());
        this.patternMap = patternMap;
        this.collector = new ProofWrapperCollector(null);
        assert (condition.hasPattern() == (patternMap != null));
    }

    public TreeMatch(Condition.Op op, Condition condition) {
        assert (!op.hasPattern());
        this.condition = condition;
        this.op = op;
        this.subMatches = this.createSubMatches(op);
        this.patternMap = null;
        this.collector = Visitor.newCollector();
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final Condition.Op getOp() {
        return this.op;
    }

    public final RuleToHostMap getPatternMap() {
        return this.patternMap;
    }

    public final Collection<TreeMatch> getSubMatches() {
        return this.subMatches;
    }

    private Collection<TreeMatch> createSubMatches(Condition.Op op) {
        return op.isConjunctive() ? new ArrayList() : new HashSet();
    }

    public final boolean addSubMatch(TreeMatch subMatch) {
        assert (!this.isFixed());
        return this.subMatches.add(subMatch);
    }

    public final boolean addSubMatches(Collection<TreeMatch> subMatches) {
        assert (!this.isFixed());
        return this.subMatches.addAll(subMatches);
    }

    public <R> R traverseProofs(Visitor<Proof, R> visitor) {
        this.setFixed();
        switch (this.op) {
            case FORALL: 
            case OR: {
                this.traverseOrProofs(visitor);
                break;
            }
            case EXISTS: 
            case AND: {
                this.traverseAndProofs(visitor);
                break;
            }
            case TRUE: {
                visitor.visit(Proof.TrueProof);
                break;
            }
            case FALSE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return visitor.getResult();
    }

    private void traverseAndProofs(Visitor<Proof, ?> visitor) {
        int subMatchCount = this.getSubMatches().size();
        if (subMatchCount == 0) {
            assert (this.op == Condition.Op.EXISTS);
            visitor.visit(this.createProof());
        } else {
            List[] matrix = new List[subMatchCount];
            int[] rowSize = new int[subMatchCount];
            int resultSize = this.computeProofMatrix(matrix, rowSize);
            if (resultSize > 0) {
                this.traverseMatrix(matrix, rowSize, visitor);
            }
        }
    }

    private void traverseOrProofs(Visitor<Proof, ?> visitor) {
        Visitor subVisitor = this.getOp().hasPattern() ? this.wrapper.newInstance(visitor) : visitor;
        for (TreeMatch subMatch : this.subMatches) {
            subMatch.traverseProofs(subVisitor);
            if (!subVisitor.isContinue()) break;
        }
    }

    public List<Proof> toProofSet() {
        this.setFixed();
        switch (this.op) {
            case FORALL: 
            case OR: {
                return this.toOrProofSet();
            }
            case EXISTS: 
            case AND: {
                return this.toAndProofSet();
            }
            case TRUE: {
                return Collections.singletonList(Proof.TrueProof);
            }
            case FALSE: {
                return Collections.emptyList();
            }
        }
        assert (false);
        return null;
    }

    private List<Proof> toAndProofSet() {
        List<Proof> result;
        int subMatchCount = this.getSubMatches().size();
        if (subMatchCount == 0) {
            result = new ArrayList<Proof>(1);
            result.add(this.createProof());
        } else {
            List[] matrix = new List[subMatchCount];
            int[] rowSize = new int[subMatchCount];
            int resultSize = this.computeProofMatrix(matrix, rowSize);
            if (resultSize == 0) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList(resultSize);
                Visitor.Collector collector = Visitor.newCollector(result);
                this.traverseMatrix(matrix, rowSize, collector);
                collector.dispose();
            }
        }
        return result;
    }

    private List<Proof> toOrProofSet() {
        ArrayList<Proof> result = new ArrayList<Proof>();
        Visitor.Collector collector = this.collector.newInstance(result);
        for (TreeMatch subMatch : this.subMatches) {
            subMatch.traverseProofs(collector);
        }
        collector.dispose();
        return result;
    }

    private void traverseMatrix(List<Proof>[] matrix, int[] rowSize, Visitor<Proof, ?> visitor) {
        Proof proof;
        int rowCount = rowSize.length;
        int[] index = new int[rowCount];
        do {
            proof = this.createProof();
            Collection<Proof> subMatches = proof.getSubProofs();
            int row = 0;
            while (row < rowCount) {
                Proof subProof = matrix[row].get(index[row]);
                if (subProof.isComposite()) {
                    subMatches.addAll(subProof.getSubProofs());
                } else {
                    subMatches.add(subProof);
                }
                ++row;
            }
        } while (visitor.visit(proof) && this.incVector(index, rowSize));
    }

    private int computeProofMatrix(List<Proof>[] matrix, int[] rowSize) {
        int resultSize = 1;
        int i = 0;
        for (TreeMatch subMatch : this.getSubMatches()) {
            List<Proof> row = subMatch.toProofSet();
            matrix[i] = row;
            if ((resultSize *= row.size()) == 0) break;
            rowSize[i] = row.size();
            ++i;
        }
        return resultSize;
    }

    private Proof createProof() {
        return new Proof(this.getCondition(), this.getPatternMap());
    }

    private boolean incVector(int[] vector, int[] size) {
        boolean result;
        assert (vector.length == size.length);
        int dim = size.length - 1;
        while (dim >= 0 && vector[dim] == size[dim] - 1) {
            vector[dim] = 0;
            --dim;
        }
        boolean bl = result = dim >= 0;
        if (result) {
            int n = dim;
            vector[n] = vector[n] + 1;
        }
        return result;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.computeHashCode();
            if (result == 0) {
                result = 1;
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.getCondition().hashCode();
        if (this.op.hasPattern()) {
            int patternHashCode = 1;
            if (this.getCondition().hasRule()) {
                Anchor anchor = this.getCondition().getRule().getAnchor();
                int i = 0;
                while (i < anchor.size()) {
                    AnchorKey key = (AnchorKey)anchor.get(i);
                    AnchorValue value = this.getPatternMap().get(key);
                    patternHashCode = 31 * patternHashCode + value.hashCode();
                    ++i;
                }
            } else {
                patternHashCode = this.getPatternMap().hashCode();
            }
            result = 31 * result + patternHashCode;
        }
        result = 31 * result + this.getSubMatches().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        assert (this.isFixed());
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TreeMatch)) {
            return false;
        }
        TreeMatch other = (TreeMatch)obj;
        assert (other.isFixed());
        if (!other.getOp().equals((Object)this.getOp())) {
            return false;
        }
        if (!other.getCondition().equals(this.getCondition())) {
            return false;
        }
        if (this.getSubMatches().size() != other.getSubMatches().size()) {
            return false;
        }
        if (this.getOp().hasPattern()) {
            RuleToHostMap myMap = this.getPatternMap();
            RuleToHostMap hisMap = other.getPatternMap();
            if (this.getCondition().hasRule()) {
                Anchor anchor = this.getCondition().getRule().getAnchor();
                int i = 0;
                while (i < anchor.size()) {
                    AnchorKey key = (AnchorKey)anchor.get(i);
                    if (!myMap.get(key).equals(hisMap.get(key))) {
                        return false;
                    }
                    ++i;
                }
            } else if (!this.getPatternMap().equals(other.getPatternMap())) {
                return false;
            }
        }
        return this.getSubMatches().equals(other.getSubMatches());
    }

    public String toString() {
        return this.toString(0).toString();
    }

    private StringBuilder toString(int level) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < level) {
            result.append("  ");
            ++i;
        }
        result.append(this.getCondition().getName());
        result.append(" (");
        result.append((Object)this.getOp());
        result.append("): ");
        result.append(this.getPatternMap());
        result.append('\n');
        for (TreeMatch subMatch : this.getSubMatches()) {
            result.append((CharSequence)subMatch.toString(level + 1));
        }
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.hashCode();
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.hashCode != 0;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    private class ProofWrapperCollector
    extends Visitor.Collector<Proof, List<Proof>> {
        public ProofWrapperCollector() {
            super(null);
        }

        private ProofWrapperCollector(List<Proof> collection) {
            super(collection);
        }

        @Override
        protected boolean process(Proof visitedProof) {
            Proof newProof = TreeMatch.this.createProof();
            if (visitedProof.isComposite()) {
                newProof.getSubProofs().addAll(visitedProof.getSubProofs());
            } else {
                newProof.getSubProofs().add(visitedProof);
            }
            return super.process(newProof);
        }

        @Override
        protected Visitor.Collector<Proof, List<Proof>> createInstance(List<Proof> collection, Property<Proof> property) {
            return new ProofWrapperCollector(collection);
        }
    }

    private class ProofWrapperVisitor<R>
    extends Visitor<Proof, R> {
        private Visitor<Proof, R> visitor;

        public ProofWrapperVisitor() {
            this(null);
        }

        private ProofWrapperVisitor(Visitor<Proof, R> visitor) {
            this.visitor = visitor;
        }

        @Override
        protected boolean process(Proof visitedProof) {
            Proof newProof = TreeMatch.this.createProof();
            if (visitedProof.isComposite()) {
                newProof.getSubProofs().addAll(visitedProof.getSubProofs());
            } else {
                newProof.getSubProofs().add(visitedProof);
            }
            return this.visitor.visit(newProof);
        }

        public <T> ProofWrapperVisitor<R> newInstance(Visitor<Proof, R> visitor) {
            if (this.isDisposed()) {
                this.visitor = visitor;
                this.resurrect();
                return this;
            }
            return new ProofWrapperVisitor<R>(visitor);
        }
    }
}

