/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.host.HostGraph;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleNode;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.HashSet;

class NegatedSearchItem
extends AbstractSearchItem {
    final SearchItem inner;
    private final Collection<RuleNode> neededNodes;
    private final Collection<LabelVar> neededVars;

    public NegatedSearchItem(SearchItem item) {
        this.inner = item;
        this.neededNodes = new HashSet<RuleNode>(item.needsNodes());
        this.neededNodes.addAll(item.bindsNodes());
        this.neededVars = new HashSet<LabelVar>(item.needsVars());
        this.neededVars.addAll(item.bindsVars());
    }

    @Override
    public NegatedSearchRecord createRecord(PlanSearchStrategy.Search search) {
        return new NegatedSearchRecord(search);
    }

    public String toString() {
        return String.format("Negation of %s", this.inner);
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return this.neededNodes;
    }

    @Override
    public Collection<LabelVar> needsVars() {
        return this.neededVars;
    }

    @Override
    public boolean isTestsNodes() {
        return this.inner.isTestsNodes();
    }

    @Override
    int getRating() {
        return 0;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.inner.activate(strategy);
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        NegatedSearchItem other = (NegatedSearchItem)item;
        return this.inner.compareTo(other.inner);
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() + 31 * this.inner.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.inner.equals(((NegatedSearchItem)obj).inner);
    }

    private class NegatedSearchRecord
    extends AbstractSearchItem.SingularRecord {
        private final SearchItem.Record innerRecord;

        NegatedSearchRecord(PlanSearchStrategy.Search search) {
            super(search);
            this.innerRecord = NegatedSearchItem.this.inner.createRecord(search);
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.innerRecord.initialise(host);
        }

        @Override
        boolean find() {
            boolean result = !this.innerRecord.next();
            this.innerRecord.reset();
            return result;
        }

        @Override
        void erase() {
        }

        @Override
        boolean write() {
            return true;
        }
    }
}

