/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGuard;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.Edge2SearchItem;
import groove.match.plan.PlanSearchStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

class VarEdgeSearchItem
extends Edge2SearchItem {
    private final LabelVar var;
    private final Collection<RuleEdge> boundEdges;
    private final Collection<LabelVar> boundVars;
    int varIx;
    boolean varFound;
    private final TypeGuard guard;
    private static final HostEdgeSet EMPTY_IMAGE_SET = new HostEdgeSet();

    public VarEdgeSearchItem(RuleEdge edge) {
        super(edge);
        this.guard = ((RuleLabel)edge.label()).getWildcardGuard();
        this.var = this.guard.getVar();
        this.boundVars = Collections.singleton(this.var);
        this.boundEdges = Collections.singleton(edge);
        assert (this.var != null) : String.format("Edge %s is not a variable edge", edge);
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return this.boundEdges;
    }

    @Override
    public Collection<LabelVar> bindsVars() {
        return this.boundVars;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        super.activate(strategy);
        if (this.var.hasName()) {
            this.varFound = strategy.isVarFound(this.var);
            this.varIx = strategy.getVarIx(this.var);
        } else {
            this.varIx = -1;
        }
    }

    @Override
    boolean isSingular(PlanSearchStrategy.Search search) {
        return super.isSingular(search) && this.varIx >= 0 && (this.varFound || search.getVarSeed(this.varIx) != null);
    }

    @Override
    AbstractSearchItem.SingularRecord createSingularRecord(PlanSearchStrategy.Search search) {
        return new VarEdgeSingularRecord(search, this.edgeIx, this.sourceIx, this.targetIx, this.varIx);
    }

    @Override
    AbstractSearchItem.MultipleRecord<HostEdge> createMultipleRecord(PlanSearchStrategy.Search search) {
        return new VarEdgeMultipleRecord(search, this.edgeIx, this.sourceIx, this.targetIx, this.varIx, this.sourceFound, this.targetFound, this.varFound);
    }

    boolean isGuardSatisfied(TypeElement type) {
        return this.guard.isSatisfied(type);
    }

    private class VarEdgeMultipleRecord
    extends Edge2SearchItem.Edge2MultipleRecord {
        private TypeEdge varSeed;
        private final int varIx;
        private final boolean varFound;
        private TypeElement varFind;

        VarEdgeMultipleRecord(PlanSearchStrategy.Search search, int edgeIx, int sourceIx, int targetIx, int varIx, boolean sourceFound, boolean targetFound, boolean varFound) {
            super(search, edgeIx, sourceIx, targetIx, sourceFound, targetFound);
            this.varFound = varFound;
            this.varIx = varIx;
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            if (this.varIx >= 0) {
                this.varSeed = (TypeEdge)this.search.getVarSeed(this.varIx);
            }
        }

        @Override
        void init() {
            this.varFind = this.varSeed;
            if (this.varFind == null && this.varFound) {
                this.varFind = this.search.getVar(this.varIx);
            }
            super.init();
        }

        @Override
        void initImages() {
            Set<HostEdge> edgeSet = this.varFind != null ? (VarEdgeSearchItem.this.isGuardSatisfied(this.varFind) ? this.host.edgeSet(this.varFind.label()) : EMPTY_IMAGE_SET) : (this.sourceFind != null ? this.host.outEdgeSet(this.sourceFind) : (this.targetFind != null ? this.host.inEdgeSet(this.targetFind) : this.host.edgeSet()));
            this.initImages(edgeSet);
        }

        @Override
        boolean write(HostEdge image) {
            boolean result;
            boolean bl = result = VarEdgeSearchItem.this.isGuardSatisfied(image.getType()) && super.write(image);
            if (result && this.varFind == null && this.varIx >= 0) {
                result = this.search.putVar(this.varIx, image.getType());
            }
            return result;
        }

        @Override
        void erase() {
            super.erase();
            if (this.varFind == null && this.varIx >= 0) {
                this.search.putVar(this.varIx, null);
            }
        }
    }

    private class VarEdgeSingularRecord
    extends Edge2SearchItem.Edge2SingularRecord {
        private TypeEdge varSeed;
        private final int varIx;

        VarEdgeSingularRecord(PlanSearchStrategy.Search search, int edgeIx, int sourceIx, int targetIx, int varIx) {
            super(search, edgeIx, sourceIx, targetIx);
            this.varIx = varIx;
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.varSeed = (TypeEdge)this.search.getVarSeed(this.varIx);
        }

        @Override
        TypeEdge getType() {
            TypeEdge result = this.varSeed;
            if (result == null) {
                result = (TypeEdge)this.search.getVar(this.varIx);
            }
            return result;
        }

        @Override
        boolean isImageCorrect(HostEdge image) {
            return VarEdgeSearchItem.this.isGuardSatisfied(image.getType()) && super.isImageCorrect(image);
        }
    }
}

