/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.graph.Label;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.DominoEventListener;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteStateSubscriber;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractPathChecker
extends ReteNetworkNode
implements ReteStateSubscriber {
    protected RuleEdge[] pattern;
    protected RegExpr expression;
    protected final boolean loop;
    private final PathMatchCache cache;

    public AbstractPathChecker(ReteNetwork network, RegExpr expression, boolean isLoop) {
        super(network);
        assert (network != null && expression != null);
        this.expression = expression;
        RuleFactory f = RuleFactory.newInstance();
        RuleNode n1 = f.createNode(f.getMaxNodeNr());
        RuleNode n2 = isLoop ? n1 : f.createNode(f.getMaxNodeNr());
        this.pattern = new RuleEdge[]{f.createEdge(n1, (Label)new RuleLabel(expression), n2)};
        this.loop = isLoop;
        this.cache = new PathMatchCache();
        this.getOwner().getState().subscribe(this);
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    public RegExpr getExpression() {
        return this.expression;
    }

    public boolean isPositivePathGenerator() {
        return this.getExpression().isAcceptsEmptyWord() || this.getExpression().getNegOperand() != null;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch match) {
        assert (match instanceof RetePathMatch);
        this.receive(source, repeatIndex, (RetePathMatch)match);
    }

    public abstract void receive(ReteNetworkNode var1, int var2, RetePathMatch var3);

    @Override
    public boolean equals(ReteNetworkNode node) {
        return this == node || node instanceof AbstractPathChecker && this.getOwner().equals(node.getOwner()) && this.expression.equals(((AbstractPathChecker)node).getExpression());
    }

    @Override
    public int size() {
        return -this.getExpression().getOperands().size();
    }

    public String toString() {
        return "- Path-checker for: " + this.getExpression().toString();
    }

    public boolean isLoop() {
        return this.loop;
    }

    @Override
    protected void passDownMatchToSuccessors(AbstractReteMatch m) {
        ReteNetworkNode previous = null;
        int repeatCount = 0;
        RetePathMatch ent = null;
        if (!((RetePathMatch)m).isEmpty()) {
            ent = this.cache.addMatch((RetePathMatch)m);
        }
        for (ReteNetworkNode n : this.getSuccessors()) {
            int n2 = repeatCount = n != previous ? 0 : repeatCount + 1;
            if (n instanceof AbstractPathChecker || ((RetePathMatch)m).isEmpty()) {
                n.receive(this, repeatCount, m);
            } else if (ent != null) {
                n.receive(this, repeatCount, ent);
            }
            previous = n;
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    protected static class CacheEntry {
        private final RetePathMatch representative;
        private int count;

        public CacheEntry(RetePathMatch rep) {
            this.representative = rep;
            this.count = 1;
        }

        public void increment() {
            ++this.count;
        }

        public boolean decrement() {
            assert (this.count >= 0);
            --this.count;
            return this.count == 0;
        }

        public int getCount() {
            return this.count;
        }

        public RetePathMatch getRepresentative() {
            return this.representative;
        }

        public String toString() {
            return String.format("Cache Entry key for %s. count: %d", this.representative.getCacheKey(), this.count);
        }
    }

    public static class PathMatchCache
    implements DominoEventListener {
        private HashMap<Object, CacheEntry> entries = new HashMap();

        @Override
        public void matchRemoved(AbstractReteMatch match) {
            RetePathMatch pm = this.removeMatch((RetePathMatch)match);
            if (pm != null) {
                pm.dominoDelete(null);
            }
        }

        public void clear() {
            this.entries.clear();
        }

        public RetePathMatch addMatch(RetePathMatch pm) {
            RetePathMatch result = null;
            RetePathMatch.Key pair = pm.getCacheKey();
            CacheEntry entry = this.entries.get(pair);
            if (entry == null) {
                result = RetePathMatch.duplicate(pm);
                entry = new CacheEntry(result);
                this.entries.put(pair, entry);
            } else {
                entry.increment();
            }
            pm.addDominoListener(this);
            return result;
        }

        public RetePathMatch removeMatch(RetePathMatch pm) {
            RetePathMatch result = null;
            RetePathMatch.Key pair = pm.getCacheKey();
            CacheEntry entry = this.entries.get(pair);
            assert (entry != null);
            if (entry.decrement()) {
                this.entries.remove(pair);
                result = entry.getRepresentative();
            }
            return result;
        }

        public String toString() {
            return String.format("Path Cache size=%d", this.entries.size());
        }
    }
}

