/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.HostNodeTreeHashSet;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteStateSubscriber;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ClosurePathChecker
extends AbstractPathChecker
implements ReteStateSubscriber {
    private RetePathMatch.EmptyPathMatch emptyMatch = new RetePathMatch.EmptyPathMatch(this);
    private final Set<RetePathMatch> leftMemory;
    private final Set<RetePathMatch> rightMemory;

    public ClosurePathChecker(ReteNetwork network, RegExpr expression, boolean isLoop) {
        super(network, expression, isLoop);
        assert (expression.getPlusOperand() != null || expression.getStarOperand() != null);
        if (expression.isStar()) {
            this.getOwner().getState().subscribe(this);
        }
        this.leftMemory = new HashSet<RetePathMatch>();
        this.rightMemory = new HashSet<RetePathMatch>();
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, RetePathMatch newMatch) {
        if (this.loop && !newMatch.isEmpty() && !newMatch.start().equals(newMatch.end())) {
            return;
        }
        this.receiveNewIncomingMatch(source, newMatch);
    }

    private void receiveLoopBackMatches(Collection<RetePathMatch> loopBackMatches, int recursionCounter) {
        LinkedList<RetePathMatch> resultingNewMatches = new LinkedList<RetePathMatch>();
        for (RetePathMatch loopBackMatch : loopBackMatches) {
            this.rightMemory.add(loopBackMatch);
            loopBackMatch.addContainerCollection(this.rightMemory);
            for (RetePathMatch left : this.leftMemory) {
                RetePathMatch combined;
                if (!this.test(left, loopBackMatch) || (combined = this.construct(left, loopBackMatch)) == null) continue;
                resultingNewMatches.add(combined);
            }
        }
        if (resultingNewMatches.size() > 0) {
            this.passDownMatches(resultingNewMatches);
            if (recursionCounter > 0) {
                this.receiveLoopBackMatches(resultingNewMatches, recursionCounter - 1);
            }
        }
    }

    private void receiveNewIncomingMatch(ReteNetworkNode source, RetePathMatch newMatch) {
        LinkedList<RetePathMatch> resultingMatches = new LinkedList<RetePathMatch>();
        RetePathMatch m = new RetePathMatch((ReteNetworkNode)this, newMatch);
        m.setClosureInfo(new ClosureInfo(m));
        resultingMatches.add(m);
        if (newMatch.start().equals(newMatch.end())) {
            this.passDownMatches(resultingMatches);
        } else {
            this.leftMemory.add(newMatch);
            newMatch.addContainerCollection(this.leftMemory);
            for (RetePathMatch right : this.rightMemory) {
                RetePathMatch combined;
                if (!this.test(newMatch, right) || (combined = this.construct(newMatch, right)) == null) continue;
                resultingMatches.add(combined);
            }
            this.passDownMatches(resultingMatches);
            if (!this.loop) {
                this.receiveLoopBackMatches(resultingMatches, this.getOwner().getState().getHostGraph().nodeCount());
            }
        }
    }

    private void passDownMatches(Collection<RetePathMatch> theMatches) {
        for (RetePathMatch m : theMatches) {
            if (this.loop && !m.isEmpty() && m.start() != m.end()) continue;
            this.passDownMatchToSuccessors(m);
        }
    }

    protected boolean test(RetePathMatch left, RetePathMatch right) {
        return left.isEmpty() || right.isEmpty() || left.end().equals(right.start());
    }

    protected RetePathMatch construct(RetePathMatch left, RetePathMatch right) {
        assert (!right.isEmpty());
        RetePathMatch result = null;
        if (!left.isEmpty()) {
            assert (right.getOrigin() == this && right.getClosureInfo() != null);
            ClosureInfo ci2 = right.getClosureInfo();
            ClosureInfo combinedInfo = ci2.getExtension(left);
            if (combinedInfo != null) {
                result = left.concatenate(this, right, false);
                result.setClosureInfo(combinedInfo);
            }
        }
        return result;
    }

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.leftMemory.clear();
        this.rightMemory.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        super.initialize();
        if (this.getExpression().isStar()) {
            this.passDownMatchToSuccessors(this.emptyMatch);
        }
        return null;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    protected static class ClosureInfo {
        private final ReteNetworkNode origin;
        private final HostNodeTreeHashSet relevantNodes;
        private final HostNode end;

        protected ClosureInfo(ClosureInfo original) {
            this.origin = original.origin;
            this.relevantNodes = new HostNodeSet((Collection<? extends HostNode>)original.relevantNodes);
            this.end = original.end;
        }

        public ClosureInfo(RetePathMatch closureBaseMatch) {
            this.origin = closureBaseMatch.getOrigin();
            this.relevantNodes = new HostNodeSet();
            this.relevantNodes.add(closureBaseMatch.start());
            this.end = closureBaseMatch.end();
            closureBaseMatch.getOrigin();
        }

        public ClosureInfo getExtension(RetePathMatch left) {
            ClosureInfo result = null;
            if (left.getOrigin() == this.origin) {
                ClosureInfo other = left.getClosureInfo();
                result = new ClosureInfo(this);
                for (HostNode newNode : other.relevantNodes) {
                    if (result.relevantNodes.add(newNode)) continue;
                    result = null;
                    break;
                }
            } else {
                HostNode newNode = left.start();
                if (newNode != this.end && !this.relevantNodes.contains(newNode)) {
                    result = new ClosureInfo(this);
                    result.relevantNodes.add(left.start());
                }
            }
            return result;
        }

        public ClosureInfo getExtension(ClosureInfo left) {
            ClosureInfo result = new ClosureInfo(this);
            for (HostNode newNode : left.relevantNodes) {
                if (result.relevantNodes.add(newNode)) continue;
                result = null;
                break;
            }
            return result;
        }
    }
}

