/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.AtomPathChecker;
import groove.match.rete.ChoicePathChecker;
import groove.match.rete.ClosurePathChecker;
import groove.match.rete.EmptyPathChecker;
import groove.match.rete.InversionPathChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.SequenceOperatorPathChecker;
import groove.match.rete.WildcardEdgePathChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class PathCheckerFactory {
    private ReteNetwork owner;
    private HashMap<String, Set<AbstractPathChecker>> pathCheckers = new HashMap();

    public PathCheckerFactory(ReteNetwork owner) {
        this.owner = owner;
    }

    public AbstractPathChecker getPathCheckerFor(RegExpr exp, boolean loop) {
        Set<AbstractPathChecker> candidates = this.pathCheckers.get(exp.toString());
        AbstractPathChecker result = null;
        if (candidates == null) {
            candidates = new HashSet<AbstractPathChecker>();
            result = this.create(exp, loop);
            candidates.add(result);
            this.pathCheckers.put(exp.toString(), candidates);
        } else {
            for (AbstractPathChecker pc : candidates) {
                if (pc.isLoop() != loop) continue;
                result = pc;
                break;
            }
            if (result == null) {
                result = this.create(exp, loop);
                candidates.add(result);
            }
        }
        return result;
    }

    private AbstractPathChecker create(RegExpr exp, boolean isLoop) {
        AbstractPathChecker result = null;
        List<Object> operands = null;
        if (exp.isAtom()) {
            operands = Collections.emptyList();
            result = new AtomPathChecker(this.owner, (RegExpr.Atom)exp, isLoop);
            this.owner.getRoot().addSuccessor(result);
        } else if (exp.isChoice()) {
            operands = ((RegExpr.Choice)exp).getChoiceOperands();
            result = new ChoicePathChecker(this.owner, (RegExpr.Choice)exp, isLoop);
        } else if (exp.isInv()) {
            operands = new ArrayList();
            operands.add(exp.getInvOperand());
            result = new InversionPathChecker(this.owner, (RegExpr.Inv)exp, isLoop);
        } else {
            if (exp.isNeg()) {
                throw new UnsupportedOperationException("Negation is not supported by this factory.");
            }
            if (exp.isPlus() || exp.isStar()) {
                operands = new ArrayList();
                operands.add(exp.isPlus() ? exp.getPlusOperand() : exp.getStarOperand());
                result = new ClosurePathChecker(this.owner, exp, isLoop);
            } else if (exp.isSeq()) {
                operands = exp.getSeqOperands();
                if (operands.size() == 2) {
                    result = new SequenceOperatorPathChecker(this.owner, exp, isLoop);
                } else {
                    result = this.buildBinaryTree(exp, isLoop);
                    operands = Collections.emptyList();
                }
            } else if (exp.isEmpty()) {
                operands = Collections.emptyList();
                result = EmptyPathChecker.getInstance(this.owner);
                this.owner.getRoot().addSuccessor(result);
            } else if (exp.isWildcard()) {
                operands = Collections.emptyList();
                if (this.owner.getTypeGraph().isNodeType(exp.getWildcardKind())) {
                    throw new UnsupportedOperationException();
                }
                result = new WildcardEdgePathChecker(this.owner, (RegExpr.Wildcard)exp, isLoop);
                this.owner.getRoot().addSuccessor(result);
            }
        }
        if (result != null) {
            boolean loop = operands.size() == 1 ? isLoop : false;
            for (RegExpr operand : operands) {
                AbstractPathChecker pc = this.getPathCheckerFor(operand, loop);
                result.addAntecedent(pc);
                pc.addSuccessor(result);
            }
        }
        return result;
    }

    private AbstractPathChecker buildBinaryTree(RegExpr exp, boolean isLoop) {
        List<RegExpr> operands = exp.getOperands();
        assert (exp.isSeq() || exp.isChoice() && operands.size() >= 2);
        Stack<AbstractPathChecker> checkers = new Stack<AbstractPathChecker>();
        for (RegExpr op : operands) {
            checkers.push(this.getPathCheckerFor(op, false));
        }
        while (checkers.size() > 1) {
            AbstractPathChecker pc2 = (AbstractPathChecker)checkers.pop();
            AbstractPathChecker pc1 = (AbstractPathChecker)checkers.pop();
            ArrayList<RegExpr> ops = new ArrayList<RegExpr>();
            ops.add(pc1.getExpression());
            ops.add(pc2.getExpression());
            RegExpr.Infix e = exp.isSeq() ? new RegExpr.Seq(ops) : new RegExpr.Choice(ops);
            AbstractPathChecker combined = this.getPathCheckerFor(e, checkers.size() == 0 ? isLoop : false);
            checkers.push(combined);
        }
        return (AbstractPathChecker)checkers.pop();
    }

    public HashMap<String, Set<AbstractPathChecker>> getPathCheckersMap() {
        return this.pathCheckers;
    }
}

