/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.Rule;
import groove.match.rete.CompositeConditionChecker;
import groove.match.rete.ConditionChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.util.Reporter;
import groove.util.collect.TreeHashSet;
import java.util.Iterator;
import java.util.Set;

public class ProductionNode
extends ConditionChecker {
    protected static final Reporter reporter = Reporter.register(ProductionNode.class);
    protected static final Reporter demandOneMatchReporter = reporter.register("demandOneMatch");

    public ProductionNode(ReteNetwork network, Rule p, ReteNetwork.ReteStaticMapping antecedents) {
        super(network, p.getCondition(), null, antecedents);
    }

    @Override
    public void addSuccessor(ReteNetworkNode nnode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object node) {
        return this == node || node != null && node instanceof ProductionNode && this.getProductionRule().equals(((ProductionNode)node).getProductionRule());
    }

    @Override
    public int hashCode() {
        return this.getProductionRule().hashCode();
    }

    public Rule getProductionRule() {
        return this.getCondition().getRule();
    }

    @Override
    public Set<ReteSimpleMatch> getConflictSet() {
        Set<ReteSimpleMatch> result;
        if (this.getProductionRule().isModifying() || this.isEmpty()) {
            result = super.getConflictSet();
        } else {
            result = new TreeHashSet<ReteSimpleMatch>();
            Set cs = this.conflictSet;
            if (this.hasNacs()) {
                this.demandUpdateOnlyIfNecessary();
            }
            if (!this.inhibitionMap.isEmpty() && cs.size() > 0) {
                for (ReteSimpleMatch m : cs) {
                    if (this.isInhibited(m)) continue;
                    result.add(m);
                    break;
                }
            } else if (cs.size() > 0) {
                result.add((ReteSimpleMatch)cs.iterator().next());
            } else {
                demandOneMatchReporter.start();
                if (this.demandOneMatch() > 0) {
                    result.add((ReteSimpleMatch)cs.iterator().next());
                }
                demandOneMatchReporter.stop();
            }
        }
        return result;
    }

    private void demandUpdateOnlyIfNecessary() {
        if (this.conflictSet.size() == this.inhibitionMap.elementSet().size()) {
            this.demandUpdate();
        } else if (!this.allNacsUpToDate()) {
            this.demandUpdate();
        }
    }

    protected boolean allNacsUpToDate() {
        boolean result = this.hasNacs();
        if (result) {
            for (ConditionChecker cc : this.getSubConditionCheckers()) {
                if (!(cc instanceof CompositeConditionChecker)) continue;
                boolean bl = result = result && ((CompositeConditionChecker)cc).isNegativePartUpToDate();
            }
        }
        return result;
    }

    @Override
    public Iterator<ReteSimpleMatch> getConflictSetIterator() {
        if (!this.getProductionRule().isModifying()) {
            return this.getConflictSet().iterator();
        }
        return super.getConflictSetIterator();
    }
}

