/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.match.rete.AbstractReteMatch;
import groove.match.rete.DominoEventListener;
import groove.match.rete.LookupEntry;
import groove.match.rete.QuantifierCountChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.SubgraphCheckerNode;
import groove.util.collect.TreeHashSet;
import java.util.HashMap;
import java.util.Set;

public class QuantifierCountSubgraphChecker
extends SubgraphCheckerNode<AbstractReteMatch, ReteSimpleMatch.ReteCountMatch>
implements DominoEventListener {
    protected ReteSimpleMatch.ReteCountMatch dummyCountMatch = null;
    protected QuantifierCountChecker countCheckerNode = null;
    protected HashMap<ReteSimpleMatch.ReteCountMatch, Set<AbstractReteMatch>> countBindings = new HashMap();

    public QuantifierCountSubgraphChecker(ReteNetwork network, ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right) {
        super(network, left, right);
        assert (right.getNNode() instanceof QuantifierCountChecker);
        this.countCheckerNode = (QuantifierCountChecker)right.getNNode();
    }

    @Override
    protected int receiveAndProcess(ReteNetworkNode source, boolean first, AbstractReteMatch match) {
        if (this.isLeftAntecedent(source, first)) {
            return this.receiveLeftMatch(source, first, match);
        }
        return this.receiveRightMatch((ReteSimpleMatch.ReteCountMatch)match);
    }

    private int receiveRightMatch(ReteSimpleMatch.ReteCountMatch countMatch) {
        assert (!this.countBindings.containsKey(countMatch));
        int result = 0;
        countMatch.addDominoListener(this);
        TreeHashSet toBeDeletedFromLeft = new TreeHashSet();
        if (!countMatch.isDummy()) {
            this.rightMemory.add(countMatch);
            countMatch.addContainerCollection(this.rightMemory);
        }
        for (AbstractReteMatch left : this.leftMemory) {
            AbstractReteMatch combined;
            if (!this.joinStrategy.test(left, countMatch) || (combined = this.joinStrategy.construct(left, countMatch)) == null) continue;
            ++result;
            toBeDeletedFromLeft.add(left);
            this.mapToCountMatch(left, countMatch);
            this.passDownMatchToSuccessors(combined);
        }
        for (AbstractReteMatch m : toBeDeletedFromLeft) {
            m.removeContainerCollection(this.leftMemory);
            this.leftMemory.remove(m);
        }
        toBeDeletedFromLeft.clear();
        if (countMatch.isDummy()) {
            this.dummyCountMatch = countMatch;
            assert (this.leftMemory.size() == 0);
        }
        return result;
    }

    private int receiveLeftMatch(ReteNetworkNode source, boolean first, AbstractReteMatch left) {
        int result = 0;
        if (this.isCountBindingPossible()) {
            for (ReteSimpleMatch.ReteCountMatch right : this.rightMemory) {
                AbstractReteMatch combined;
                if (!this.joinStrategy.test(left, right) || (combined = this.joinStrategy.construct(left, right)) == null) continue;
                result = 1;
                this.mapToCountMatch(left, right);
                this.passDownMatchToSuccessors(combined);
                break;
            }
            if (result == 0 && this.dummyCountMatch != null) {
                AbstractReteMatch combined = this.joinStrategy.construct(left, this.dummyCountMatch);
                assert (combined != null);
                result = 1;
                this.mapToCountMatch(left, this.dummyCountMatch);
                this.passDownMatchToSuccessors(combined);
            }
        } else {
            this.leftMemory.add(left);
            left.addContainerCollection(this.leftMemory);
        }
        return result;
    }

    private void mapToCountMatch(AbstractReteMatch left, ReteSimpleMatch.ReteCountMatch countMatch) {
        Set<AbstractReteMatch> boundMatches = this.countBindings.get(countMatch);
        if (boundMatches == null) {
            boundMatches = new TreeHashSet<AbstractReteMatch>();
            this.countBindings.put(countMatch, boundMatches);
        }
        boundMatches.add(left);
        left.addContainerCollection(boundMatches);
    }

    @Override
    protected void selectJoinStrategy(ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right) {
        if (!(left.getNNode() instanceof QuantifierCountChecker) && right.getNNode() instanceof QuantifierCountChecker) {
            this.joinStrategy = new JoinWithCountStrategy(this);
        } else if (left.getNNode() instanceof QuantifierCountChecker && !(right.getNNode() instanceof QuantifierCountChecker)) {
            throw new UnsupportedOperationException(String.format("Left is of type %s and right is of type %s", left.getNNode().getClass().toString(), right.getNNode().getClass().toString()));
        }
    }

    protected boolean isCountBindingPossible() {
        return this.countCheckerNode.isConstant() || this.dummyCountMatch != null;
    }

    @Override
    public void matchRemoved(AbstractReteMatch match) {
        ReteSimpleMatch.ReteCountMatch countMatch = (ReteSimpleMatch.ReteCountMatch)match;
        Set<AbstractReteMatch> boundMatches = this.countBindings.get(countMatch);
        if (boundMatches != null) {
            for (AbstractReteMatch left : boundMatches) {
                this.leftMemory.add(left);
                left.addContainerCollection(this.leftMemory);
            }
            boundMatches.clear();
            this.countBindings.remove(countMatch);
        }
        if (countMatch.isDummy()) {
            this.dummyCountMatch = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.dummyCountMatch = null;
        this.countBindings.clear();
    }

    protected static class JoinWithCountStrategy<LT extends AbstractReteMatch>
    extends SubgraphCheckerNode.AbstractSimpleTestJoinStrategy<LT, ReteSimpleMatch.ReteCountMatch> {
        final LookupEntry[] leftAnchorLookup;

        public JoinWithCountStrategy(SubgraphCheckerNode<?, ?> sgChecker) {
            super(sgChecker);
            assert (!(sgChecker.getAntecedents().get(0) instanceof QuantifierCountChecker) && sgChecker.getAntecedents().get(1) instanceof QuantifierCountChecker);
            QuantifierCountChecker qcc = (QuantifierCountChecker)sgChecker.getAntecedents().get(1);
            this.leftAnchorLookup = new LookupEntry[qcc.getPattern().length - 1];
            LookupEntry[] leftTable = this.subgraphChecker.getLeftLookupTable();
            LookupEntry[] rightTable = this.subgraphChecker.getRightLookupTable();
            int i = 0;
            while (i < leftTable.length) {
                LookupEntry leftEntry = leftTable[i];
                LookupEntry rightEntry = rightTable[i];
                this.leftAnchorLookup[rightEntry.getPos()] = leftEntry;
                ++i;
            }
        }

        @Override
        public boolean test(LT left, ReteSimpleMatch.ReteCountMatch right) {
            if (right.isDummy()) {
                return true;
            }
            return super.test(left, right);
        }

        @Override
        public AbstractReteMatch construct(LT left, ReteSimpleMatch.ReteCountMatch right) {
            if (right.isDummy()) {
                return right.dummyMerge(this.subgraphChecker, (AbstractReteMatch)left, this.subgraphChecker.shouldPreservePrefix, this.leftAnchorLookup);
            }
            return ReteSimpleMatch.merge((ReteNetworkNode)this.subgraphChecker, left, (AbstractReteMatch)right, this.subgraphChecker.shouldPreservePrefix, false);
        }
    }
}

