/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.algebra.Constant;
import groove.automaton.RegExpr;
import groove.grammar.Condition;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleGraphMorphism;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeComparator;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainNode;
import groove.io.FileType;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.CompositeConditionChecker;
import groove.match.rete.ConditionChecker;
import groove.match.rete.DataOperatorChecker;
import groove.match.rete.DefaultNodeChecker;
import groove.match.rete.DisconnectedSubgraphChecker;
import groove.match.rete.EdgeCheckerNode;
import groove.match.rete.LookupEntry;
import groove.match.rete.NegativeFilterSubgraphCheckerNode;
import groove.match.rete.NodeChecker;
import groove.match.rete.PathCheckerFactory;
import groove.match.rete.ProductionNode;
import groove.match.rete.QuantifierCountChecker;
import groove.match.rete.QuantifierCountSubgraphChecker;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSearchEngine;
import groove.match.rete.ReteStateSubscriber;
import groove.match.rete.RootNode;
import groove.match.rete.SubgraphCheckerNode;
import groove.match.rete.ValueNodeChecker;
import groove.util.Groove;
import groove.util.collect.TreeHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReteNetwork {
    private final String grammarName;
    private final TypeGraph typeGraph;
    private final boolean injective;
    private final RootNode root;
    private final HashMap<TypeNode, DefaultNodeChecker> defaultNodeCheckers = new HashMap();
    private final HashMap<Rule, ProductionNode> productionNodes = new HashMap();
    private final HashMap<Condition, ConditionChecker> conditionCheckerNodes = new HashMap();
    private final ArrayList<CompositeConditionChecker> compositeConditionCheckerNodes = new ArrayList();
    private final HashMap<Constant, ValueNodeChecker> valueNodeCheckerNodes = new HashMap();
    private final HashMap<Condition, QuantifierCountChecker> quantifierCountCheckerNodes = new HashMap();
    private final PathCheckerFactory pathCheckerFactory = new PathCheckerFactory(this);
    private ReteState state;
    private HostFactory hostFactory = null;
    private boolean updating = false;
    private final ReteSearchEngine ownerEngine;

    public ReteNetwork(ReteSearchEngine engine, Grammar g, boolean enableInjectivity) {
        this.grammarName = g.getName();
        this.typeGraph = g.getTypeGraph();
        this.injective = enableInjectivity;
        this.root = new RootNode(this);
        this.state = new ReteState(this);
        this.build(g.getAllRules());
        this.ownerEngine = engine;
    }

    public void build(Collection<Rule> rules) {
        Collection<Rule> shuffledRules = rules;
        for (Rule p : shuffledRules) {
            this.addConditionToNetwork(p.getCondition(), null);
        }
    }

    private void addConditionToNetwork(Condition condition, ConditionChecker parent) {
        ConditionChecker result = null;
        StaticMap openList = new StaticMap();
        TreeHashSet<RuleEdge> emptyAndNegativePathEdges = new TreeHashSet<RuleEdge>();
        TreeHashSet<OperatorNode> operatorNodes = new TreeHashSet<OperatorNode>();
        this.mapQuantifierCountNodes(openList, condition);
        this.mapEdgesAndNodes(openList, condition.getPattern(), emptyAndNegativePathEdges, operatorNodes);
        if (openList.size() > 0) {
            StaticMap toBeDeleted = new StaticMap();
            boolean changes = false;
            HashSet<ReteStaticMapping> isolatedComponents = new HashSet<ReteStaticMapping>();
            while (openList.size() > 1 && isolatedComponents.size() < openList.size() || !operatorNodes.isEmpty()) {
                toBeDeleted.clear();
                int i = 0;
                while (i < openList.size()) {
                    ReteStaticMapping m = (ReteStaticMapping)openList.get(i);
                    if (!toBeDeleted.contains(m)) {
                        for (ReteNetworkNode suc : m.getNNode().getSuccessors()) {
                            ReteNetworkNode other;
                            ReteStaticMapping otherM;
                            if (!(suc instanceof SubgraphCheckerNode) || (otherM = openList.getFirstMappingFor(other = ((SubgraphCheckerNode)suc).getOtherAntecedent(m.getNNode()), m)) == null || toBeDeleted.containsNNode(other) || !((SubgraphCheckerNode)suc).checksValidSubgraph(m, otherM)) continue;
                            toBeDeleted.add(m);
                            toBeDeleted.add(otherM);
                            ReteStaticMapping sucMapping = ReteStaticMapping.combine(m, otherM, (SubgraphCheckerNode)suc);
                            openList.add(sucMapping);
                            changes = true;
                            break;
                        }
                    }
                    ++i;
                }
                for (ReteStaticMapping n : toBeDeleted) {
                    openList.remove(n);
                }
                toBeDeleted.clear();
                while (!(changes || isolatedComponents.size() >= openList.size() && operatorNodes.isEmpty())) {
                    ReteStaticMapping m2;
                    ReteStaticMapping m1 = this.pickTheNextLargestCheckerNode(openList, isolatedComponents);
                    ReteStaticMapping reteStaticMapping = m2 = m1 != null ? this.pickCheckerNodeConnectedTo(openList, m1) : null;
                    if (m2 != null) {
                        if (m1.getNNode() instanceof QuantifierCountChecker && !(m2.getNNode() instanceof QuantifierCountChecker)) {
                            ReteStaticMapping temp = m1;
                            m1 = m2;
                            m2 = temp;
                        }
                        SubgraphCheckerNode sgc = m2.getNNode() instanceof QuantifierCountChecker ? new QuantifierCountSubgraphChecker(this, m1, m2) : new SubgraphCheckerNode(this, m1, m2);
                        ReteStaticMapping newCombinedMapping = ReteStaticMapping.combine(m1, m2, sgc);
                        toBeDeleted.add(m1);
                        toBeDeleted.add(m2);
                        openList.add(newCombinedMapping);
                        changes = true;
                        continue;
                    }
                    if (m1 != null) {
                        isolatedComponents.add(m1);
                        continue;
                    }
                    if (operatorNodes.isEmpty()) break;
                    ArrayList<ReteStaticMapping> argumentSources = new ArrayList<ReteStaticMapping>();
                    OperatorNode opNode = this.pickOneOperatorNode(openList, operatorNodes, argumentSources);
                    ReteStaticMapping inputAntecedent = null;
                    assert (argumentSources.size() > 0);
                    inputAntecedent = argumentSources.size() == 1 ? (ReteStaticMapping)argumentSources.get(0) : this.createDisjointJoin(argumentSources);
                    toBeDeleted.addAll(argumentSources);
                    DataOperatorChecker operatorNode = new DataOperatorChecker(this, inputAntecedent, opNode);
                    ReteStaticMapping opCheckerMapping = ReteStaticMapping.mapDataOperatorNode(operatorNode, opNode, inputAntecedent);
                    openList.add(opCheckerMapping);
                    assert (opNode != null);
                    operatorNodes.remove(opNode);
                    changes = true;
                }
                changes = false;
                for (ReteStaticMapping mappingToDelete : toBeDeleted) {
                    openList.remove(mappingToDelete);
                }
            }
            if (openList.size() >= 1) {
                if (openList.size() > 1) {
                    ReteStaticMapping disjointMerge = this.createDisjointJoin(openList);
                    openList.clear();
                    openList.add(disjointMerge);
                }
                if (emptyAndNegativePathEdges.size() > 0) {
                    this.addEmptyWordAcceptingAndNegativePathCheckers(openList, emptyAndNegativePathEdges, false);
                }
                if (parent == null) {
                    result = new ProductionNode(this, condition.getRule(), (ReteStaticMapping)openList.get(0));
                    this.productionNodes.put(condition.getRule(), (ProductionNode)result);
                    this.conditionCheckerNodes.put(condition, result);
                } else {
                    result = new ConditionChecker(this, condition, parent, (ReteStaticMapping)openList.get(0));
                    this.conditionCheckerNodes.put(condition, result);
                }
            }
        }
        if (result == null) {
            if (parent == null) {
                result = new ProductionNode(this, condition.getRule(), null);
                this.productionNodes.put(condition.getRule(), (ProductionNode)result);
                this.conditionCheckerNodes.put(condition, result);
            } else {
                result = new ConditionChecker(this, condition, parent, null);
                this.conditionCheckerNodes.put(condition, result);
            }
        }
        if (condition.getCountNode() != null) {
            QuantifierCountChecker qcc = this.getQuantifierCountCheckerFor(condition);
            assert (qcc != null);
            qcc.setUniversalQuantifierChecker(result);
            result.setCountCheckerNode(qcc);
        }
        if (condition.getSubConditions().size() > 0) {
            HashSet<Condition> nacs = new HashSet<Condition>();
            HashSet<Condition> positiveSubConditions = new HashSet<Condition>();
            for (Condition c : condition.getSubConditions()) {
                if (c.getOp() == Condition.Op.NOT) {
                    nacs.add(c);
                    continue;
                }
                positiveSubConditions.add(c);
            }
            this.processNacs(openList.size() > 0 ? (ReteStaticMapping)openList.get(0) : null, nacs, result);
            for (Condition c : positiveSubConditions) {
                this.addConditionToNetwork(c, result);
            }
        }
    }

    private void mapQuantifierCountNodes(StaticMap openList, Condition condition) {
        for (Condition c : condition.getSubConditions()) {
            if (c.getOp() != Condition.Op.FORALL || c.getCountNode() == null) continue;
            QuantifierCountChecker qcc = new QuantifierCountChecker(this, c);
            this.quantifierCountCheckerNodes.put(c, qcc);
            ReteStaticMapping sm = new ReteStaticMapping(qcc, qcc.getPattern());
            openList.add(sm);
        }
    }

    private ReteStaticMapping createDisjointJoin(List<ReteStaticMapping> antecedents) {
        ReteStaticMapping disjointMerge = null;
        ArrayList<ReteStaticMapping> scratchList = new ArrayList<ReteStaticMapping>(antecedents);
        Collections.sort(scratchList, new Comparator<ReteStaticMapping>(){

            @Override
            public int compare(ReteStaticMapping m1, ReteStaticMapping m2) {
                return m2.getNNode().size() - m1.getNNode().size();
            }
        });
        if (scratchList.size() == 2) {
            SubgraphCheckerNode sgc = new SubgraphCheckerNode(this, (ReteStaticMapping)scratchList.get(0), (ReteStaticMapping)scratchList.get(1));
            disjointMerge = ReteStaticMapping.combine((ReteStaticMapping)scratchList.get(0), (ReteStaticMapping)scratchList.get(1), sgc);
        } else {
            DisconnectedSubgraphChecker dsc = new DisconnectedSubgraphChecker(this, scratchList);
            disjointMerge = ReteStaticMapping.combine(scratchList, dsc);
        }
        return disjointMerge;
    }

    private OperatorNode pickOneOperatorNode(StaticMap openList, Set<OperatorNode> operatorNodes, List<ReteStaticMapping> argumentSources) {
        OperatorNode result = null;
        final HashMap candidates = new HashMap();
        for (OperatorNode node : operatorNodes) {
            boolean allArgumentsFound = true;
            ArrayList<ReteStaticMapping> argumentComponents = new ArrayList<ReteStaticMapping>();
            for (VariableNode vn : node.getArguments()) {
                boolean found = false;
                for (ReteStaticMapping component : openList) {
                    if (!component.getLhsNodes().contains(vn)) continue;
                    found = true;
                    if (argumentComponents.contains(component)) break;
                    argumentComponents.add(component);
                    break;
                }
                if (found) continue;
                allArgumentsFound = false;
                break;
            }
            if (!allArgumentsFound) continue;
            candidates.put(node, argumentComponents);
        }
        OperatorNode[] resultCandidates = new OperatorNode[candidates.keySet().size()];
        candidates.keySet().toArray(resultCandidates);
        Arrays.sort(resultCandidates, new Comparator<OperatorNode>(){

            @Override
            public int compare(OperatorNode arg0, OperatorNode arg1) {
                int result = ((List)candidates.get(arg0)).size() - ((List)candidates.get(arg1)).size();
                if (result == 0) {
                    result = this.getTotalSize((List)candidates.get(arg0)) - this.getTotalSize((List)candidates.get(arg1));
                }
                return 0;
            }

            private int getTotalSize(List<ReteStaticMapping> argumentComps) {
                int result = 0;
                int i = 0;
                while (i < argumentComps.size()) {
                    result += argumentComps.get(i).getElements().length;
                    ++i;
                }
                return result;
            }
        });
        result = resultCandidates[0];
        argumentSources.clear();
        argumentSources.addAll((Collection)candidates.get(result));
        return result;
    }

    private void addEmptyWordAcceptingAndNegativePathCheckers(StaticMap openList, Set<RuleEdge> emptyPathEdges, boolean keepPrefix) {
        assert (openList.size() == 1);
        for (RuleEdge e : emptyPathEdges) {
            SubgraphCheckerNode sg;
            RegExpr exp = ((RuleLabel)e.label()).getMatchExpr();
            ReteStaticMapping m1 = (ReteStaticMapping)openList.get(0);
            AbstractPathChecker pc = this.pathCheckerFactory.getPathCheckerFor(exp.isNeg() ? exp.getNegOperand() : exp, exp.isEmpty() || e.source() == e.target());
            ReteStaticMapping m2 = new ReteStaticMapping(pc, new RuleElement[]{e});
            if (exp.isNeg()) {
                sg = new NegativeFilterSubgraphCheckerNode(this, m1, m2, keepPrefix);
                m1 = ReteStaticMapping.combine(m1, m2, sg);
            } else {
                sg = new SubgraphCheckerNode(this, m1, m2, keepPrefix);
                m1 = ReteStaticMapping.combine(m1, m2, sg);
            }
            openList.set(0, m1);
        }
        assert (openList.size() == 1);
    }

    protected Collection<RuleEdge> getEdgeCollection(Condition c) {
        ArrayList<RuleEdge> result = new ArrayList<RuleEdge>(c.getPattern().edgeSet());
        Collections.sort(result, EdgeComparator.instance());
        return result;
    }

    private RuleNode translate(RuleFactory factory, RuleGraphMorphism translationMap, RuleNode node) {
        RuleNode result = node;
        if (translationMap != null && (result = (RuleNode)translationMap.getNode(node)) == null) {
            result = node;
        }
        return result;
    }

    private RuleEdge translate(RuleFactory factory, RuleGraphMorphism translationMap, RuleEdge edge) {
        RuleEdge result = edge;
        if (translationMap != null) {
            RuleNode n1 = this.translate(factory, translationMap, (RuleNode)edge.source());
            RuleNode n2 = this.translate(factory, translationMap, (RuleNode)edge.target());
            if (!((RuleNode)edge.source()).equals(n1) || !((RuleNode)edge.target()).equals(n2)) {
                result = factory.createEdge(n1, (Label)edge.label(), n2);
            }
        }
        return result;
    }

    private void mapEdgesAndNodes(StaticMap openList, RuleGraph ruleGraph, Set<RuleEdge> emptyAndNegativePathEdges, Set<OperatorNode> operatorNodes) {
        HashSet<Node> mappedLHSNodes = new HashSet<Node>();
        Set<RuleEdge> edgeSet = ruleGraph.edgeSet();
        Set<RuleNode> nodeSet = ruleGraph.nodeSet();
        for (RuleNode n : nodeSet) {
            if (!(n instanceof OperatorNode)) continue;
            OperatorNode opNode = (OperatorNode)n;
            operatorNodes.add(opNode);
            mappedLHSNodes.add(opNode.getTarget());
            mappedLHSNodes.add(opNode);
        }
        for (RuleEdge e : edgeSet) {
            ReteStaticMapping mapping = null;
            if (((RuleLabel)e.label()).isAtom() || ((RuleLabel)e.label()).isWildcard()) {
                EdgeCheckerNode edgeChecker = this.findEdgeCheckerForEdge(e);
                if (edgeChecker == null) {
                    edgeChecker = new EdgeCheckerNode(this, e);
                    this.root.addSuccessor(edgeChecker);
                }
                mapping = new ReteStaticMapping(edgeChecker, new RuleElement[]{e});
            } else if (!((RuleLabel)e.label()).getMatchExpr().isAcceptsEmptyWord() && !((RuleLabel)e.label()).getMatchExpr().isNeg()) {
                AbstractPathChecker pathChecker = this.pathCheckerFactory.getPathCheckerFor(((RuleLabel)e.label()).getMatchExpr(), e.source() == e.target());
                mapping = new ReteStaticMapping(pathChecker, new RuleElement[]{e});
            } else {
                emptyAndNegativePathEdges.add(e);
            }
            if (mapping == null) continue;
            openList.add(mapping);
            mappedLHSNodes.add((RuleNode)e.source());
            mappedLHSNodes.add((RuleNode)e.target());
        }
        for (Condition c : this.quantifierCountCheckerNodes.keySet()) {
            assert (c.getCountNode() != null);
            mappedLHSNodes.add(c.getCountNode());
        }
        for (RuleNode n : nodeSet) {
            if (mappedLHSNodes.contains(n) || this.quantifierCountCheckerNodes.containsKey(n)) continue;
            NodeChecker nc = this.findNodeCheckerForNode(n);
            ReteStaticMapping mapping = new ReteStaticMapping(nc, new RuleElement[]{n});
            openList.add(mapping);
        }
    }

    private RuleGraphMorphism createRuleMorphismForCloning(RuleGraph source, Condition positiveRule) {
        RuleFactory rfact = positiveRule.getFactory();
        RuleGraphMorphism result = rfact.createMorphism();
        int maxNodeNr = 0;
        for (RuleNode n : positiveRule.getPattern().nodeSet()) {
            if (maxNodeNr >= n.getNumber()) continue;
            maxNodeNr = n.getNumber();
        }
        ++maxNodeNr;
        for (RuleNode n : source.nodeSet()) {
            if (n instanceof VariableNode) {
                VariableNode vn = (VariableNode)n;
                result.nodeMap().put(n, rfact.createVariableNode(maxNodeNr++, vn.getTerm()));
                continue;
            }
            DefaultRuleNode dn = (DefaultRuleNode)n;
            result.nodeMap().put(dn, rfact.createNode(maxNodeNr++, dn.getType().label(), n.isSharp(), dn.getTypeGuards()));
        }
        return result;
    }

    private RuleGraph copyAndRenumberNodes(RuleGraph source, RuleFactory rfact, RuleGraphMorphism nodeMapping) {
        RuleGraph result = source.newGraph(source.getName());
        for (RuleNode n : source.nodeSet()) {
            result.addNode((RuleNode)nodeMapping.getNode(n));
        }
        for (RuleEdge e : source.edgeSet()) {
            result.addEdgeContext(this.translate(rfact, nodeMapping, e));
        }
        return result;
    }

    private RuleGraphMorphism copyRootMap(Set<RuleNode> sourceRootNodes, RuleGraphMorphism nodeMapping) {
        RuleGraphMorphism result = new RuleGraphMorphism();
        for (RuleNode sourceEntry : sourceRootNodes) {
            result.nodeMap().put(sourceEntry, (RuleNode)nodeMapping.getNode(sourceEntry));
        }
        return result;
    }

    private void processNacs(ReteStaticMapping lastSubgraphMapping, Set<Condition> nacs, ConditionChecker positiveConditionChecker) {
        assert (lastSubgraphMapping == null || positiveConditionChecker.getAntecedents().get(0).equals(lastSubgraphMapping.getNNode()));
        StaticMap openList = new StaticMap();
        ArrayList<ReteStaticMapping> byPassList = new ArrayList<ReteStaticMapping>();
        for (Condition nac : nacs) {
            byPassList.clear();
            openList.clear();
            RuleGraphMorphism nodeRenumberingMapping = this.createRuleMorphismForCloning(nac.getPattern(), positiveConditionChecker.getCondition());
            RuleGraph newNacGraph = this.copyAndRenumberNodes(nac.getPattern(), positiveConditionChecker.getCondition().getFactory(), nodeRenumberingMapping);
            RuleGraphMorphism newRootMap = this.copyRootMap(nac.getRoot().nodeSet(), nodeRenumberingMapping);
            ReteStaticMapping m1 = this.duplicateAndTranslateMapping(positiveConditionChecker.getCondition().getFactory(), lastSubgraphMapping, newRootMap);
            if (m1 != null) {
                byPassList.add(m1);
                openList.add(m1);
            }
            TreeHashSet<RuleEdge> emptyAcceptingAndNegativeEdges = new TreeHashSet<RuleEdge>();
            TreeHashSet<OperatorNode> operatorNode = new TreeHashSet<OperatorNode>();
            this.mapEdgesAndNodes(openList, newNacGraph, emptyAcceptingAndNegativeEdges, operatorNode);
            if (m1 == null) {
                m1 = (ReteStaticMapping)openList.get(0);
                byPassList.add(m1);
            }
            while (openList.size() > 1) {
                ReteStaticMapping m2 = this.pickCheckerNodeConnectedTo(openList, m1);
                if (m2 == null) {
                    m2 = this.pickTheNextLargestCheckerNode(openList, byPassList);
                }
                SubgraphCheckerNode<?, ?> sg = SubgraphCheckerNode.create(this, m1, m2, true);
                m1 = ReteStaticMapping.combine(m1, m2, sg);
                openList.set(0, m1);
                if (!byPassList.isEmpty()) {
                    byPassList.set(0, m1);
                } else {
                    byPassList.add(m1);
                }
                openList.remove(m2);
            }
            if (emptyAcceptingAndNegativeEdges.size() > 0) {
                this.addEmptyWordAcceptingAndNegativePathCheckers(openList, emptyAcceptingAndNegativeEdges, true);
            }
            CompositeConditionChecker result = new CompositeConditionChecker(this, nac, positiveConditionChecker, (ReteStaticMapping)openList.get(0));
            this.compositeConditionCheckerNodes.add(result);
        }
    }

    private ReteStaticMapping duplicateAndTranslateMapping(RuleFactory factory, ReteStaticMapping source, RuleGraphMorphism translationMap) {
        ReteStaticMapping result = null;
        if (source != null) {
            RuleElement[] oldElements = source.getElements();
            RuleElement[] newElements = new RuleElement[oldElements.length];
            int i = 0;
            while (i < newElements.length) {
                newElements[i] = oldElements[i] instanceof RuleEdge ? this.translate(factory, translationMap, (RuleEdge)oldElements[i]) : this.translate(factory, translationMap, (RuleNode)oldElements[i]);
                ++i;
            }
            result = new ReteStaticMapping(source.getNNode(), newElements);
        }
        return result;
    }

    private NodeChecker findNodeCheckerForNode(RuleNode n) {
        NodeChecker result = null;
        if (n instanceof DefaultRuleNode) {
            DefaultNodeChecker dnc = this.defaultNodeCheckers.get(n.getType());
            if (dnc == null) {
                dnc = new DefaultNodeChecker(this, n);
                this.defaultNodeCheckers.put(n.getType(), dnc);
                this.root.addSuccessor(dnc);
            }
            result = dnc;
        } else if (n instanceof VariableNode) {
            VariableNode vn = (VariableNode)n;
            assert (vn.getConstant() != null);
            if (this.valueNodeCheckerNodes.get(vn.getConstant()) != null) {
                result = this.valueNodeCheckerNodes.get(vn.getConstant());
            } else {
                ValueNodeChecker vnc = new ValueNodeChecker(this, vn);
                this.root.addSuccessor(vnc);
                this.valueNodeCheckerNodes.put(vn.getConstant(), vnc);
                result = vnc;
            }
        }
        return result;
    }

    private ReteStaticMapping pickTheNextLargestCheckerNode(StaticMap openList, Collection<ReteStaticMapping> bypassThese) {
        assert (openList.size() > 0);
        ReteStaticMapping result = null;
        int i = 0;
        while (i < openList.size()) {
            if (!(result != null && result.getNNode().size() >= ((ReteStaticMapping)openList.get(i)).getNNode().size() || bypassThese.contains(openList.get(i)))) {
                result = (ReteStaticMapping)openList.get(i);
            }
            ++i;
        }
        return result;
    }

    private ReteStaticMapping pickCheckerNodeConnectedTo(StaticMap openList, ReteStaticMapping g1) {
        ReteStaticMapping result = null;
        for (ReteStaticMapping m : openList) {
            if (m == g1 || !this.isOkToJoin(g1, m) || !ReteStaticMapping.properlyOverlap(g1, m)) continue;
            result = m;
            break;
        }
        return result;
    }

    private boolean isOkToJoin(ReteStaticMapping m1, ReteStaticMapping m2) {
        return !(m1.getNNode() instanceof QuantifierCountChecker) || !(m2.getNNode() instanceof QuantifierCountChecker);
    }

    private EdgeCheckerNode findEdgeCheckerForEdge(RuleEdge e) {
        EdgeCheckerNode result = null;
        for (ReteNetworkNode n : this.getRoot().getSuccessors()) {
            if (!(n instanceof EdgeCheckerNode) || !((EdgeCheckerNode)n).canBeStaticallyMappedToEdge(e)) continue;
            result = (EdgeCheckerNode)n;
            break;
        }
        return result;
    }

    public boolean isInjective() {
        return this.injective;
    }

    public void update(HostNode e, ReteNetworkNode.Action action) {
        assert (this.isUpdating());
        this.getRoot().receiveNode(e, action);
    }

    public void update(HostEdge e, ReteNetworkNode.Action action) {
        assert (this.isUpdating());
        this.getRoot().receiveEdge(e, action);
    }

    public RootNode getRoot() {
        return this.root;
    }

    public TypeGraph getTypeGraph() {
        return this.typeGraph;
    }

    public ReteState getState() {
        return this.state;
    }

    public Collection<ProductionNode> getProductionNodes() {
        return this.productionNodes.values();
    }

    public Collection<ConditionChecker> getConditonCheckerNodes() {
        return this.conditionCheckerNodes.values();
    }

    public Collection<CompositeConditionChecker> getCompositeConditonCheckerNodes() {
        return this.compositeConditionCheckerNodes;
    }

    public QuantifierCountChecker getQuantifierCountCheckerFor(Condition c) {
        assert (c.getOp() == Condition.Op.FORALL && c.getCountNode() != null);
        return this.quantifierCountCheckerNodes.get(c);
    }

    public ProductionNode getProductionNodeFor(Rule r) {
        ProductionNode result = this.productionNodes.get(r);
        return result;
    }

    public ConditionChecker getConditionCheckerNodeFor(Condition c) {
        ConditionChecker result = this.conditionCheckerNodes.get(c);
        return result;
    }

    public HashMap<TypeNode, DefaultNodeChecker> getDefaultNodeCheckers() {
        return this.defaultNodeCheckers;
    }

    public DefaultNodeChecker getDefaultNodeCheckerForType(TypeNode type) {
        return this.defaultNodeCheckers.get(type);
    }

    public void processGraph(HostGraph g) {
        this.hostFactory = g.getFactory();
        this.getState().clearSubscribers();
        this.getState().initializeSubscribers();
        ReteState.ReteUpdateMode oldUpdateMode = this.getState().getUpdateMode();
        this.setUpdating(true);
        this.getState().setHostGraph(g);
        this.getState().updateMode = ReteState.ReteUpdateMode.NORMAL;
        for (HostNode n : g.nodeSet()) {
            this.getRoot().receiveNode(n, ReteNetworkNode.Action.ADD);
        }
        for (HostEdge e : g.edgeSet()) {
            this.getRoot().receiveEdge(e, ReteNetworkNode.Action.ADD);
        }
        if (oldUpdateMode == ReteState.ReteUpdateMode.ONDEMAND) {
            this.getState().setUpdateMode(oldUpdateMode);
        }
        this.setUpdating(false);
    }

    public PlainGraph toPlainGraph() {
        PlainGraph graph = new PlainGraph(String.valueOf(this.grammarName) + "-rete");
        graph.setRole(GraphRole.RETE);
        HashMap<ReteNetworkNode, PlainNode> map = new HashMap<ReteNetworkNode, PlainNode>();
        PlainNode rootNode = (PlainNode)graph.addNode();
        map.put(this.getRoot(), rootNode);
        graph.addEdge(rootNode, "ROOT", rootNode);
        this.addChildren(graph, map, this.getRoot());
        this.addEmptyConditions(graph, map);
        this.addQuantifierCountCheckers(graph, map);
        this.addSubConditionEdges(graph, map);
        return graph;
    }

    private void addQuantifierCountCheckers(PlainGraph graph, Map<ReteNetworkNode, PlainNode> map) {
        for (ConditionChecker cc : this.getConditonCheckerNodes()) {
            PlainEdge[] flags;
            QuantifierCountChecker qcc = cc.getCountCheckerNode();
            if (qcc == null) continue;
            PlainNode qccNode = (PlainNode)graph.addNode();
            map.put(qcc, qccNode);
            PlainEdge[] plainEdgeArray = flags = this.makeNNodeLabels(qcc, qccNode);
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                PlainEdge f = plainEdgeArray[n2];
                graph.addEdgeContext(f);
                ++n2;
            }
            String l = "count";
            graph.addEdge(map.get(cc), l, map.get(qcc));
            this.addChildren(graph, map, qcc);
        }
    }

    private void addEmptyConditions(PlainGraph graph, Map<ReteNetworkNode, PlainNode> map) {
        for (ConditionChecker cc : this.getConditonCheckerNodes()) {
            PlainEdge[] flags;
            if (!cc.isEmpty()) continue;
            PlainNode conditionCheckerNode = (PlainNode)graph.addNode();
            map.put(cc, conditionCheckerNode);
            PlainEdge[] plainEdgeArray = flags = this.makeNNodeLabels(cc, conditionCheckerNode);
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                PlainEdge f = plainEdgeArray[n2];
                graph.addEdgeContext(f);
                ++n2;
            }
        }
    }

    private void addSubConditionEdges(PlainGraph graph, Map<ReteNetworkNode, PlainNode> map) {
        String l;
        ConditionChecker parent;
        for (ConditionChecker conditionChecker : this.getConditonCheckerNodes()) {
            parent = conditionChecker.getParent();
            if (parent == null) continue;
            l = "subcondition";
            graph.addEdge(map.get(conditionChecker), l, map.get(parent));
        }
        for (CompositeConditionChecker compositeConditionChecker : this.getCompositeConditonCheckerNodes()) {
            parent = compositeConditionChecker.getParent();
            if (parent == null) continue;
            l = "NAC";
            graph.addEdge(map.get(compositeConditionChecker), l, map.get(parent));
        }
    }

    private void addChildren(PlainGraph graph, Map<ReteNetworkNode, PlainNode> map, ReteNetworkNode nnode) {
        PlainNode jNode = map.get(nnode);
        if (jNode != null) {
            ReteNetworkNode previous = null;
            int repeatCounter = 0;
            for (ReteNetworkNode childNNode : nnode.getSuccessors()) {
                repeatCounter = previous == childNNode ? repeatCounter + 1 : 0;
                boolean navigate = false;
                PlainNode childJNode = map.get(childNNode);
                if (childJNode == null) {
                    PlainEdge[] flags;
                    childJNode = (PlainNode)graph.addNode();
                    PlainEdge[] plainEdgeArray = flags = this.makeNNodeLabels(childNNode, childJNode);
                    int n = flags.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PlainEdge f = plainEdgeArray[n2];
                        graph.addEdgeContext(f);
                        ++n2;
                    }
                    map.put(childNNode, childJNode);
                    navigate = true;
                }
                if (childNNode instanceof SubgraphCheckerNode) {
                    if (childNNode.getAntecedents().get(0) != childNNode.getAntecedents().get(1)) {
                        if (nnode == childNNode.getAntecedents().get(0)) {
                            graph.addEdge(jNode, "left", childJNode);
                        } else {
                            graph.addEdge(jNode, "right", childJNode);
                        }
                    } else {
                        graph.addEdge(jNode, "left", childJNode);
                        graph.addEdge(jNode, "right", childJNode);
                    }
                } else if (childNNode instanceof ConditionChecker && repeatCounter > 0) {
                    graph.addEdge(jNode, "receive_" + repeatCounter, childJNode);
                } else {
                    graph.addEdge(jNode, "receive", childJNode);
                }
                if (navigate) {
                    this.addChildren(graph, map, childNNode);
                }
                previous = childNNode;
            }
        }
    }

    private PlainEdge[] makeNNodeLabels(ReteNetworkNode nnode, PlainNode source) {
        ArrayList<PlainEdge> result = new ArrayList<PlainEdge>();
        if (nnode instanceof RootNode) {
            result.add(PlainEdge.createEdge(source, "ROOT", source));
        } else if (nnode instanceof DefaultNodeChecker) {
            result.add(PlainEdge.createEdge(source, "Node Checker", source));
            result.add(PlainEdge.createEdge(source, ((DefaultNodeChecker)nnode).getNode().toString(), source));
        } else if (nnode instanceof ValueNodeChecker) {
            result.add(PlainEdge.createEdge(source, String.format("Value Node Checker - %s ", ((VariableNode)((ValueNodeChecker)nnode).getNode()).getConstant().getSymbol()), source));
            result.add(PlainEdge.createEdge(source, ":" + ((ValueNodeChecker)nnode).getNode().toString(), source));
        } else if (nnode instanceof QuantifierCountChecker) {
            result.add(PlainEdge.createEdge(source, String.format("- Quantifier Count Checker ", new Object[0]), source));
            int i = 0;
            while (i < ((QuantifierCountChecker)nnode).getPattern().length) {
                RuleElement e = ((QuantifierCountChecker)nnode).getPattern()[i];
                result.add(PlainEdge.createEdge(source, ":--" + i + " " + e.toString(), source));
                ++i;
            }
        } else if (nnode instanceof EdgeCheckerNode) {
            result.add(PlainEdge.createEdge(source, "Edge Checker", source));
            result.add(PlainEdge.createEdge(source, ":" + ((EdgeCheckerNode)nnode).getEdge().toString(), source));
        } else if (nnode instanceof SubgraphCheckerNode) {
            String[] lines;
            String[] stringArray = lines = nnode.toString().split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.add(PlainEdge.createEdge(source, s, source));
                ++n2;
            }
        } else if (nnode instanceof DisconnectedSubgraphChecker) {
            result.add(PlainEdge.createEdge(source, "DisconnectedSubgraphChecker", source));
        } else if (nnode instanceof ProductionNode) {
            result.add(PlainEdge.createEdge(source, "- Production Node " + (((ConditionChecker)nnode).isIndexed() ? "(idx)" : "()"), source));
            result.add(PlainEdge.createEdge(source, "-" + ((ProductionNode)nnode).getCondition().getName(), source));
            int i = 0;
            while (i < ((ProductionNode)nnode).getPattern().length) {
                RuleElement e = ((ProductionNode)nnode).getPattern()[i];
                result.add(PlainEdge.createEdge(source, ":--" + i + " " + e.toString(), source));
                ++i;
            }
        } else if (nnode instanceof ConditionChecker) {
            result.add(PlainEdge.createEdge(source, "- Condition Checker " + (((ConditionChecker)nnode).isIndexed() ? "(idx)" : "()"), source));
            int i = 0;
            while (i < ((ConditionChecker)nnode).getPattern().length) {
                RuleElement e = ((ConditionChecker)nnode).getPattern()[i];
                result.add(PlainEdge.createEdge(source, ":--" + i + " " + e.toString(), source));
                ++i;
            }
        } else {
            String[] lines;
            String[] stringArray = lines = nnode.toString().split("\n");
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                result.add(PlainEdge.createEdge(source, s, source));
                ++n3;
            }
        }
        PlainEdge[] res = new PlainEdge[result.size()];
        return result.toArray(res);
    }

    public void save(String filePath, String name) {
        PlainGraph graph = this.toPlainGraph();
        graph.setName(name);
        File file = new File(FileType.GXL_FILTER.addExtension(filePath));
        try {
            Groove.saveGraph((Graph)graph, file);
        }
        catch (IOException exc) {
            throw new RuntimeException(String.format("Error while saving graph to '%s'", file), exc);
        }
    }

    public boolean isInOnDemandMode() {
        return this.getState().getUpdateMode() == ReteState.ReteUpdateMode.ONDEMAND;
    }

    public HostFactory getHostFactory() {
        return this.hostFactory;
    }

    public HashMap<Constant, ValueNodeChecker> getValueNodeCheckerNodes() {
        return this.valueNodeCheckerNodes;
    }

    public void setUpdating(boolean updating) {
        if (updating && !this.updating) {
            this.updating = updating;
            this.getState().notifyUpdateBegin();
        } else if (!updating && this.updating) {
            this.updating = updating;
            this.getState().notifyUpdateEnd();
        } else {
            this.updating = updating;
        }
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public ReteSearchEngine getOwnerEngine() {
        return this.ownerEngine;
    }

    static class ReteState {
        private ReteNetwork owner;
        private HostGraph hostGraph;
        private Set<ReteStateSubscriber> subscribers = new HashSet<ReteStateSubscriber>();
        private Set<ReteStateSubscriber> updateSubscribers = new HashSet<ReteStateSubscriber>();
        private ReteUpdateMode updateMode = ReteUpdateMode.NORMAL;

        protected ReteState(ReteNetwork owner) {
            this.owner = owner;
        }

        public ReteNetwork getOwner() {
            return this.owner;
        }

        public synchronized void subscribe(ReteStateSubscriber sb) {
            this.subscribe(sb, false);
        }

        public synchronized void subscribe(ReteStateSubscriber sb, boolean receiveUpdateNotifications) {
            this.subscribers.add(sb);
            if (receiveUpdateNotifications) {
                this.updateSubscribers.add(sb);
            }
        }

        public void unsubscribe(ReteStateSubscriber sb) {
            sb.clear();
            this.subscribers.remove(sb);
            this.updateSubscribers.remove(sb);
        }

        public void clearSubscribers() {
            for (ReteStateSubscriber sb : this.subscribers) {
                sb.clear();
            }
        }

        public synchronized void initializeSubscribers() {
            for (ReteStateSubscriber sb : this.subscribers) {
                sb.initialize();
            }
        }

        public synchronized void notifyUpdateBegin() {
            for (ReteStateSubscriber sb : this.updateSubscribers) {
                sb.updateBegin();
            }
        }

        public synchronized void notifyUpdateEnd() {
            for (ReteStateSubscriber sb : this.updateSubscribers) {
                sb.updateEnd();
            }
        }

        synchronized void setHostGraph(HostGraph hgraph) {
            this.hostGraph = hgraph;
        }

        public HostGraph getHostGraph() {
            return this.hostGraph;
        }

        public void setUpdateMode(ReteUpdateMode newMode) {
            if (newMode != this.updateMode) {
                if (this.updateMode == ReteUpdateMode.ONDEMAND) {
                    this.updateMode = newMode;
                    this.owner.getRoot().forceFlush();
                } else {
                    this.updateMode = newMode;
                }
            }
        }

        public ReteUpdateMode getUpdateMode() {
            return this.updateMode;
        }

        public static enum ReteUpdateMode {
            NORMAL,
            ONDEMAND;

        }
    }

    static class ReteStaticMapping {
        private ReteNetworkNode nNode;
        private RuleElement[] elements;
        private HashMap<RuleNode, LookupEntry> nodeLookupMap = new HashMap();

        public ReteStaticMapping(ReteNetworkNode reteNode, RuleElement[] mappedTo) {
            this.nNode = reteNode;
            this.elements = mappedTo;
            int i = 0;
            while (i < this.elements.length) {
                if (this.elements[i] instanceof RuleEdge) {
                    RuleNode n1 = (RuleNode)((RuleEdge)this.elements[i]).source();
                    RuleNode n2 = (RuleNode)((RuleEdge)this.elements[i]).target();
                    this.nodeLookupMap.put(n1, new LookupEntry(i, LookupEntry.Role.SOURCE));
                    this.nodeLookupMap.put(n2, new LookupEntry(i, LookupEntry.Role.TARGET));
                } else {
                    assert (this.elements[i] instanceof RuleNode);
                    this.nodeLookupMap.put((RuleNode)this.elements[i], new LookupEntry(i, LookupEntry.Role.NODE));
                }
                ++i;
            }
            assert (reteNode.getPattern().length == mappedTo.length);
        }

        public static ReteStaticMapping mapDataOperatorNode(DataOperatorChecker doc, OperatorNode opEdge, ReteStaticMapping antecedentMapping) {
            assert (antecedentMapping.getNNode().equals(doc.getAntecedents().get(0)));
            RuleElement[] mapto = new RuleElement[doc.getPattern().length];
            int i = 0;
            while (i < antecedentMapping.getElements().length) {
                mapto[i] = antecedentMapping.getElements()[i];
                ++i;
            }
            mapto[mapto.length - 1] = opEdge.getTarget();
            return new ReteStaticMapping(doc, mapto);
        }

        public static ReteStaticMapping combine(ReteStaticMapping oneMap, ReteStaticMapping otherMap, SubgraphCheckerNode<?, ?> suc) {
            assert (oneMap.getNNode().getSuccessors().contains(suc) && otherMap.getNNode().getSuccessors().contains(suc));
            ReteStaticMapping left = suc.getAntecedents().get(0).equals(oneMap.getNNode()) ? oneMap : otherMap;
            ReteStaticMapping right = left == oneMap ? otherMap : oneMap;
            RuleElement[] combinedElements = new RuleElement[left.getElements().length + right.getElements().length];
            int i = 0;
            while (i < left.getElements().length) {
                combinedElements[i] = left.getElements()[i];
                ++i;
            }
            while (i < combinedElements.length) {
                combinedElements[i] = right.getElements()[i - left.getElements().length];
                ++i;
            }
            ReteStaticMapping result = new ReteStaticMapping(suc, combinedElements);
            return result;
        }

        public static ReteStaticMapping combine(List<ReteStaticMapping> maps, DisconnectedSubgraphChecker suc) {
            ArrayList<RuleElement> tempElementsList = new ArrayList<RuleElement>();
            int i = 0;
            while (i < maps.size()) {
                RuleElement[] elems = maps.get(i).getElements();
                int j = 0;
                while (j < elems.length) {
                    tempElementsList.add(elems[j]);
                    ++j;
                }
                ++i;
            }
            RuleElement[] combinedElements = new RuleElement[tempElementsList.size()];
            combinedElements = tempElementsList.toArray(combinedElements);
            ReteStaticMapping result = new ReteStaticMapping(suc, combinedElements);
            return result;
        }

        public static ReteStaticMapping combine(ReteStaticMapping oneMap, ReteStaticMapping otherMap, NegativeFilterSubgraphCheckerNode<?, ?> suc) {
            ReteStaticMapping left = suc.getAntecedents().get(0).equals(oneMap.getNNode()) ? oneMap : otherMap;
            RuleElement[] combinedElements = new RuleElement[left.getElements().length];
            int i = 0;
            while (i < left.getElements().length) {
                combinedElements[i] = left.getElements()[i];
                ++i;
            }
            ReteStaticMapping result = new ReteStaticMapping(suc, combinedElements);
            return result;
        }

        public static boolean properlyOverlap(ReteStaticMapping one, ReteStaticMapping theOther) {
            boolean result = false;
            TreeHashSet nodes1 = new TreeHashSet();
            nodes1.addAll(one.getLhsNodes());
            TreeHashSet nodes2 = new TreeHashSet();
            nodes2.addAll(theOther.getLhsNodes());
            if (one.getNNode() instanceof QuantifierCountChecker || theOther.getNNode() instanceof QuantifierCountChecker) {
                result = true;
                if (one.getNNode() instanceof QuantifierCountChecker) {
                    nodes1.remove(one.getNNode().getPattern()[one.getNNode().getPattern().length - 1]);
                    boolean bl = result = result && nodes2.containsAll(nodes1);
                }
                if (theOther.getNNode() instanceof QuantifierCountChecker) {
                    nodes2.remove(theOther.getNNode().getPattern()[theOther.getNNode().getPattern().length - 1]);
                    result = result && nodes1.containsAll(nodes2);
                }
            } else {
                for (RuleNode n : nodes1) {
                    result = nodes2.contains(n);
                    if (result) break;
                }
            }
            return result;
        }

        public ReteNetworkNode getNNode() {
            return this.nNode;
        }

        public RuleElement[] getElements() {
            return this.elements;
        }

        public Set<RuleNode> getLhsNodes() {
            return Collections.unmodifiableSet(this.nodeLookupMap.keySet());
        }

        public LookupEntry locateNode(RuleNode n) {
            return this.nodeLookupMap.get(n);
        }

        public String toString() {
            StringBuilder res = new StringBuilder(String.format("%s \n lhs-elements:\n", this.getNNode().toString()));
            int i = 0;
            while (i < this.getElements().length) {
                res.append(String.format("%d %s \n", i, this.getElements()[i].toString()));
                ++i;
            }
            res.append("------------\n");
            return res.toString();
        }
    }

    static class StaticMap
    extends ArrayList<ReteStaticMapping> {
        StaticMap() {
        }

        public boolean containsNNode(ReteNetworkNode nnode) {
            boolean result = false;
            for (ReteStaticMapping m : this) {
                if (!m.getNNode().equals(nnode)) continue;
                result = true;
                break;
            }
            return result;
        }

        public ReteStaticMapping getFirstMappingFor(ReteNetworkNode nnode, ReteStaticMapping exceptThis) {
            ReteStaticMapping result = null;
            for (ReteStaticMapping m : this) {
                if (m == exceptThis || !m.getNNode().equals(nnode)) continue;
                result = m;
                break;
            }
            return result;
        }
    }
}

