/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.Valuation;
import groove.graph.NodeComparator;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.ClosurePathChecker;
import groove.match.rete.ReteNetworkNode;

public class RetePathMatch
extends AbstractReteMatch {
    private final HostNode start;
    private final HostNode end;
    private int pathLength = 0;
    private HostNodeSet nodes = null;
    private ClosurePathChecker.ClosureInfo closureInfo = null;
    private HostEdge associatedEdge = null;
    private Key key;
    Object[] unitsToReport = null;
    private static final NodeComparator nodeComparator = NodeComparator.instance();

    private RetePathMatch(ReteNetworkNode origin, HostNode start, HostNode end) {
        super(origin, false);
        this.start = start;
        this.end = end;
        this.valuation = new Valuation();
    }

    public RetePathMatch(ReteNetworkNode origin, HostEdge edge) {
        this(origin, edge.source(), edge.target());
        this.pathLength = 1;
        this.associatedEdge = edge;
        this.valuation = new Valuation();
    }

    protected RetePathMatch(ReteNetworkNode origin, RetePathMatch subMatch) {
        this(origin, subMatch.start, subMatch.end);
        this.pathLength = subMatch.pathLength;
        this.valuation = subMatch.valuation;
        this.associatedEdge = subMatch.associatedEdge;
        subMatch.addSuperMatch(this);
    }

    public RetePathMatch reoriginate(ReteNetworkNode newOrigin) {
        return new RetePathMatch(newOrigin, this);
    }

    @Override
    public Object[] getAllUnits() {
        if (this.unitsToReport == null) {
            this.unitsToReport = new Object[]{this};
        }
        return this.unitsToReport;
    }

    @Override
    public HostNodeSet getNodes() {
        if (this.nodes == null) {
            this.nodes = new HostNodeSet();
            this.nodes.add(this.start);
            this.nodes.add(this.end);
        }
        return this.nodes;
    }

    public ClosurePathChecker.ClosureInfo getClosureInfo() {
        return this.closureInfo;
    }

    public void setClosureInfo(ClosurePathChecker.ClosureInfo value) {
        this.closureInfo = value;
    }

    @Override
    public int size() {
        return 1;
    }

    public int compareTo(RetePathMatch m) {
        int result = this.hashCode() - m.hashCode();
        if (result == 0 && (result = nodeComparator.compare(this.start, m.start)) == 0) {
            result = nodeComparator.compare(this.end, m.end);
        }
        return result;
    }

    public int getPathLength() {
        return this.pathLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetePathMatch)) {
            return false;
        }
        RetePathMatch other = (RetePathMatch)o;
        if (this.pathLength != 1 || other.pathLength != 1) {
            return false;
        }
        return this.associatedEdge != null && this.associatedEdge.equals(other.associatedEdge);
    }

    @Override
    protected int computeHashCode() {
        int result = this.pathLength == 1 && this.associatedEdge != null ? this.associatedEdge.hashCode() : System.identityHashCode(this);
        return result;
    }

    public RetePathMatch concatenate(ReteNetworkNode origin, RetePathMatch m, boolean copyPrefix) {
        Valuation valuation;
        RetePathMatch result = null;
        if (this.end.equals(m.start) && (valuation = this.getMergedValuation(m)) != null) {
            result = new RetePathMatch(origin, this.start, m.end);
            if (copyPrefix) {
                result.specialPrefix = m.specialPrefix != null ? m.specialPrefix : m;
            }
            result.pathLength = this.pathLength + m.pathLength;
            result.valuation = valuation != emptyMap ? valuation : null;
            this.hashCode();
            this.addSuperMatch(result);
            m.addSuperMatch(result);
        }
        return result;
    }

    public RetePathMatch inverse(ReteNetworkNode origin) {
        RetePathMatch result = new RetePathMatch(origin, this.end, this.start);
        result.pathLength = this.pathLength;
        result.valuation = this.valuation;
        result.hashCode();
        this.addSuperMatch(result);
        return result;
    }

    public HostNode start() {
        return this.start;
    }

    public HostNode end() {
        return this.end;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return String.format("Path from %s to %s (l= %d) match %s |> %s", this.start().toString(), this.end().toString(), this.pathLength, ((AbstractPathChecker)this.getOrigin()).getExpression().toString(), this.valuation.toString());
    }

    public Key getCacheKey() {
        if (this.key == null) {
            this.key = new Key(this);
        }
        return this.key;
    }

    public static RetePathMatch duplicate(RetePathMatch m) {
        RetePathMatch result = new RetePathMatch(m.getOrigin(), m.start, m.end);
        result.associatedEdge = m.associatedEdge;
        result.nodes = m.nodes;
        result.pathLength = m.pathLength;
        result.specialPrefix = m.specialPrefix;
        result.valuation = m.valuation;
        return result;
    }

    /* synthetic */ RetePathMatch(ReteNetworkNode reteNetworkNode, HostNode hostNode, HostNode hostNode2, RetePathMatch retePathMatch) {
        this(reteNetworkNode, hostNode, hostNode2);
    }

    public static class EmptyPathMatch
    extends RetePathMatch {
        public EmptyPathMatch(ReteNetworkNode origin) {
            super(origin, null, null, null);
        }

        public EmptyPathMatch(ReteNetworkNode origin, HostNode n) {
            super(origin, n, n, null);
        }

        private EmptyPathMatch(ReteNetworkNode origin, EmptyPathMatch subMatch) {
            super(origin, subMatch);
        }

        @Override
        public RetePathMatch reoriginate(ReteNetworkNode newOrigin) {
            return new EmptyPathMatch(newOrigin, this);
        }

        @Override
        public RetePathMatch inverse(ReteNetworkNode origin) {
            return this.reoriginate(origin);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptyPathMatch && this.getOrigin() == ((EmptyPathMatch)o).getOrigin();
        }

        @Override
        public String toString() {
            return String.format("Empty path matched by %s", ((AbstractPathChecker)this.getOrigin()).getExpression().toString());
        }
    }

    private static class Key {
        private final HostNode start;
        private final HostNode end;
        private final Valuation valuation;

        public Key(RetePathMatch pm) {
            assert (pm.start() != null && pm.end() != null || pm instanceof EmptyPathMatch);
            this.start = pm.start();
            this.end = pm.end();
            this.valuation = pm.getValuation();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
            result = 31 * result + (this.valuation == null ? 0 : this.valuation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
                return false;
            }
            if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
                return false;
            }
            return !(this.valuation == null ? other.valuation != null : !this.valuation.equals(other.valuation));
        }

        public String toString() {
            return "Key [start=" + this.start + ", end=" + this.end + ", valuation=" + this.valuation + "]";
        }
    }
}

