/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.grammar.host.HostNode;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.collect.MapSet;
import java.util.List;
import java.util.Set;

public class SequenceOperatorPathChecker
extends AbstractPathChecker
implements ReteStateSubscriber {
    private final MapSet<HostNode, RetePathMatch> leftMemory = new MapSet<HostNode, RetePathMatch>(){

        @Override
        protected HostNode getKey(Object value) {
            return ((RetePathMatch)value).end();
        }
    };
    private RetePathMatch leftEmpty;
    private final MapSet<HostNode, RetePathMatch> rightMemory = new MapSet<HostNode, RetePathMatch>(){

        @Override
        protected HostNode getKey(Object value) {
            return ((RetePathMatch)value).start();
        }
    };
    private RetePathMatch rightEmpty;

    public SequenceOperatorPathChecker(ReteNetwork network, RegExpr expression, boolean isLoop) {
        super(network, expression, isLoop);
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, RetePathMatch newMatch) {
        boolean fromLeft;
        if (this.getAntecedents().get(0) != this.getAntecedents().get(1)) {
            fromLeft = this.getAntecedents().get(0) == source;
        } else {
            boolean bl = fromLeft = repeatIndex == 0;
        }
        if (fromLeft) {
            if (newMatch.isEmpty()) {
                assert (this.leftEmpty == null);
                this.leftEmpty = newMatch;
                this.constructAndPassDown(true, newMatch, this.rightMemory);
            } else {
                newMatch.addContainerCollection(this.leftMemory);
                this.leftMemory.add(newMatch);
                this.constructAndPassDown(true, newMatch, this.rightMemory.get(newMatch.end()));
            }
        } else if (newMatch.isEmpty()) {
            assert (this.rightEmpty == null);
            this.rightEmpty = newMatch;
            this.constructAndPassDown(false, newMatch, this.leftMemory);
        } else {
            newMatch.addContainerCollection(this.rightMemory);
            this.rightMemory.add(newMatch);
            this.constructAndPassDown(false, newMatch, this.leftMemory.get(newMatch.start()));
        }
    }

    private void constructAndPassDown(boolean fromLeft, RetePathMatch newMatch, Set<RetePathMatch> oldMatches) {
        RetePathMatch empty;
        if (oldMatches != null) {
            for (RetePathMatch oldMatch : oldMatches) {
                this.constructAndPassDown(fromLeft, newMatch, oldMatch);
            }
        }
        RetePathMatch retePathMatch = empty = fromLeft ? this.rightEmpty : this.leftEmpty;
        if (empty != null) {
            this.constructAndPassDown(fromLeft, newMatch, empty);
        }
    }

    private void constructAndPassDown(boolean fromLeft, RetePathMatch newMatch, RetePathMatch oldMatch) {
        RetePathMatch right;
        RetePathMatch left = fromLeft ? newMatch : oldMatch;
        RetePathMatch combined = this.construct(left, right = fromLeft ? oldMatch : newMatch);
        if (combined != null) {
            this.passDownMatchToSuccessors(combined);
        }
    }

    protected boolean test(RetePathMatch left, RetePathMatch right) {
        return left.isEmpty() || right.isEmpty() || left.end().equals(right.start());
    }

    protected RetePathMatch construct(RetePathMatch left, RetePathMatch right) {
        if (left.isEmpty()) {
            if (this.isLoop() && !right.isEmpty() && right.start() != right.end()) {
                return null;
            }
            return right.reoriginate(this);
        }
        if (right.isEmpty()) {
            if (this.isLoop() && left.start() != left.end()) {
                return null;
            }
            return left.reoriginate(this);
        }
        if (this.isLoop() && left.start() != right.end()) {
            return null;
        }
        return left.concatenate(this, right, false);
    }

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.leftEmpty = null;
        this.rightEmpty = null;
        this.leftMemory.clear();
        this.rightMemory.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        super.initialize();
        return null;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }
}

