/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.algebra.Constant;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.NodeChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import java.util.List;

public class ValueNodeChecker
extends NodeChecker
implements ReteStateSubscriber {
    final VariableNode node;

    public ValueNodeChecker(ReteNetwork network, VariableNode variableNode) {
        super(network);
        this.pattern[0] = variableNode;
        this.node = variableNode;
        this.getOwner().getState().subscribe(this);
    }

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    public boolean equals(Object node) {
        return this.equals((ReteNetworkNode)node);
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node instanceof ValueNodeChecker && ((ValueNodeChecker)node).getConstant().equals(this.getConstant());
    }

    public Constant getConstant() {
        return ((VariableNode)this.pattern[0]).getConstant();
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch match) {
        throw new UnsupportedOperationException("This method is not supposed to have been called.");
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void clear() {
    }

    @Override
    public List<? extends Object> initialize() {
        VariableNode varNode = (VariableNode)this.pattern[0];
        Algebra<?> algebra = AlgebraFamily.getInstance().getAlgebra(varNode.getSignature());
        ValueNode valueNode = this.getOwner().getHostFactory().createValueNode(algebra, algebra.getValueFromSymbol(varNode.getConstant().getSymbol()));
        ReteSimpleMatch match = new ReteSimpleMatch((ReteNetworkNode)this, valueNode, this.getOwner().isInjective());
        this.passDownMatchToSuccessors(match);
        return null;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    @Override
    public boolean canBeStaticallyMappedTo(RuleNode node) {
        assert (node instanceof VariableNode && ((VariableNode)node).getConstant() != null);
        return node instanceof VariableNode && ((VariableNode)node).getConstant().equals(this.node.getConstant());
    }
}

