/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.Rule;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.rule.RuleToHostMap;
import groove.graph.Edge;
import groove.match.TreeMatch;
import groove.transform.Proof;
import groove.transform.RuleApplication;
import groove.transform.RuleEffect;
import groove.transform.RuleEvent;
import groove.util.Visitor;
import groove.util.cache.AbstractCacheHolder;
import groove.util.cache.CacheReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingFormatArgumentException;

public abstract class AbstractRuleEvent<R extends Rule, C extends AbstractEventCache>
extends AbstractCacheHolder<C>
implements RuleEvent {
    private final R rule;
    private int hashCode;
    static final HostNode[] EMPTY_NODE_ARRAY = new HostNode[0];

    protected AbstractRuleEvent(CacheReference<C> template, R rule) {
        super(template);
        this.rule = rule;
    }

    @Override
    public RuleEffect getEffect(HostGraph host) {
        RuleEffect result = new RuleEffect(host);
        this.recordEffect(result);
        return result;
    }

    abstract RuleEvent.Reuse getReuse();

    public String getLabelText(HostNode[] addedNodes, boolean anchored) {
        StringBuilder result = new StringBuilder();
        result.append(((Rule)this.getRule()).getTransitionLabel());
        if (anchored) {
            result.append(this.getAnchorImageString());
        } else if (((Rule)this.getRule()).getSystemProperties().isUseParameters()) {
            result.append('(');
            boolean first = true;
            HostNode[] hostNodeArray = this.getArguments(addedNodes);
            int n = hostNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                HostNode arg = hostNodeArray[n2];
                if (!first) {
                    result.append(',');
                }
                first = false;
                if (arg == null) {
                    result.append('_');
                } else if (arg instanceof ValueNode) {
                    result.append(((ValueNode)arg).getSymbol());
                } else {
                    result.append(arg);
                }
                ++n2;
            }
            result.append(')');
        }
        return result.toString();
    }

    public String getOutputString(HostNode[] addedNodes) throws FormatException {
        String result = null;
        String formatString = ((Rule)this.getRule()).getFormatString();
        if (formatString != null && !formatString.isEmpty()) {
            ArrayList<Object> args = new ArrayList<Object>();
            HostNode[] hostNodeArray = this.getArguments(addedNodes);
            int n = hostNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                HostNode arg = hostNodeArray[n2];
                if (arg instanceof ValueNode) {
                    args.add(((ValueNode)arg).getValue());
                } else {
                    args.add(arg.toString());
                }
                ++n2;
            }
            try {
                result = String.format(formatString, args.toArray());
            }
            catch (MissingFormatArgumentException e) {
                throw new FormatException("Error in rule output string: %s", e.getMessage());
            }
        }
        return result;
    }

    abstract HostNode[] getArguments(HostNode[] var1);

    public R getAction() {
        return this.getRule();
    }

    public R getRule() {
        return this.rule;
    }

    @Override
    public RuleApplication newApplication(HostGraph source) {
        return new RuleApplication(this, source);
    }

    public String toString() {
        return this.getLabelText(null, false);
    }

    public int hashCode() {
        return this.getReuse() == RuleEvent.Reuse.EVENT ? System.identityHashCode(this) : this.eventHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractRuleEvent)) {
            return false;
        }
        AbstractRuleEvent other = (AbstractRuleEvent)obj;
        if (this.getReuse() != RuleEvent.Reuse.EVENT) {
            return this.equalsEvent(other);
        }
        if (other.getReuse() != RuleEvent.Reuse.EVENT) {
            return other.equalsEvent(this);
        }
        assert (!this.equalsEvent(other));
        return false;
    }

    abstract boolean equalsEvent(RuleEvent var1);

    int eventHashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeEventHashCode();
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    abstract int computeEventHashCode();

    protected HostNodeSet createNodeSet() {
        return new HostNodeSet();
    }

    protected HostNodeSet createNodeSet(int capacity) {
        return new HostNodeSet(capacity);
    }

    protected HostEdgeSet createEdgeSet() {
        return new HostEdgeSet();
    }

    protected HostEdgeSet createEdgeSet(int capacity) {
        return new HostEdgeSet(capacity);
    }

    @Override
    public final Proof getMatch(final HostGraph source) {
        assert (this.isCorrectFor(source));
        Visitor<TreeMatch, Proof> matchVisitor = new Visitor<TreeMatch, Proof>(){

            @Override
            protected boolean process(TreeMatch match) {
                if (((Rule)AbstractRuleEvent.this.getRule()).isValidPatternMap(source, match.getPatternMap())) {
                    this.setResult(AbstractRuleEvent.this.extractProof(match));
                }
                return !this.hasResult();
            }
        };
        Proof result = ((Rule)this.getRule()).getEventMatcher().traverse(source, this.getAnchorMap(), matchVisitor);
        return result;
    }

    private boolean isCorrectFor(HostGraph host) {
        RuleToHostMap anchorMap = this.getAnchorMap();
        boolean correct = true;
        Iterator edgeImageIter = anchorMap.edgeMap().values().iterator();
        while (correct && edgeImageIter.hasNext()) {
            correct = host.containsEdge((Edge)edgeImageIter.next());
        }
        if (correct) {
            Iterator nodeImageIter = anchorMap.nodeMap().values().iterator();
            while (correct && nodeImageIter.hasNext()) {
                HostNode nodeImage = (HostNode)nodeImageIter.next();
                boolean bl = correct = nodeImage instanceof ValueNode || host.containsNode(nodeImage);
            }
        }
        return correct;
    }

    protected abstract Proof extractProof(TreeMatch var1);

    protected abstract class AbstractEventCache {
        protected AbstractEventCache() {
        }
    }
}

