/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.Rule;
import groove.grammar.host.AnchorValue;
import groove.grammar.host.HostNode;
import groove.grammar.rule.RuleToHostMap;
import groove.match.TreeMatch;
import groove.transform.AbstractRuleEvent;
import groove.transform.BasicEvent;
import groove.transform.Proof;
import groove.transform.Record;
import groove.transform.RuleEffect;
import groove.transform.RuleEvent;
import groove.util.cache.CacheReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompositeEvent
extends AbstractRuleEvent<Rule, CompositeEventCache> {
    private final Record record;
    private final RuleEvent.Reuse reuse;
    final BasicEvent[] eventArray;
    private static final CacheReference<CompositeEventCache> reference = CacheReference.newInstance(false);

    public CompositeEvent(Record record, Rule rule, Collection<BasicEvent> eventSet, RuleEvent.Reuse reuse) {
        super(reference, rule);
        assert (!eventSet.isEmpty());
        this.record = record;
        this.reuse = reuse;
        this.eventArray = new BasicEvent[eventSet.size()];
        eventSet.toArray(this.eventArray);
    }

    @Override
    RuleEvent.Reuse getReuse() {
        return this.reuse;
    }

    @Override
    public boolean conflicts(RuleEvent other) {
        BasicEvent[] basicEventArray = this.eventArray;
        int n = this.eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicEvent event = basicEventArray[n2];
            if (event.conflicts(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public AnchorValue getAnchorImage(int i) {
        return this.eventArray[0].getAnchorImage(i);
    }

    @Override
    public RuleToHostMap getAnchorMap() {
        return this.eventArray[0].getAnchorMap();
    }

    @Override
    public String getAnchorImageString() {
        ArrayList<String> eventLabels = new ArrayList<String>();
        BasicEvent[] basicEventArray = this.eventArray;
        int n = this.eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicEvent event = basicEventArray[n2];
            eventLabels.add(String.valueOf(((Rule)event.getRule()).getFullName()) + event.getAnchorImageString());
            ++n2;
        }
        return Arrays.toString(eventLabels.toArray());
    }

    @Override
    protected Proof extractProof(TreeMatch match) {
        Proof result = null;
        for (Proof proof : match.toProofSet()) {
            RuleEvent proofEvent = this.createEvent(proof);
            if (this.hashCode() != proofEvent.hashCode() || !this.equals(proofEvent)) continue;
            result = proof;
            break;
        }
        return result;
    }

    @Override
    public RuleEvent createEvent(Proof proof) {
        return proof.newEvent(this.record);
    }

    @Override
    public void recordEffect(RuleEffect record) {
        BasicEvent[] events = this.eventArray;
        int eventCount = events.length;
        int i = 0;
        while (i < eventCount) {
            events[i].recordEffect(record);
            ++i;
        }
    }

    @Override
    public int compareTo(RuleEvent other) {
        BasicEvent[] otherEventArray;
        BasicEvent[] myEventArray;
        int result = ((Rule)this.getRule()).compareTo(other.getRule());
        if (result == 0 && (result = (myEventArray = this.eventArray).length - (otherEventArray = other instanceof CompositeEvent ? ((CompositeEvent)other).eventArray : new BasicEvent[]{(BasicEvent)other}).length) == 0) {
            int i = 0;
            while (result == 0 && i < myEventArray.length) {
                result = myEventArray[i].compareTo(otherEventArray[i]);
                ++i;
            }
        }
        return result;
    }

    public Set<BasicEvent> getEventSet() {
        return ((CompositeEventCache)this.getCache()).getEventSet();
    }

    @Override
    int computeEventHashCode() {
        int result = 1;
        int i = 0;
        while (i < this.eventArray.length) {
            result += this.eventArray[i].hashCode();
            ++i;
        }
        return result;
    }

    @Override
    boolean equalsEvent(RuleEvent obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompositeEvent)) {
            return false;
        }
        BasicEvent[] myEvents = this.eventArray;
        BasicEvent[] otherEvents = ((CompositeEvent)obj).eventArray;
        if (myEvents.length != otherEvents.length) {
            return false;
        }
        HashSet<BasicEvent> myEventSet = new HashSet<BasicEvent>(Arrays.asList(myEvents));
        int i = 0;
        while (i < otherEvents.length) {
            if (!myEventSet.contains(otherEvents[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.eventArray[0].toString();
    }

    @Override
    HostNode[] getArguments(HostNode[] addedNodes) {
        return this.eventArray[0].getArguments(addedNodes);
    }

    @Override
    protected CompositeEventCache createCache() {
        return new CompositeEventCache();
    }

    @Override
    public void clearCache() {
        super.clearCache();
        BasicEvent[] basicEventArray = this.eventArray;
        int n = this.eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasicEvent event = basicEventArray[n2];
            event.clearCache();
            ++n2;
        }
    }

    class CompositeEventCache
    extends AbstractRuleEvent.AbstractEventCache {
        private SortedSet<BasicEvent> eventSet;

        CompositeEventCache() {
        }

        SortedSet<BasicEvent> getEventSet() {
            if (this.eventSet == null) {
                this.eventSet = new TreeSet<BasicEvent>(Arrays.asList(CompositeEvent.this.eventArray));
            }
            return this.eventSet;
        }
    }
}

