/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.Condition;
import groove.grammar.Rule;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.RuleToHostMap;
import groove.transform.BasicEvent;
import groove.transform.CompositeEvent;
import groove.transform.Record;
import groove.transform.RuleEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

public class Proof {
    private final Condition condition;
    private final RuleToHostMap patternMap;
    private final Collection<Proof> subProofs = new LinkedHashSet<Proof>();
    private int hashCode;
    public static final Proof TrueProof = new Proof(Condition.True, null);

    public Proof(Condition condition, RuleToHostMap patternMap) {
        this.condition = condition;
        this.patternMap = patternMap;
        assert (condition.getOp().hasPattern() || (condition.getOp().isConjunctive() || condition.getOp() == Condition.Op.TRUE) && patternMap == null);
    }

    public boolean hasRule() {
        return this.condition.hasRule();
    }

    public Rule getRule() {
        return this.condition.getRule();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean isComposite() {
        return this.patternMap == null;
    }

    public RuleToHostMap getPatternMap() {
        return this.patternMap;
    }

    public Collection<Proof> getSubProofs() {
        return this.subProofs;
    }

    public HostEdgeSet getEdgeValues() {
        HostEdgeSet result = new HostEdgeSet();
        for (Proof subMatch : this.getSubProofs()) {
            result.addAll(subMatch.getEdgeValues());
        }
        if (this.patternMap != null) {
            result.addAll(this.patternMap.edgeMap().values());
        }
        return result;
    }

    public HostNodeSet getNodeValues() {
        HostNodeSet result = new HostNodeSet();
        for (Proof subMatch : this.getSubProofs()) {
            result.addAll(subMatch.getNodeValues());
        }
        if (this.patternMap != null) {
            result.addAll(this.patternMap.nodeMap().values());
        }
        return result;
    }

    public RuleEvent newEvent(Record nodeFactory) {
        assert (this.hasRule());
        ArrayList<BasicEvent> eventSet = new ArrayList<BasicEvent>();
        this.collectEvents(eventSet, nodeFactory);
        assert (!eventSet.isEmpty());
        if (eventSet.size() == 1 && !this.getRule().hasSubRules()) {
            return (RuleEvent)eventSet.iterator().next();
        }
        return this.createCompositeEvent(nodeFactory, eventSet);
    }

    private void collectEvents(Collection<BasicEvent> events, Record nodeFactory) {
        if (this.hasRule()) {
            BasicEvent myEvent = this.createSimpleEvent(nodeFactory);
            events.add(myEvent);
        }
        for (Proof subMatch : this.getSubProofs()) {
            subMatch.collectEvents(events, nodeFactory);
        }
    }

    private BasicEvent createSimpleEvent(Record record) {
        assert (this.hasRule());
        if (record == null) {
            return new BasicEvent(this.getRule(), this.getPatternMap(), RuleEvent.Reuse.NONE);
        }
        return record.createSimpleEvent(this.getRule(), this.getPatternMap());
    }

    private RuleEvent createCompositeEvent(Record record, Collection<BasicEvent> eventSet) {
        if (record == null) {
            return new CompositeEvent(record, this.getRule(), eventSet, RuleEvent.Reuse.NONE);
        }
        return record.createCompositeEvent(this.getRule(), eventSet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Proof)) {
            return false;
        }
        Proof other = (Proof)obj;
        if (!other.getCondition().equals(this.getCondition())) {
            return false;
        }
        if (this.getPatternMap() == null ? other.getPatternMap() != null : !this.getPatternMap().equals(other.getPatternMap())) {
            return false;
        }
        if (this.getSubProofs() == null) {
            return other.getSubProofs() == null;
        }
        return this.getSubProofs().equals(other.getSubProofs());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    protected int computeHashCode() {
        int result = this.getCondition().hashCode();
        result = 31 * result + this.getSubProofs().hashCode();
        if (this.getPatternMap() != null) {
            result = 31 * result + this.getPatternMap().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.getPatternMap() == null) {
            result.append(String.format("Combined match of %s", this.getCondition().getName()));
        } else {
            result.append(String.format("Match of %s: Nodes %s, edges %s", this.getCondition().getName(), this.getPatternMap().nodeMap(), this.getPatternMap().edgeMap()));
        }
        if (!this.getSubProofs().isEmpty()) {
            result.append(String.format("%n--- Submatches of %s ---%n", this.getCondition().getName()));
            for (Proof match : this.getSubProofs()) {
                result.append(match.toString());
                result.append("\n");
            }
            result.append(String.format("--- End of %s ---", this.getCondition().getName()));
        }
        return result.toString();
    }
}

