/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.algebra.JavaStringAlgebra;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.util.ExprParser;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import org.antlr.runtime.Parser;
import org.antlr.runtime.tree.CommonTree;

public class AntlrGrapher {
    private final String[] tokens;
    private final BitSet textTypes;
    private static final String TOKEN_NAMES = "tokenNames";
    public static final TypeLabel CHILD_LABEL = TypeLabel.createBinaryLabel("child");
    public static final TypeLabel NEXT_LABEL = TypeLabel.createBinaryLabel("next");
    public static final TypeLabel TEXT_LABEL = TypeLabel.createBinaryLabel("text");
    public static final TypeLabel FIRST_FLAG = TypeLabel.createLabel(EdgeRole.FLAG, "first");
    public static final TypeLabel LAST_FLAG = TypeLabel.createLabel(EdgeRole.FLAG, "last");
    public static final TypeLabel LEAF_FLAG = TypeLabel.createLabel(EdgeRole.FLAG, "leaf");
    public static final TypeLabel TOP_TYPE = TypeLabel.createLabel(EdgeRole.NODE_TYPE, "TOP$");
    private static final TypeLabel STRING_TYPE = TypeLabel.createLabel(EdgeRole.NODE_TYPE, "string");

    public AntlrGrapher(Class<? extends Parser> parser, int ... textTypes) throws IllegalArgumentException {
        try {
            this.tokens = (String[])parser.getField(TOKEN_NAMES).get(null);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
        this.textTypes = new BitSet(this.tokens.length);
        int[] nArray = textTypes;
        int n = textTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (type < 0 || type > this.tokens.length) {
                throw new IllegalArgumentException(String.format("Token type %d does not exist in parser class %s", type, parser));
            }
            this.textTypes.set(type);
            ++n2;
        }
    }

    public TypeGraph getType() {
        TypeGraph result = new TypeGraph("type");
        TypeNode topNode = result.addNode(TOP_TYPE);
        result.addEdge(topNode, CHILD_LABEL, topNode);
        result.addEdge(topNode, NEXT_LABEL, topNode);
        result.addEdge(topNode, FIRST_FLAG, topNode);
        result.addEdge(topNode, LAST_FLAG, topNode);
        result.addEdge(topNode, LEAF_FLAG, topNode);
        TypeNode stringNode = result.addNode(STRING_TYPE);
        int i = 0;
        while (i < this.tokens.length) {
            String token = this.tokens[i];
            if (ExprParser.isIdentifier(token)) {
                TypeNode tokenNode;
                block5: {
                    TypeLabel typeLabel = TypeLabel.createLabel(EdgeRole.NODE_TYPE, token);
                    tokenNode = result.addNode(typeLabel);
                    try {
                        result.addInheritance(tokenNode, topNode);
                    }
                    catch (FormatException formatException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
                if (this.textTypes.get(i)) {
                    result.addEdge(tokenNode, TEXT_LABEL, stringNode);
                }
            }
            ++i;
        }
        return result;
    }

    public HostGraph getGraph(CommonTree tree) {
        DefaultHostGraph result = new DefaultHostGraph("ast");
        HashMap<CommonTree, HostNode> treeNodeMap = new HashMap<CommonTree, HostNode>();
        treeNodeMap.put(tree, this.createNode(result, tree));
        HashSet<CommonTree> pool = new HashSet<CommonTree>();
        pool.add(tree);
        while (!pool.isEmpty()) {
            CommonTree next = (CommonTree)pool.iterator().next();
            assert (next != null);
            pool.remove(next);
            HostNode nextNode = (HostNode)treeNodeMap.get(next);
            HostNode prevChild = null;
            int i = 0;
            while (i < next.getChildCount()) {
                CommonTree child = (CommonTree)next.getChild(i);
                HostNode childNode = this.createNode(result, child);
                treeNodeMap.put(child, childNode);
                result.addEdge(nextNode, CHILD_LABEL, childNode);
                if (prevChild == null) {
                    result.addEdge(childNode, FIRST_FLAG, childNode);
                } else {
                    result.addEdge(prevChild, NEXT_LABEL, childNode);
                }
                pool.add(child);
                prevChild = childNode;
                ++i;
            }
            if (prevChild == null) {
                result.addEdge(nextNode, LEAF_FLAG, nextNode);
                continue;
            }
            result.addEdge(prevChild, LAST_FLAG, prevChild);
        }
        return result;
    }

    private HostNode createNode(DefaultHostGraph graph, CommonTree tree) {
        HostNode result = (HostNode)graph.addNode();
        int tokenType = tree.getType();
        graph.addEdge(result, TypeLabel.createLabel(EdgeRole.NODE_TYPE, this.tokens[tokenType]), result);
        if (this.textTypes.get(tokenType) && tree.getText() != null) {
            ValueNode nameNode = graph.addNode(JavaStringAlgebra.instance, tree.getText());
            graph.addEdge(result, TEXT_LABEL, nameNode);
        }
        return result;
    }
}

