/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.util.Groove;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class Colors {
    public static final String BRIGHTER = ".brighter";
    public static final String DARKER = ".darker";
    private static final Map<String, Color> colorMap;
    private static final int MAX = 255;

    static {
        Field[] colorFields;
        colorMap = new TreeMap<String, Color>();
        Class<Color> colorClass = Color.class;
        Field[] fieldArray = colorFields = colorClass.getFields();
        int n = colorFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isStatic(field.getModifiers()) && field.getType() == colorClass) {
                try {
                    String key = field.getName();
                    Color color = (Color)field.get(null);
                    colorMap.put(key, color);
                    colorMap.put(String.valueOf(key) + DARKER, color.darker());
                    colorMap.put(String.valueOf(key) + BRIGHTER, color.brighter());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
    }

    public static Map<String, Color> getColorMap() {
        return Collections.unmodifiableMap(colorMap);
    }

    public static Color findColor(String name) {
        if (colorMap.containsKey(name)) {
            return colorMap.get(name);
        }
        Color result = Color.getColor(name);
        if (result != null) {
            return result;
        }
        try {
            return Color.decode(name);
        }
        catch (NumberFormatException numberFormatException) {
            int[] val = Groove.toIntArray(name);
            if (val == null) {
                val = Groove.toIntArray(name, ",");
            }
            if (val != null) {
                if (val.length == 3) {
                    return new Color(Colors.norm(val[0]), Colors.norm(val[1]), Colors.norm(val[2]));
                }
                if (val.length == 4) {
                    return new Color(Colors.norm(val[0]), Colors.norm(val[1]), Colors.norm(val[2]), Colors.norm(val[3]));
                }
            }
            return null;
        }
    }

    public static void main(String[] args) {
        for (Map.Entry<String, Color> colorEntry : colorMap.entrySet()) {
            String key = colorEntry.getKey();
            Color color = colorEntry.getValue();
            String colorString = color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha();
            System.out.println(String.valueOf(key) + " = " + colorString);
            assert (color.equals(Colors.findColor(colorString)));
        }
    }

    private static int norm(int val) {
        if (val < 0) {
            return 0;
        }
        if (val > 255) {
            return 255;
        }
        return val;
    }
}

