/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.grammar.model.FormatException;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ExprParser {
    private final boolean[] quoteChars = new boolean[255];
    private final boolean[] openBrackets = new boolean[255];
    private final boolean[] closeBrackets = new boolean[255];
    private final Map<Character, Integer> openBracketsIndexMap = new LinkedHashMap<Character, Integer>();
    private final Map<Character, Integer> closeBracketsIndexMap = new LinkedHashMap<Character, Integer>();
    private final char placeholder;
    public static final char SINGLE_QUOTE_CHAR = '\'';
    public static final char DOUBLE_QUOTE_CHAR = '\"';
    public static final char ESCAPE_CHAR = '\\';
    public static final char LPAR_CHAR = '(';
    public static final char RPAR_CHAR = ')';
    public static final char LANGLE_CHAR = '<';
    public static final char RANGLE_CHAR = '>';
    public static final char LCURLY = '{';
    public static final char RCURLY = '}';
    public static final char[] ROUND_BRACKETS = new char[]{'(', ')'};
    private static final char[] CURLY_BRACKETS = new char[]{'{', '}'};
    private static final char[] SQUARE_BRACKETS = new char[]{'[', ']'};
    private static final char[] ANGLE_BRACKETS = new char[]{'<', '>'};
    public static final int INFIX_POSITION = 0;
    public static final int PREFIX_POSITION = 1;
    public static final int POSTFIX_POSITION = 2;
    private static final char[] DEFAULT_QUOTE_CHARS = new char[]{'\"', '\''};
    private static final char[][] DEFAULT_BRACKETS = new char[][]{ROUND_BRACKETS, ANGLE_BRACKETS, CURLY_BRACKETS, SQUARE_BRACKETS};
    public static final char PLACEHOLDER = '\uffff';
    public static final String IDENTIFIER_CHARS = "_$";
    public static final String IDENTIFIER_START_CHARS = "_";
    private static final ExprParser prototype = new ExprParser();

    public ExprParser() {
        this(DEFAULT_BRACKETS);
    }

    public ExprParser(char[] ... brackets) {
        this('\uffff', DEFAULT_QUOTE_CHARS, brackets);
    }

    public ExprParser(char placeholder, char[] quoteChars, char[] ... brackets) {
        char[] cArray = quoteChars;
        int n = quoteChars.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            this.quoteChars[element] = true;
            ++n2;
        }
        int i = 0;
        while (i < brackets.length) {
            char[] element = brackets[i];
            char open = element[0];
            this.openBrackets[open] = true;
            this.openBracketsIndexMap.put(Character.valueOf(open), i);
            char close = element[1];
            this.closeBrackets[close] = true;
            this.closeBracketsIndexMap.put(Character.valueOf(close), i);
            ++i;
        }
        this.placeholder = placeholder;
    }

    public Pair<String, List<String>> parse(String expr) throws FormatException {
        boolean escaped = false;
        boolean quoted = false;
        char quoteChar = '\u0000';
        Stack<Character> bracketStack = new Stack<Character>();
        SimpleStringBuilder strippedExpr = new SimpleStringBuilder(expr.length());
        LinkedList<String> replacements = new LinkedList<String>();
        SimpleStringBuilder current = strippedExpr;
        int i = 0;
        while (i < expr.length()) {
            char nextChar = expr.charAt(i);
            Character nextCharObject = Character.valueOf(nextChar);
            if (escaped) {
                current.add(nextChar);
                escaped = false;
            } else if (nextChar == '\\') {
                current.add(nextChar);
                escaped = true;
            } else if (quoted) {
                current.add(nextChar);
                boolean bl = quoted = nextChar != quoteChar;
                if (!quoted && bracketStack.isEmpty()) {
                    strippedExpr.add(this.placeholder);
                    replacements.add(current.toString());
                    current = strippedExpr;
                }
            } else if (this.quoteChars[nextChar]) {
                if (bracketStack.isEmpty()) {
                    current = new SimpleStringBuilder(expr.length() - i);
                }
                current.add(nextChar);
                quoted = true;
                quoteChar = nextChar;
            } else if (this.openBrackets[nextChar]) {
                if (bracketStack.isEmpty()) {
                    current = new SimpleStringBuilder(expr.length() - i);
                }
                current.add(nextChar);
                bracketStack.push(Character.valueOf(nextChar));
            } else if (this.closeBrackets[nextChar]) {
                int closeBracketIndex;
                if (bracketStack.isEmpty()) {
                    throw new FormatException("Unbalanced brackets in expression '%s': '%c' is not opened", expr, Character.valueOf(nextChar));
                }
                Character openBracket = (Character)bracketStack.pop();
                int openBracketIndex = this.openBracketsIndexMap.get(openBracket);
                if (openBracketIndex != (closeBracketIndex = this.closeBracketsIndexMap.get(nextCharObject).intValue())) {
                    throw new FormatException("Unbalanced brackets in expression '%s': '%c' closed by '%c'", expr, openBracket, Character.valueOf(nextChar));
                }
                current.add(nextChar);
                if (bracketStack.isEmpty()) {
                    strippedExpr.add(this.placeholder);
                    replacements.add(current.toString());
                    current = strippedExpr;
                }
            } else {
                current.add(nextChar);
            }
            ++i;
        }
        if (escaped) {
            throw new FormatException("Expression '%s' ends on escape character", expr);
        }
        if (quoted) {
            throw new FormatException("Unbalanced quotes in expression '%s': %c is not closed", expr, Character.valueOf(quoteChar));
        }
        if (!bracketStack.isEmpty()) {
            throw new FormatException("Unbalanced brackets in expression '%s': '%c' is not closed", expr, bracketStack.pop());
        }
        return new Pair<String, List<String>>(strippedExpr.toString(), Collections.unmodifiableList(replacements));
    }

    public String unparse(String basis, List<String> replacements) {
        int replacementLength = 0;
        for (String replacement : replacements) {
            replacementLength += replacement.length();
        }
        SimpleStringBuilder result = new SimpleStringBuilder(basis.length() + replacementLength);
        Iterator<String> replacementIter = replacements.iterator();
        int i = 0;
        while (i < basis.length()) {
            char next = basis.charAt(i);
            if (next == this.placeholder) {
                String replacement = replacementIter.next();
                int c = 0;
                while (c < replacement.length()) {
                    result.add(replacement.charAt(c));
                    ++c;
                }
            } else {
                result.add(next);
            }
            ++i;
        }
        return result.toString();
    }

    public String[] split(String expr, String split) throws FormatException {
        ArrayList<String> result = new ArrayList<String>();
        Pair<String, List<String>> parseResult = this.parse(expr);
        String parseExpr = parseResult.one();
        Iterator<String> replacements = parseResult.two().iterator();
        SimpleStringBuilder subResult = new SimpleStringBuilder(expr.length());
        int i = 0;
        while (i < parseExpr.length()) {
            char next = parseExpr.charAt(i);
            if (next == split.charAt(0) && parseExpr.startsWith(split, i)) {
                result.add(subResult.toString());
                subResult.clear();
                i += split.length() - 1;
            } else if (next == this.placeholder) {
                String replacement = replacements.next();
                int c = 0;
                while (c < replacement.length()) {
                    subResult.add(replacement.charAt(c));
                    ++c;
                }
            } else if (!subResult.isEmpty() || !Character.isWhitespace(next)) {
                subResult.add(next);
            }
            ++i;
        }
        result.add(subResult.toString());
        return result.toArray(new String[result.size()]);
    }

    public String[] split(String expr, String oper, int position) throws FormatException {
        expr = expr.trim();
        switch (position) {
            case 0: {
                String[] result = this.split(expr, oper);
                if (result.length == 1) {
                    if (result[0].length() == 0) {
                        return new String[0];
                    }
                    return result;
                }
                int i = 0;
                while (i < result.length) {
                    if (result[i].length() == 0) {
                        throw new FormatException("Infix operator '" + oper + "' has empty operand nr. " + i + " in \"" + expr + "\"", new Object[0]);
                    }
                    ++i;
                }
                return result;
            }
            case 1: {
                Pair<String, List<String>> parsedExpr = this.parse(expr);
                String parsedBasis = parsedExpr.one();
                List<String> replacements = parsedExpr.two();
                int operIndex = parsedBasis.indexOf(oper);
                if (operIndex < 0) {
                    return null;
                }
                if (operIndex > 0) {
                    throw new FormatException("Prefix operator '" + oper + "' occurs in wrong position in \"" + expr + "\"", new Object[0]);
                }
                if (expr.length() == oper.length()) {
                    throw new FormatException("Prefix operator '" + oper + "' has empty operand in \"" + expr + "\"", new Object[0]);
                }
                return new String[]{this.unparse(parsedBasis.substring(oper.length()), replacements)};
            }
            case 2: {
                Pair<String, List<String>> parsedExpr = this.parse(expr);
                String parsedBasis = parsedExpr.one();
                List<String> replacements = parsedExpr.two();
                int operIndex = parsedBasis.lastIndexOf(oper);
                if (operIndex < 0) {
                    return null;
                }
                if (operIndex < parsedBasis.length() - oper.length()) {
                    throw new FormatException("Postfix operator '" + oper + "' occurs in wrong position in \"" + expr + "\"", new Object[0]);
                }
                if (operIndex == 0) {
                    throw new FormatException("Postfix operator '" + oper + "' has empty operand in \"" + expr + "\"", new Object[0]);
                }
                return new String[]{this.unparse(parsedBasis.substring(0, operIndex), replacements)};
            }
        }
        throw new IllegalArgumentException("Illegal position parameter value '" + position + "'");
    }

    public static Pair<String, List<String>> parseExpr(String expr) throws FormatException {
        ExprParser p = prototype;
        return p.parse(expr);
    }

    public static String unparseExpr(String basis, List<String> replacements) {
        return prototype.unparse(basis, replacements);
    }

    public static boolean isParsable(String expr) {
        try {
            ExprParser.parseExpr(expr);
            return true;
        }
        catch (FormatException formatException) {
            return false;
        }
    }

    public static String toString(String main, List<String> args) {
        StringBuffer result = new StringBuffer();
        int placeHolderCount = 0;
        int c = 0;
        while (c < main.length()) {
            char nextChar = main.charAt(c);
            if (nextChar == '\uffff') {
                if (placeHolderCount > args.size()) {
                    return null;
                }
                result.append(args.get(placeHolderCount));
                ++placeHolderCount;
            } else {
                result.append(nextChar);
            }
            ++c;
        }
        return result.toString();
    }

    public static String[] splitExpr(String expr, String split) throws FormatException {
        return prototype.split(expr, split);
    }

    public static String[] splitExpr(String expr, String split, int position) throws FormatException {
        return prototype.split(expr, split, position);
    }

    public static String toTrimmed(String expr, char open, char close) throws FormatException {
        Pair<String, List<String>> parseResult = new ExprParser(new char[][]{{open, close}}).parse(expr);
        if (parseResult.one().length() != 1 || parseResult.two().get(0).charAt(0) != open) {
            throw new FormatException("Expression %s not surrounded by bracket pair %c%c", expr, Character.valueOf(open), Character.valueOf(close));
        }
        return expr.substring(1, expr.length() - 1);
    }

    public static String toRegExpr(String expr) {
        return expr.replaceAll("(\\W)", "\\\\$1");
    }

    public static String toNormExpr(String regExpr) {
        String result = regExpr.replaceAll("\\\\\\\\", "\\\\\uffff");
        result = result.replaceAll("^\\W", "");
        result = result.replaceAll("([^\\\\])\\W", "$1");
        result = result.replaceAll("\\\\(\\W)", "$1");
        result = result.replace('\uffff', '\\');
        return result;
    }

    public static String toEscaped(String string, Set<Character> specialChars) {
        StringBuffer result = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\\' || specialChars.contains(Character.valueOf(c))) {
                result.append('\\');
            }
            result.append(c);
            ++n2;
        }
        return result.toString();
    }

    public static String toQuoted(String string, char quote) {
        StringBuffer result = new StringBuffer();
        result.append(quote);
        result.append(ExprParser.toEscaped(string, Collections.singleton(Character.valueOf(quote))));
        result.append(quote);
        return result.toString();
    }

    public static String toUnquoted(String string, char quote) throws FormatException {
        boolean startsWithQuote = !string.isEmpty() && string.charAt(0) == quote;
        boolean endsWithQuote = false;
        char[] content = string.toCharArray();
        StringBuffer result = new StringBuffer();
        boolean escaped = false;
        int quoteCount = 0;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (escaped) {
                result.append(c);
                escaped = false;
                endsWithQuote = false;
            } else {
                boolean bl = escaped = c == '\\';
                if (!escaped) {
                    result.append(c);
                    if (c == quote) {
                        endsWithQuote = true;
                        ++quoteCount;
                    } else {
                        endsWithQuote = false;
                    }
                }
            }
            ++n2;
        }
        if (escaped) {
            throw new FormatException("String %s ends on escape character", new Object[0]);
        }
        if (startsWithQuote ? !endsWithQuote || quoteCount != 2 : quoteCount != 0) {
            throw new FormatException("Unbalanced quotes in %s", string);
        }
        if (startsWithQuote) {
            return result.substring(1, result.length() - 1);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println("Empty string: " + "".substring(0, 0));
        if (args.length == 0) {
            System.out.println("Regular expression tests");
            System.out.println("------- ---------- -----");
            ExprParser.testRegExpr("a(3)");
            ExprParser.testRegExpr("$ \\ii*2");
            ExprParser.testRegExpr("\\\\\\a \\");
            System.out.println();
            System.out.println("String quotation tests");
            System.out.println("----- --------- -----");
            ExprParser.testQuoteString("a\"3\"");
            ExprParser.testQuoteString("\"a \\\"stress\\\" test\"");
            ExprParser.testQuoteString("a\\\"");
            System.out.println();
            System.out.println("Parsing tests");
            System.out.println("------- -----");
            ExprParser.testParse("");
            ExprParser.testParse("()");
            ExprParser.testParse("(<)");
            ExprParser.testParse("(\\<)");
            ExprParser.testParse("()')");
            ExprParser.testParse("()\\)");
            ExprParser.testParse("(\\')");
            ExprParser.testParse("()')'");
            ExprParser.testParse("a'b+c");
            ExprParser.testParse("a()b<(c)>");
            ExprParser.testParse("{a()b<(c)>}");
            ExprParser.testParse("\"{a()b<(c)>\"");
            ExprParser.testParse("\"(\"(a+b)");
            ExprParser.testParse("(\"(\"a+b)");
            ExprParser.testParse("\"");
            ExprParser.testParse("(");
            ExprParser.testParse(")");
            ExprParser.testParse("\\'");
            ExprParser.testParse("{a()b<(c)}");
            System.out.println();
            System.out.println("Splitting tests");
            System.out.println("--------- -----");
            ExprParser.testSplit("\"a \\\"stress\\\" test\"", ",");
            ExprParser.testSplit("a|(b.c)*", "|");
            ExprParser.testSplit("a|(b.c)*", "*");
            ExprParser.testSplit("a|(b.c)*", ".");
            ExprParser.testSplit("a|(b.c)*", "|", 0);
            ExprParser.testSplit("a|(b.c)*", "|", 2);
            ExprParser.testSplit("a|(b.c)*", "*", 0);
            ExprParser.testSplit("a|(b.c)*", "*", 2);
            ExprParser.testSplit("a|(b.c)*", "a", 1);
            ExprParser.testSplit("a|(b.c)*", "a", 2);
            ExprParser.testTrim("(b.c ) ", '(', ')');
            ExprParser.testTrim("a|(b.c)*", '(', ')');
            ExprParser.testTrim(" (b.c)* ", '(', ')');
        } else {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                ExprParser.testParse(element);
                ++n2;
            }
        }
    }

    private static void testRegExpr(String expr) {
        System.out.print("Expression " + expr);
        expr = ExprParser.toRegExpr(expr);
        System.out.print(". To regular: " + expr);
        expr = ExprParser.toNormExpr(expr);
        System.out.println(". To normal: " + expr);
    }

    private static void testQuoteString(String string) {
        System.out.print("String " + string);
        string = ExprParser.toQuoted(string, '\"');
        System.out.print(". To quoted: " + string);
        try {
            string = ExprParser.toUnquoted(string, '\"');
            System.out.println(". To unquoted: " + string);
        }
        catch (FormatException e) {
            System.out.println(". Error: " + e);
        }
    }

    private static void testParse(String expr) {
        try {
            System.out.println("Parsing: " + expr);
            Pair<String, List<String>> result = ExprParser.parseExpr(expr);
            System.out.println("Result: " + result.one() + " with replacements " + result.two());
        }
        catch (FormatException exc) {
            System.out.println("Error: " + exc.getMessage());
        }
        System.out.println();
    }

    private static void testSplit(String expr, String split) {
        try {
            System.out.println("Splitting: \"" + expr + "\" according to \"" + split + "\"");
            String[] result = ExprParser.splitExpr(expr, split);
            if (result == null) {
                System.out.println("null");
            } else {
                System.out.print("[\"");
                int i = 0;
                while (i < result.length) {
                    System.out.print((Object)result[i]);
                    if (i < result.length - 1) {
                        System.out.print("\", \"");
                    }
                    ++i;
                }
                System.out.println("\"]");
            }
        }
        catch (FormatException exc) {
            System.out.println("Error: " + exc.getMessage());
        }
        System.out.println();
    }

    private static void testSplit(String expr, String oper, int position) {
        try {
            System.out.print("Splitting: \"" + expr + "\" according to ");
            System.out.print(position == 0 ? "infix" : (position == 1 ? "prefix" : "postfix"));
            System.out.println(" operator \"" + oper + "\"");
            String[] result = ExprParser.splitExpr(expr, oper, position);
            System.out.print("Result: ");
            if (result == null) {
                System.out.println("null");
            } else {
                System.out.print("[\"");
                int i = 0;
                while (i < result.length) {
                    System.out.print(result[i]);
                    if (i < result.length - 1) {
                        System.out.print("\", \"");
                    }
                    ++i;
                }
                System.out.println("\"]");
            }
        }
        catch (FormatException exc) {
            System.out.println("Error: " + exc.getMessage());
        }
        System.out.println();
    }

    private static void testTrim(String expr, char open, char close) {
        System.out.println("Trimming bracket pair '" + open + "', '" + close + "' from \"" + expr + "\"");
        try {
            String result = ExprParser.toTrimmed(expr.trim(), open, close);
            System.out.printf("Result: \"%s\"%n", result);
        }
        catch (FormatException e) {
            System.out.printf("Error: \"%s\"%n", e);
        }
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || IDENTIFIER_CHARS.indexOf(c) >= 0;
    }

    public static boolean isIdentifierStartChar(char c) {
        return Character.isLetter(c) || IDENTIFIER_START_CHARS.indexOf(c) >= 0;
    }

    public static boolean isIdentifier(String text) {
        if (text.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char nextChar = text.charAt(i);
            if (i == 0 ? !ExprParser.isIdentifierStartChar(nextChar) : !ExprParser.isIdentifierChar(nextChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class SimpleStringBuilder {
        private final char[] sequence;
        private int length;

        public SimpleStringBuilder(int capacity) {
            this.sequence = new char[capacity];
        }

        public void add(char next) {
            this.sequence[this.length] = next;
            ++this.length;
        }

        public String toString() {
            return new String(this.sequence, 0, this.length);
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public void clear() {
            this.length = 0;
        }
    }
}

