/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.grammar.model.GrammarModel;
import groove.graph.Graph;
import groove.graph.plain.PlainGraph;
import groove.io.FileType;
import groove.io.graph.GxlIO;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class Groove {
    public static final String WORKING_DIR;
    public static String CURRENT_WORKING_DIR;
    public static final String FILE_SEPARATOR;
    public static final String DEFAULT_START_GRAPH_NAME = "start";
    public static final String DEFAULT_CONTROL_NAME = "control";
    public static final String DEFAULT_TYPE_NAME = "type";
    public static final String PROPERTY_NAME = "system";
    public static final String XML_PROPERTIES_FILE;
    public static final boolean GATHER_STATISTICS = true;
    public static final String ARRAY_START = "[";
    public static final String ARRAY_END = "]";
    public static final String ARRAY_SEPARATOR = ",";
    private static final GxlIO gxlGraphLoader;
    public static final boolean IS_PLATFORM_WINDOWS;
    public static final boolean IS_PLATFORM_MAC;
    public static final boolean IS_PLATFORM_LINUX;

    static {
        CURRENT_WORKING_DIR = WORKING_DIR = System.getProperty("user.dir");
        FILE_SEPARATOR = System.getProperty("file.separator");
        XML_PROPERTIES_FILE = "groove.xml" + FileType.PROPERTY.getExtension();
        gxlGraphLoader = GxlIO.getInstance();
        IS_PLATFORM_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
        IS_PLATFORM_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac os x") > -1;
        IS_PLATFORM_LINUX = System.getProperty("os.name").toLowerCase().indexOf("linux") > -1;
        Locale.setDefault(Locale.ENGLISH);
    }

    public static PlainGraph loadGraph(String filename) throws IOException {
        File file = new File(filename);
        if ((FileType.GXL_FILTER.accept(file) || FileType.STATE_FILTER.accept(file)) && !(file = new File(FileType.GXL_FILTER.addExtension(filename))).exists()) {
            file = new File(FileType.STATE_FILTER.addExtension(filename));
        }
        return Groove.loadGraph(file);
    }

    public static PlainGraph loadGraph(File file) throws IOException {
        return gxlGraphLoader.loadGraph(file).toPlainGraph();
    }

    public static File saveGraph(Graph graph, String filename) throws IOException {
        if (!FileType.STATE_FILTER.hasExtension(filename)) {
            filename = FileType.GXL_FILTER.addExtension(filename);
        }
        File file = new File(filename);
        Groove.saveGraph(graph, file);
        return file;
    }

    public static void saveGraph(Graph graph, File file) throws IOException {
        gxlGraphLoader.saveGraph(graph, file);
    }

    public static Rectangle toRectangle(Rectangle2D r) {
        if (r != null) {
            return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
        }
        return null;
    }

    public static GrammarModel loadGrammar(String dirname) throws IOException {
        File dir = new File(FileType.GRAMMAR_FILTER.addExtension(dirname));
        return GrammarModel.newInstance(dir, false);
    }

    public static String currentTime(int lossfactor, int modulo, int fraction) {
        long time = System.currentTimeMillis() / (long)lossfactor;
        StringBuffer res = new StringBuffer();
        while (modulo > 1) {
            res.insert(0, time > 0L ? "" + time % 10L : "");
            time /= 10L;
            if ((fraction /= 10) == 1) {
                res.insert(0, ".");
            }
            modulo /= 10;
        }
        return res.toString();
    }

    public static String currentTime() {
        return Groove.currentTime(10, 10000, 100);
    }

    public static void message(Object obj) {
        System.out.println(String.valueOf(Groove.currentTime()) + ": " + obj);
    }

    public static void startMessage(String method) {
        Groove.message("Starting " + method);
    }

    public static void endMessage(String method) {
        Groove.message("Ending " + method);
    }

    public static URL getResource(String name) {
        return Groove.class.getClassLoader().getResource(name);
    }

    public static int[] toIntArray(String text) {
        return Groove.toIntArray(text, null);
    }

    public static int[] toIntArray(String text, String delims) {
        if (text == null) {
            return null;
        }
        try {
            StringTokenizer tokenizer = delims == null ? new StringTokenizer(text) : new StringTokenizer(text, delims);
            int[] result = new int[tokenizer.countTokens()];
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                result[count] = Integer.parseInt(nextToken);
                ++count;
            }
            return result;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String pad(String text, int length, boolean right) {
        StringBuffer result = new StringBuffer(text);
        while (result.length() < length) {
            if (right) {
                result.append(' ');
                continue;
            }
            result.insert(0, ' ');
        }
        return result.toString();
    }

    public static String pad(String text, int length) {
        return Groove.pad(text, length, true);
    }

    public static String unCamel(String input, boolean caps) {
        StringBuilder result = new StringBuilder(input);
        int ix = 0;
        boolean wasLower = true;
        while (ix < result.length()) {
            boolean atStart;
            char c = result.charAt(ix);
            boolean isLower = Character.isLowerCase(c);
            boolean bl = atStart = ix == 0;
            if (atStart || wasLower && !isLower) {
                boolean toUpper;
                if (!atStart) {
                    result.insert(ix, ' ');
                    ++ix;
                }
                boolean bl2 = toUpper = atStart || caps;
                if (!toUpper) {
                    toUpper = ix < result.length() - 1 && Character.isUpperCase(result.charAt(ix + 1));
                }
                result.setCharAt(ix, toUpper ? Character.toUpperCase(c) : Character.toLowerCase(c));
            }
            wasLower = isLower;
            ++ix;
        }
        return result.toString();
    }

    public static Integer[] toArray(int[] array) {
        Integer[] result = new Integer[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i];
            ++i;
        }
        return result;
    }

    public static <T> String toString(T[] array) {
        return Groove.toString(array, ARRAY_START, ARRAY_END, ARRAY_SEPARATOR);
    }

    public static <T> String toString(T[] array, String start, String end, String separator) {
        return Groove.toString(array, start, end, separator, separator);
    }

    public static String toString(Object[] array, String start, String end, String separator, String finalSeparator) {
        StringBuffer result = new StringBuffer(start);
        int i = 0;
        while (i < array.length) {
            result.append(array[i]);
            if (i < array.length - 2) {
                result.append(separator);
            } else if (i == array.length - 2) {
                result.append(finalSeparator);
            }
            ++i;
        }
        result.append(end);
        return result.toString();
    }

    public static URL toURL(File file) {
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(String.format("File '%s' cannot be converted to URL", file));
        }
        return url;
    }

    public static File toFile(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (url.getProtocol().equals("jar")) {
            try {
                URL innerURL = ((JarURLConnection)url.openConnection()).getJarFileURL();
                return Groove.toFile(innerURL);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static void printStackTrace(PrintStream out, boolean allLines) {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        String method = stackTrace[1].getMethodName();
        out.printf("%s called from: %n", method);
        int myCode = 2;
        while (myCode < stackTrace.length) {
            if (allLines || stackTrace[myCode].getLineNumber() >= 0) {
                out.printf("  %s%n", stackTrace[myCode]);
            }
            ++myCode;
        }
    }

    public static String toString(ActionMap am) {
        StringBuilder result = new StringBuilder();
        LinkedHashMap<Object, Action> map = new LinkedHashMap<Object, Action>();
        Object[] objectArray = am.allKeys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            map.put(key, am.get(key));
            ++n2;
        }
        result.append(map);
        result.append('\n');
        ActionMap parent = am.getParent();
        if (parent != null) {
            result.append("Parent: ");
            result.append(Groove.toString(parent));
        }
        return result.toString();
    }

    public static String toString(InputMap im) {
        StringBuilder result = new StringBuilder();
        LinkedHashMap<KeyStroke, Object> map = new LinkedHashMap<KeyStroke, Object>();
        KeyStroke[] keyStrokeArray = im.allKeys();
        int n = keyStrokeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke key = keyStrokeArray[n2];
            map.put(key, im.get(key));
            ++n2;
        }
        result.append(map);
        result.append('\n');
        InputMap parent = im.getParent();
        if (parent != null) {
            result.append("Parent: ");
            result.append(Groove.toString(parent));
        }
        return result.toString();
    }
}

