/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class ObservableSet<T>
extends Observable
implements Set<T> {
    private final Set<T> set;

    public ObservableSet(Set<T> set) {
        this.set = set;
    }

    public ObservableSet() {
        this(new HashSet());
    }

    @Override
    public boolean add(T o) {
        if (this.set.add(o)) {
            this.setChanged();
            this.notifyObservers(new AddUpdate<T>(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        HashSet<T> addedElements = new HashSet<T>();
        boolean result = false;
        for (T element : c) {
            if (!this.set.add(element)) continue;
            addedElements.add(element);
            result = true;
        }
        if (result) {
            this.setChanged();
            this.notifyObservers(new AddUpdate(addedElements));
        }
        return result;
    }

    @Override
    public void clear() {
        if (!this.set.isEmpty()) {
            HashSet<T> elements = new HashSet<T>(this.set);
            this.set.clear();
            this.setChanged();
            this.notifyObservers(new RemoveUpdate<HashSet<T>>(elements));
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iter = this.set.iterator();
        return new Iterator<T>(){
            private T last;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                this.last = iter.next();
                return this.last;
            }

            @Override
            public void remove() {
                iter.remove();
                ObservableSet.this.setChanged();
                ObservableSet.this.notifyObservers(new RemoveUpdate(this.last));
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.setChanged();
            this.notifyObservers(new RemoveUpdate<Object>(o));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        HashSet removedElements = new HashSet();
        boolean result = false;
        for (Object element : c) {
            if (!this.set.remove(element)) continue;
            removedElements.add(element);
            result = true;
        }
        if (result) {
            this.setChanged();
            this.notifyObservers(new RemoveUpdate(removedElements));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        HashSet<T> removedSet = new HashSet<T>();
        Iterator<T> iter = this.set.iterator();
        while (iter.hasNext()) {
            T element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            removedSet.add(element);
            result = true;
        }
        if (result) {
            this.setChanged();
            this.notifyObservers(new RemoveUpdate(removedSet));
        }
        return result;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.set.toArray(a);
    }

    @Override
    protected final synchronized void setChanged() {
        super.setChanged();
    }

    public static class AddUpdate<T> {
        private final Set<T> addedSet;

        AddUpdate(Set<T> addedSet) {
            this.addedSet = Collections.unmodifiableSet(addedSet);
        }

        AddUpdate(T element) {
            this.addedSet = Collections.singleton(element);
        }

        public Set<T> getAddedSet() {
            return this.addedSet;
        }
    }

    public static class RemoveUpdate<T> {
        private final Set<T> removedSet;

        RemoveUpdate(Set<T> removedSet) {
            this.removedSet = Collections.unmodifiableSet(removedSet);
        }

        RemoveUpdate(T element) {
            this.removedSet = Collections.singleton(element);
        }

        public Set<T> getRemovedSet() {
            return this.removedSet;
        }
    }
}

