/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class StackedSet<T>
extends AbstractSet<T> {
    final Set<? extends T> lower;
    final Set<T> added;
    final Set<T> removed;

    public StackedSet(Set<? extends T> lower, Set<T> added, Set<T> removed) {
        this.lower = lower;
        this.added = added;
        this.removed = removed;
        assert (lower != null) : "Lower set of stacked set should not be null";
        assert (added != null) : "Added set of stacked set should not be null";
        assert (removed != null) : "Removed set of stacked set should not be null";
    }

    public StackedSet() {
        this(Collections.emptySet());
    }

    public StackedSet(Set<? extends T> lower) {
        this.lower = lower;
        this.added = this.createAddedSet();
        this.removed = this.createRemovedSet();
        assert (lower != null) : "Lower set of stacked set should not be null";
    }

    @Override
    public int size() {
        return this.lower.size() + this.added.size() - this.removed.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Set<T> removed;
            private final Iterator<T> addedIter;
            private final Iterator<? extends T> lowerIter;
            private T lowerNext;
            private T lowerLatest;
            {
                this.removed = StackedSet.this.removed;
                this.addedIter = StackedSet.this.added.iterator();
                this.lowerIter = StackedSet.this.lower.iterator();
                this.lowerNext = null;
            }

            @Override
            public void remove() {
                if (this.lowerLatest == null) {
                    this.addedIter.remove();
                } else {
                    this.removed.add(this.lowerLatest);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.lowerLatest == null && this.addedIter.hasNext()) {
                    return true;
                }
                Iterator lowerIter = this.lowerIter;
                Object next = this.lowerNext;
                while (next == null && lowerIter.hasNext()) {
                    next = lowerIter.next();
                    if (!this.removed.contains(next)) continue;
                    next = null;
                }
                this.lowerNext = next;
                return next != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    if (this.lowerNext != null) {
                        this.lowerLatest = this.lowerNext;
                        this.lowerNext = null;
                        return this.lowerLatest;
                    }
                    return this.addedIter.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean add(T o) {
        if (this.removed.remove(o)) {
            return true;
        }
        return !this.lower.contains(o) && this.added.add(o);
    }

    @Override
    public void clear() {
        this.added.clear();
        this.removed.addAll(this.lower);
    }

    @Override
    public boolean contains(Object o) {
        return this.added.contains(o) || this.lower.contains(o) && !this.removed.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        if (this.added.remove(o)) {
            return true;
        }
        return this.lower.contains(o) && this.removed.add(o);
    }

    public Set<T> added() {
        return Collections.unmodifiableSet(this.added);
    }

    public Set<T> removed() {
        return Collections.unmodifiableSet(this.removed);
    }

    protected Set<T> lower() {
        return Collections.unmodifiableSet(this.lower);
    }

    protected Set<T> createAddedSet() {
        return new HashSet();
    }

    protected Set<T> createRemovedSet() {
        return new HashSet();
    }
}

