/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.TransformIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public abstract class TransformCollection<T, U>
extends AbstractCollection<U> {
    private final Collection<T> inner;

    public TransformCollection(Collection<T> inner) {
        this.inner = inner;
    }

    @Override
    public Iterator<U> iterator() {
        return new TransformIterator<T, U>(this.inner.iterator()){

            @Override
            protected U toOuter(T key) {
                return TransformCollection.this.toOuter(key);
            }
        };
    }

    @Override
    public boolean add(U obj) {
        return this.inner.add(this.toInner(obj));
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(this.toInner(o));
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(this.toInner(o));
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    protected abstract U toOuter(T var1);

    protected T toInner(Object key) {
        throw new UnsupportedOperationException();
    }
}

