/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.access.IUser;
import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.DebugListener;
import com.jaxfront.core.dom.DirtyChangeListener;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.dom.FingerPrint;
import com.jaxfront.core.dom.HistoryLoggingListener;
import com.jaxfront.core.dom.InitUIListener;
import com.jaxfront.core.dom.JAXFrontPropertyChangeSupport;
import com.jaxfront.core.dom.LoggingListener;
import com.jaxfront.core.dom.SerializationModifier;
import com.jaxfront.core.error.Error;
import com.jaxfront.core.error.ErrorTypeComparator;
import com.jaxfront.core.error.ValidationError;
import com.jaxfront.core.help.DefaultHelpURLResolver;
import com.jaxfront.core.help.HelpURLResolver;
import com.jaxfront.core.keyRef.KeyKeyRefManager;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.ActionPerformEvent;
import com.jaxfront.core.rule.ActionPerformListener;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.rule.SimpleRuleImpl;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.ClipBoard;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.DoubleKeyHashtable;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.util.ImageHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.StopWatch;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.XPathEncoder;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.util.io.IConnectionManager;
import com.jaxfront.core.util.io.cache.XUICache;
import com.jaxfront.core.util.io.classloader.DBClassLoader;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.xpath.XPathExecuterImpl;
import com.jaxfront.core.xpath.XPathTree;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.GlobalDefinition;
import com.jaxfront.core.xui.LayoutInfo;
import com.jaxfront.core.xui.NLS;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.core.xui.XUIDefinition;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParseException;
import org.nfunk.jep.type.NULL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document {
    public static final String DOCUMENT_STATUS = "STATUS";
    public static final String XUI_VERSION = "2.77";
    public static final String BUILD_VERSION = "10-2011-01";
    public static final String TARGET_PI = "jaxfront";
    public static final String DOM_ARGS = "domArgs";
    public static final String CLIENT_PROPERTY_HTTP_REQUEST = "http-request";
    public static final String CLIENT_PROPERTY_HTTP_PARAM_MAP_INITIAL = "initial-http-param-map";
    public static final String APPLICATION_PROPERTY_DOCUMENT = "Document";
    public static final String APPLICATION_PROPERTY_CUSTOM_CLASSLOADER = "customClassloader";
    public static final String GLOBAL_CODESET_DOC = "codeSetDoc";
    private String _appContext;
    private transient JAXFrontPropertyChangeSupport _propertyChangeSupport;
    private String _schemaLocation;
    private boolean _isXUIInitialized;
    private boolean _isBinding;
    private boolean _isReleased;
    private boolean _isSCReleased;
    private boolean _isSchemaCacheDom;
    private boolean _blockRuleEngine;
    private JAXFrontUndoManager _undoManager;
    private transient Document _uiDOM;
    private transient FingerPrint _fingerPrint;
    private transient FingerPrint _fingerPrintXUI;
    private transient NLS _nls;
    private transient XMLSchema _schema;
    private ClassLoader _customClassLoader;
    private transient TypeController _controller;
    private Type _rootType;
    protected transient Vector _domListeners;
    private transient HashMap _formulas;
    protected transient Vector _actionListeners;
    private List _processingInstructions;
    private transient List _filters;
    private GlobalDefinition _globalDefinition;
    public DoubleKeyHashtable itCache;
    public DoubleKeyHashtable parentCache;
    public DoubleKeyHashtable xpCache;
    private Hashtable _clientProperties;
    private Hashtable _applicationProperties;
    private DoubleKeyHashtable _xuiDefinitions;
    private Hashtable _globalRulesImpls;
    private Hashtable _xmlNamespaceMapping;
    private Hashtable _xuiNamespaceMapping;
    private HashMap _xmlPrefixNamespaceMapping;
    private String _defaultXMLNamespace;
    private HashSet _lostComponents;
    private LinkedHashMap _notFiredInitializationRules;
    private boolean _immutable;
    private String _encoding;
    private Hashtable _originalXmlHeaderAttributes;
    private Map<String, Type> _varToTypeMapping;
    private boolean _keepXUIDOMinMemory;
    private short _XUIDOMInstance;
    private SerializationModifier serializationModifier;
    public boolean _enforcePrefixSerialization;
    private boolean _isRunningAsXuiEditor;
    private ClipBoard _clipBoard;
    private KeyKeyRefManager _keyRefManager;
    private long _bindingTime;
    private long _initUITime;
    private long _serializationTime;
    private long _xuiComponentCount;
    private long _createdTime;
    public long _lastDomUpdateTime;
    private boolean _pasteMode;
    private boolean _blockRelease;
    private String _blockOwner;
    private boolean _releaseAfterUnblock;
    private boolean _hasXUI;
    private LoggingListener _historyListener;
    private XPathEncoder _xpEncoder;
    private FormulaExpression _formulaLookupDummy;
    private HelpURLResolver _helpUrlResolver;
    private String _lastLoadedNLSLanguage;
    private TypeVisualizerFactory _renderRequestFacotry;
    private Hashtable _editingTypeCache;
    private HashMap _noTargetVars;
    private WeakReference<IUser> _user;
    private InitUIListener _uiInitListener;
    private boolean _isSchemaInitMode;
    private String _rootName;
    private String _docID;
    private boolean _debugMode;
    private DebugListener _debugListener;
    public static int _instanceCount = 0;
    public static final String RIGHT_HIDDEN = "H";
    public static final String RIGHT_VISIBLE = "V";
    public static final String RIGHT_READ = "R";
    public static final String RIGHT_READ_WRITE_NOT_NULL = "RWN";
    public static final String RIGHT_READ_WRITE = "RW";
    private int _blockCounter;
    static /* synthetic */ Class class$com$jaxfront$core$dom$DebugListener;
    static /* synthetic */ Class class$org$apache$xerces$xni$parser$XMLEntityResolver;

    public Document(XMLSchema schema, Type rootType, Hashtable params) {
        block8: {
            this._appContext = null;
            this._isReleased = false;
            this._isSCReleased = false;
            this._isSchemaCacheDom = false;
            this._blockRuleEngine = false;
            this._undoManager = null;
            this._formulas = new HashMap();
            this.itCache = null;
            this.parentCache = null;
            this.xpCache = null;
            this._encoding = JAXFrontProperties.getDefaultXMLFileEncoding();
            this._originalXmlHeaderAttributes = null;
            this._varToTypeMapping = null;
            this._keepXUIDOMinMemory = false;
            this._XUIDOMInstance = (short)-1;
            this.serializationModifier = null;
            this._enforcePrefixSerialization = false;
            this._clipBoard = null;
            this._keyRefManager = null;
            this._bindingTime = -1L;
            this._initUITime = -1L;
            this._serializationTime = -1L;
            this._xuiComponentCount = 0L;
            this._lastDomUpdateTime = 0L;
            this._pasteMode = false;
            this._blockRelease = false;
            this._blockOwner = null;
            this._releaseAfterUnblock = false;
            this._hasXUI = false;
            this._xpEncoder = null;
            this._formulaLookupDummy = new FormulaExpression();
            this._renderRequestFacotry = null;
            this._rootName = null;
            this._debugMode = true;
            this._blockCounter = 0;
            this._rootName = rootType.getName();
            this._createdTime = System.currentTimeMillis();
            this._schema = schema;
            if (params != null) {
                if (params.containsKey("isSchemaInitMode")) {
                    params.remove("isSchemaInitMode");
                    this._isSchemaInitMode = true;
                    this._isSchemaCacheDom = true;
                    schema.setSCDom(this);
                }
                if (params.containsKey((class$com$jaxfront$core$dom$DebugListener == null ? (class$com$jaxfront$core$dom$DebugListener = Document.class$("com.jaxfront.core.dom.DebugListener")) : class$com$jaxfront$core$dom$DebugListener).getName())) {
                    this.setDebugListener((DebugListener)params.get((class$com$jaxfront$core$dom$DebugListener == null ? (class$com$jaxfront$core$dom$DebugListener = Document.class$("com.jaxfront.core.dom.DebugListener")) : class$com$jaxfront$core$dom$DebugListener).getName()));
                    params.remove((class$com$jaxfront$core$dom$DebugListener == null ? (class$com$jaxfront$core$dom$DebugListener = Document.class$("com.jaxfront.core.dom.DebugListener")) : class$com$jaxfront$core$dom$DebugListener).getName());
                }
                this.getClientProperties().putAll(params);
                if (params.containsKey(DOM_ARGS)) {
                    this.getApplicationProperties().putAll((Map)params.get(DOM_ARGS));
                }
                IConnectionManager conMan = (IConnectionManager)params.get("IConnectionManager");
                ClassLoader customClassLoader = (ClassLoader)params.get(APPLICATION_PROPERTY_CUSTOM_CLASSLOADER);
                if (conMan != null) {
                    this._createdTime = conMan.getCommonServerTime();
                    if (customClassLoader == null) {
                        String mandantName = (String)params.get("MANDANT_NAME");
                        customClassLoader = DBClassLoader.getInstance(mandantName);
                        ((DBClassLoader)customClassLoader).setConnectionManager(conMan);
                    }
                    this.getApplicationProperties().put("IConnectionManager", conMan);
                }
                this.setCustomClassloader(customClassLoader);
            }
            this.getApplicationProperties().put("domId", this.getDocumentID());
            try {
                this._rootType = schema.isXUISchema() ? rootType.deepClone(this, true, false, true, null, null) : rootType.deepClone(this, true, false);
                this._isSchemaInitMode = false;
            }
            catch (CloneNotSupportedException ex) {
                if (!LogRegistry.getInstance().logWarnings()) break block8;
                LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Unable to create JAXFront DOM, rootType (").append(rootType.getName()).append(") not clonable.").toString());
            }
        }
        this.initializeLanguage();
        ((XMLSchemaImpl)this.getSchema()).initializeXSDKeySystem(this);
        this.initializeNameSpaces(null);
        this.getApplicationProperties().put(APPLICATION_PROPERTY_DOCUMENT, this);
    }

    private void initializeLanguage() {
        String language = null;
        if (this.getApplicationProperties().get("NLS_LANGUAGE_SEQUENCE") != null) {
            language = ((String[])this.getApplicationProperties().get("NLS_LANGUAGE_SEQUENCE"))[0];
        }
        if (language != null) {
            this.getGlobalDefinition().setLanguageWithoutReinitialize(language);
        }
    }

    public Document(XMLSchema schema, Type rootType) {
        this(schema, rootType, null);
    }

    public void addDOMChangeListener(DOMChangeListener newListener) {
        if (!this.containsDOMChangeListener(newListener)) {
            this.getDOMListeners().add(newListener);
        }
    }

    public boolean containsDOMChangeListener(DOMChangeListener listener) {
        return this.getDOMListeners().contains(listener);
    }

    public void addDOMChangeListener(DOMChangeListener newListener, int pos) {
        this.getDOMListeners().add(0, newListener);
    }

    public void fireDirtyChange() {
        this.getController().fireDirtyChange();
    }

    public void addDirtyChangeListener(DirtyChangeListener newListener) {
        this.getController().addDirtyChangeListener(newListener);
    }

    public void removeDirtyChangeListener(DirtyChangeListener listener) {
        this.getController().removeDirtyChangeListener(listener);
    }

    public FormulaExpression addFormula(FormulaExpression formula) {
        FormulaExpression old = this.getFormulas().put(formula, formula);
        return old;
    }

    public FormulaExpression lookupFormula(Type source, String expression) {
        return this.lookupFormula(source, expression, false, null);
    }

    public FormulaExpression lookupFormula(Type source, String expression, boolean includeOnlySerializable, TableCell cell) {
        this._formulaLookupDummy.setSource(source);
        this._formulaLookupDummy.setExpression(expression);
        this._formulaLookupDummy.setTableCell(cell);
        this._formulaLookupDummy.setDoesIncludeOnlySerializableNodes(includeOnlySerializable);
        FormulaExpression result = source.getDOM().hasFormula(this._formulaLookupDummy);
        this._formulaLookupDummy.setSource(null);
        this._formulaLookupDummy.setExpression(null);
        return result;
    }

    public FormulaExpression hasFormula(FormulaExpression formula) {
        FormulaExpression old = (FormulaExpression)this.getFormulas().get(formula);
        return old;
    }

    public void removeAllFormulas() {
        Object[] formulas = this.getFormulas().values().toArray();
        for (int i = formulas.length - 1; i >= 0; --i) {
            FormulaExpression fe = (FormulaExpression)formulas[i];
            Type fSource = fe.getSource();
            if (fSource == null) continue;
            fe.release();
            this.removeFormula(fe);
        }
    }

    public FormulaExpression removeFormula(FormulaExpression formula) {
        if (this.getFormulas() != null) {
            return (FormulaExpression)this.getFormulas().remove(formula);
        }
        return null;
    }

    public void removeFormulaExpressions(Type forType) {
        Object[] formulas = this.getFormulas().values().toArray();
        for (int i = formulas.length - 1; i >= 0; --i) {
            FormulaExpression fe = (FormulaExpression)formulas[i];
            Type fSource = fe.getSource();
            if ((fSource == null || fSource != forType) && (fSource == null || !fSource.isDerivedFrom(forType))) continue;
            fe.release();
            this.removeFormula(fe);
        }
    }

    public void addActionPerformListener(ActionPerformListener newListener) {
        this.getActionListeners().add(newListener);
    }

    private Vector getDOMListeners() {
        if (this._domListeners == null) {
            this._domListeners = new Vector();
        }
        return this._domListeners;
    }

    private Vector getActionListeners() {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        return this._actionListeners;
    }

    public void cancelInstance() {
        this.fireDOMChanged(DOMChangeEvent.DOM_CANCELLED(this));
    }

    public Document copy() throws DocumentCreationException {
        Document aCopy = this._schema.createDocument();
        aCopy.setDefaultNamespace(this._defaultXMLNamespace);
        aCopy.setAppContext(this._appContext);
        if (this._clientProperties != null) {
            aCopy._clientProperties = (Hashtable)this._clientProperties.clone();
        }
        aCopy._originalXmlHeaderAttributes = this._originalXmlHeaderAttributes;
        if (this._xmlNamespaceMapping != null) {
            aCopy._xmlNamespaceMapping = (Hashtable)this._xmlNamespaceMapping.clone();
        }
        if (this._xuiNamespaceMapping != null) {
            aCopy._xuiNamespaceMapping = (Hashtable)this._xuiNamespaceMapping.clone();
        }
        aCopy._isRunningAsXuiEditor = this._isRunningAsXuiEditor;
        return aCopy;
    }

    public Document copy(boolean withValue, boolean reinitXUI, boolean copyProperties) throws DocumentCreationException {
        Document aCopy = this.copy();
        if (withValue) {
            aCopy.getRootType().bind(this.getRootType());
        }
        aCopy.setEncoding(this.getEncoding());
        if (this.getFingerPrint().getProcessingInstructions() != null) {
            aCopy.getFingerPrint().getProcessingInstructions().putAll(this.getFingerPrint().getProcessingInstructions());
        }
        aCopy.setSchemaLocation(this.getSchemaLocation());
        if (copyProperties) {
            aCopy.getController().getMathEvaluator().getVariables().putAll(this.getController().getMathEvaluator().getVariables());
            aCopy.getClientProperties().putAll(this.getClientProperties());
            aCopy.getApplicationProperties().putAll(this.getApplicationProperties());
        }
        aCopy.initAfterBind(reinitXUI);
        aCopy.validateIntegrity();
        aCopy.getKeyKeyRefManager().registerAllKeyAndKeyRefs(this.getRootType());
        return aCopy;
    }

    public void bind(org.w3c.dom.Document dom) {
        this.bind(dom, true);
    }

    private void initializeNameSpaces(org.w3c.dom.Document dom) {
        if (JAXFrontProperties.getInstance().ignoreXMLNamespaceDeclaration()) {
            this._xmlNamespaceMapping = null;
            this.setDefaultNamespace(null);
        } else {
            this._xmlNamespaceMapping = new Hashtable();
            Hashtable xsdNamespaceMapping = this.getSchema().getNamespaceMapping();
            Hashtable xmlNamespaceMapping = null;
            if (dom != null) {
                xmlNamespaceMapping = DOMHelper.getNameSpaceToPrefixMapping(dom);
                this._originalXmlHeaderAttributes = DOMHelper.getXMLHeaderAttributes(dom);
                String xmlDefaultNs = DOMHelper.getDefaultNameSpace(dom);
                if (xmlDefaultNs == null) {
                    xmlDefaultNs = this.getSchema().getTargetNamespace();
                }
                this.setDefaultNamespace(xmlDefaultNs);
            } else {
                this.setDefaultNamespace(this.getSchema().getTargetNamespace());
            }
            if (xsdNamespaceMapping != null) {
                this._xmlNamespaceMapping.putAll(xsdNamespaceMapping);
            }
            if (xmlNamespaceMapping != null) {
                this._xmlNamespaceMapping.putAll(xmlNamespaceMapping);
            }
        }
    }

    private void initializeXUINameSpaces(Document xuiDom) {
        this._xuiNamespaceMapping = new Hashtable();
        Hashtable importFromXUI = xuiDom.getFingerPrint().getXUINamespaceMapping();
        Hashtable xmlNamespaceMapping = this.getXMLNamespaceMappings();
        if (xmlNamespaceMapping != null) {
            this._xuiNamespaceMapping.putAll(xmlNamespaceMapping);
        }
        if (importFromXUI != null) {
            this._xuiNamespaceMapping.putAll(importFromXUI);
        }
    }

    public void bind(org.w3c.dom.Document dom, boolean reinitializeXUI, Hashtable processingInstructions) {
        StopWatch.start(new StringBuffer().append("bind").append(this.hashCode()).toString());
        this._isBinding = true;
        if (this._controller != null) {
            this._controller.getErrorController().release();
            this._controller.releaseRules();
        }
        this.removeAllFormulas();
        this.initializeNameSpaces(dom);
        String documentEncoding = DOMHelper.getEncoding(dom);
        this.initializePI(dom);
        if (processingInstructions != null) {
            if (this._processingInstructions != null) {
                this._processingInstructions.clear();
            }
            this.getFingerPrint().getProcessingInstructions().putAll(processingInstructions);
            this.getApplicationProperties().putAll(processingInstructions);
        }
        if (documentEncoding == null) {
            documentEncoding = JAXFrontProperties.getDefaultXMLFileEncoding();
        }
        this.setEncoding(documentEncoding);
        if (dom != null) {
            String schemaLocationDefinedInXML = DOMHelper.getNoNameSpaceSchemaLocation(dom);
            if (schemaLocationDefinedInXML == null) {
                schemaLocationDefinedInXML = DOMHelper.getNameSpaceSchemaLocation(dom);
            }
            if (schemaLocationDefinedInXML != null) {
                this.setSchemaLocation(schemaLocationDefinedInXML);
            }
            this.getRootType().bind(this, dom.getDocumentElement());
        } else {
            this.getRootType().bind(this, (Element)null);
        }
        this.initAfterBind(reinitializeXUI);
        this._bindingTime = StopWatch.stop(new StringBuffer().append("bind").append(this.hashCode()).toString());
        this._isBinding = false;
    }

    private void initAfterBind(boolean reinitializeXUI) {
        if (reinitializeXUI) {
            this.checkAutoCreateListItems(this.getRootType());
            if (this.getFingerPrint().getXUIInput() != null) {
                DOMBuilder.getInstance().initializeXUI(this.getAppContext(), this, this.getFingerPrint().getXUIInput(), true);
            } else if (this.getFingerPrint().getXUIURL() != null) {
                DOMBuilder.getInstance().initializeXUI(this.getAppContext(), this, null, this.getFingerPrint().getXUIURL(), true);
            }
        }
        this.validateIntegrity();
        this.getKeyKeyRefManager().registerAllKeyAndKeyRefs(this.getRootType());
    }

    public void bind(org.w3c.dom.Document dom, boolean reinitializeXUI) {
        this.bind(dom, reinitializeXUI, null);
    }

    public ClassLoader getCustomClassloader() {
        if (this._customClassLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this._customClassLoader;
    }

    public void setCustomClassloader(ClassLoader aClassLoader) {
        this._customClassLoader = aClassLoader;
    }

    public void setXPathCached(boolean cache) {
        if (cache) {
            this.itCache = new DoubleKeyHashtableUnsynced(100);
            this.xpCache = new DoubleKeyHashtableUnsynced(100);
            this.parentCache = new DoubleKeyHashtableUnsynced(100);
        } else {
            this.itCache = null;
            this.xpCache = null;
            this.parentCache = null;
        }
    }

    public boolean isXPathCached() {
        return this.itCache != null && this.xpCache != null && this.parentCache != null;
    }

    private void validateIntegrity() {
        boolean wasCached = this.isXPathCached();
        this.setXPathCached(true);
        for (Error element : this.getController().getErrorController().getAllErrors()) {
            ValidationException valEx;
            if (!(element instanceof ValidationError) || !(valEx = ((ValidationError)element).getException()).isDuplicateKeyException() && !valEx.isDuplicateIDException()) continue;
            this.getController().getErrorController().removeError(element, false);
        }
        this.validateKeyRefIntegrity(false);
        if (!wasCached) {
            this.setXPathCached(false);
        }
    }

    public void validateKeyRefIntegrity(boolean notifyErrorController) {
        List errors = this.checkKeyRefIntegrity();
        for (int e = 0; e < errors.size(); ++e) {
            ValidationException valEx = (ValidationException)errors.get(e);
            this.getController().getErrorController().addError(new ValidationError(valEx, valEx.getSource()), false);
        }
        if (notifyErrorController) {
            this.getController().fireDOMValidated(this);
        }
    }

    public KeyKeyRefManager getKeyKeyRefManager() {
        if (this._keyRefManager == null) {
            this._keyRefManager = new KeyKeyRefManager(this);
        }
        return this._keyRefManager;
    }

    private List checkKeyRefIntegrity() {
        List errors = this.getKeyKeyRefManager().checkKeyRefIntegrity();
        return errors;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void fireDOMChanged(DOMChangeEvent event) {
        this.fireDOMChanged(event, false);
    }

    public void fireDOMChanged(DOMChangeEvent event, boolean isTemporary) {
        if (event.isAddingNode() || event.isRemovingNode() || event.isSwappingNode() || event.isSorted()) {
            this._lastDomUpdateTime = System.currentTimeMillis();
        }
        event.setIsTemporary(isTemporary);
        Vector ap = (Vector)this.getDOMListeners().clone();
        int s = ap.size();
        for (int i = 0; i < s; ++i) {
            ((DOMChangeListener)ap.get(i)).domChanged(event);
        }
        Iterator formulas = this.getFormulas().values().iterator();
        while (formulas.hasNext()) {
            ((DOMChangeListener)formulas.next()).domChanged(event);
        }
    }

    public void fireActionPerformed(ActionPerformEvent event) {
        int s = this.getActionListeners().size();
        Vector ap = this.getActionListeners();
        for (int i = 0; i < s; ++i) {
            ((ActionPerformListener)ap.get(i)).actionPerformed(event);
        }
    }

    public CodeTables getCodeTables() {
        if (this.getSchema() != null) {
            CodeTables ct = this.getSchema().getCodeTables(this.getSchema(), null, null);
            return ct;
        }
        return null;
    }

    public TypeController getController() {
        if (this._controller == null) {
            if (this._isReleased) {
                throw new NullPointerException("Document is released!");
            }
            this._controller = new TypeController(this);
            this.addDOMChangeListener(this._controller);
            this.getPropertyChangeSupport().addPropertyChangeListener(this._controller);
        }
        return this._controller;
    }

    public boolean hasController() {
        return this._controller != null;
    }

    public float getDividerLocation() {
        return this.getGlobalDefinition().getDividerLocation();
    }

    public Color getErrorMarkingColor() {
        return this.getGlobalDefinition().getErrorMarkingColor();
    }

    public List getFilters() {
        if (this._filters == null) {
            this._filters = new Vector();
        }
        return this._filters;
    }

    public float getGlobalLabelIndent() {
        return this.getGlobalDefinition().getGlobalLabelIndent();
    }

    public GlobalDefinition getGlobalDefinition() {
        if (this._globalDefinition == null) {
            this._globalDefinition = new GlobalDefinition(this.getRootType(), null);
        }
        return this._globalDefinition;
    }

    public SimpleType getLeafType(String xpath) {
        SimpleType leafType;
        block2: {
            leafType = null;
            try {
                leafType = (SimpleType)this.getType(xpath);
            }
            catch (ClassCastException e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block2;
                LogRegistry.getInstance().error(this.getClass(), e);
            }
        }
        return leafType;
    }

    public String getLanguage() {
        return this.getGlobalDefinition().getLanguage();
    }

    public Color getSchemaRequiredFieldColor() {
        return this.getGlobalDefinition().getSchemaRequiredFieldColor();
    }

    public Color getApplicationFieldColor() {
        return this.getGlobalDefinition().getApplicationFieldColor();
    }

    public Color getOptionalFieldColor() {
        return this.getGlobalDefinition().getOptionalFieldColor();
    }

    public Type getRootType() {
        return this._rootType;
    }

    public XMLSchema getSchema() {
        return this._schema;
    }

    public Dimension getScreenSize() {
        return this.getGlobalDefinition().getScreenSize();
    }

    public List getTreeRoot() {
        return this.getGlobalDefinition().getTreeRoot();
    }

    public Type getType(String xpath) {
        block3: {
            List types = this.getTypes(xpath);
            if (types.size() > 0) {
                try {
                    return (Type)types.get(0);
                }
                catch (ClassCastException e) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block3;
                    LogRegistry.getInstance().error(this.getClass(), e);
                }
            }
        }
        return null;
    }

    public String getTypeValue(String xpath) {
        Type found = this.getType(xpath);
        if (found != null) {
            if (found.isSimple()) {
                return ((SimpleType)found).getValue();
            }
            return found.getDisplayValue();
        }
        return null;
    }

    public Type getType(String xpath, Type baseType) {
        block3: {
            List types = this.getTypes(xpath, baseType);
            if (types.size() > 0) {
                try {
                    return (Type)types.get(0);
                }
                catch (ClassCastException e) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block3;
                    LogRegistry.getInstance().error(this.getClass(), e);
                }
            }
        }
        return null;
    }

    public List getTypes(String xpath) {
        return this.getTypes(xpath, this.getRootType());
    }

    public List getTypes(String xpath, Type rootType) {
        return TypePathExecuter.getInstance().processXPath(rootType, xpath);
    }

    public List getTypes(String xpath, Type rootType, boolean serializableOnly) {
        return TypePathExecuter.getInstance().processXPath(rootType, xpath, false, true, false, serializableOnly);
    }

    public boolean isRunningInXUIEditor() {
        return this._isRunningAsXuiEditor;
    }

    public void setRunningAsXUIEditor(boolean isEditorMode) {
        this._isRunningAsXuiEditor = isEditorMode;
    }

    public int getVerticalScrollBarPolicy() {
        return this.getGlobalDefinition().getVerticalScrollBarPolicy();
    }

    public Document getXUIDocument() {
        return this._uiDOM;
    }

    public void setXUIDocument(Document xuiDocument) {
        this._uiDOM = xuiDocument;
    }

    public Type getXUIRootType() {
        if (this.getRootType() != null) {
            if (this.getXUIDocument() != null) {
                return this.getXUIDocument().getRootType();
            }
            if (this.getRootType().getName().equals("XUI")) {
                return this.getRootType();
            }
        }
        return null;
    }

    public static String getXUIVersionNo() {
        return XUI_VERSION;
    }

    public static String getBuildVersion() {
        return BUILD_VERSION;
    }

    public void initUISpecification(URL xuiURL) throws DocumentCreationException {
        try {
            Document xuiDOM = DOMBuilder.getInstance().getXUISchemaDOM(this.getAppContext()).copy();
            org.w3c.dom.Document xuiW3CDOM = DOMHelper.createDocument(xuiURL);
            if (xuiW3CDOM != null) {
                xuiDOM.bind(xuiW3CDOM, false);
            }
            xuiDOM.getFingerPrint().setXuiURL(xuiURL);
            xuiDOM.getFingerPrint().setEntityResolver((XMLEntityResolver)this.getApplicationProperty((class$org$apache$xerces$xni$parser$XMLEntityResolver == null ? (class$org$apache$xerces$xni$parser$XMLEntityResolver = Document.class$("org.apache.xerces.xni.parser.XMLEntityResolver")) : class$org$apache$xerces$xni$parser$XMLEntityResolver).getName()));
            this.initUISpecification(xuiDOM);
        }
        catch (IOException ioEx) {
            throw new DocumentCreationException(ioEx);
        }
        catch (SAXException saxEx) {
            throw new DocumentCreationException(saxEx);
        }
    }

    public void attachUISpecification(org.w3c.dom.Document xuiW3CDOM, boolean reinitializeGlobalDefinitions) throws DocumentCreationException {
        Document xuiDOM = DOMBuilder.getInstance().getXUISchemaDOM(this.getAppContext()).copy();
        if (xuiW3CDOM != null) {
            xuiDOM.bind(xuiW3CDOM, false);
        }
        this.initUISpecification(xuiDOM, false, reinitializeGlobalDefinitions);
    }

    public void initUISpecification(Document uiDoc) throws DocumentCreationException {
        this.initUISpecification(uiDoc, true, true);
    }

    private void extractXUIResources(Document uiDoc) {
        ListType resourcesList = (ListType)uiDoc.getRootType().getChild("resources");
        int dChildSize = resourcesList.getDirectChildrenSize();
        if (dChildSize > 0) {
            List resources = resourcesList.getDirectChildren();
            for (int r = 0; r < dChildSize; ++r) {
                Type aResource = (Type)resources.get(r);
                String id = aResource.getDirectChildValue("id");
                String content = aResource.getDirectChildValue("content");
                try {
                    ImageHelper.getInstance().putImage(id, TextTools.decodeBase64Ziped(content), true);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUISpecification(Document uiDoc, boolean releaseOldUISpecification, boolean reinitializeGlobalDefinitions) throws DocumentCreationException {
        if (uiDoc.isReleased()) {
            if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().error(this.getClass(), "try to init with a released xui");
            }
            return;
        }
        if (LicenseChecker.getInstance().isStandardEdition()) {
            return;
        }
        if (uiDoc.getAppContext() == null) {
            uiDoc.setAppContext(this.getAppContext());
        }
        this._isXUIInitialized = false;
        this._hasXUI = uiDoc != null && DOMBuilder.getInstance().getXUISchemaDOM(this.getAppContext()) != uiDoc;
        StopWatch.start("initUI");
        boolean isAlreadyBlocked = this.getUndoManager().isBlocked();
        this.getUndoManager().blockInput(true);
        this.getController().blockDirtyChange(true);
        try {
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("*** (initialize UI Specification ").append(uiDoc.getFingerPrint().getXUIURL()).append(") *** START ***").toString());
            }
            if (releaseOldUISpecification) {
                this.releaseXUIDefintions();
            }
            this.initializeXUINameSpaces(uiDoc);
            this.setXUIDocument(uiDoc);
            this.extractXUIResources(uiDoc);
            Type xuiRootType = uiDoc.getRootType();
            if (reinitializeGlobalDefinitions) {
                this._globalDefinition = new GlobalDefinition(this.getRootType(), xuiRootType);
                this.initializeLanguage();
            }
            this.updateFingerPrint();
            if (this._uiInitListener != null) {
                this._uiInitListener.initUISpecificationStart(uiDoc, this, releaseOldUISpecification, reinitializeGlobalDefinitions);
            }
            this.checkAutoCreateListItems(this.getRootType());
            this.initializeVars(xuiRootType);
            ListType xuiComponents = (ListType)xuiRootType.getDirectChild("component");
            this._xuiComponentCount = xuiComponents.size();
            Vector globalTypes = new Vector();
            globalTypes.addAll(this.getSchema().getGlobalEntities().values());
            if (xuiComponents != null) {
                this.setXPathCached(true);
                for (int i = xuiComponents.size() - 1; i >= 0; --i) {
                    Type aType = (Type)xuiComponents.get(i);
                    if (aType.getDirectChildValue("xpath") != null) continue;
                    if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("found a damaged component at index!").append(i + 1).toString());
                    }
                    xuiComponents.remove(i);
                }
                Iterator components = this.getSortedXUIComponents(xuiComponents).iterator();
                String xpath = null;
                this.initializeNLS(uiDoc, uiDoc.getFingerPrint());
                this._lastLoadedNLSLanguage = uiDoc.getFingerPrint().getLastLoadedLanguage();
                this.initializeGlobalCodeSet(this._globalDefinition.getGlobalCodeSetURL());
                this.initializeGlobalRules(uiDoc.getRootType().getDirectChild("rule"));
                if (this.getClientProperties() != null) {
                    org.w3c.dom.Document codeSetDoc = (org.w3c.dom.Document)this.getClientProperties().get(GLOBAL_CODESET_DOC);
                    this.setGlobalCodeSet(codeSetDoc);
                }
                if (this.getFingerPrint().getEntityResolver() != null && this.getFingerPrint().getXSDInput() != null) {
                    String codeName = FileHelper.getFileName(this.getFingerPrint().getXSDInput().getSystemId());
                    codeName = FileHelper.replaceFileExtension(codeName, "codes");
                    this.getCodeTables().initialize(this.getSchema(), codeName, this.getFingerPrint().getXUIURL(), this.getFingerPrint().getEntityResolver());
                }
                while (components.hasNext()) {
                    Type component = (Type)components.next();
                    xpath = component.getDirectChildValue("xpath");
                    if (xpath.equals("global:")) continue;
                    try {
                        this.initUISpecification(xpath, component, globalTypes);
                    }
                    catch (Exception e) {
                        LogRegistry.getInstance().error(this.getClass(), new StringBuffer().append("Error initializing UI Specification at:").append(xpath).append(" ->").append(StringUtil.getStackTrace(e)).toString());
                    }
                }
            }
            this.setXPathCached(false);
            if (this._uiInitListener != null) {
                this._uiInitListener.initUISpecificationEnd(uiDoc, this, releaseOldUISpecification, reinitializeGlobalDefinitions);
            }
            this._isXUIInitialized = true;
            this.fireDOMChanged(DOMChangeEvent.DOM_INITIALIZED(this));
            if (!this.keepXUIDOMinMemory()) {
                if (!JAXFrontProperties.getInstance(this.getAppContext()).isUsingXUICache()) {
                    this.getXUIDocument().release();
                }
                this.setXUIDocument(null);
            }
            this.checkAutoCreateListItems(this.getRootType());
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "*** (initialize UI Specification) *** END ***");
            }
            if (this._controller != null) {
                this._controller.getErrorController().fireUnhandledValidationExceptions();
            }
        }
        finally {
            if (!isAlreadyBlocked) {
                this.getUndoManager().blockInput(false);
            }
            this.getController().blockDirtyChange(false);
            this._initUITime = StopWatch.stop("initUI");
            this.getUndoManager().discardAllEdits();
        }
    }

    public void initializeVars(Type xuiRootType) {
        List xuiComponents = (List)((Object)xuiRootType.getDirectChild("var"));
        for (int x = 0; x < xuiComponents.size(); ++x) {
            Type type = (Type)xuiComponents.get(x);
            String name = type.getDirectChildValue("name");
            String namePrefix = type.getDirectChildValue("namePrefix");
            String xpath = type.getDirectChildValue("xpath");
            String isDynamic = type.getDirectChildValue("isDynamic");
            if (StringUtil.isTrue(isDynamic)) {
                this.initializeVarCollection(name, xpath, namePrefix);
                continue;
            }
            this.initializeVar(name, xpath, namePrefix);
        }
    }

    private void initializeVar(String name, String xpath, String namePrefix) {
        if (name != null && xpath != null) {
            Type targetType = this.getType(xpath);
            this.initializeVar(name, targetType, xpath, namePrefix);
        }
    }

    private void initializeVar(String name, Type targetType, String xpath, String namePrefix) {
        if (name != null) {
            if (namePrefix != null) {
                name = new StringBuffer().append(namePrefix).append(name).toString();
            }
            if (targetType != null) {
                if (targetType.isEditingType()) {
                    LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Unable to declare a variable on an editing type (").append(targetType.getXPathLocation()).append("). Skip var (").append(name).append(").").toString());
                } else if (targetType.isList()) {
                    LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("Unable to declare a variable on a list type (").append(targetType.getXPathLocation()).append("). Skip var (").append(name).append(").").toString());
                } else {
                    ((AbstractType)targetType).setVarName(name);
                    this.getNoTargetVars().remove(name);
                }
            } else {
                this.getNoTargetVars().put(name, xpath);
            }
        }
    }

    private void initializeVarCollection(String names, String typeXPath, String namePrefix) {
        if (typeXPath != null) {
            List baseTypes = this.getTypes(typeXPath);
            String[] tNames = names == null ? new String[]{} : names.split(",");
            block5: for (int t = 0; t < baseTypes.size(); ++t) {
                Type baseType = (Type)baseTypes.get(t);
                Type tt = null;
                String id = null;
                switch (tNames.length) {
                    case 0: {
                        id = Document.generateVarID(baseType);
                        tt = baseType;
                        this.initializeVar(id, tt, typeXPath, namePrefix);
                        continue block5;
                    }
                    case 1: {
                        id = baseType.getDirectChildValue(tNames[0]);
                        tt = baseType;
                        this.initializeVar(id, tt, typeXPath, namePrefix);
                        continue block5;
                    }
                    case 2: {
                        id = baseType.getDirectChildValue(tNames[0]);
                        tt = baseType.getChild(tNames[1]);
                        this.initializeVar(id, tt, typeXPath, namePrefix);
                        continue block5;
                    }
                    default: {
                        id = baseType.getDirectChildValue(tNames[0]);
                        for (int tn = 1; tn < tNames.length; ++tn) {
                            tt = baseType.getChild(tNames[tn]);
                            if (tt == null) continue;
                            this.initializeVar(new StringBuffer().append(id).append("_").append(tt.getName()).toString(), tt, typeXPath, namePrefix);
                        }
                    }
                }
            }
        }
    }

    public static String generateVarID(Type baseType) {
        StringBuilder id = new StringBuilder();
        ListType parentList = baseType.getParentList();
        id.append(baseType.getParent().getName());
        if (parentList != null) {
            id.append("_");
            id.append(ArrayUtil.toString(DOMHelper.generateHierachyId(baseType)));
        }
        id.append("_");
        id.append(baseType.getName());
        return id.toString();
    }

    public void reinitVars() {
        HashMap entryMap = new HashMap(this.getNoTargetVars());
        for (Map.Entry pEntry : entryMap.entrySet()) {
            this.initializeVar((String)pEntry.getKey(), (String)pEntry.getValue(), null);
        }
    }

    public Map getNoTargetVars() {
        if (this._noTargetVars == null) {
            this._noTargetVars = new HashMap();
        }
        return this._noTargetVars;
    }

    public boolean isUsingDefaultRendering() {
        return this._xuiComponentCount == 0L;
    }

    private Vector getSortedXUIComponents(List xuiComponents) {
        Vector sequence;
        block18: {
            XPathTree tree;
            Vector<Type> normal;
            block17: {
                Vector<Type> globals;
                block16: {
                    globals = new Vector<Type>();
                    Vector<Type> included = new Vector<Type>();
                    Vector<Type> globalIncluded = new Vector<Type>();
                    normal = new Vector<Type>();
                    for (int i = 0; i < xuiComponents.size(); ++i) {
                        Type aXuiType = (Type)xuiComponents.get(i);
                        String xuiXpath = aXuiType.getDirectChildValue("xpath");
                        boolean isGlobal = aXuiType.isGlobal() || xuiXpath.startsWith("global:");
                        boolean isIncluded = aXuiType.isIncluded();
                        if (isGlobal && isIncluded) {
                            globalIncluded.add(aXuiType);
                            continue;
                        }
                        if (isGlobal) {
                            globals.add(aXuiType);
                            continue;
                        }
                        if (isIncluded) {
                            included.add(aXuiType);
                            continue;
                        }
                        normal.add(aXuiType);
                    }
                    sequence = new Vector();
                    if (globalIncluded.size() > 0) {
                        try {
                            tree = XPathTree.createTree(globalIncluded, false);
                            tree.getRootNode().extractUserNodesAsSequence(sequence);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (included.size() > 0) {
                        try {
                            tree = XPathTree.createTree(included, false);
                            tree.getRootNode().extractUserNodesAsSequence(sequence);
                        }
                        catch (Exception e) {
                            if (!JAXFrontProperties.LOG_ENABLED) break block16;
                            LogRegistry.getInstance().error(this.getClass(), e.toString());
                        }
                    }
                }
                if (globals.size() > 0) {
                    try {
                        tree = XPathTree.createTree(globals, false);
                        tree.getRootNode().extractUserNodesAsSequence(sequence);
                    }
                    catch (Exception e) {
                        if (!JAXFrontProperties.LOG_ENABLED) break block17;
                        LogRegistry.getInstance().error(this.getClass(), e.toString());
                    }
                }
            }
            if (normal.size() > 0) {
                try {
                    tree = XPathTree.createTree(normal, false);
                    Vector temp = new Vector();
                    tree.getRootNode().extractUserNodesAsSequence(temp);
                    sequence.addAll(ArrayUtil.invert(temp));
                }
                catch (Exception e) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block18;
                    LogRegistry.getInstance().error(this.getClass(), e.toString());
                }
            }
        }
        return sequence;
    }

    public void initializeNLS(Document uiDoc, FingerPrint fingerprint) {
        this._fingerPrintXUI = fingerprint;
        this.getFingerPrint().refresh(fingerprint);
        if (this.isImmutable()) {
            this._nls = new NLS();
        } else {
            String[] nlsLanguageSeq = (String[])this.getApplicationProperties().get("NLS_LANGUAGE_SEQUENCE");
            if (nlsLanguageSeq != null && uiDoc != null && fingerprint != null) {
                fingerprint.setNLSReadingSequence(nlsLanguageSeq);
            }
            this._nls = new NLS(this.getSchema().getURL(), uiDoc, fingerprint, this.getLanguage(), nlsLanguageSeq, true, false);
        }
    }

    private void initializeGlobalCodeSet(String globalCodeSetUrl) {
        if (globalCodeSetUrl != null && globalCodeSetUrl.length() > 0) {
            this.getSchema().getCodeTables().initialize(this.getSchema(), globalCodeSetUrl);
        }
    }

    public void setGlobalCodeSet(org.w3c.dom.Document codesetDoc) {
        if (codesetDoc != null) {
            this.getSchema().getCodeTables().initialize(codesetDoc);
        }
    }

    public NLS getNLS() {
        if (this._nls == null) {
            this._nls = new NLS();
        }
        return this._nls;
    }

    public void initUISpecification(Type xuiType) {
        this.initUISpecification(xuiType.getDirectChildValue("xpath"), xuiType, null);
    }

    private void initUISpecification(String xpath, Type xuiType, List globalTypes) {
        List types = null;
        if (xpath.startsWith("global:")) {
            String globalStartName;
            String cacheXPath = TextTools.replace(xpath, "global:", "/");
            if (cacheXPath.startsWith("//")) {
                cacheXPath = cacheXPath.substring(1, cacheXPath.length());
            }
            if (globalTypes != null) {
                // empty if block
            }
            if ((globalStartName = cacheXPath.substring(1)).indexOf("/") != -1) {
                globalStartName = globalStartName.substring(0, globalStartName.indexOf("/"));
            }
            if (globalStartName.indexOf(":") != -1) {
                String nsPrefix = globalStartName.substring(0, globalStartName.indexOf(":"));
                globalStartName = globalStartName.substring(globalStartName.indexOf(":") + 1, globalStartName.length());
                String nsURI = null;
                Enumeration entries = this.getXMLNamespaceMappings().keys();
                while (entries.hasMoreElements()) {
                    Object uri = entries.nextElement();
                    Object prefix = this.getXMLNamespaceMappings().get(uri);
                    if (!prefix.equals(nsPrefix)) continue;
                    nsURI = uri.toString();
                    break;
                }
                if (nsURI != null) {
                    globalStartName = new StringBuffer().append(nsURI).append(":").append(globalStartName).toString();
                }
            } else if (this.getDefaultNamespace() != null) {
                globalStartName = new StringBuffer().append(this.getDefaultNamespace()).append(":").append(globalStartName).toString();
            }
            String globalXUIKey1 = globalStartName;
            String globalXUIKey2 = cacheXPath;
            this.getGlobalXUIDefinitions().put(globalXUIKey1 != null ? globalXUIKey1 : "", globalXUIKey2 != null ? globalXUIKey2 : "", new XUIDefinition(this.getRootType(), xuiType, false, true, false, true));
        } else {
            ListType listType;
            block17: {
                boolean editingTypeIncluded = !TypePathExecuter.isLastAddressingIndexedComponent(xpath);
                try {
                    types = XPathExecuterImpl.getInstance().processXPath(xpath, this.getRootType(), editingTypeIncluded, false, false, false, false, false, false, true);
                }
                catch (Exception e) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block17;
                    LogRegistry.getInstance().error(this.getClass(), e);
                }
            }
            if (types.size() == 0 && !this.keepXUIDOMinMemory()) {
                xuiType.setUserObject(this.getRootType());
                this.getLostComponents().add(xuiType);
            }
            if (TypePathExecuter.isAddressingIndexedComponent(xpath) && (listType = TypePathExecuter.getIndexedComponentListType(this.getRootType(), xpath)) != null) {
                listType.addNoTargetXUIDefinition(xuiType);
            }
        }
        if (xpath.indexOf("//") >= 0) {
            this.getController().addIndeterminateXPath(this.getRootType(), xpath, xuiType);
        }
        if (types != null) {
            Iterator typesIterator = types.iterator();
            while (typesIterator.hasNext()) {
                Type type;
                XUIDefinition xuiDefinition = new XUIDefinition(type, xuiType, false, (type = (Type)typesIterator.next()).isEditingType() || type.isDerivedFromEditingType(), this.keepXUIDOMinMemory(), false);
                type.setUIDefinition(xuiDefinition);
            }
        }
    }

    private void maintainListUISpecification(String xpath, Type xuiType) {
        boolean editingTypeIncluded = !TypePathExecuter.isLastAddressingIndexedComponent(xpath);
        List types = TypePathExecuter.getInstance().processXPath(this.getRootType(), xpath, editingTypeIncluded);
        if (types != null) {
            for (Type type : types) {
                XUIDefinition def = type.getXUIDefinition(true);
                if (def != null && def.hasBeenInitializedFromFile()) continue;
                XUIDefinition xuiDefinition = new XUIDefinition(type, xuiType, false, type.isEditingType() || type.isDerivedFromEditingType());
                type.setUIDefinition(xuiDefinition);
            }
        }
    }

    public void maintainNoTargetXPathDefinitions(List definitions) {
        if (definitions != null) {
            for (int i = definitions.size() - 1; i >= 0; --i) {
                Type xuiComponent = (Type)definitions.get(i);
                this.maintainLostXUIComponent(xuiComponent);
            }
        }
    }

    public void maintainLostXUIComponent(Type xuiComponent) {
        String xpath = null;
        if (xuiComponent.getSchemaElement() != null && xuiComponent.getName().equals("component")) {
            Type xpathType = xuiComponent.getDirectChild("xpath");
            if (xpathType != null) {
                xpath = ((SimpleType)xpathType).getValue();
            }
            if (xpath != null) {
                this.maintainListUISpecification(xpath, xuiComponent);
            }
        }
    }

    public void reApplyLostComponents() {
        for (Type xuiType : this.getLostComponents()) {
            this.maintainLostXUIComponent(xuiType);
        }
    }

    public boolean isAllowingSavingWithErrors() {
        return this.getGlobalDefinition().isAllowingSavingWithErrors();
    }

    public EditablePanel getEditor() {
        return TypeVisualizerFactory.getInstance().getEditor(this);
    }

    public boolean isEditable() {
        return this.getGlobalDefinition().isEditable();
    }

    public boolean isOrphan(Node node) {
        boolean isOrphan = false;
        Node uppermostParent = node;
        while ((node = node.getParentNode()) != null) {
            uppermostParent = node;
        }
        if (uppermostParent.getNodeType() != 10) {
            isOrphan = true;
        }
        return isOrphan;
    }

    public boolean isSerializingDefaults() {
        if (this.getGlobalDefinition() != null) {
            return this.getGlobalDefinition().isSerializingDefaults();
        }
        return false;
    }

    public boolean isShowingTreeListContainer() {
        return this.getGlobalDefinition().isShowingTreeListContainer();
    }

    public boolean isUsingBackwardButton() {
        return this.getGlobalDefinition().isUsingBackwardButton();
    }

    public boolean isUsingButtonBar() {
        return this.getGlobalDefinition().isUsingButtonBar();
    }

    public boolean isUsingForwardButton() {
        return this.getGlobalDefinition().isUsingForwardButton();
    }

    public boolean isUsingPlugins() {
        return this.getGlobalDefinition().isUsingPlugins();
    }

    public boolean isUsingStatusBar() {
        return this.getGlobalDefinition().isUsingStatusBar();
    }

    private void printTypes(Type smartType, int indent) {
        Iterator iterator;
        String indentString = "";
        for (int i = 0; i < indent; ++i) {
            indentString = new StringBuffer().append(indentString).append(".").toString();
        }
        if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append(indentString).append("Type: ").append(smartType.getName()).append(" (ST:").append(smartType.hashCode()).append(") ").toString());
        }
        if (smartType.isList()) {
            ++indent;
            ListType listType = (ListType)smartType;
            iterator = listType.getList().iterator();
            while (iterator.hasNext()) {
                this.printTypes((Type)iterator.next(), indent);
            }
        } else if (smartType.isComposite()) {
            CompositeType listType = (CompositeType)smartType;
            iterator = listType.getComposites().iterator();
            ++indent;
            while (iterator.hasNext()) {
                this.printTypes((Type)iterator.next(), indent);
            }
        }
        --indent;
    }

    public void printTypeTree() {
        this.printTypes(this.getRootType(), 0);
    }

    public void refresh(org.w3c.dom.Document dom, Document uiDOM) throws DocumentCreationException {
        if (this._controller != null) {
            this._controller.release();
        }
        this._controller = null;
        this._domListeners = null;
        this._actionListeners = null;
        this.bind(dom, false);
        this.refreshUISpecification(uiDOM);
    }

    public void refreshUISpecification(Document uiDOM) throws DocumentCreationException {
        this.setXUIDocument(uiDOM);
        if (this.getXUIDocument() != null) {
            TypeVisualizerFactory.getInstance().releaseCache(this);
            this.initUISpecification(this.getXUIDocument());
        }
    }

    protected void finalize() throws Throwable {
        --_instanceCount;
        if (!this._isReleased) {
            this._blockRelease = false;
            this._blockOwner = null;
            this.release();
        }
    }

    public void release() {
        if (this._blockRelease) {
            this._releaseAfterUnblock = true;
            return;
        }
        if (this == DOMBuilder.getInstance().getXUISchemaDOM(this.getAppContext())) {
            this._clientProperties = null;
            this._applicationProperties = null;
            if (this._controller != null) {
                this._controller.getMathEvaluator();
                MathEvaluator.release();
            }
            return;
        }
        this._isReleased = true;
        this._formulaLookupDummy = null;
        TypeVisualizerFactory.getInstance().releaseCache(this);
        if (this._controller != null) {
            this.removeDOMChangeListener(this._controller);
            this.getPropertyChangeSupport().removePropertyChangeListener(this._controller);
            this._controller.release();
        }
        if (this._clipBoard != null) {
            this._clipBoard.release();
            this._clipBoard = null;
        }
        if (this.getXUIDocument() != null && !this.keepXUIDOMinMemory()) {
            if (!JAXFrontProperties.getInstance(this.getAppContext()).isUsingXUICache()) {
                this.getXUIDocument().release();
            }
            this._uiDOM = null;
        }
        if (this._notFiredInitializationRules != null) {
            this._notFiredInitializationRules.clear();
            this._notFiredInitializationRules = null;
        }
        this._originalXmlHeaderAttributes = null;
        if (this._lostComponents != null) {
            this._lostComponents.clear();
            this._lostComponents = null;
        }
        if (this._globalRulesImpls != null) {
            this._globalRulesImpls.clear();
            this._globalRulesImpls = null;
        }
        if (this._varToTypeMapping != null) {
            this._varToTypeMapping.clear();
            this._varToTypeMapping = null;
        }
        if (this._editingTypeCache != null) {
            this._editingTypeCache.clear();
            this._editingTypeCache = null;
        }
        if (this._globalDefinition != null) {
            this._globalDefinition.release();
        }
        if (this._processingInstructions != null) {
            this._processingInstructions.clear();
        }
        if (this._filters != null) {
            this._filters.clear();
        }
        if (this._xuiDefinitions != null) {
            this._xuiDefinitions.clear();
        }
        if (this._undoManager != null) {
            this._undoManager.release();
            this._undoManager = null;
        }
        if (this._keyRefManager != null) {
            this._keyRefManager.release();
            this._keyRefManager = null;
        }
        this._uiInitListener = null;
        this._schema = null;
        if (this._nls != null) {
            this._nls.clearSmallCash();
            this._nls = null;
        }
        if (this._historyListener != null) {
            this.getController().removeLogListener(this._historyListener);
            this._historyListener = null;
        }
        this._controller = null;
        if (this._rootType != null) {
            this._rootType.release();
        }
        this._rootType = null;
        this._globalDefinition = null;
        this._xuiDefinitions = null;
        this._processingInstructions = null;
        this._filters = null;
        this._domListeners = null;
        this.setFormulas(null);
        this._actionListeners = null;
        this._fingerPrint = null;
        this._fingerPrintXUI = null;
        this._applicationProperties = null;
        this._clientProperties = null;
        this._xmlPrefixNamespaceMapping = null;
        this._customClassLoader = null;
        this._xmlNamespaceMapping = null;
        this._xuiNamespaceMapping = null;
        this._propertyChangeSupport = null;
        if (this.itCache != null) {
            this.itCache.clear();
            this.itCache = null;
        }
        if (this.xpCache != null) {
            this.xpCache.clear();
            this.xpCache = null;
        }
        if (this._xpEncoder != null) {
            this._xpEncoder.release();
            this._xpEncoder = null;
        }
        if (this.parentCache != null) {
            this.parentCache.clear();
            this.parentCache = null;
        }
        this._debugListener = null;
        TypeVisualizerFactory.getInstance().releaseCache(this);
    }

    public void notifyDebug(int type, String message) {
        if (this._debugListener != null) {
            this._debugListener.debug(type, message);
        }
    }

    public void releaseForSchemaCache() {
        this._isSCReleased = true;
        if (this._controller != null) {
            this._controller = null;
        }
        if (this._clipBoard != null) {
            this._clipBoard = null;
        }
        if (this._notFiredInitializationRules != null) {
            this._notFiredInitializationRules = null;
        }
        if (this._lostComponents != null) {
            this._lostComponents = null;
        }
        if (this._varToTypeMapping != null) {
            this._varToTypeMapping = null;
        }
        if (this._filters != null) {
            this._filters = null;
        }
        if (this._undoManager != null) {
            this._undoManager = null;
        }
        if (this._keyRefManager != null) {
            this._keyRefManager.release();
            this._keyRefManager = null;
        }
        this._uiInitListener = null;
        if (this._historyListener != null) {
            this._historyListener = null;
        }
        this.releaseController();
        this._domListeners = null;
        this.setFormulas(null);
        this._actionListeners = null;
        this._applicationProperties = null;
        this._clientProperties = null;
        this._propertyChangeSupport = null;
        if (this.itCache != null) {
            this.itCache = null;
        }
        if (this.xpCache != null) {
            this.xpCache = null;
        }
        if (this._xpEncoder != null) {
            this._xpEncoder = null;
        }
        if (this.parentCache != null) {
            this.parentCache = null;
        }
        TypeVisualizerFactory.getInstance().releaseCache(this);
        if (this._editingTypeCache != null) {
            this._editingTypeCache.clear();
            this._editingTypeCache = null;
        }
    }

    public void releaseController() {
        if (this._controller != null) {
            this._controller.release();
        }
        this._controller = null;
    }

    public void releaseProperties() {
        if (this._globalDefinition != null) {
            this._globalDefinition.releaseProperties();
        }
    }

    public void initializeGlobalRules(Type rules) {
        ListType gRules = (ListType)rules;
        for (int i = 0; i < gRules.size(); ++i) {
            Type aGRule = (Type)gRules.get(i);
            Rule aGRuleImpl = SimpleRuleImpl.initializeRule(i, aGRule);
            if (aGRuleImpl.getId() != null) {
                this.getGlobalRules().put(aGRuleImpl.getId(), aGRuleImpl);
                continue;
            }
            if (!LogRegistry.getInstance().logWarnings()) continue;
            LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("global rule (").append(aGRuleImpl.getRuleType()).append(") has no id!").toString());
        }
    }

    public Hashtable getGlobalRules() {
        if (this._globalRulesImpls == null) {
            this._globalRulesImpls = new Hashtable();
        }
        return this._globalRulesImpls;
    }

    public Map<String, Type> getVarToTypeMapping() {
        if (this._varToTypeMapping == null) {
            this._varToTypeMapping = new LinkedHashMap<String, Type>();
        }
        return this._varToTypeMapping;
    }

    public boolean hasVarToTypeMapping() {
        return this._varToTypeMapping != null && this._varToTypeMapping.size() > 0;
    }

    public Type removeVarToTypeMapping(String varName) {
        Type removed = null;
        if (varName != null) {
            this.getController().getMathEvaluator().getVariables().remove(varName);
            if (this._varToTypeMapping != null) {
                removed = this._varToTypeMapping.remove(varName);
            }
            this.fireDOMChanged(DOMChangeEvent.DOM_GENERIC(this, "typeVarChanged", 2));
        }
        return removed;
    }

    public Type addVarToTypeMapping(String varName, Type aType) {
        Type removed = null;
        if (varName != null) {
            this.getController().getMathEvaluator().getVariables().put(varName, aType);
            removed = this.getVarToTypeMapping().put(varName, aType);
            this.fireDOMChanged(DOMChangeEvent.DOM_GENERIC(this, "typeVarChanged", 1));
        }
        return removed;
    }

    public Rule getGlobalRule(Object id) {
        return (Rule)this.getGlobalRules().get(id);
    }

    private void releaseXUIDefintion(Type type) {
        if (type.hasUIDefinition()) {
            ((AbstractType)type).getXUIDefinition(false, true).release();
            type.setUIDefinition(null);
        }
        List children = null;
        if (type.isList()) {
            children = (List)((Object)type);
            this.releaseXUIDefintion(((ListType)type).getEditingType());
        } else if (type.isComposite()) {
            children = ((CompositeType)type).getComposites();
        }
        if (children != null) {
            int cc = children.size();
            for (int c = 0; c < cc; ++c) {
                this.releaseXUIDefintion((Type)children.get(c));
            }
        }
    }

    private void releaseXUIDefintions() {
        this.getGlobalXUIDefinitions().clear();
        this.releaseXUIDefintion(this.getRootType());
        this.releaseProperties();
        if (this._controller != null) {
            this.getController().releaseRules();
        }
    }

    public void removeDOMChangeListener(DOMChangeListener newListener) {
        this.getDOMListeners().remove(newListener);
    }

    public void removeActionPerformListener(ActionPerformListener newListener) {
        this.getActionListeners().remove(newListener);
    }

    public void saveAs(File file) throws ValidationException, IOException {
        StringBuffer buffer = this.serialize(true);
        if (buffer != null) {
            DOMHelper.write(buffer, file, this.getEncoding());
        }
    }

    public void saveAsZip(File file) throws ValidationException, IOException {
        StringBuffer buffer = this.serialize(true);
        if (buffer != null) {
            String zipped = TextTools.encodeBase64Ziped(buffer.toString().getBytes());
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(zipped.getBytes());
            fos.flush();
            fos.close();
        }
    }

    public StringBuffer serialize() throws ValidationException {
        return this.serialize(true);
    }

    public byte[] serializeToByteArray() throws ValidationException, UnsupportedEncodingException {
        return this.serializeToByteArray(this.getEncoding());
    }

    public byte[] serializeToByteArray(String encoding) throws ValidationException, UnsupportedEncodingException {
        byte[] serializedByteArray = null;
        StringBuffer xml = this.serialize();
        if (xml != null) {
            serializedByteArray = xml.toString().getBytes(encoding);
        }
        return serializedByteArray;
    }

    public StringBuffer serialize(boolean makeIndents) throws ValidationException {
        return this.serialize(makeIndents, true);
    }

    public StringBuffer serialize(boolean makeIndents, boolean serializeHeader) throws ValidationException {
        boolean hasErrors = false;
        StringBuffer stringBuffer = null;
        hasErrors = this.getController().getErrorController().hasValidationErrors();
        if (hasErrors && !this.isAllowingSavingWithErrors()) {
            throw new ValidationException(null, "DOM has errors, not allowed to save", false, false, false, null);
        }
        this.fireDOMChanged(DOMChangeEvent.DOM_IS_ABOUT_TO_SERIALIZE(this));
        stringBuffer = this.serializeInternal(makeIndents, serializeHeader);
        this.fireDOMChanged(DOMChangeEvent.DOM_SERIALIZED(this));
        return stringBuffer;
    }

    private void serializeXMLHeader(StringBuffer sb, boolean makeIndents) {
        StringBuffer fingerprint;
        sb.append(new StringBuffer().append("<?xml version=\"1.0\" encoding=\"").append(this.getEncoding()).append("\"?>").toString());
        String jaxfrontPI = null;
        if (this._processingInstructions != null) {
            Iterator piIterator = this._processingInstructions.iterator();
            String pi = null;
            while (piIterator.hasNext()) {
                pi = (String)piIterator.next();
                if (pi.startsWith("<?jaxfront")) {
                    jaxfrontPI = pi;
                    continue;
                }
                if (makeIndents) {
                    sb.append("\n");
                }
                sb.append(pi);
            }
        }
        if ((fingerprint = this.getFingerPrint().serialize(this)) != null && makeIndents) {
            sb.append("\n");
        }
        if (jaxfrontPI != null) {
            // empty if block
        }
        if (fingerprint != null) {
            sb.append(fingerprint);
        }
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public Hashtable getOriginalXmlHeaderAttributes() {
        return this._originalXmlHeaderAttributes;
    }

    private void serializeInternal(StringBuffer sb, boolean makeIndents, boolean serializeHeader) {
        StopWatch.start("serialize");
        boolean isXuiDOM = this.isXUIDOMInstance();
        if (serializeHeader) {
            this.serializeXMLHeader(sb, makeIndents);
        }
        if (this.getRootType() != null) {
            if (makeIndents) {
                sb.append("\n");
            }
            StringBuffer headerAttribs = new StringBuffer();
            if (!JAXFrontProperties.getInstance(this.getRootType().getDOM().getAppContext()).ignoreNamespace()) {
                Vector allNS = null;
                if (isXuiDOM) {
                    allNS = DOMHelper.getNamespaceDeclarations(this.getXUINamespaceMappings(), this.getRootType().getDOM().isXUIDOMInstance(), this._enforcePrefixSerialization, null);
                    headerAttribs.append(DOMHelper.getAdditionalXUIHeaderAttribs(this));
                } else if (this._originalXmlHeaderAttributes != null) {
                    headerAttribs.append(DOMHelper.getXMLHeaderAttribs(this, this.getOriginalXmlHeaderAttributes()));
                } else {
                    allNS = DOMHelper.getNamespaceDeclarations(this.getXMLNamespaceMappings(), this.getRootType().getDOM().isXUIDOMInstance(), this._enforcePrefixSerialization, this.getDefaultNamespace());
                    headerAttribs.append(DOMHelper.getAdditionalXMLHeaderAttribs(this));
                }
                if (allNS != null) {
                    Iterator it = allNS.iterator();
                    String ns = null;
                    while (it.hasNext()) {
                        headerAttribs.append(" ");
                        ns = (String)it.next();
                        headerAttribs.append(ns);
                    }
                }
            }
            String name = ((AbstractType)this.getRootType()).getSerializationName();
            if (this.getRootType().isSerializable()) {
                sb.append("<");
                sb.append(name);
                sb.append(headerAttribs);
                int indent = 0;
                if (makeIndents) {
                    indent = 1;
                }
                this.getRootType().serialize(sb, indent, false, true, false);
                if (makeIndents) {
                    sb.append("\n");
                }
                sb.append("</");
                sb.append(name);
                sb.append(">");
            }
        }
        this._serializationTime = StopWatch.stop("serialize");
    }

    public StringBuffer serializeInternal(boolean makeIndents, boolean serializeHeader) {
        StringBuffer sb = new StringBuffer();
        this.serializeInternal(sb, makeIndents, serializeHeader);
        return sb;
    }

    public void setSchemaLocation(String schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public boolean systemExitOnClose() {
        return this.getGlobalDefinition().systemExitOnClose();
    }

    public boolean useOptionalCheckBox() {
        return this.getGlobalDefinition().useOptionalCheckBox();
    }

    public void validate() {
        this.validate(false);
    }

    public Hashtable validateTemporary() {
        Hashtable delegate = new Hashtable();
        this.getController().getErrorController().setErrorsDelegate(delegate);
        this.validate();
        this.getController().getErrorController().setErrorsDelegate(null);
        return delegate;
    }

    public TypeVisualizerFactory getRenderRequestVisualizerFactory() {
        if (this._renderRequestFacotry == null) {
            return TypeVisualizerFactory.getInstance();
        }
        return this._renderRequestFacotry;
    }

    public void setRenderRequestVisualizerFactory(TypeVisualizerFactory factory) {
        this._renderRequestFacotry = factory;
    }

    public Map getEditingTypeCache() {
        if (this._editingTypeCache == null) {
            this._editingTypeCache = new Hashtable();
        }
        return this._editingTypeCache;
    }

    public void putEditingTypeCache(Type edType) {
        this.getEditingTypeCache().put(((AbstractType)edType).getAbsoluteXPathLocation(), edType);
    }

    public Vector validatePageErrors(Type type, int pageIndex) {
        return this.validatePageErrors(type, pageIndex, true);
    }

    public Vector validatePageErrors(Type type, int pageIndex, boolean validate) {
        Vector<Error> pageErrors = new Vector<Error>();
        if (validate) {
            this.validate();
        }
        if (pageIndex == -1 || type.getStyle().isPagingLayout() || type.getParentList() != null && type.getParentList().getStyle().isUsingPagingList()) {
            if (pageIndex >= 0) {
                if (type.getParentList() != null && type.getParentList().getStyle().isUsingPagingList()) {
                    type.getParentList().getStyle().setSelectedTabIdx(pageIndex);
                } else {
                    type.getStyle().setSelectedTabIdx(pageIndex);
                }
            }
            if (this.getController().getErrorController().hasValidationErrors()) {
                List allTypes = DOMHelper.getAllSelectedVisStructureChilds(type, true);
                Collection allErrors = this.getController().getErrorController().getAllErrors();
                Vector<Error> notRelevantErrors = new Vector<Error>();
                for (Error element : allErrors) {
                    if (allTypes.contains(element.getErrorHolder())) {
                        pageErrors.add(element);
                        continue;
                    }
                    if (!element.isMandatoryError() && !element.isCardinalityError() && !element.isXSDError() && pageIndex != -1) continue;
                    notRelevantErrors.add(element);
                }
                this.getController().getErrorController().removeErrors(notRelevantErrors);
            }
        } else {
            Enumeration allErrorsEnum = this.getController().getErrorController().getErrors().elements();
            while (allErrorsEnum.hasMoreElements()) {
                pageErrors.addAll((Collection)allErrorsEnum.nextElement());
            }
        }
        FastQSort sort = new FastQSort();
        try {
            sort.sort(pageErrors, (Comparator)new ErrorTypeComparator());
        }
        catch (Exception e) {
            // empty catch block
        }
        return pageErrors;
    }

    public void validate(boolean isRunningOnServer) {
        this.fireDOMChanged(DOMChangeEvent.DOM_IS_ABOUT_TO_VALIDATE(this));
        this.setXPathCached(true);
        this.validateSchemaConstraints();
        this.validateXUIRules(isRunningOnServer);
        this.validateIntegrity();
        this.setXPathCached(false);
        this.fireDOMChanged(DOMChangeEvent.DOM_VALIDATED(this));
        this.getController().fireDOMValidated(this);
    }

    public void validateSchemaConstraints() {
        this.getController().getErrorController().removeMandatoryAndCardinalityValidationErrors();
        Vector errors = new Vector();
        this.validateMandatoryAndCardinality(this.getRootType(), errors, true);
        for (int i = 0; i < errors.size(); ++i) {
            this.getController().getErrorController().addError((Error)errors.get(i), false);
        }
    }

    public void validateXUIRules(boolean isRunningOnServer) {
        this.getController().applySaveRules(null, isRunningOnServer);
    }

    public long getLastDomUpdateTimeStamp() {
        return this._lastDomUpdateTime;
    }

    public List getProcessingInstructions() {
        return this._processingInstructions;
    }

    public void setProcessingInstructions(List pi) {
        this._processingInstructions = pi;
    }

    public void validateMandatoryAndCardinality(Type type, List errors, boolean checkValue) {
        ArrayList<Type> children = null;
        if (!type.getSerializableFlag()) {
            return;
        }
        if (type.isSimple()) {
            String value = ((SimpleType)type).getValue();
            ((SimpleType)type).validate(true);
            if (type.isRequired()) {
                if (!checkValue) {
                    this.validateSimpleRequiredElement(type, errors);
                } else if (value == null || value.length() == 0) {
                    this.validateSimpleRequiredElement(type, errors);
                }
            }
        } else if (type.isComposite()) {
            CompositeType composite = (CompositeType)type;
            List compChilds = composite.getComposites();
            children = new ArrayList<Type>(compChilds.size());
            if (type.isChoice()) {
                Type choosenType = type.getChoosenType();
                if (type.isMandatoryAxis()) {
                    if (choosenType == null) {
                        errors.add(new ValidationError(ValidationException.createMandatoryException(type), type));
                    } else {
                        children.add(choosenType);
                    }
                } else if (choosenType != null) {
                    children.add(choosenType);
                }
            } else if (type.isSerializable(false)) {
                if (type.isRequired()) {
                    children.addAll(compChilds);
                    if (compChilds.size() == 0 && type.getSchemaElement().getElementSet().length > 0) {
                        errors.add(new ValidationError(ValidationException.createMandatoryException(type), type));
                    }
                } else if (!composite.hasEmptyContent(true, true)) {
                    children.addAll(compChilds);
                } else {
                    Type parType = type.getParent();
                    Type choosenType = null;
                    if (parType != null && parType.isChoice() && (choosenType = parType.getChoosenType()) != null && !choosenType.isEmpty() && choosenType == type) {
                        children.addAll(compChilds);
                    }
                }
            }
        } else {
            ListType listType = (ListType)type;
            if (listType.size() > 0) {
                children = listType.getList();
            }
            try {
                if (listType.isSerializable()) {
                    listType.checkCardinality(0);
                }
            }
            catch (ValidationException ex) {
                errors.add(new ValidationError(ex, (Type)listType));
            }
        }
        if (children != null) {
            for (Type child : children) {
                this.validateMandatoryAndCardinality(child, errors, checkValue);
            }
        }
    }

    private void validateSimpleRequiredElement(Type type, List errors) {
        boolean isMandatoryWithinAnonymousGroup = true;
        if (type.getSchemaElement().hasUnnamedOptionalParent()) {
            isMandatoryWithinAnonymousGroup = DOMHelper.isMandatoryWithinAnonymousGroup(type, true);
        }
        if (isMandatoryWithinAnonymousGroup) {
            if (!type.isKeyRef()) {
                if (this.getGlobalDefinition().isValidatingEmptyMandatoryContent() && !type.getSchemaType().isMixedContent()) {
                    errors.add(new ValidationError(ValidationException.createMandatoryException(type), type));
                }
            } else {
                errors.add(new ValidationError(ValidationException.createMandatoryException(type), type));
            }
        }
    }

    public FingerPrint getFingerPrint() {
        if (this._fingerPrint == null) {
            FingerPrint defaultFingetPrint = null;
            defaultFingetPrint = this.getSchema() == null ? new FingerPrint(this, null, null, (URL)null) : new FingerPrint(this, null, this.getSchema().getURL(), (URL)null);
            this.setFingerPrint(defaultFingetPrint);
        }
        return this._fingerPrint;
    }

    public void setPID(String pid) {
        this.getFingerPrint().setPID(pid);
        if (this._processingInstructions != null) {
            for (int i = this._processingInstructions.size() - 1; i >= 0; --i) {
                String aPI = (String)this._processingInstructions.get(i);
                if (aPI == null || !aPI.startsWith("<?jaxfront")) continue;
                this._processingInstructions.remove(i);
            }
        }
    }

    public boolean hasChanged() {
        return this.getController().hasChanged();
    }

    public String getAppVersionNo() {
        return this.getFingerPrint().getAppVersionNo();
    }

    public void setFingerPrint(FingerPrint fingerPrint) {
        this._fingerPrint = fingerPrint;
        if (this._processingInstructions != null) {
            this.updateFingerPrint();
        }
        String[] nlsLanguageSeq = (String[])this.getApplicationProperties().get("NLS_LANGUAGE_SEQUENCE");
        this._fingerPrint.setNLSReadingSequence(nlsLanguageSeq);
    }

    private void updateFingerPrint() {
        if (this._processingInstructions != null) {
            for (String pi : this._processingInstructions) {
                if (!pi.startsWith("<?jaxfront")) continue;
                this.getFingerPrint().update(pi);
                break;
            }
        }
    }

    public void setNLS(NLS nls) {
        this._nls = nls;
    }

    public void setLanguage(String language) {
        this.getGlobalDefinition().setLanguage(language);
    }

    public Hashtable getClientProperties() {
        if (this._clientProperties == null) {
            this._clientProperties = new Hashtable();
        }
        return this._clientProperties;
    }

    public void putClientProperty(String key, Object value) {
        if (key != null && value != null) {
            this.getClientProperties().put(key, value);
        }
    }

    public void putApplicationProperty(String key, Object value) {
        if (key != null && value != null) {
            if (value == NULL._null) {
                this.removeApplicationProperty(key);
                this.getController().getMathEvaluator().getVariables().remove(key);
            } else {
                this.getApplicationProperties().put(key, value);
                this.getController().getMathEvaluator().setVariable(key, value);
            }
        }
    }

    public Object getApplicationProperty(String key) {
        return this.getApplicationProperties().get(key);
    }

    public Object removeApplicationProperty(String key) {
        return this.getApplicationProperties().remove(key);
    }

    public void removeClientProperty(String key) {
        this.getClientProperties().remove(key);
    }

    public Object getClientProperty(String key) {
        return this.getClientProperties().get(key);
    }

    public DoubleKeyHashtable getGlobalXUIDefinitions() {
        if (this._xuiDefinitions == null) {
            this._xuiDefinitions = new DoubleKeyHashtableUnsynced();
        }
        return this._xuiDefinitions;
    }

    public Hashtable getXMLNamespaceMappings() {
        return this._xmlNamespaceMapping;
    }

    public Hashtable getXUINamespaceMappings() {
        if (this._xuiNamespaceMapping == null) {
            this._xuiNamespaceMapping = this.getXMLNamespaceMappings();
        }
        return this._xuiNamespaceMapping;
    }

    public Map getXUIPrefixNamespaceMappings() {
        if (this._xmlPrefixNamespaceMapping == null) {
            this._xmlPrefixNamespaceMapping = new HashMap(this.getXUINamespaceMappings().size());
            for (Map.Entry entry : this.getXUINamespaceMappings().entrySet()) {
                this._xmlPrefixNamespaceMapping.put(entry.getValue(), entry.getKey());
            }
        }
        return this._xmlPrefixNamespaceMapping;
    }

    public void setXUINamespaceMappings(Hashtable mapping) {
        this._xuiNamespaceMapping = mapping;
    }

    public void setXMLNamespaceMappings(Hashtable mapping) {
        this._xmlNamespaceMapping = mapping;
    }

    public boolean isXUIInitialized() {
        return this._isXUIInitialized;
    }

    public boolean keepXUIDOMinMemory() {
        return this._keepXUIDOMinMemory;
    }

    public boolean isXUIDOMInstance() {
        return this.isXUIDOMInstance(this.getRootType());
    }

    public boolean isXUIDOMInstance(Type rootType) {
        if (this._XUIDOMInstance < 0) {
            this._XUIDOMInstance = rootType != null && rootType.getName().equals("XUI") && "http://www.jaxfront.com/xui".equals(rootType.getSchemaElement().getSchema().getTargetNamespace()) ? (short)1 : 0;
        }
        return this._XUIDOMInstance != 0;
    }

    public void keepXUIDOMinMemory(boolean isXuiDom) {
        this._keepXUIDOMinMemory = isXuiDom;
    }

    public boolean isPDFXUIDOM() {
        return this.getRootType() != null && this.getRootType().getName().equals("PDF_XUI");
    }

    public void reinitializeNLS() {
        block6: {
            FingerPrint fingerPrint = this.getFingerPrint();
            if (this._fingerPrintXUI != null) {
                fingerPrint = this._fingerPrintXUI;
            }
            try {
                if (fingerPrint.getXUIURL() != null) {
                    Document uiDom = null;
                    if (JAXFrontProperties.getInstance(this.getAppContext()).isUsingXUICache()) {
                        uiDom = XUICache.getInstance().getCached(fingerPrint.getXUIURL());
                    } else {
                        org.w3c.dom.Document w3CDOM = DOMHelper.createDocument(fingerPrint.getXUIURL());
                        uiDom = DOMBuilder.getInstance().getXUISchemaDOM(this.getAppContext()).copy();
                        uiDom.bind(DOMBuilder.getInstance().getExpandedXUIDOM(this.getAppContext(), w3CDOM, fingerPrint, false, !this.isRunningInXUIEditor()), true);
                    }
                    this.initializeNLS(uiDom, fingerPrint);
                }
                this.reinitializeNLS(this.getRootType());
            }
            catch (Exception e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block6;
                LogRegistry.getInstance().error(this.getClass(), new StringBuffer().append("can't reinitializeNLS for:").append(fingerPrint.getXUIURL() != null ? fingerPrint.getXUIURL().toExternalForm() : "null").toString());
            }
        }
    }

    public void reinitializeUISpecification() {
        this.reinitializeUISpecification(this.getRootType());
    }

    public void reinitializeUISpecification(Type type) {
        LayoutInfo tempInfo;
        XUIDefinition xuiDef = type.getXUIDefinition(false);
        if (xuiDef != null && !xuiDef.hasBeenInitializedFromFile()) {
            type.setUIDefinition(null);
        }
        if (xuiDef != null && xuiDef.getStyle().isTableLayout() && (tempInfo = xuiDef.getStyle().getLayoutManager()) instanceof FormLayoutInfo) {
            xuiDef.getStyle().updateLayoutManager(((FormLayoutInfo)tempInfo).clone(type));
        }
        Iterator childIterator = null;
        if (type.isComposite()) {
            childIterator = ((CompositeType)type).getComposites().iterator();
        } else if (type.isList()) {
            ListType listType = (ListType)type;
            List list = listType.getList();
            childIterator = list.iterator();
            while (childIterator.hasNext()) {
                listType.maintainXUIDefinitions((Type)childIterator.next());
            }
            childIterator = list.iterator();
        }
        if (childIterator != null) {
            while (childIterator.hasNext()) {
                this.reinitializeUISpecification((Type)childIterator.next());
            }
        }
    }

    public void setImmutable(boolean immutable) {
        this._immutable = immutable;
    }

    public boolean isImmutable() {
        return this._immutable;
    }

    public JAXFrontPropertyChangeSupport getPropertyChangeSupport() {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new JAXFrontPropertyChangeSupport(this);
        }
        return this._propertyChangeSupport;
    }

    public boolean isBinding() {
        return this._isBinding;
    }

    private void reinitializeNLS(Type type) {
        if (type.isSimple() && type.hasUIDefinition() && type.getStyle().isUsingCodeSet()) {
            type.getStyle().reinitializeCodeSetValues();
        }
        List<Type> children = new Vector<Type>();
        if (type.isList()) {
            children.add(((ListType)type).getEditingType());
            children.addAll(((ListType)type).getList());
        } else if (type.isComposite()) {
            CompositeType composite = (CompositeType)type;
            children = composite.getComposites();
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            this.reinitializeNLS((Type)iterator.next());
        }
    }

    public void setIsBinding(boolean isBinding) {
        this._isBinding = isBinding;
    }

    public boolean isValid() {
        return !this.getController().getErrorController().hasValidationErrors();
    }

    public LinkedHashMap getNotFiredInitializationRules() {
        if (this._notFiredInitializationRules == null) {
            this._notFiredInitializationRules = new LinkedHashMap();
        }
        return this._notFiredInitializationRules;
    }

    public void addNotFiredInitializationRule(Type target, Rule initializationRule) {
        Vector<Rule> rules = (Vector<Rule>)this.getNotFiredInitializationRules().get(initializationRule.getSource());
        if (rules == null) {
            rules = new Vector<Rule>(3);
            this.getNotFiredInitializationRules().put(target != null ? target : initializationRule.getSource(), rules);
        }
        if (!rules.contains(initializationRule)) {
            rules.add(initializationRule);
        }
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Execution of initialization method not successfully now delegate it to visualizer instance! location is:").append(initializationRule.getSource().getXPathLocation()).toString());
        }
    }

    public Type getViewHolderType(Type smartType) {
        Type viewHolderType = null;
        if (smartType != null) {
            if (smartType.getStyle().isParentViewHolder()) {
                if (smartType.isRepresentedAsTab()) {
                    Type representedTabHolder = this.getRepresentedTabHolder(smartType);
                    viewHolderType = representedTabHolder == smartType ? smartType : this.getViewHolderType(representedTabHolder);
                } else if (smartType.getParent() != null && smartType.getParent().getStyle().isUsingTabList()) {
                    viewHolderType = smartType.getParent();
                } else if (smartType.isRepresentedAsHeader()) {
                    Type parent;
                    if (smartType.getParent() != null && (parent = smartType.getParent()).getRepresentedTreeNodeParent() != null) {
                        viewHolderType = parent;
                    }
                } else {
                    viewHolderType = this.checkTableLayoutParentVisualizer(smartType);
                }
                if (viewHolderType == null) {
                    viewHolderType = smartType.getParent() != null ? this.getViewHolderType(smartType.getParent()) : smartType;
                }
            } else if (!smartType.getStyle().isParentViewHolder()) {
                viewHolderType = smartType;
            }
        }
        return viewHolderType;
    }

    private Type getRepresentedTabHolder(Type tabbedType) {
        Type parent;
        if (tabbedType != null && tabbedType.getParent() != null && (parent = tabbedType.getParent()).getStyle().isTabHolder()) {
            if (parent.isRepresentedAsTab()) {
                return this.getRepresentedTabHolder(parent);
            }
            if (parent.getRepresentedTreeNodeParent() != null) {
                return parent.getRepresentedTreeNodeParent();
            }
        }
        return tabbedType;
    }

    private Type checkTableLayoutParentVisualizer(Type type) {
        Type treeParent;
        Type tableParent = type.getRepresentedTableLayoutParent();
        if (tableParent != null && tableParent.getParent() != null && (treeParent = tableParent.getParent().getRepresentedTreeNodeParent()) != null) {
            return treeParent;
        }
        return null;
    }

    private void initializePI(org.w3c.dom.Document dom) {
        if (dom != null) {
            this._processingInstructions = DOMHelper.getProcessingInstructions(dom);
            if (this._processingInstructions != null) {
                this.updateFingerPrint();
            }
        } else {
            this.getFingerPrint().setPID(null);
        }
    }

    public HashSet getLostComponents() {
        if (this._lostComponents == null) {
            this._lostComponents = new HashSet();
        }
        return this._lostComponents;
    }

    public void lock(String[] fieldsToUnlock) {
        this.lock(fieldsToUnlock, true, false);
    }

    public void lock(String[] fieldsToUnlock, boolean lockGlobal, boolean unlockIfNotNull) {
        Hashtable targetHash = null;
        if (fieldsToUnlock != null) {
            targetHash = new Hashtable();
            for (int i = 0; i < fieldsToUnlock.length; ++i) {
                List lTypes = DOMHelper.getLockedTypes(this.getRootType(), fieldsToUnlock[i]);
                for (int l = 0; l < lTypes.size(); ++l) {
                    Object target = lTypes.get(l);
                    targetHash.put(target, target);
                }
            }
        }
        if (lockGlobal) {
            this.getGlobalDefinition().setEditable(true);
        }
        Enumeration visualizers = TypeVisualizerFactory.getInstance().getVisualizers(this).elements();
        this.markNotEditableTypes(this.getRootType(), false, true);
        while (visualizers.hasMoreElements()) {
            Object cached = visualizers.nextElement();
            Visualizer visualizer = (Visualizer)cached;
            if (targetHash != null && targetHash.containsKey(visualizer.getModel())) continue;
            visualizer.setEditable(false);
            if (!(visualizer instanceof JComponent)) continue;
            ((JComponent)((Object)visualizer)).updateUI();
        }
        if (targetHash != null && targetHash.size() > 0) {
            Enumeration targetList = targetHash.keys();
            boolean unlock = true;
            while (targetList.hasMoreElements()) {
                Type target = (Type)targetList.nextElement();
                unlock = unlockIfNotNull ? (target.isSimple() ? ((SimpleType)target).getValue() != null : target.isSerializable(true)) : true;
                if (!unlock) continue;
                target.setEnabled(true);
                target.setEditable(true);
                target.getStyle().setEditableAtRuntime(true);
                target.getStyle().markAsUnlockedField();
                Vector possibleTargetVis = TypeVisualizerFactory.getInstance().getAllVisualizers(target);
                for (int pt = 0; pt < possibleTargetVis.size(); ++pt) {
                    Visualizer targetVisualizer = (Visualizer)possibleTargetVis.get(pt);
                    if (targetVisualizer == null) continue;
                    targetVisualizer.setEditable(true);
                    this.fireActionPerformed(new ActionPerformEvent(targetVisualizer.getModel(), null, "setEnabled", new String[]{String.valueOf(true)}));
                    if (!(targetVisualizer instanceof JComponent)) continue;
                    ((JComponent)((Object)targetVisualizer)).invalidate();
                }
            }
        }
    }

    public void unlock() {
        this.getGlobalDefinition().setEditable(true);
        Enumeration visualizers = TypeVisualizerFactory.getInstance().getVisualizers(this).elements();
        while (visualizers.hasMoreElements()) {
            Visualizer visualizer = (Visualizer)visualizers.nextElement();
            if (visualizer.getModel().isLocked()) continue;
            visualizer.setEditable(true);
            if (!(visualizer instanceof JComponent)) continue;
            ((JComponent)((Object)visualizer)).invalidate();
        }
        this.markNotEditableTypes(this.getRootType(), true, true);
    }

    public void markNotEditableTypes(Type type, boolean unmark, boolean handleListItems) {
        if (unmark) {
            type.removeClientProperty("locked&notEditable");
            type.removeClientProperty("lockedExistingListItem");
        } else {
            if (type.getXUIDefinition(false) != null && (!type.getXUIDefinition(false).getStyle().isEditable() || type.getXUIDefinition(false).getStyle().isReadOnly())) {
                type.putClientProperty("locked&notEditable", Boolean.TRUE);
            }
            if (handleListItems && type.getParent() != null && type.getParent().isList()) {
                type.putClientProperty("lockedExistingListItem", "");
            }
        }
        List subTypes = null;
        if (type.isList()) {
            if (((ListType)type).size() > 0) {
                subTypes = ((ListType)type).getList();
            }
        } else if (type.isComposite()) {
            subTypes = ((CompositeType)type).getComposites();
        }
        if (subTypes != null) {
            Iterator iterator = subTypes.iterator();
            while (iterator.hasNext()) {
                this.markNotEditableTypes((Type)iterator.next(), unmark, handleListItems);
            }
        }
    }

    private void cleanNotSerializable(Type type) {
        Type parent;
        if (!type.isSerializable() && (parent = type.getParent()) != null) {
            try {
                parent.removeChild(type);
            }
            catch (ListModificationException listModificationException) {
                // empty catch block
            }
            type.release();
        }
        if (type.getDOM() != null) {
            Iterator iterator = null;
            if (type.isComposite()) {
                iterator = new Vector(((CompositeType)type).getComposites()).iterator();
            } else if (type.isList()) {
                iterator = new Vector(((ListType)type).getList()).iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.cleanNotSerializable((Type)iterator.next());
                }
            }
        }
    }

    public void checkAutoCreateListItems(Type type) {
        ListType aList;
        if (type.isList()) {
            ((ListType)type).autoCreateEntries();
        }
        List childs = null;
        if (type.isComposite()) {
            childs = ((CompositeType)type).getComposites();
        } else if (type.isList() && (aList = (ListType)type).size() > 0) {
            childs = aList.getList();
        }
        if (childs != null) {
            for (int c = 0; c < childs.size(); ++c) {
                this.checkAutoCreateListItems((Type)childs.get(c));
            }
        }
    }

    public void setRuleEngineBlocked(boolean blockRuleEngine) {
        this._blockRuleEngine = blockRuleEngine;
    }

    public boolean isRuleEngineBlocked() {
        return this._blockRuleEngine;
    }

    public org.w3c.dom.Document serializeToW3CDocument() throws XMLParseException, SAXException, IOException, ValidationException {
        org.w3c.dom.Document w3cDoc = DOMHelper.createDocument(this.serialize(false).toString());
        return w3cDoc;
    }

    public String getAppContext() {
        return this._appContext;
    }

    public void setAppContext(String appContext) {
        this._appContext = appContext;
    }

    public void setSerializationModifier(SerializationModifier serializationModifier) {
        this.serializationModifier = serializationModifier;
    }

    public SerializationModifier getSerializationModifier() {
        return this.serializationModifier;
    }

    public void setDefaultNamespace(String defaultXMLNamespace) {
        this._defaultXMLNamespace = defaultXMLNamespace;
    }

    public String getDefaultNamespace() {
        return this._defaultXMLNamespace;
    }

    public Hashtable getApplicationProperties() {
        if (this._applicationProperties == null) {
            this._applicationProperties = new Hashtable();
        }
        return this._applicationProperties;
    }

    public JAXFrontUndoManager getUndoManager() {
        if (this._undoManager == null) {
            this._undoManager = new JAXFrontUndoManager(this);
        }
        return this._undoManager;
    }

    public void setUndoManager(JAXFrontUndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public void setStatus(int status) {
        this.getFingerPrint().putProcessingInstructions(DOCUMENT_STATUS, String.valueOf(status));
        this.putApplicationProperty(DOCUMENT_STATUS, String.valueOf(status));
        this._lastDomUpdateTime = System.currentTimeMillis();
    }

    public int getStatus() {
        int status = -1;
        String piValue = this.getFingerPrint().getProcessingInstruction(DOCUMENT_STATUS);
        if (piValue != null) {
            status = Integer.valueOf(this.getFingerPrint().getProcessingInstruction(DOCUMENT_STATUS));
        }
        return status;
    }

    public ClipBoard getClipBoard() {
        if (this._clipBoard == null) {
            this._clipBoard = new ClipBoard();
        }
        return this._clipBoard;
    }

    public String getInfo() {
        StringBuffer info = new StringBuffer();
        for (Map.Entry entry : this.getInfos().entrySet()) {
            info.append(new StringBuffer().append(entry.getKey()).append(" ").append(entry.getValue()).toString());
            info.append(StringUtil.newLine);
        }
        return info.toString();
    }

    public Map getInfos() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("***** Document Properties *****", "");
        info.put("XUI_VERSION", XUI_VERSION);
        info.put("BUILD_VERSION", BUILD_VERSION);
        info.put("XSD", this.getFingerPrint().getXsdLocation());
        info.put("XUI", this.getFingerPrint().getXuiLocation());
        info.put("keepXUIDOMinMemory", new StringBuffer().append(this.keepXUIDOMinMemory()).append("").toString());
        info.put("XML", this.getFingerPrint().getXmlLocation());
        info.put("APPLICATON CONTEXT", this._appContext);
        info.put("Country", this.getGlobalDefinition().getCountry().toString());
        info.put("Language", this.getLanguage());
        info.put("LocaleFormat", this.getGlobalDefinition().getCurrentLocale().toString());
        info.put("Default DateFormat", this.getGlobalDefinition().getDateFormat().format(new Date()));
        info.put("Default DateTimeFormat", this.getGlobalDefinition().getDateTimeFormat().format(new Date()));
        info.put("Default TimeFormat", this.getGlobalDefinition().getTimeFormat().format(new Date()));
        info.put("***** Runtime Information *****", "");
        info.put("Total DOM nodes", new StringBuffer().append(DOMHelper.countSubNodes(this.getRootType(), true, false, false, false)).append("").toString());
        info.put("Total Simple DOM nodes", new StringBuffer().append(DOMHelper.countSubNodes(this.getRootType(), false, false, true, false)).append("").toString());
        info.put("Total filled Simple DOM nodes", new StringBuffer().append(DOMHelper.countSubNodes(this.getRootType(), false, true, true, false)).append("").toString());
        info.put("Total Schema nodes", new StringBuffer().append(DOMHelper.countSubNodes(this.getRootType().getSchemaElement())).append("").toString());
        info.put("MathEvaluator calls (current DOM)", new StringBuffer().append(this.getController().getMathEvaluator().getCalls()).append("").toString());
        info.put("MathEvaluator time consumption (current DOM)", new StringBuffer().append(this.getController().getMathEvaluator().timeConsumption).append("").toString());
        info.put("XPathExecuterImpl calls", new StringBuffer().append(XPathExecuterImpl.counter).append("").toString());
        info.put("XPathExecuterImpl cacheHits", new StringBuffer().append(XPathExecuterImpl.cacheHitCounter).append("").toString());
        info.put("XPathExecuterImpl naviCacheHits", new StringBuffer().append(XPathExecuterImpl.naviCacheHitCounter).append("").toString());
        info.put("XPathExecuterImpl time consumption (overall)", new StringBuffer().append(XPathExecuterImpl.timeConsumption).append("").toString());
        info.put("XUICache cachedObjects", new StringBuffer().append(XUICache.getInstance().getCacheCount()).append("").toString());
        info.put("ImageHelper cachedObjects", new StringBuffer().append(ImageHelper.getInstance().getLoadedImages()).append("").toString());
        info.put("ImageHelper cachedObjectsSize (byte)", new StringBuffer().append(ImageHelper.getInstance().getLoadedImagesSize()).append("").toString());
        info.put("Formula Listeners:", new StringBuffer().append(this.getFormulas().size()).append("").toString());
        info.put("Action Listeners:", new StringBuffer().append(this.getActionListeners().size()).append("").toString());
        info.put("Global Rules:", new StringBuffer().append(this.getGlobalRules().size()).append("").toString());
        info.put("***** Creation Timings *****", "");
        info.put("BindTime", new StringBuffer().append(this._bindingTime).append("").toString());
        info.put("InitUITime", new StringBuffer().append(this._initUITime).append("").toString());
        info.put("XUI Components", new StringBuffer().append(this._xuiComponentCount).append("").toString());
        info.put("SerializationTime", new StringBuffer().append(this._serializationTime).append("").toString());
        info.put("***** KeyKeyRef Information *****", "");
        info.put("Structure:", this.getKeyKeyRefManager().getInfo());
        info.put("***** Variable Information *****", "");
        info.put("Variables:", MapHelper.toString(this.getVarToTypeMapping()));
        return info;
    }

    public boolean isPasteMode() {
        return this._pasteMode;
    }

    public void setPasteMode(boolean pasting) {
        this._pasteMode = pasting;
    }

    public XUIDefinition removeXUIDefinition(Type type) {
        String globalXUIKey1 = DOMHelper.getGlobalNameFromXPath(type.getXPathLocation());
        String globalXUIKey2 = type.getQName();
        return (XUIDefinition)this.getGlobalXUIDefinitions().remove(globalXUIKey1, globalXUIKey2);
    }

    public long getCreatedTime() {
        return this._createdTime;
    }

    public void setCreatedTime(long created) {
        this._createdTime = created;
    }

    public boolean isHistoryMode() {
        return this._historyListener != null;
    }

    public String getDocumentID() {
        if (this._docID == null) {
            this._docID = Integer.toString(this.hashCode());
        }
        return this._docID;
    }

    public void setHistoryMode(String logLevel, boolean enabled, boolean logChanges, Vector fingerprintActions) {
        if (!logChanges) {
            this.getController().getLoggingListeners().clear();
        }
        if (enabled) {
            if (logLevel == null && this.getRootType().getXUIDefinition().getBehaviour() != null) {
                logLevel = this.getRootType().getXUIDefinition().getBehaviour().getLogLevel();
            }
            HistoryLoggingListener hisListener = new HistoryLoggingListener(this, "all", logLevel, fingerprintActions);
            hisListener.setLogOnlyMetaData(!logChanges);
            this._historyListener = this.getController().addLogListener(hisListener);
        } else {
            this._historyListener = null;
        }
    }

    protected void setFormulas(HashMap formulas) {
        this._formulas = formulas;
    }

    public HashMap getFormulas() {
        if (this._formulas == null) {
            this._formulas = new HashMap();
        }
        return this._formulas;
    }

    public boolean hasXUI() {
        return this._hasXUI;
    }

    public XPathEncoder getXPathEncoder() {
        if (this._xpEncoder == null) {
            this._xpEncoder = JAXFrontProperties.getInstance(this.getAppContext()).usePersistentIDGenerator() ? new XPathEncoder(new StringBuffer().append("ID").append(this.getRootType().getName().toUpperCase()).append("_").toString(), true) : new XPathEncoder(new StringBuffer().append("ID").append(this.getDocumentID()).append("_").toString(), false);
        }
        return this._xpEncoder;
    }

    public boolean isReleased() {
        return this._isReleased;
    }

    public void setHelpUrlResolver(HelpURLResolver helpUrlResolver) {
        this._helpUrlResolver = helpUrlResolver;
    }

    public HelpURLResolver getHelpUrlResolver() {
        if (this._helpUrlResolver == null) {
            this._helpUrlResolver = new DefaultHelpURLResolver();
        }
        return this._helpUrlResolver;
    }

    public String getLastLoadedNLSLanguage() {
        return this._lastLoadedNLSLanguage;
    }

    public IUser getUser() {
        IUser user = null;
        if (this._user == null) {
            user = (IUser)this.getApplicationProperty("IUser");
            this.setUser(user);
        } else {
            user = (IUser)this._user.get();
        }
        return user;
    }

    private void setUser(IUser user) {
        this._user = user != null ? new WeakReference<IUser>(user) : null;
    }

    public void setRights(String[][] aRights) {
        ArrayList fieldsToHidden = new ArrayList();
        ArrayList fieldsToVisible = new ArrayList();
        ArrayList fieldsToRead = new ArrayList();
        ArrayList<String> fieldsToUnlockIfNotNull = new ArrayList<String>();
        ArrayList<String> fieldsToUnlock = new ArrayList<String>();
        if (aRights != null) {
            for (int r = 0; r < aRights.length; ++r) {
                List rwTypes;
                String xpath = aRights[r][0];
                String right = aRights[r][1];
                if (RIGHT_HIDDEN.equalsIgnoreCase(right)) {
                    rwTypes = this.getTypes(xpath);
                    if (rwTypes == null) continue;
                    fieldsToHidden.addAll(rwTypes);
                    continue;
                }
                if (RIGHT_VISIBLE.equalsIgnoreCase(right)) {
                    rwTypes = this.getTypes(xpath);
                    if (rwTypes == null) continue;
                    fieldsToVisible.addAll(rwTypes);
                    continue;
                }
                if (RIGHT_READ.equalsIgnoreCase(right)) {
                    rwTypes = this.getTypes(xpath);
                    if (rwTypes == null) continue;
                    fieldsToRead.addAll(rwTypes);
                    continue;
                }
                if (RIGHT_READ_WRITE_NOT_NULL.equalsIgnoreCase(right)) {
                    fieldsToUnlockIfNotNull.add(xpath);
                    continue;
                }
                if (!RIGHT_READ_WRITE.equalsIgnoreCase(right)) continue;
                fieldsToUnlock.add(xpath);
            }
            for (Type hiddenType : fieldsToHidden) {
                hiddenType.setVisible(false);
            }
            for (Type visType : fieldsToVisible) {
                visType.getStyle().setVisible(true);
                visType.setVisible(true);
            }
            for (Type readType : fieldsToRead) {
                readType.setEnabled(false);
            }
            if (fieldsToUnlockIfNotNull.size() > 0) {
                this.lock(ArrayUtil.toStringArray(fieldsToUnlockIfNotNull), false, true);
            }
            if (fieldsToUnlock.size() > 0) {
                this.lock(ArrayUtil.toStringArray(fieldsToUnlock), false, false);
            }
        }
    }

    public IConnectionManager getConnectionManager() {
        return (IConnectionManager)this.getApplicationProperty("IConnectionManager");
    }

    public List<Type> getVarsFor(String[] varNames, List result) {
        if (varNames == null) {
            return result;
        }
        for (int v = 0; v < varNames.length; ++v) {
            String varName = varNames[v];
            if (varName == null) continue;
            varName = varName.trim();
            Type found = this.getVarToTypeMapping().get(varName);
            if (found == null) continue;
            result.add(found);
        }
        return result;
    }

    public synchronized void setReleaseBlocked(String blockOwner, boolean blocked) {
        this._blockRelease = blocked;
        this._blockOwner = blockOwner;
        this._blockCounter = blocked ? ++this._blockCounter : --this._blockCounter;
        if (!blocked && this._releaseAfterUnblock && this._blockCounter <= 0) {
            System.out.println("releaseAfterUB");
            this.release();
        }
    }

    public boolean isReleaseAfterUnblock() {
        return this._releaseAfterUnblock;
    }

    public boolean isReleaseBlocked() {
        return this._blockRelease;
    }

    public void setInitUIListener(InitUIListener listener) {
        this._uiInitListener = listener;
    }

    public InitUIListener getUIInitListener() {
        return this._uiInitListener;
    }

    public boolean isSchemaInit() {
        return this._isSchemaInitMode;
    }

    public boolean isSCDom() {
        return this._isSchemaCacheDom;
    }

    public boolean isSCReleased() {
        return this._isSCReleased;
    }

    public boolean isDebugMode() {
        return this._debugMode;
    }

    public void setDebugListener(DebugListener listener) {
        this._debugListener = listener;
    }

    public DebugListener getDebugListener() {
        return this._debugListener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

