/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ResourceInfo;
import com.jaxfront.core.util.TextTools;
import java.beans.PropertyChangeEvent;

public class LogEntry {
    private long _action = 0L;
    private Type _source;
    private long _time;
    private String _logLevel;
    private String _name;
    private String _oldValue;
    private String _newValue;

    public LogEntry(Type source, DOMChangeEvent event, String logLevel, String oldValue) {
        this._action = event.getType();
        this._source = source;
        if ((0x400000L & event.getType()) != 0L) {
            this._name = event.getChangeName();
            this._oldValue = event.getOldValue();
            this._newValue = event.getNewValue();
        } else if (event.isPersistent() && source != null) {
            this._oldValue = String.valueOf(source.getDOM().getStatus());
            this._newValue = String.valueOf(source.getDOM().getStatus());
        } else {
            this._oldValue = oldValue;
            if (source.isSimple()) {
                this._newValue = ((SimpleType)source).getValue();
            }
        }
        this._logLevel = logLevel;
        this.refreshTime();
    }

    public LogEntry(Type source, PropertyChangeEvent event, String logLevel, String oldValue) {
        this._action = 256L;
        this._source = source;
        this._oldValue = oldValue;
        if (source.isSimple()) {
            this._newValue = ((SimpleType)source).getValue();
        }
        this._logLevel = logLevel;
        this.refreshTime();
    }

    public LogEntry(Type aType, long action, String logLevel, String propertyName, String oldValue, String newValue, long time) {
        this._source = aType;
        this._action = action;
        this._name = propertyName;
        this._oldValue = oldValue;
        this._newValue = newValue;
        this._logLevel = logLevel;
        this._time = time;
    }

    public long getAction() {
        return this._action;
    }

    public Type getSource() {
        return this._source;
    }

    public String getOldValue() {
        return this._oldValue;
    }

    public String getNewValue() {
        return this._newValue;
    }

    public long getTime() {
        return this._time;
    }

    public void dump() {
        System.out.println("LogEntry: " + this.getAction() + "  " + this._source.getXPathLocation() + " | " + this._time + " | " + this._oldValue);
    }

    public void refreshTime() {
        this._time = this._source != null && this._source.getDOM().getConnectionManager() != null ? this._source.getDOM().getConnectionManager().getCommonServerTime() : System.currentTimeMillis();
    }

    public void refresh() {
        this.refreshTime();
    }

    public boolean isValueChange() {
        return (0x100L & this.getAction()) != 0L;
    }

    public String toString() {
        int iAction = (int)this.getAction();
        if ((0x100L & (long)iAction) != 0L) {
            return "Changed value from (" + (this.getOldValue() == null ? "" : this.getOldValue()) + ") to (" + this.getSource().getDisplayValue() + ") for field (" + this.getSource().getStyle().getLabelText() + ").";
        }
        if ((0x400000L & (long)iAction) != 0L) {
            String action = null;
            action = this.getOldValue() == null ? "Initialized " + this._name + " (" + this.getNewValue() + ")" : "Changed " + this._name + " from (" + this.getOldValue() + ") to (" + this.getNewValue() + ")";
            return action;
        }
        if ((0x1000L & (long)iAction) != 0L) {
            return "Added new entry (" + this.getSource().getStyle().getCaptionTitleLabel() + ").";
        }
        if ((2L & (long)iAction) != 0L) {
            String position = ".";
            String xpath = this.getSource().getXPathLocation();
            if (xpath.endsWith("]")) {
                xpath = TextTools.reverseText(xpath);
                position = " at position (" + xpath.substring(1, xpath.indexOf("[")) + ").";
            }
            return "Removed entry (" + this.getSource().getStyle().getCaptionTitleLabel() + ")" + position;
        }
        if ((1L & (long)iAction) != 0L) {
            return "Document (" + this._source.getName() + ") tried to save.";
        }
        if ((0x2000L & (long)iAction) != 0L) {
            String state = "saved";
            if (this.getSource() != null && this.getSource().getDOM().getClientProperty("initialCreated") != null && ((Boolean)this.getSource().getDOM().getClientProperty("initialCreated")).booleanValue()) {
                state = "created";
            }
            String documentName = this._source.getName();
            if (this.getSource().getDOM().getClientProperty("resourceInfo") != null) {
                documentName = ((ResourceInfo)this.getSource().getDOM().getClientProperty("resourceInfo")).getFormID();
            }
            return "Document (" + documentName + ") " + state + ".";
        }
        if ((0x8000L & (long)iAction) != 0L) {
            return "Document created:" + this._source.getName() + ".";
        }
        if ((0L & (long)iAction) != 0L) {
            return null;
        }
        if ((4L & (long)iAction) != 0L) {
            return null;
        }
        if ((8L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x10L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x20L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x40L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x80L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x200L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x400L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x800L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x4000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x10000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x800000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x2000000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x1000000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x20000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x40000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x80000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x100000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x20000000L & (long)iAction) != 0L) {
            return null;
        }
        if ((0x40000000L & (long)iAction) != 0L) {
            return null;
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LogEntry) {
            LogEntry toCompare = (LogEntry)obj;
            if (((LogEntry)obj)._source == this._source) {
                return true;
            }
            return !toCompare._source.isRoot() && toCompare._source.getParent().isChoice() && toCompare._source.getParent() == this._source.getParent();
        }
        return false;
    }
}

