/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;

public class DateTools
extends SuperTypeNode {
    private String _defaultPattern = "yyyy-MM-dd";

    public DateTools() {
    }

    public DateTools(String pattern) {
        this._defaultPattern = pattern;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object result = null;
        switch (this.curNumberOfParameters) {
            case 0: {
                String pattern = this._defaultPattern;
                result = this.getDateAsString(communicator, pattern);
                break;
            }
            case 1: {
                String value = (String)stack.pop();
                result = this.getDateAsString(communicator, value);
                break;
            }
            case 2: {
                result = this.disPatchDate(communicator, stack.pop(), stack.pop());
                break;
            }
            case 3: {
                try {
                    result = this.disPatchDate(communicator, stack.pop(), stack.pop(), stack.pop());
                }
                catch (java.text.ParseException e) {}
                break;
            }
            default: {
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
        }
        stack.push(result);
    }

    public boolean isMonth(String value) {
        return value.endsWith("M");
    }

    public boolean isYear(String value) {
        return value.endsWith("Y");
    }

    public boolean isDay(String value) {
        return value.endsWith("D");
    }

    public boolean isHour(String value) {
        return value.endsWith("H");
    }

    public boolean isSecond(String value) {
        return value.endsWith("s");
    }

    public boolean isMinute(String value) {
        return value.endsWith("m");
    }

    public boolean isMilli(String value) {
        return value.endsWith("S");
    }

    public boolean endsWithRangeMarker(String value) {
        return this.isMonth(value) || this.isYear(value) || this.isDay(value) || this.isHour(value) || this.isSecond(value) || this.isMinute(value) || this.isMilli(value);
    }

    public int getType(String value) {
        if (this.isMonth(value)) {
            return 2;
        }
        if (this.isYear(value)) {
            return 1;
        }
        if (this.isDay(value)) {
            return 6;
        }
        if (this.isHour(value)) {
            return 10;
        }
        if (this.isSecond(value)) {
            return 13;
        }
        if (this.isMinute(value)) {
            return 12;
        }
        if (this.isMilli(value)) {
            return 14;
        }
        return -1;
    }

    public Date parseDate(String aDate) throws java.text.ParseException {
        if (JAXFrontDateTools.isISODateTime(aDate)) {
            this._defaultPattern = "yyyy-MM-dd'T'HH:mm:ss";
            return JAXFrontDateTools.isoDateTimeFormat.parse(aDate);
        }
        if (JAXFrontDateTools.isISODate(aDate)) {
            this._defaultPattern = "yyyy-MM-dd";
            return JAXFrontDateTools.isoDateFormat.parse(aDate);
        }
        if (JAXFrontDateTools.isISOTime(aDate)) {
            this._defaultPattern = "HH:mm:ss.SSS";
            return JAXFrontDateTools.isoTimeFormat.parse(aDate);
        }
        if (StringUtil.isNumeric(aDate)) {
            return new Date(Long.parseLong(aDate));
        }
        return null;
    }

    public Object disPatchDate(MathEvaluator.MathCommunicator communicator, Object o1, Object o2, Object o3) throws java.text.ParseException {
        if (o1 instanceof SimpleType && o2 instanceof String && o3 instanceof SimpleType) {
            Date dateFrom = this.getDateAsDate(communicator, (SimpleType)o1);
            Date dateTo = this.getDateAsDate(communicator, (SimpleType)o3);
            if (o2.toString().startsWith("-")) {
                return this.substract(dateFrom, dateTo, this.getType(o2.toString()));
            }
            if ("+".equals(o2)) {
                return this.add(dateFrom, dateTo, "M");
            }
            if ("==".equals(o2)) {
                return new Integer(this.compare(dateFrom, dateTo));
            }
        } else if (o1 instanceof String && o2 instanceof String && o3 instanceof String) {
            Date dateFrom = this.parseDate(o1.toString());
            Date dateTo = this.parseDate(o3.toString());
            if (o2.toString().startsWith("-")) {
                return this.substract(dateFrom, dateTo, this.getType(o2.toString()));
            }
            if ("+".equals(o2)) {
                return this.add(dateFrom, dateTo, "M");
            }
            if ("==".equals(o2)) {
                return new Integer(this.compare(dateFrom, dateTo));
            }
        } else if (o1 instanceof String && o2 instanceof String && o3 instanceof SimpleType) {
            Date dateFrom = this.getDateAsDate(communicator, (SimpleType)o3, o1.toString());
            Date dateTo = this.getDateAsDate(communicator, (SimpleType)o3);
            String op = o2.toString();
            if (op.startsWith("-")) {
                return this.substract(dateFrom, dateTo, this.getType(op));
            }
            if ("+".equals(op)) {
                return this.add(dateFrom, dateTo, "M");
            }
            if ("==".equals(op)) {
                return new Integer(this.compare(dateFrom, dateTo));
            }
        }
        return null;
    }

    public Vector splitDateModifier(String modifier) {
        Vector<String> result = new Vector<String>();
        int last = 0;
        for (int i = 0; i < modifier.length(); ++i) {
            int dateType = this.getType(modifier.charAt(i) + "");
            if (dateType == -1) continue;
            result.add(modifier.substring(last, i + 1));
            last = i + 1;
        }
        return result;
    }

    public String disPatchDate(MathEvaluator.MathCommunicator communicator, Object o2, Object o3) {
        if (o3 instanceof SimpleType) {
            return this.disPatchDate(communicator, o2.toString(), (SimpleType)o3);
        }
        return this.disPatchDate(communicator, o2.toString(), o3.toString());
    }

    public String disPatchDate(MathEvaluator.MathCommunicator communicator, String o2, SimpleType o3) {
        try {
            Date date1 = this.getDateAsDate(communicator, o3);
            Vector modifiers = this.splitDateModifier(o2);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(date1.getTime());
            for (int m = 0; m < modifiers.size(); ++m) {
                String modifier = modifiers.get(m).toString();
                String value = modifier.substring(0, modifier.length() - 1);
                ((Calendar)cal).add(this.getType(modifier), Integer.parseInt(value));
            }
            return this.getResultAsString(o3, cal.getTime());
        }
        catch (Exception e) {
            return "";
        }
    }

    public String disPatchDate(MathEvaluator.MathCommunicator communicator, String o2, String o3) {
        try {
            Date date1 = this.parseDate(o3);
            Vector modifiers = this.splitDateModifier(o2);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(date1.getTime());
            for (int m = 0; m < modifiers.size(); ++m) {
                String modifier = modifiers.get(m).toString();
                String value = modifier.substring(0, modifier.length() - 1);
                ((Calendar)cal).add(this.getType(modifier), Integer.parseInt(value));
            }
            SimpleDateFormat formatter = new SimpleDateFormat(this._defaultPattern, communicator.getRootType().getDOM().getGlobalDefinition().getCurrentLocale());
            return formatter.format(new Date(cal.getTimeInMillis()));
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getDateAsString(MathEvaluator.MathCommunicator communicator, String pattern) {
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, communicator.getRootType().getDOM().getGlobalDefinition().getCurrentLocale());
        return formatter.format(today);
    }

    private Date getDateAsDate(MathEvaluator.MathCommunicator communicator, String value) throws java.text.ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(this._defaultPattern, communicator.getRootType().getDOM().getGlobalDefinition().getCurrentLocale());
        return formatter.parse(value);
    }

    private String getResultAsString(SimpleType type, Date aDate) {
        if (type.isDate()) {
            return JAXFrontDateTools.isoDateFormat.format(aDate);
        }
        if (type.isDateTime()) {
            return JAXFrontDateTools.isoDateTimeFormat.format(aDate);
        }
        if (type.isTime()) {
            return JAXFrontDateTools.isoTimeFormat.format(aDate);
        }
        return "";
    }

    private Date getDateAsDate(MathEvaluator.MathCommunicator communicator, SimpleType type) throws java.text.ParseException {
        return this.getDateAsDate(communicator, type, type.getValue());
    }

    private Date getDateAsDate(MathEvaluator.MathCommunicator communicator, SimpleType type, String value) throws java.text.ParseException {
        if (type.isDate()) {
            return JAXFrontDateTools.isoDateFormat.parse(value);
        }
        if (type.isDateTime()) {
            return JAXFrontDateTools.isoDateTimeFormat.parse(value);
        }
        if (type.isTime()) {
            return JAXFrontDateTools.isoTimeFormat.parse(value);
        }
        return new Date();
    }

    public Long substract(Date from, Date to, int difType) {
        long result;
        GregorianCalendar cal_1 = new GregorianCalendar();
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_1.setTimeInMillis(from.getTime());
        cal_2.setTimeInMillis(to.getTime());
        long time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
        switch (difType) {
            case 1: {
                result = Math.round((double)time / 3.1536E10);
                break;
            }
            case 2: {
                result = Math.round((double)time / 2.627424E9);
                break;
            }
            case 6: {
                result = Math.round((double)time / 8.64E7);
                break;
            }
            case 10: {
                result = Math.round((double)time / 3600000.0);
                break;
            }
            case 12: {
                result = Math.round((double)time / 60000.0);
                break;
            }
            case 13: {
                result = Math.round((double)time / 1000.0);
                break;
            }
            default: {
                result = time;
            }
        }
        return new Long(result);
    }

    public Long add(Date from, Date to, String difType) {
        long result;
        GregorianCalendar cal_1 = new GregorianCalendar();
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_1.setTimeInMillis(from.getTime());
        cal_2.setTimeInMillis(to.getTime());
        long time = cal_2.getTime().getTime() + cal_1.getTime().getTime();
        switch (this.getType(difType)) {
            case 1: {
                result = Math.round((double)time / 3.1536E10);
                break;
            }
            case 2: {
                result = Math.round((double)time / 2.627424E9);
                break;
            }
            case 6: {
                result = Math.round((double)time / 8.64E7);
                break;
            }
            case 10: {
                result = Math.round((double)time / 3600000.0);
                break;
            }
            case 12: {
                result = Math.round((double)time / 60000.0);
                break;
            }
            case 13: {
                result = Math.round((double)time / 1000.0);
                break;
            }
            default: {
                result = time;
            }
        }
        return new Long(result);
    }

    public int compare(Date from, Date to) {
        return from.compareTo(to);
    }
}

