/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.NULL;

public class IntegerCast
extends PostfixMathCommand {
    public IntegerCast() {
        this.numberOfParameters = -1;
    }

    private Integer convert(String param) {
        return new Integer(new Double(param).intValue());
    }

    private Integer convert(Boolean param) {
        if (param.booleanValue()) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    private Integer convert(Number param) {
        return new Integer(((Double)param).intValue());
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object result = null;
        if (this.curNumberOfParameters == 1) {
            Object newParam = stack.pop();
            try {
                if (newParam == NULL._null) {
                    result = NULL._null;
                }
                if (newParam instanceof String) {
                    result = this.convert((String)newParam);
                }
                if (newParam instanceof Integer) {
                    result = newParam;
                }
                if (newParam instanceof Number) {
                    result = this.convert((Number)newParam);
                }
                if (newParam instanceof Boolean) {
                    result = this.convert((Boolean)newParam);
                }
                if (newParam instanceof TypeObject && ((TypeObject)newParam).isSimple()) {
                    result = this.convert(newParam.toString());
                }
                if (newParam instanceof List) {
                    List paramArray = (List)newParam;
                    ArrayResult resultArray = new ArrayResult(paramArray.size());
                    for (int i = 0; i < paramArray.size(); ++i) {
                        Object aArrayValue = paramArray.get(i);
                        if (aArrayValue instanceof String) {
                            resultArray.add(this.convert((String)aArrayValue));
                            continue;
                        }
                        if (paramArray.get(i) instanceof Number) {
                            resultArray.add(this.convert((Number)aArrayValue));
                            continue;
                        }
                        if (newParam instanceof Boolean) {
                            resultArray.add(this.convert((Boolean)aArrayValue));
                            continue;
                        }
                        resultArray.add(NULL._null);
                    }
                    result = resultArray;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type:" + newParam);
            }
            catch (NumberFormatException e) {
                throw new ParseException(this.getClass() + " NumberFormatException can't parse:" + newParam);
            }
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter count");
        }
        stack.push(result);
    }
}

