/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.keyRef;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.keyRef.KeyContextWrapper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.SchemaKey;
import com.jaxfront.core.schema.SchemaKeyRef;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.impl.KeyCompositeContainer;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.schema.impl.KeyDefinition;
import com.jaxfront.core.schema.impl.KeyKeyRefEvent;
import com.jaxfront.core.schema.impl.KeyKeyRefListener;
import com.jaxfront.core.schema.impl.KeyRefDefinition;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.DoubleKeyHashtable;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.util.JAXFrontProperties;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class KeyKeyRefManager {
    private DoubleKeyHashtable _keyTable = null;
    public static EmptyType DUMMY_KEY_TYPE = new EmptyType(null, null);
    protected transient Vector _keyKeyRefListeners;
    private boolean _blockEvents = false;
    private Document _dom;
    static /* synthetic */ Class class$com$jaxfront$core$keyRef$KeyKeyRefManager;

    public KeyKeyRefManager(Document document) {
        this._dom = document;
    }

    public KeyContainer getKeyContainer(String keyName, Object context) {
        KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(keyName, context);
        return keyContainer;
    }

    public KeyContainer getKeyContainerForRef(String keyName, Object context) {
        KeyContainer keyContainer = null;
        keyContainer = context.equals(KeyContainer._defaultContextWrapper) ? new KeyCompositeContainer(keyName, this.getKeyTable().getPrimary(keyName)) : (KeyContainer)this.getKeyTable().get(keyName, context);
        return keyContainer;
    }

    public List getKeyContainer(SimpleType type, Hashtable keys) {
        Iterator selectors = keys.entrySet().iterator();
        ArrayList<KeyContainer> containers = new ArrayList<KeyContainer>(2);
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, key.getSchemaElement()));
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(key.getName(), context);
            if (KeyContainer._wrongContext == context.getContext()) continue;
            if (keyContainer == null) {
                keyContainer = new KeyContainer(key.getName(), key, this._dom);
                keyContainer.setContext(context);
                this.addKeyContainer(key.getName(), context, keyContainer);
            }
            if (!KeyKeyRefManager.isValidSelector(type, keyContainer.getSchemaKey(), keyDef.getSelectorNode(), true)) continue;
            containers.add(keyContainer);
        }
        return containers;
    }

    public void registerKey(SimpleType type, Hashtable keys, boolean isBinding) throws KeyRefException {
        Iterator selectors = keys.entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            Type[] wrapperContext = KeyContainer.createContext(type, key.getSchemaElement());
            KeyContextWrapper context = new KeyContextWrapper(wrapperContext);
            if (wrapperContext == KeyContainer._wrongContext) continue;
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(key.getName(), context);
            if (keyContainer == null) {
                keyContainer = new KeyContainer(key.getName(), key, this._dom);
                keyContainer.setContext(context);
                this.addKeyContainer(key.getName(), context, keyContainer);
            }
            if (!KeyKeyRefManager.isValidSelector(type, keyContainer.getSchemaKey(), keyDef.getSelectorNode(), true)) continue;
            if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().log(this.getClass(), "register Key:" + keyContainer.getKeyName() + " context:" + context.toString() + " " + type.getPlainValue());
            }
            keyContainer.addKeyType(type, false);
            this.fireKeyKeyRefEvent(new KeyKeyRefEvent(key.getName(), null, 1, type));
        }
    }

    public boolean isKeyType(SimpleType type, Hashtable keys) {
        Iterator selectors = keys.entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            if (!KeyKeyRefManager.isValidSelector(type, key, keyDef.getSelectorNode(), true)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyRefType(SimpleType type, ArrayList keyRefs) {
        for (int k = 0; k < keyRefs.size(); ++k) {
            KeyRefDefinition kRD = (KeyRefDefinition)keyRefs.get(k);
            if (!KeyKeyRefManager.isValidSelector(type, kRD.getSchemakeyRef(), kRD.getSelectorNode(), false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidSelector(Type type, SchemaKey sKey, SchemaNode selectorElement, boolean isKey) {
        boolean match2 = false;
        SchemaNode[] selectors = sKey.getSelectors();
        for (int i = 0; selectors != null && i < selectors.length && !(match2 = isKey ? KeyContainer.isSelectorKeyParent(sKey, selectors[i], type) : KeyContainer.isSelectorRefParent(sKey, selectors[i], type)); ++i) {
        }
        return match2;
    }

    public boolean isKeyRemoveable(Type deletionStart, SimpleType type, Hashtable keys) {
        Iterator selectors = keys.entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            SchemaKey key = (SchemaKey)entry.getValue();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, key.getSchemaElement()));
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(key.getName(), context);
            boolean rmb = keyContainer.isKeyRemovable(deletionStart, type);
            if (rmb) continue;
            return false;
        }
        return true;
    }

    public static void deRegisterKeyKeyRefStructure(Type type, boolean forceDeletion) throws KeyRefException {
        Vector<Type> childsToProcess = new Vector<Type>();
        childsToProcess.add(type);
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type achild = (Type)childsToProcess.get(c);
            if (!achild.isSimple()) {
                childsToProcess.addAll(achild.getDirectChildren());
                continue;
            }
            if (achild.isKeyRef()) {
                achild.getDOM().getKeyKeyRefManager().deRegisterKeyRef((SimpleType)achild);
            }
            if (!achild.isKey()) continue;
            achild.getDOM().getKeyKeyRefManager().deRegisterKey((SimpleType)achild, achild.getSchemaElement().getSchemaKeys(), forceDeletion);
        }
    }

    public void deRegisterKey(SimpleType type, Hashtable keys, boolean forceDeletion) throws KeyRefException {
        this.deRegisterKey(null, type, keys, forceDeletion);
    }

    public void deRegisterKey(Type deletionStart, SimpleType type, Hashtable keys, boolean forceDeletion) throws KeyRefException {
        Iterator selectors = keys.entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, key.getSchemaElement()));
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(key.getName(), context);
            if (!KeyKeyRefManager.isValidSelector(type, keyContainer.getSchemaKey(), keyDef.getSelectorNode(), true)) continue;
            if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().log(this.getClass(), "deRegister Key:" + keyContainer.getKeyName() + " context:" + context.toString() + " " + type.getPlainValue());
            }
            keyContainer.removeKeyType(deletionStart, type, forceDeletion);
            this.fireKeyKeyRefEvent(new KeyKeyRefEvent(key.getName(), null, 2, type));
        }
    }

    public void canDeRegisterKey(Type deletionStart, SimpleType type, Hashtable keys, boolean forceDeletion) throws KeyRefException {
        Iterator selectors = keys.entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, key.getSchemaElement()));
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(key.getName(), context);
            if (!KeyKeyRefManager.isValidSelector(type, keyContainer.getSchemaKey(), keyDef.getSelectorNode(), true)) continue;
            if (LogRegistry.getInstance().logLogs()) {
                LogRegistry.getInstance().log(this.getClass(), "deRegister Key:" + keyContainer.getKeyName() + " " + type.getPlainValue());
            }
            keyContainer.isKeyTypeRemoveable(deletionStart, type);
        }
    }

    public void registerKeyRef(SimpleType type, boolean isBinding) {
        KeyRefDefinition keyRefDef = type.getKeyRefDefinition();
        if (keyRefDef != null) {
            SchemaKeyRef keyRef = keyRefDef.getSchemakeyRef();
            if (keyRef.getKey() != null) {
                KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, keyRef.getKey().getSchemaElement()));
                KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(keyRef.getKeyName(), context);
                if (keyContainer == null) {
                    keyContainer = new KeyContainer(keyRef.getKeyName(), keyRef.getKey(), this._dom);
                    keyContainer.setContext(context);
                    this.addKeyContainer(keyRef.getKeyName(), context, keyContainer);
                }
                keyContainer.addKeyRefType(keyRef.getName(), type);
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "register KeyRef:" + keyRef.getKeyName() + " refName:" + keyRef.getName() + " context:" + context.toString() + " " + type.getPlainValue());
                }
                this.fireKeyKeyRefEvent(new KeyKeyRefEvent(keyRef.getKeyName(), keyRef.getName(), 3, type));
            } else if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().error(this.getClass(), "no key defined for keyref:" + keyRefDef.getName());
            }
        }
    }

    public void deRegisterKeyRef(SimpleType type) {
        KeyRefDefinition keyRefDef = type.getKeyRefDefinition();
        if (keyRefDef != null) {
            SchemaKeyRef keyRef = keyRefDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(type, keyRef.getKey().getSchemaElement()));
            KeyContainer keyContainer = (KeyContainer)this.getKeyTable().get(keyRef.getKeyName(), context);
            if (keyContainer != null) {
                if (LogRegistry.getInstance().logLogs()) {
                    LogRegistry.getInstance().log(this.getClass(), "deRegister KeyRef:" + keyRef.getKeyName() + " refName:" + keyRef.getName() + " context:" + context.toString() + " " + type.getPlainValue());
                }
                keyContainer.removeKeyRefType(keyRef.getName(), type);
                this.fireKeyKeyRefEvent(new KeyKeyRefEvent(keyRef.getKeyName(), keyRef.getName(), 4, type));
            } else if (LogRegistry.getInstance().logLogs()) {
                LogRegistry.getInstance().log(this.getClass(), "can't deRegister KeyRef:" + keyRef.getKeyName() + " refName:" + keyRef.getName() + " context:" + context.toString() + " " + type.getPlainValue());
            }
        }
    }

    public List checkKeyRefIntegrity() {
        Iterator keyContainers = this.getKeyTable().entrySet().iterator();
        Vector errors = new Vector();
        while (keyContainers.hasNext()) {
            DoubleKeyHashtable.Entry entry = (DoubleKeyHashtable.Entry)keyContainers.next();
            KeyContainer keyContainer = (KeyContainer)entry.getValue();
            try {
                keyContainer.areAllKeysValid();
            }
            catch (KeyRefException e) {
                errors.addAll(e.getReferences());
            }
            try {
                keyContainer.areAllReferencesValid();
            }
            catch (KeyRefException e) {
                errors.addAll(e.getReferences());
            }
        }
        return errors;
    }

    public List getReleased() {
        Iterator keyContainers = this.getKeyTable().entrySet().iterator();
        Vector released = new Vector();
        while (keyContainers.hasNext()) {
            DoubleKeyHashtable.Entry entry = (DoubleKeyHashtable.Entry)keyContainers.next();
            KeyContainer keyContainer = (KeyContainer)entry.getValue();
            try {
                released.addAll(keyContainer.getReleased());
            }
            catch (KeyRefException e) {}
        }
        return released;
    }

    private Vector getKeyKeyRefListeners() {
        if (this._keyKeyRefListeners == null) {
            this._keyKeyRefListeners = new Vector();
        }
        return this._keyKeyRefListeners;
    }

    public void addKeyKeyRefListener(KeyKeyRefListener newListener) {
        this.getKeyKeyRefListeners().add(newListener);
    }

    public void removeKeyKeyRefListener(KeyKeyRefListener newListener) {
        this.getKeyKeyRefListeners().remove(newListener);
    }

    public void fireKeyKeyRefEvent(KeyKeyRefEvent event) {
        if (!this._blockEvents) {
            Vector ap = this.getKeyKeyRefListeners();
            int s = ap.size();
            block8: for (int i = 0; i < s; ++i) {
                KeyKeyRefListener listener = (KeyKeyRefListener)ap.get(i);
                switch (event.getEventType()) {
                    case 1: {
                        listener.keyAdded(event);
                        continue block8;
                    }
                    case 2: {
                        listener.keyRemoved(event);
                        continue block8;
                    }
                    case 3: {
                        listener.keyRefAdded(event);
                        continue block8;
                    }
                    case 4: {
                        listener.keyRefRemoved(event);
                        continue block8;
                    }
                    case 5: {
                        listener.keyChanged(event);
                        continue block8;
                    }
                    case 6: {
                        listener.keyRefChanged(event);
                        continue block8;
                    }
                }
            }
        }
    }

    public DoubleKeyHashtable getKeyTable() {
        if (this._keyTable == null) {
            this._keyTable = new DoubleKeyHashtableUnsynced();
        }
        return this._keyTable;
    }

    public void addKeyContainer(String keyName, Object context, KeyContainer keyContainer) {
        this.getKeyTable().put(keyName, context, keyContainer);
    }

    public void removeKeyContainer(Type aType) {
        Type[] context = KeyContainer._defaultContext;
        context = ArrayUtil.addToArray(context, aType);
        this.getKeyTable().removeSecondary(new KeyContextWrapper(context));
    }

    public void keyRefChanged(SimpleType refType) {
        KeyRefDefinition keyRefDef = refType.getKeyRefDefinition();
        if (keyRefDef != null) {
            SchemaKeyRef scr = keyRefDef.getSchemakeyRef();
            this.fireKeyKeyRefEvent(new KeyKeyRefEvent(scr.getKeyName(), scr.getName(), 6, refType));
        }
    }

    public void keyChanged(SimpleType keyType) {
        Iterator selectors = keyType.getSchemaElement().getSchemaKeys().entrySet().iterator();
        while (selectors.hasNext()) {
            Map.Entry entry = selectors.next();
            KeyDefinition keyDef = (KeyDefinition)entry.getValue();
            SchemaKey key = keyDef.getSchemakey();
            if (!KeyKeyRefManager.isValidSelector(keyType, key, keyDef.getSelectorNode(), true)) continue;
            this.fireKeyKeyRefEvent(new KeyKeyRefEvent(key.getName(), null, 5, keyType));
        }
    }

    public String getInfo() {
        KeyContainer keyContainer;
        DoubleKeyHashtable.Entry entry;
        StringBuffer info = new StringBuffer();
        Iterator keyContainers = this.getKeyTable().entrySet().iterator();
        while (keyContainers.hasNext()) {
            entry = (DoubleKeyHashtable.Entry)keyContainers.next();
            keyContainer = (KeyContainer)entry.getValue();
            keyContainer.getInfo(info, false);
        }
        keyContainers = this.getKeyTable().entrySet().iterator();
        while (keyContainers.hasNext()) {
            entry = (DoubleKeyHashtable.Entry)keyContainers.next();
            keyContainer = (KeyContainer)entry.getValue();
            keyContainer.getInfo(info, true);
        }
        return info.toString();
    }

    public void release() {
        if (this._keyTable != null) {
            Iterator keyContainers = this._keyTable.entrySet().iterator();
            while (keyContainers.hasNext()) {
                DoubleKeyHashtable.Entry entry = (DoubleKeyHashtable.Entry)keyContainers.next();
                KeyContainer keyContainer = (KeyContainer)entry.getValue();
                keyContainer.release();
            }
            this._keyTable.clear();
        }
        this._keyTable = null;
        this._keyKeyRefListeners = null;
    }

    public void setBlockEvents(boolean block) {
        this._blockEvents = block;
    }

    public boolean isBlockEvents() {
        return this._blockEvents;
    }

    public void registerAllKeyAndKeyRefs(Type rootType) {
        List childs = this.getAllChilds(rootType, true);
        Document dom = rootType.getDOM();
        KeyKeyRefManager manager = dom.getKeyKeyRefManager();
        for (int c = 0; c < childs.size(); ++c) {
            Type aChild;
            block4: {
                aChild = (Type)childs.get(c);
                if (aChild.isKey()) {
                    try {
                        manager.registerKey((SimpleType)aChild, aChild.getSchemaElement().getSchemaKeys(), true);
                    }
                    catch (KeyRefException e) {
                        if (!JAXFrontProperties.LOG_ENABLED) break block4;
                        LogRegistry.getInstance().error(class$com$jaxfront$core$keyRef$KeyKeyRefManager == null ? KeyKeyRefManager.class$("com.jaxfront.core.keyRef.KeyKeyRefManager") : class$com$jaxfront$core$keyRef$KeyKeyRefManager, e);
                    }
                }
            }
            if (!aChild.isKeyRef()) continue;
            manager.registerKeyRef((SimpleType)aChild, false);
        }
    }

    public List getAllChilds(Type aStartType, boolean includingStartType) {
        Vector<Type> childsToEvaluate = new Vector<Type>();
        if (includingStartType) {
            childsToEvaluate.add(aStartType);
        } else {
            childsToEvaluate.addAll(aStartType.getDirectChildren());
        }
        for (int c = 0; c < childsToEvaluate.size(); ++c) {
            Type aType = (Type)childsToEvaluate.get(c);
            if (aType.isList()) {
                childsToEvaluate.addAll((List)((Object)aType));
                continue;
            }
            List dirChilds = aType.getDirectChildren();
            if (dirChilds == null) continue;
            childsToEvaluate.addAll(dirChilds);
        }
        return childsToEvaluate;
    }
}

