/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.log;

import com.jaxfront.core.log.DummyLogRegistry;
import com.jaxfront.core.log.Log4JLogRegistry;
import com.jaxfront.core.log.Logger;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class LogRegistry
implements Logger {
    private static LogRegistry _singleton;
    private Logger _logger = null;
    private static org.apache.log4j.Logger _jdbcLogger;
    private boolean _isDebug = false;
    private static final String KEY_PROPERTY_LOG4J = "Log4J";
    private int _logSchema = 0;

    private LogRegistry() {
        List levels;
        try {
            Vector logTool = JAXFrontProperties.getInstance().getValues("jaxfront.logTool");
            if (logTool != null && logTool.size() > 0) {
                String loggerName = (String)logTool.firstElement();
                if (loggerName.equalsIgnoreCase(KEY_PROPERTY_LOG4J)) {
                    this._logger = new Log4JLogRegistry();
                    String location = System.getProperty("user.dir") + File.separator + "log" + File.separator + "jaxfront.log";
                    this._logger.setLogFileUrl(location);
                } else {
                    this._logger = new DummyLogRegistry();
                }
            } else {
                this._logger = new DummyLogRegistry();
            }
        }
        catch (Throwable ex) {
            this._logger = new DummyLogRegistry();
        }
        if (this._logger != null && (levels = JAXFrontProperties.getInstance().getLogLevels()) != null) {
            this._isDebug = levels.size() > 0;
            this._logger.setLogLevels(ArrayUtil.toStringArray(levels));
        }
    }

    public void setLogFileUrl(String url) {
        this._logger.setLogFileUrl(url);
    }

    public String getLogFileUrl() {
        return this._logger.getLogFileUrl();
    }

    public void setLogLevels(String[] logLevels) {
        if (logLevels != null) {
            this._isDebug = logLevels.length > 0;
        }
        this._logger.setLogLevels(logLevels);
    }

    public void error(Class aClass, Exception e) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.error(aClass, e);
        }
    }

    public void error(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.error(aClass, message);
        }
    }

    public void fatal(Class aClass, Exception e) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.fatal(aClass, e);
        }
    }

    public void fatal(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.fatal(aClass, message);
        }
    }

    public static LogRegistry getInstance() {
        if (_singleton == null) {
            _singleton = new LogRegistry();
        }
        return _singleton;
    }

    public boolean logWarnings() {
        return JAXFrontProperties.LOG_ENABLED && this.getLogger().logWarnings();
    }

    public boolean logErrors() {
        return JAXFrontProperties.LOG_ENABLED && this.getLogger().logErrors();
    }

    public boolean logLogs() {
        return JAXFrontProperties.LOG_ENABLED && this.getLogger().logLogs();
    }

    public boolean logInfos() {
        return JAXFrontProperties.LOG_ENABLED && this.getLogger().logInfos();
    }

    public boolean logFatals() {
        return this.getLogger().logFatals();
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void info(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.info(aClass, message);
        }
    }

    public void infoDB(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.info(aClass, message);
        }
    }

    public void infoRule(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.info(aClass, message);
        }
    }

    public void errorDB(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.error(aClass, message);
        }
    }

    public void errorRule(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.error(aClass, message);
        }
    }

    public void log(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.log(aClass, message);
        }
    }

    public void warn(Class aClass, String message) {
        if (JAXFrontProperties.LOG_ENABLED) {
            this._logger.warn(aClass, message);
        }
    }

    public boolean isDebug() {
        return this._isDebug;
    }

    private static void initDBLogger() {
        _jdbcLogger = org.apache.log4j.Logger.getLogger((String)"JDBC2");
    }

    public static org.apache.log4j.Logger getJDBCLogger() {
        if (_jdbcLogger == null) {
            LogRegistry.initDBLogger();
        }
        return _jdbcLogger;
    }
}

