/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.Type;

public class Message
implements Cloneable {
    private int _id;
    private Type _sourceType = null;
    private String _classification;
    private boolean _needsUserAcceptance;
    private FormulaExpression _formulaExpression = null;

    public Message(int id, Type sourceType, String classification, boolean needsUserAcceptance, FormulaExpression formEx) {
        this._id = id;
        this._sourceType = sourceType;
        this._classification = classification;
        this._needsUserAcceptance = needsUserAcceptance;
        this._formulaExpression = formEx;
    }

    public void setID(int id) {
        this._id = id;
    }

    public String getText() {
        String formulaNLSMessage = this.getSourceType().getDOM().getNLS().getTranslation(this.getSourceType(), null, "message", String.valueOf(this._id), "formula");
        if (formulaNLSMessage == null) {
            formulaNLSMessage = this.getSourceType().getDOM().getNLS().getTranslation(this.getSourceType(), null, "message", String.valueOf(this._id), null);
        }
        if (formulaNLSMessage == null && this._formulaExpression != null) {
            formulaNLSMessage = this._formulaExpression.getExpression();
        }
        if (formulaNLSMessage == null) {
            formulaNLSMessage = "undefined";
        }
        return formulaNLSMessage;
    }

    public boolean isErrorMessage() {
        return this.getClassification() != null && this.getClassification().equals("error");
    }

    public boolean isInfoMessage() {
        return this.getClassification() != null && this.getClassification().equals("info");
    }

    public boolean isWarningMessage() {
        return this.getClassification() != null && this.getClassification().equals("warning");
    }

    public String getClassification() {
        if (this._classification == null) {
            this._classification = "warning";
        }
        return this._classification;
    }

    public boolean isNeedingUserAcceptance() {
        return this._needsUserAcceptance;
    }

    private Type getSourceType() {
        return this._sourceType;
    }

    public boolean isHintMessage() {
        return this.getClassification() != null && this.getClassification().equals("hint");
    }

    public boolean isQuestionMessage() {
        return this.getClassification() != null && this.getClassification().equals("question");
    }

    public Object clone(Type newSourceType) {
        Message clone = null;
        try {
            clone = (Message)this.clone();
            clone._sourceType = newSourceType;
            if (this._formulaExpression != null) {
                clone._formulaExpression = new FormulaExpression(newSourceType, this._formulaExpression.getExpression(), false, false);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public void release() {
        this._formulaExpression = null;
        this._sourceType = null;
    }
}

