/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.error.ConditionalError;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.IAction;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.rule.RuleImpl;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.xui.AbstractXUIElement;
import com.jaxfront.core.xui.StyleDefinition;
import java.util.Iterator;
import java.util.Stack;
import org.nfunk.jep.FunctionViewerFactory;

public class SimpleRuleImpl
extends RuleImpl {
    public SimpleRuleImpl(long type, Type source) {
        this(type, source, null);
    }

    public SimpleRuleImpl(long type, Type source, String scope) {
        this(type, source, scope, true);
    }

    public SimpleRuleImpl(long type, Type source, String scope, boolean doesConcernNoneSerializableSource) {
        this(type, source, null, scope, doesConcernNoneSerializableSource, false);
    }

    public SimpleRuleImpl(long type, Type source, String executionMode, String scope, boolean doesConcernNoneSerializableSource, boolean doesConcernOnlyVisible) {
        this(null, type, source, executionMode, scope, doesConcernNoneSerializableSource, doesConcernOnlyVisible, false);
    }

    public SimpleRuleImpl(String id, long type, Type source, String executionMode, String scope, boolean doesConcernNoneSerializableSource, boolean doesConcernOnlyVisible, boolean scopeIncludeTarget) {
        super(id, type, source, executionMode, scope, doesConcernNoneSerializableSource, doesConcernOnlyVisible, scopeIncludeTarget);
    }

    public void apply(Type eventSource, Object event, boolean isRunningAsServer) {
        this.setSource(eventSource);
        TypeController typeCtrl = this.getSource().getDOM().getController();
        StyleDefinition sourceStyle = this.getSource().getXUIDefinition().getStyle();
        if (this.getCondition() != null) {
            boolean conditionsOK = true;
            boolean toggledConditionUsed = false;
            this.getCondition().setSource(this.getSource());
            try {
                this.getCondition().getFormulaExpression().setSource(eventSource);
                conditionsOK = this.getCondition().isTrue(this.getSource(), null);
            }
            catch (FormulaException e) {
                conditionsOK = false;
            }
            if (!conditionsOK) {
                toggledConditionUsed = true;
                this.performInverseActions(eventSource, null);
            }
            if (this.getCondition().isShowingError()) {
                typeCtrl.getErrorController().removeConditionalError(this, this.getCondition(), this.getSource());
                if (conditionsOK && sourceStyle.isVisible()) {
                    typeCtrl.getErrorController().addError(new ConditionalError(this, this.getCondition(), this.getCondition().getSource()));
                } else {
                    typeCtrl.getErrorController().removeConditionalError(this, this.getCondition(), this.getSource());
                }
            }
            if (conditionsOK && !toggledConditionUsed) {
                Iterator<IAction> iterator = this.getActions().iterator();
                while (iterator.hasNext()) {
                    IAction aAction = iterator.next();
                    aAction.setSource(this.getSource());
                    try {
                        aAction.perform(eventSource, false);
                    }
                    catch (RuleInvocationException e1) {
                        if (!this.isVisualizerInitializationRule()) {
                            this.getSource().getDOM().addNotFiredInitializationRule(e1.getTargetType(), this);
                            continue;
                        }
                        if (!LogRegistry.getInstance().logWarnings()) continue;
                        LogRegistry.getInstance().warn(this.getClass(), e1.getMessage());
                    }
                }
            }
        }
    }

    protected void performInverseActions(Type eventSource, Stack callStack) {
        Iterator<IAction> iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            try {
                AbstractAction action = (AbstractAction)iterator.next();
                action.setSource(this.getSource());
                boolean performInverse = false;
                if (action.getInverseAction() != null) {
                    performInverse = true;
                } else if (this.getCondition().isUsingDefaultToggle() && action.isInversable()) {
                    performInverse = true;
                }
                if (action.isInversable() && this.getSource().getDOM().getController().isDebug()) {
                    if (action != null && action.getInverseAction() != null) {
                        FunctionViewerFactory.getFunctionViewer().startAction("Fire InverseAction: " + action.getInverseAction().toString());
                    } else {
                        FunctionViewerFactory.getFunctionViewer().startAction("Fire InverseAction: no action taken!");
                    }
                }
                if (!performInverse) continue;
                action.performInverse(eventSource, callStack);
            }
            catch (RuleInvocationException ex) {
                if (this.isVisualizerInitializationRule()) continue;
                this.getSource().getDOM().addNotFiredInitializationRule(ex.getTargetType(), this);
            }
        }
    }

    public static Rule initializeRule(int counter, Type ruleDefinition) {
        SimpleRuleImpl rule = null;
        SimpleType idType = (SimpleType)ruleDefinition.getDirectChild("id");
        String id = idType != null ? idType.getValue() : null;
        String tempPriority = ruleDefinition.getDirectChildValue("priority");
        if (ruleDefinition != null) {
            Type eventDefinition = ruleDefinition.getDirectChild("event");
            Type conditionDefinition = ruleDefinition.getDirectChild("condition");
            ListType actionDefinition = (ListType)ruleDefinition.getDirectChild("action");
            if (eventDefinition != null) {
                rule = new SimpleRuleImpl(id, 0L, null, null, null, false, false, false);
                if (tempPriority != null) {
                    try {
                        rule.setPriority(Integer.parseInt(tempPriority));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (conditionDefinition != null) {
                    ConditionExpression condition = new ConditionExpression(counter, ruleDefinition.getDOM(), ruleDefinition, conditionDefinition);
                    rule.setCondition(condition);
                }
                if (actionDefinition != null) {
                    Iterator iterator = actionDefinition.getList().iterator();
                    int actionCounter = 1;
                    while (iterator.hasNext()) {
                        AbstractAction action = AbstractXUIElement.initAction(actionCounter, ruleDefinition.getDOM(), ruleDefinition, (Type)iterator.next());
                        rule.getActions().add(action);
                        ++actionCounter;
                    }
                }
            }
        }
        return rule;
    }

    public boolean doesConcern(Type sourceType) {
        return true;
    }
}

