/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema;

import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;

public class SchemaKey {
    private SchemaNode _schemaElement;
    private String _name;
    private String _selectorXPath;
    private String[] _normalizedSelectorXPath;
    private SchemaNode[] _selectors;
    private String[] _fields;
    private boolean _isDefinedOnList = false;

    public SchemaKey(SchemaNode schemaElement, String name, String selectorXPath, String[] fields) {
        this._schemaElement = schemaElement;
        this._name = name;
        this._selectorXPath = selectorXPath.trim();
        this._fields = fields;
        if (this._selectorXPath.indexOf("//") >= 0) {
            this.setNormalizedSelectorXPath(TextTools.tokenize(StringUtil.replace(this._selectorXPath, "//", "/"), "|"));
        } else {
            this._normalizedSelectorXPath = TextTools.tokenize(this._selectorXPath, "|");
            this.setNormalizedSelectorXPath(this._normalizedSelectorXPath);
        }
        this.setDefinedOnList(schemaElement.getMaxOccurs() > 1 || schemaElement.getMaxOccurs() == -1);
    }

    public String[] getFields() {
        return this._fields;
    }

    public SchemaNode getSchemaElement() {
        return this._schemaElement;
    }

    public String getSelectorXPath() {
        return this._selectorXPath;
    }

    public String[] getNormalizedSelectorXPath() {
        return this._normalizedSelectorXPath;
    }

    public void setNormalizedSelectorXPath(String[] xpaths) {
        String[] result = new String[xpaths.length];
        for (int i = 0; i < xpaths.length; ++i) {
            String fieldValue = this.getFields()[0].trim();
            result[i] = fieldValue.startsWith("./") ? xpaths[i].trim() + fieldValue.substring(1) : (fieldValue.equals(".") ? xpaths[i].trim() : xpaths[i].trim() + "/" + fieldValue);
        }
        this._normalizedSelectorXPath = result;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefinedOnList() {
        return this._isDefinedOnList;
    }

    public void setDefinedOnList(boolean onList) {
        this._isDefinedOnList = onList;
    }

    public void addSelector(SchemaNode kfNode) {
        if (this._selectors == null) {
            this._selectors = new SchemaNode[0];
        }
        this._selectors = (SchemaNode[])ArrayUtil.addToArray(SchemaNode.class, (Object[])this._selectors, kfNode);
    }

    public SchemaNode[] getSelectors() {
        return this._selectors;
    }
}

