/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema;

import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.schema.impl.XSDExceptionTranslator;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.xui.NLS;

public class ValidationException
extends Exception {
    public static final int EXCEPTION_NOT_DEFINED = -1;
    public static final int MANDATORY_EXCEPTION = 1;
    public static final int CARDINALITY_EXCEPTION = 2;
    public static final int DUPLICATE_KEY_EXCEPTION = 3;
    public static final int MISSING_KEY_EXCEPTION = 4;
    public static final int INVALID_CODESET_EXCEPTION = 5;
    public static final int DUPLICATE_ID_EXCEPTION = 6;
    private Exception _exception;
    private ConditionExpression _condition;
    private Type _source;
    private String _messageText;
    private String _classification;
    private String _invalidCodeSetValue;
    private boolean _needsUserAcceptance = false;
    private boolean _showDialog = false;
    private int _exceptionType = -1;
    public static final int LIST_NO_CHANGE = 0;
    public static final int LIST_ADD_ENTRY = 1;
    public static final int LIST_REMOVE_ENTRY = -1;

    public ValidationException(ConditionExpression condition) {
        this._condition = condition;
    }

    public ValidationException(Type source, boolean needingUserAcceptance, boolean showDialog, boolean isMandatoryException, String classification) {
        this(source, null, needingUserAcceptance, showDialog, isMandatoryException, classification);
    }

    public ValidationException(Type source, boolean needingUserAcceptance, boolean showDialog, boolean isMandatoryException) {
        this(source, needingUserAcceptance, showDialog, isMandatoryException, null);
    }

    public ValidationException(Type source, boolean needingUserAcceptance, boolean showDialog) {
        this(source, needingUserAcceptance, showDialog, false);
    }

    public ValidationException(Type source, boolean needingUserAcceptance) {
        this(source, needingUserAcceptance, false);
    }

    public ValidationException(Type source, Exception e, String classification) {
        super(e);
        this._source = source;
        this._exception = e;
        this._classification = classification;
    }

    public ValidationException(Type source, String messageText, boolean needingUserAcceptance, boolean showDialog, boolean isMandatoryException, String classification) {
        this._source = source;
        this._messageText = messageText;
        this._classification = classification;
        this._showDialog = showDialog;
        this._needsUserAcceptance = needingUserAcceptance;
        this._exceptionType = 1;
    }

    public ValidationException(Type source) {
        this(source, false, false);
    }

    public static ValidationException createMandatoryException(Type type) {
        ValidationException ex = new ValidationException(type, false, false);
        ex._exceptionType = 1;
        ex.setClassification("incomplete");
        return ex;
    }

    public static ValidationException createCardinalityException(ListType type) {
        ValidationException ex = new ValidationException((Type)type, true, false);
        ex._exceptionType = 2;
        ex.setClassification("incomplete");
        return ex;
    }

    public static ValidationException createInvalidCodeSetCodeException(SimpleType type, String invalidValue) {
        ValidationException ex = new ValidationException((Type)type, false, false);
        ex._exceptionType = 5;
        ex._invalidCodeSetValue = invalidValue;
        ex.setClassification("error");
        return ex;
    }

    public static ValidationException createDuplicateKeyException(SimpleType type, String invalidValue) {
        ValidationException ex = new ValidationException(type, ValidationException.getDuplicateKeyMessage(type, invalidValue), false, false, false, "error");
        ex._exceptionType = 3;
        return ex;
    }

    public static ValidationException createMissingKeyException(SimpleType type, String invalidValue) {
        ValidationException ex = new ValidationException(type, ValidationException.getMissingKeyMessage(type, invalidValue), false, false, false, "error");
        ex._exceptionType = 4;
        return ex;
    }

    public static ValidationException createDuplicateIDException(SimpleType type, String invalidValue) {
        ValidationException ex = new ValidationException(type, ValidationException.getDuplicateIDMessage(type, invalidValue), false, false, false, "error");
        ex._exceptionType = 6;
        return ex;
    }

    public ConditionExpression getCondition() {
        return this._condition;
    }

    public String getMessage() {
        String message = null;
        if (this._exception != null) {
            message = XSDExceptionTranslator.getMessage(this.getSource(), this._exception);
            String ownMessage = this.getSource().getStyle().getValidationErrorMessage();
            if (ownMessage != null && !ownMessage.equals(this.getSource().getName())) {
                message = ownMessage;
            }
        } else if (this._messageText != null) {
            message = this._messageText;
        }
        if (message != null) {
            return message;
        }
        if (this.getSource() != null && this.getSource().isSimple() && this.getSource().getStyle().getValidationErrorMessage() != null) {
            message = this.getSource().getStyle().getValidationErrorMessage();
            return message;
        }
        if (this.getCondition() != null) {
            message = this.getCondition().getMessage().getText();
            return message;
        }
        if (this.getSource() != null) {
            switch (this._exceptionType) {
                case 2: {
                    message = ValidationException.getCardinalityExceptionMessage((ListType)this.getSource());
                    break;
                }
                case 1: {
                    message = ValidationException.getMandatoryException(this.getSource());
                    break;
                }
                case 5: {
                    message = ValidationException.getInvalidCodeSetExceptionMessage((SimpleType)this.getSource(), this._invalidCodeSetValue);
                }
            }
            if (message != null) {
                return message;
            }
        }
        return message;
    }

    public boolean isNeedingUserAcceptance() {
        if (this.getCondition() != null) {
            return this.getCondition().getMessage().isNeedingUserAcceptance();
        }
        if (this.getSource() != null && this.getSource().getStyle().isValidationErrorNeedingUserAcceptance()) {
            return true;
        }
        return this._needsUserAcceptance;
    }

    public boolean isMandatoryException() {
        return this._exceptionType == 1;
    }

    public boolean isCardinalityException() {
        return this._exceptionType == 2;
    }

    public boolean isMissingKeyException() {
        return this._exceptionType == 4;
    }

    public boolean isDuplicateKeyException() {
        return this._exceptionType == 3;
    }

    public boolean isDuplicateIDException() {
        return this._exceptionType == 6;
    }

    public int getExceptionType() {
        return this._exceptionType;
    }

    public boolean isShowingDialog() {
        return this._showDialog;
    }

    public String getClassification() {
        if (this._classification == null) {
            String classification;
            this._classification = "error";
            if (this.getSource() != null && this.getSource().isSimple() && (classification = this.getSource().getStyle().getValidationErrorClassification()) != null) {
                this._classification = classification;
            }
        }
        return this._classification;
    }

    public void setClassification(String classification) {
        this._classification = classification;
    }

    public Exception getOccuredException() {
        return this._exception;
    }

    private static String getCardinalityExceptionMessage(ListType type) {
        String xuiMessage = type.getStyle().getValidationErrorMessage();
        String maxOccurs = String.valueOf(type.getMaxOccurs());
        String minOccurs = String.valueOf(type.getMinOccurs());
        if (type.getMaxOccurs() == -1) {
            maxOccurs = "*";
        }
        String label = type.getStyle().getLabelText();
        if (type.isList()) {
            label = type.getStyle().getCaptionTitleLabel();
        }
        String[] vars = new String[]{label, maxOccurs, minOccurs};
        xuiMessage = xuiMessage == null ? GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_cardinality_violation", "The list (%1) may not have more than %2 items or less than %3 items.", vars) : NLS.replaceVariables(xuiMessage, vars);
        return xuiMessage;
    }

    private static String getInvalidCodeSetExceptionMessage(SimpleType type, String invalidValue) {
        String codeSet = type.getStyle().getCodeSetName();
        return GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_invalid_code", "The value (%1 - %2) is not a valid code for codeSet: %3.", new String[]{type.getValue(), invalidValue, codeSet});
    }

    private static String getDuplicateKeyMessage(SimpleType type, String invalidValue) {
        return GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_duplicate_key", "Duplicate key. The key (%1) is already used", new String[]{invalidValue});
    }

    private static String getMissingKeyMessage(SimpleType type, String invalidValue) {
        return GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_missing_key", "Missing key. The key (%1) doesn't exist in reference list and was removed", new String[]{invalidValue});
    }

    private static String getDuplicateIDMessage(SimpleType type, String invalidValue) {
        return GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_duplicate_id", "Duplicate id. The id (%1) is already used", new String[]{invalidValue});
    }

    public static String getMandatoryException(Type type) {
        String[] params = new String[]{type.getStyle().getLabelText()};
        if (params[0].length() > 0) {
            ListType parList = type.getParentList();
            Type parType = type.getParent();
            StringBuilder msgText = new StringBuilder();
            if (parList != null && parList.getStyle().hasCaption() || parType != null && parType.getStyle().hasCaption()) {
                if (parList != null) {
                    Type listEntry = type.getParent(parList.getEditingType().getName());
                    String captLabel = parList.getStyle().getCaptionTitleLabel();
                    if (captLabel == null) {
                        captLabel = "";
                    }
                    msgText.append(captLabel);
                    if (type.getVarName() != null) {
                        msgText.append(" ");
                        msgText.append(type.getVarName());
                        msgText.append(" ");
                    } else {
                        msgText.append("[");
                        msgText.append(parList.getList().indexOf(listEntry) + 1);
                        msgText.append("]");
                    }
                    msgText.append(" > ");
                    msgText.append(type.getStyle().getLabelText());
                    params = new String[]{msgText.toString()};
                } else {
                    String captLabel = parType.getStyle().getCaptionTitleLabel();
                    if (captLabel != null) {
                        msgText.append(captLabel);
                        msgText.append(" > ");
                        msgText.append(params[0]);
                        params[0] = msgText.toString();
                    }
                }
            }
        }
        return GUIComponentNLS.getInstance().getNLSText(type.getDOM(), "message_mandatory_field", "The Field %1 is mandatory.", params);
    }

    public Type getSource() {
        return this._source;
    }
}

