/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.SerializationModifier;
import com.jaxfront.core.error.UserError;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.QName;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaType;
import com.jaxfront.core.schema.impl.SchemaNodeImpl;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.GlobalDefinition;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.core.xui.XUITypes;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
implements Type,
XUITypes,
Cloneable,
PropertyChangeListener,
Serializable,
DOMChangeListener,
QName {
    public static final String PI_TARGET_JAXFRONT_VAR = "jaxfront-var";
    public static final String MISSING_TYPES_CREATED = "missingTypesCreated";
    public static final String TAB_HOLDER = "tabHolder";
    public static final String PROPERTY_USER_CHANGED_SERIALIZE = "userChangedSerialize";
    protected short[] _id;
    private String _edTypeUUID;
    private boolean _isGlobalEdType;
    protected int _globalEdTypeRefCount;
    private String _name;
    private String _serName;
    private boolean _isDirtyXPath = true;
    protected Boolean _isAnonymous;
    private String _xpath;
    private String _pXpath;
    protected transient Document _DOM;
    private SchemaNode _schemaElement;
    private Type _parent;
    protected Type _choosen;
    protected XUIDefinition _uiDefinition;
    private transient Object _userObject;
    private Boolean _checkForEmptyContent;
    protected boolean _globalXUIDefinitionsChecked = false;
    protected boolean _derivedTypesResolved = false;
    protected List _derivedTypes;
    protected String[] _derivedTypeNames;
    protected boolean _serializable = true;
    private boolean _isIncluded;
    protected boolean _hasParentListBeenResolved;
    protected Hashtable _properties;
    protected transient ListType _parentList;
    public static final String FIELD_SLASH = "/";
    public static final String FIELD_LIST_IDENTIFIER = "[list]";
    public static final String FIELD_LIST_OPEN_BRACKET = "[";
    public static final String FIELD_LIST_CLOSE_BRACKET = "]";
    public static final String FIELD_ADD = "@";
    private boolean _isChoice = false;
    protected boolean _isReleased = false;
    protected boolean _isAttribute = false;
    protected short _typeClassification = 0;
    private boolean _userInstanciated = false;
    protected Type _template;
    private boolean _recursionBuilt;
    protected boolean _noneChoosen = false;
    public static final char[] indentChars = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' '};
    public boolean _needXUIMaintain = false;
    private boolean _renderable = true;
    protected boolean _hasChanged;
    protected long _changedTS;
    protected byte _isSerCache = (byte)-1;
    protected byte _isMandCache = (byte)-1;
    protected byte _isDerivedCache = (byte)-1;
    private byte hasEmptyContent = (byte)-1;
    protected String _varName;
    private String[] _processingInstructions;
    private HashMap<String, String> _uiState;
    private boolean _isKeyContext = false;
    private XUIDefinition _usedGlobalXUI;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractType() {
    }

    public AbstractType(SchemaNode schemaElement) {
        this._schemaElement = schemaElement;
        if (this._schemaElement != null) {
            this.setIsChoice(this._schemaElement.getSchemaType().isChoice());
        }
    }

    @Override
    public void bind(Document DOM, Element instanceElement) {
        boolean bindOnylAvailable = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isBindingOnlyAvailable();
        if (this.getDOM().isXUIDOMInstance()) {
            bindOnylAvailable = false;
        }
        this.bind(DOM, instanceElement, bindOnylAvailable);
    }

    @Override
    public void bind(Element instanceElement) {
        this.bind(null, instanceElement);
    }

    @Override
    public void bind(Document DOM, Element instanceElement, boolean bindOnlyAvailable) {
        Attr attribute;
        if (DOM != null) {
            this.setDOM(DOM);
        }
        if (!this.isList() && instanceElement != null && (attribute = instanceElement.getAttributeNodeNS("jaxfront", "included")) != null) {
            instanceElement.removeAttributeNS("jaxfront", "included");
            this.markAsIncluded();
        }
        this._processingInstructions = null;
        this._uiState = null;
        if (!this.isAttribute() && instanceElement != null) {
            this.bindProcessingInstructions(instanceElement);
        }
    }

    private void bindProcessingInstructions(Element instanceElement) {
        List<ProcessingInstruction> found = DOMHelper.searchPrevProcessingInstructions(instanceElement, null);
        if (found != null && found.size() > 0) {
            this._processingInstructions = new String[found.size() * 2];
            int pos = 0;
            int jaxfrontPos = -1;
            for (int i = found.size(); i > 0; --i) {
                ProcessingInstruction pi = found.get(i - 1);
                if (pos > 0) {
                    ++pos;
                }
                if (!"jaxfront".equalsIgnoreCase(pi.getTarget())) {
                    this._processingInstructions[pos] = pi.getTarget();
                    this._processingInstructions[++pos] = pi.getData();
                    if (!"jax-ui-state".equals(pi.getTarget())) continue;
                    String id = DOMHelper.getProcessingInstructionValue(pi, "id");
                    String param = DOMHelper.getProcessingInstructionValue(pi, "param");
                    this.putUIState(id, param);
                    instanceElement.getParentNode().removeChild(pi);
                    continue;
                }
                jaxfrontPos = pos++;
            }
            if (jaxfrontPos != -1 && this._processingInstructions.length > 0) {
                this._processingInstructions = (String[])ArrayUtil.removeNullFromArray(class$java$lang$String == null ? (class$java$lang$String = AbstractType.class$("java.lang.String")) : class$java$lang$String, this._processingInstructions);
                if (this._processingInstructions.length == 0) {
                    this._processingInstructions = null;
                }
            }
        }
    }

    @Override
    public abstract void bind(Object var1, Type var2);

    @Override
    public void bind(Type type) {
        this.bind(null, type);
    }

    public void markAsIncluded() {
        this._isIncluded = true;
    }

    public void unmarkAsIncluded() {
        this._isIncluded = false;
    }

    public void removeAllKeyReferences() throws ListModificationException {
    }

    public boolean isKeyRemovable() throws KeyRefException {
        this.checkKeysForDeletion(this);
        return true;
    }

    public void checkKeysForDeletion(Type childToDelete) throws KeyRefException {
        Vector<Type> childsToProcess = new Vector<Type>();
        childsToProcess.add(childToDelete);
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type achild = (Type)childsToProcess.get(c);
            if (achild.isSimple()) {
                if (!achild.getSchemaElement().hasSchemaKeys()) continue;
                achild.getDOM().getKeyKeyRefManager().canDeRegisterKey(this, (SimpleType)achild, achild.getSchemaElement().getSchemaKeys(), true);
                continue;
            }
            List directChilds = achild.getDirectChildren();
            if (directChilds == null) continue;
            childsToProcess.addAll(directChilds);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractType clone = (AbstractType)super.clone();
        clone._id = null;
        clone._template = this._template;
        clone.setDirtyXPath(true);
        clone._hasParentListBeenResolved = false;
        clone._globalXUIDefinitionsChecked = false;
        clone._parentList = null;
        clone.setParent(this._parent);
        clone._choosen = null;
        clone._isGlobalEdType = false;
        clone._schemaElement = this._schemaElement;
        clone.setDOM(this._DOM);
        clone._uiDefinition = null;
        clone._serializable = this._serializable;
        clone._isAttribute = this._isAttribute;
        clone._isChoice = this._isChoice;
        clone._userInstanciated = this._userInstanciated;
        clone._properties = null;
        clone._edTypeUUID = null;
        clone._varName = null;
        return clone;
    }

    private List createFullNameSet(SchemaNode schemaElement, List names) {
        Vector<String> innerNames = new Vector<String>();
        Vector<SchemaNode> children = new Vector<SchemaNode>();
        if (!schemaElement.getSchemaType().isSimple()) {
            SchemaNode[] subSet = ((SchemaComplexType)schemaElement.getSchemaType()).getElementSet();
            for (int i = 0; i < subSet.length; ++i) {
                children.add(subSet[i]);
            }
        }
        for (int i = 0; i < children.size(); ++i) {
            SchemaNode subElement = (SchemaNode)children.get(i);
            if (subElement.isAnonymous()) {
                names.add(this.createFullNameSet(subElement, names));
                continue;
            }
            innerNames.add(subElement.getQName());
        }
        return innerNames;
    }

    public Type deepClone(Document dom) throws CloneNotSupportedException {
        return this.deepClone(dom, true, false);
    }

    @Override
    public abstract Type deepClone(Document var1, boolean var2, boolean var3) throws CloneNotSupportedException;

    @Override
    public abstract Type deepClone(Document var1, boolean var2, boolean var3, boolean var4, SchemaNode var5, Element var6) throws CloneNotSupportedException;

    @Override
    public abstract Type getDirectChild(String var1);

    @Override
    public abstract Type getDirectChild(String var1, String var2);

    protected List getChildNames(Type composite) {
        Vector names = new Vector();
        Vector nameVector = this.createFullNameSet(composite.getSchemaElement(), names);
        if (nameVector.isEmpty()) {
            nameVector = names;
        } else {
            int size = nameVector.size();
            for (int i = 0; i < size; ++i) {
                Vector tempVector = new Vector(size);
                tempVector.add(nameVector.get(i));
                names.add(tempVector);
            }
        }
        return names;
    }

    @Override
    public abstract List getDirectChildren();

    @Override
    public abstract List getDirectChildren(String var1);

    @Override
    public String getDirectChildValue(String name) {
        String value;
        Type child = this.getDirectChild(name);
        if (child != null && child.isSimple() && (value = ((SimpleType)child).getValue()) != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        if (this.isChoice() && this._hasChanged) {
            return true;
        }
        if (this.getDirectChildrenSize() > 0) {
            List childs = this.getDirectChildren();
            for (int i = 0; i < childs.size(); ++i) {
                Type child = (Type)childs.get(i);
                if (!child.hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Type getChoosenType() {
        return this._choosen;
    }

    private Hashtable getClientProperties() {
        if (this._properties == null) {
            this._properties = new Hashtable();
        }
        return this._properties;
    }

    @Override
    public Object getClientProperty(String key) {
        if (this._properties != null) {
            return this.getClientProperties().get(key);
        }
        return null;
    }

    @Override
    public List getDerivedTypes() {
        if (!this._derivedTypesResolved) {
            this._derivedTypes = this.initializeDerivedTypes();
        }
        return this._derivedTypes;
    }

    protected String[] getDerivedTypeNames() {
        if (this.isAbstract()) {
            if (this._derivedTypeNames == null) {
                this._derivedTypeNames = this.initializeDerivedTypeNames();
            }
            return this._derivedTypeNames;
        }
        return null;
    }

    @Override
    public Document getDOM() {
        return this._DOM;
    }

    @Override
    public short[] getId() {
        if (this._id == null) {
            this._id = this.generateId();
        }
        return this._id;
    }

    public String getAbsoluteXPathLocation() {
        if (this._edTypeUUID == null) {
            this._edTypeUUID = StringUtil.removeAllBetween(this.getXPathLocation(), FIELD_LIST_OPEN_BRACKET, FIELD_LIST_CLOSE_BRACKET);
        }
        return this._edTypeUUID;
    }

    public String getEdTypeUUID() {
        return this._edTypeUUID;
    }

    @Override
    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        this._name = this.getSchemaElement().getName();
        return this._name;
    }

    @Override
    public String getQName() {
        return this.getSchemaElement().getQName();
    }

    @Override
    public String getSerializationName() {
        String sName = null;
        if (this.getDOM() != null && this.getDOM().getXMLNamespaceMappings() != null) {
            String nsPrefix;
            String targetNS = null;
            if (this.isSimple() && ((SimpleType)this).isSimpleContent()) {
                targetNS = "";
            } else if (this.isEmpty()) {
                targetNS = null;
            } else if (this.getSchemaElement() != null) {
                targetNS = this.getSchemaElement().getTargetNS();
            }
            String string = nsPrefix = targetNS != null ? (String)this.getDOM().getXMLNamespaceMappings().get(targetNS) : null;
            sName = nsPrefix != null && nsPrefix.length() > 0 ? new StringBuffer().append(nsPrefix).append(":").append(this.getName()).toString() : this.getName();
        } else {
            sName = this.getName();
        }
        return sName;
    }

    public String getSerializationName2() {
        if (this._serName == null) {
            String sName = null;
            if (this.getDOM() != null && this.getDOM().getXMLNamespaceMappings() != null) {
                String nsPrefix;
                String targetNS = null;
                if (!this.isAnonymous() && (targetNS = DOMHelper.evalNamespace(this)) == null) {
                    targetNS = this.getDOM().getDefaultNamespace();
                }
                String string = nsPrefix = targetNS != null ? (String)this.getDOM().getXMLNamespaceMappings().get(targetNS) : null;
                sName = nsPrefix != null && nsPrefix.length() > 0 ? new StringBuffer().append(nsPrefix).append(":").append(this.getName()).toString() : this.getName();
            } else {
                sName = this.getName();
            }
            this._serName = sName;
        }
        return this._serName;
    }

    @Override
    public String getNamespace() {
        String tns = this.getSchemaElement().getTargetNS();
        return tns;
    }

    @Override
    public Type getParent() {
        return this._parent;
    }

    @Override
    public boolean hasChoosenType() {
        return false;
    }

    private Type getParent(Type parent, String parentName) {
        if (parent.getName().equals(parentName)) {
            return parent;
        }
        if (parent.getParent() != null) {
            return this.getParent(parent.getParent(), parentName);
        }
        return null;
    }

    @Override
    public Type getParent(String parentName) {
        return this.getParent(this, parentName);
    }

    @Override
    public ListType getParentList() {
        if (!this._hasParentListBeenResolved) {
            if (this.isList()) {
                this._parentList = (ListType)((Object)this);
            } else if (this.getParent() != null) {
                this._parentList = this.getParent().getParentList();
            }
            this._hasParentListBeenResolved = true;
        }
        return this._parentList;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.getDOM() != null) {
            return this.getDOM().getPropertyChangeSupport();
        }
        return null;
    }

    @Override
    public Type getRepresentedTabParent(boolean checkCurrentType) {
        if (checkCurrentType && this.isRepresentedAsTab()) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getRepresentedTabParent(true);
        }
        return null;
    }

    public void jumpTo() {
        Visualizer aVisualizer = TypeVisualizerFactory.getInstance().getVisualizer((Type)this, true);
        aVisualizer.jumpTo();
    }

    @Override
    public Type getRepresentedTreeNodeParent() {
        if (this.isRepresentedAsTreeNode()) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getRepresentedTreeNodeParent();
        }
        return null;
    }

    @Override
    public GlobalDefinition getGlobalDefinition() {
        return this.getDOM().getGlobalDefinition();
    }

    @Override
    public Type getRepresentedTreeNodeHolder() {
        if (!this.getGlobalDefinition().isShowingTree()) {
            return (Type)this.getGlobalDefinition().getTreeRoot().get(0);
        }
        if (this.isRepresentedAsTreeNode() && this.getStyle().isSelfViewHolder()) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getRepresentedTreeNodeParent();
        }
        return null;
    }

    @Override
    public String getRepresentedTreeNodeParentIconName() {
        Type treeNodeParent = this.getRepresentedTreeNodeParent();
        while (treeNodeParent != null) {
            String treeIconName = treeNodeParent.getStyle().getTreeIcon();
            if (treeIconName == null) {
                if ((treeNodeParent = treeNodeParent.getParent()) == null) continue;
                treeNodeParent = treeNodeParent.getRepresentedTreeNodeParent();
                continue;
            }
            return treeIconName;
        }
        return null;
    }

    @Override
    public ImageIcon getRepresentedTreeNodeParentIcon() {
        String iconName = this.getRepresentedTreeNodeParentIconName();
        if (iconName != null) {
            return JAXFrontProperties.getImageIcon(this.getDOM().getFingerPrint().getXUIURL(), iconName);
        }
        return null;
    }

    @Override
    public SchemaNode getSchemaElement() {
        return this._schemaElement;
    }

    @Override
    public XUIDefinition getXUIDefinition() {
        XUIDefinition def = this.getXUIDefinition(true);
        return def;
    }

    @Override
    public Object getUserObject() {
        return this._userObject;
    }

    @Override
    public String getShortCaption() {
        String shortCaption = "";
        String separatorCharacter = " - ";
        String currentTypeDescription = null;
        Type representedTreeNodeParent = null;
        if (this.isRepresentedAsTreeNode()) {
            if (this.getParent() != null) {
                representedTreeNodeParent = this.getParent().getRepresentedTreeNodeParent();
            }
        } else {
            representedTreeNodeParent = this.getRepresentedTreeNodeParent();
        }
        while (representedTreeNodeParent != null) {
            Type treeNodeParent;
            String treeLabel = representedTreeNodeParent.getStyle().getTreeLabelText();
            if (treeLabel != null) {
                shortCaption = new StringBuffer().append(treeLabel).append(separatorCharacter).append(shortCaption).toString();
            }
            if ((treeNodeParent = representedTreeNodeParent.getRepresentedTreeNodeParent()) != representedTreeNodeParent) {
                representedTreeNodeParent = treeNodeParent;
                continue;
            }
            if (representedTreeNodeParent.getParent() == null) break;
            representedTreeNodeParent = representedTreeNodeParent.getParent().getRepresentedTreeNodeParent();
        }
        currentTypeDescription = this.getVisualName();
        shortCaption = shortCaption != null && shortCaption.length() > 0 ? new StringBuffer().append(shortCaption).append(currentTypeDescription).toString() : currentTypeDescription;
        return shortCaption;
    }

    @Override
    public String getXPathLocation() {
        if (this._isDirtyXPath) {
            this.initializeXPathLocation();
        }
        return this._xpath;
    }

    @Override
    public String getPrefixedXPathLocation() {
        if (this._pXpath == null) {
            StringBuffer xpath = new StringBuffer();
            this.getXPathLocation(xpath, 0, true, true);
            this._pXpath = xpath.toString();
        }
        return this._pXpath;
    }

    private void initializeXPathLocation() {
        StringBuffer xpath = new StringBuffer();
        this.getXPathLocation(xpath, 0, false, true);
        this._xpath = xpath.toString();
        this.setDirtyXPath(false);
    }

    @Override
    public String getW3CXPathLocation(boolean prefixed) {
        StringBuffer xpath = new StringBuffer();
        this.getXPathLocation(xpath, 0, prefixed, false);
        return xpath.toString();
    }

    private int getXPathLocation(StringBuffer xpath, int level, boolean prefixed, boolean uNameIncluded) {
        Type parent = this.getParent();
        String name = null;
        name = prefixed ? this.getSerializationName() : this.getName();
        if (!uNameIncluded && this.isAnonymous()) {
            name = null;
        }
        if (parent != null) {
            ++level;
            level = ((AbstractType)parent).getXPathLocation(xpath, level, prefixed, uNameIncluded);
            String parentName = null;
            parentName = prefixed ? ((AbstractType)parent).getSerializationName() : ((AbstractType)parent).getName();
            if (!uNameIncluded && parent.isAnonymous()) {
                parentName = null;
            }
            if (parent.isAbstract()) {
                name = parent.getName();
            }
            if (name != null) {
                if (this.isAttribute()) {
                    xpath.append(FIELD_SLASH);
                    xpath.append(FIELD_ADD);
                    xpath.append(name);
                } else if (!this.isList()) {
                    xpath.append(FIELD_SLASH);
                    xpath.append(name);
                } else if (this.isList() && level == 0) {
                    xpath.append(FIELD_SLASH);
                    xpath.append(name);
                    xpath.append(FIELD_LIST_IDENTIFIER);
                }
            }
            if (parent.isList()) {
                boolean found = false;
                ListType parentList = this.getParentList();
                if (parentList != null) {
                    int plSize = parentList.size();
                    for (int counter = 0; counter < plSize; ++counter) {
                        if (this != parentList.get(counter)) continue;
                        found = true;
                        xpath.append(FIELD_LIST_OPEN_BRACKET);
                        xpath.append(counter + 1);
                        xpath.append(FIELD_LIST_CLOSE_BRACKET);
                        break;
                    }
                }
                if (parentName != null && this.isAttribute() && !found && !this.isEditingType()) {
                    xpath.append(FIELD_ADD);
                    xpath.append(parentName);
                }
            }
        } else if (name != null) {
            xpath.append(FIELD_SLASH);
            xpath.append(name);
        }
        return --level;
    }

    public boolean hasEmptyContentParent(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        if (this.getParent() != null) {
            return this.hasEmptyContentParent(this.getParent(), checkSerializeDefaults, checkDefaultValue);
        }
        return false;
    }

    private boolean hasEmptyContentParent(Type type, boolean checkSerializeDefaults, boolean checkDefaultValue) {
        if (type.isComposite() && !type.isRequired() && ((CompositeType)type).hasEmptyContent(checkSerializeDefaults, checkDefaultValue)) {
            return true;
        }
        return type.getParent() != null && this.hasEmptyContentParent(type.getParent(), checkSerializeDefaults, checkDefaultValue);
    }

    public abstract boolean hasEmptyContent(boolean var1, boolean var2);

    @Override
    public Type getRepresentedTableLayoutParent() {
        return this.getRepresentedTableLayoutParent(this);
    }

    private Type getRepresentedTableLayoutParent(Type baseType) {
        Type parent = this.getParent();
        Type tableViewType = baseType.getViewContextType();
        if (parent != null && tableViewType == null) {
            if (parent.getStyle().isTableLayout()) {
                FormLayoutInfo tablelayout = (FormLayoutInfo)parent.getStyle().getLayoutManager();
                if (tablelayout.holds(baseType)) {
                    tableViewType = parent;
                }
            } else if (parent.getStyle().isPagingLayout()) {
                Vector layoutInfos = parent.getStyle().getLayoutInfos();
                for (FormLayoutInfo tablelayout : layoutInfos) {
                    if (!tablelayout.contains(baseType)) continue;
                    tableViewType = parent;
                    break;
                }
            } else if (parent.getViewContextType() != null) {
                tableViewType = parent.getViewContextType();
            } else if (parent.getParent() != null) {
                tableViewType = ((AbstractType)parent).getRepresentedTableLayoutParent(baseType);
            }
        }
        return tableViewType;
    }

    @Override
    public boolean hasRepresentableTreeChildren() {
        return this.hasRepresentableTreeChildren(this);
    }

    private boolean hasRepresentableTreeChildren(Type type) {
        List childsList = null;
        if (type.isComposite()) {
            childsList = ((CompositeType)type).getComposites();
        }
        if (this.isList()) {
            childsList = ((ListType)type).getList();
        }
        if (childsList != null) {
            Object[] childs = childsList.toArray();
            for (int i = 0; i < childs.length; ++i) {
                Type child = (Type)childs[i];
                if (!child.isRepresentedAsTreeNode()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public short getTypeClassification() {
        return this._typeClassification;
    }

    @Override
    public boolean unChoosenBranch() {
        if (this.getParent() != null) {
            return this.unChoosenBranch(this.getParent());
        }
        return false;
    }

    private boolean unChoosenBranch(Type type) {
        if (type.isComposite()) {
            CompositeType composite = (CompositeType)type;
            Type chooseType = null;
            if (composite.isChoice() && this != (chooseType = composite.getChoosenType()) && !this.isDerivedFrom(chooseType)) {
                return true;
            }
        }
        return type.getParent() != null && this.unChoosenBranch(type.getParent());
    }

    @Override
    public boolean hasUnChoosenChoiceParent() {
        if (this.getParent() != null) {
            return this.hasUnChoosenChoiceParent(this.getParent());
        }
        return false;
    }

    private boolean hasUnChoosenChoiceParent(Type type) {
        if (type.isComposite()) {
            CompositeType composite = (CompositeType)type;
            Type chooseType = null;
            if (composite.isChoice() && this != (chooseType = composite.getChoosenType()) && !this.isDerivedFrom(chooseType)) {
                return !this.isAttribute();
            }
        }
        return type.getParent() != null && this.hasUnChoosenChoiceParent(type.getParent());
    }

    public boolean isInRepresentationTree(Type type) {
        Type parent = type.getParent();
        if (parent == null && type.getDOM().getRootType() == type) {
            return true;
        }
        if (parent.isComposite()) {
            if (((CompositeType)parent).isChoice() && ((CompositeType)parent).getChoosenType() != type) {
                return false;
            }
            return this.isInRepresentationTree(parent);
        }
        return this.isInRepresentationTree(parent);
    }

    @Override
    public boolean hasUndefinedChildren() {
        List childs = this.getDirectChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            if (!child.isSimple() || ((SimpleType)child).isRequired()) continue;
            return true;
        }
        return false;
    }

    protected void informPlugin(Type type) {
        Vector allVis = TypeVisualizerFactory.getInstance().getAllVisualizers(type);
        for (int i = 0; i < allVis.size(); ++i) {
            ((Visualizer)allVis.get(i)).setModel(type);
        }
    }

    protected List initializeDerivedTypes() {
        String name = this.getSchemaElement().getRefName();
        if (name == null || this.getSchemaElement().isGlobal() || this.getSchemaElement().isReferenceWithNoExtension()) {
            name = this.getSchemaType().getQName();
        }
        return this.initializeDerivedTypes(name);
    }

    protected String[] initializeDerivedTypeNames() {
        String name = this.getSchemaElement().getRefName();
        if (name == null || this.getSchemaElement().isGlobal() || this.getSchemaElement().isReferenceWithNoExtension()) {
            name = this.getSchemaType().getQName();
        }
        return this.initializeDerivedTypeNames(name);
    }

    protected List initializeDerivedTypes(String abstractName) {
        Vector<Type> derrivedTypes = new Vector<Type>();
        if (this.getDOM() != null) {
            Set baseTypes = this.getSchemaElement().getSchema().getDerivedTypes(abstractName, null);
            for (Type originalType : baseTypes) {
                if (originalType == null) continue;
                try {
                    Type newType = originalType.deepClone(null, false, false);
                    newType.setParent(this);
                    if (newType.getSchemaElement() instanceof SchemaNodeImpl) {
                        ((SchemaNodeImpl)newType.getSchemaElement()).setName(newType.getName());
                    }
                    derrivedTypes.add(newType);
                }
                catch (CloneNotSupportedException ex) {
                    if (!LogRegistry.getInstance().logWarnings()) continue;
                    LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("unable to create clone for ").append(originalType.getXPathLocation()).toString());
                }
            }
            this._derivedTypesResolved = true;
        }
        return derrivedTypes;
    }

    protected String[] initializeDerivedTypeNames(String abstractName) {
        String[] names = null;
        if (this.getDOM() != null) {
            names = this.getSchemaElement().getSchema().getDerivedTypeNames(abstractName);
        }
        return names;
    }

    @Override
    public boolean isAbstract() {
        if (this.getSchemaElement() != null) {
            return this.getSchemaType().isAbstract();
        }
        return false;
    }

    @Override
    public boolean isAnonymous() {
        if (this._isAnonymous == null) {
            return this.getSchemaElement().isAnonymous();
        }
        return this._isAnonymous;
    }

    @Override
    public boolean isAttribute() {
        return this._isAttribute;
    }

    @Override
    public boolean isChoice() {
        return this._isChoice;
    }

    public void setIsChoice(boolean isChoice) {
        this._isChoice = isChoice;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public boolean isSerializable() {
        this.checkCache();
        if (this._isSerCache == -1) {
            this._isSerCache = this.isSerializable(true) ? (byte)1 : 0;
        }
        return this._isSerCache == 1;
    }

    @Override
    public boolean isSerializable(boolean checkValue) {
        return this.isSerializable(checkValue, this.getDOM().isSerializingDefaults());
    }

    @Override
    public boolean isSerializable(boolean checkValue, boolean serDefaults) {
        SerializationModifier serModifier = this.getDOM().getSerializationModifier();
        if (serModifier != null && !serModifier.serialize(this)) {
            return false;
        }
        if (this.isIncluded()) {
            return false;
        }
        boolean serializable = this._serializable;
        if (serializable) {
            if (this.isSimple()) {
                Boolean serializableDefault;
                SimpleType simpleType = (SimpleType)this;
                Boolean globalSerializeAttributes = null;
                if (simpleType.isAttribute()) {
                    globalSerializeAttributes = this.getGlobalDefinition().isSerializingAttributes();
                }
                serializable = globalSerializeAttributes == null || globalSerializeAttributes.booleanValue() ? (serDefaults ? true : (checkValue && simpleType.getValue() != null && !simpleType.isUsingDefaultValue() ? true : simpleType.getParent() != null && simpleType.getParent().isChoice() && simpleType.getParent().getChoosenType() == simpleType)) : ((serializableDefault = this.getStyle().getSerializableDefault()) != null ? serializableDefault.booleanValue() : globalSerializeAttributes.booleanValue());
                if (this.isKey() || this.isKeyRef()) {
                    return !this.isSimple() || ((SimpleType)this).getPlainValue() != null && ((SimpleType)this).getPlainValue().length() != 0 || this.isMandatoryAxis();
                }
            }
            if (serializable) {
                if (checkValue && this.isSimple() && (((SimpleType)this).getValue() == null || ((SimpleType)this).getValue().length() == 0)) {
                    serializable = false;
                    if (!serializable && this.getParent() != null && this.getParent().isChoice() && this.getParent().getChoosenType() == this) {
                        serializable = true;
                    }
                    if (this.hasUIDefinition() && this.getStyle().isApplicationRequired()) {
                        serializable = true;
                    }
                    if (this.getGlobalDefinition().isSerializingEmptyContent() && this.isMandatoryAxis()) {
                        serializable = true;
                    }
                }
                if (this.getParent() != null && !this.getParent().isSerializable()) {
                    serializable = false;
                }
                if (this.hasUnChoosenChoiceParent()) {
                    serializable = false;
                }
            }
        }
        return serializable;
    }

    protected void checkCache() {
        if (this._DOM != null && this._changedTS != this._DOM.getLastDomUpdateTimeStamp()) {
            this._changedTS = this._DOM.getLastDomUpdateTimeStamp();
            this._isSerCache = (byte)-1;
            this._isMandCache = (byte)-1;
            this._isDerivedCache = (byte)-1;
        }
    }

    @Override
    public boolean isDerived() {
        if (this.getParent() != null) {
            SimpleType simpleType;
            if (this.getParent().isAbstract()) {
                return true;
            }
            if (this.getParent().isSimple() && (simpleType = (SimpleType)this.getParent()).isSimpleContent() && simpleType.isDerived()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDerivedFrom(Type type) {
        return this.isDerivedFrom(type, true);
    }

    @Override
    public boolean isDerivedFromEditingType() {
        return this.isDerivedFromEditingType(this, true);
    }

    public boolean isDerivedFrom(Type type, boolean firstIteration) {
        for (Type pT = this; pT != null; pT = pT.getParent()) {
            if (!firstIteration && pT == type) {
                return true;
            }
            firstIteration = false;
        }
        return false;
    }

    private boolean isDerivedFromEditingType(Type type, boolean firstIteration) {
        Type pt = null;
        if (!firstIteration && this.isEditingType()) {
            return true;
        }
        pt = this.getParent();
        if (pt != null) {
            return ((AbstractType)pt).isDerivedFromEditingType(type, false);
        }
        return false;
    }

    @Override
    public boolean isEditingType() {
        Type pt = this.getParent();
        return pt != null && pt.isList() && ((ListType)pt).getEditingType() == this;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.getClientProperty("locked&notEditable") != null;
    }

    @Override
    public boolean isRecursive() {
        return this.getSchemaType().isRecursive();
    }

    @Override
    public boolean isRepresentedAsHeader() {
        return this.getStyle().isRepresentedAsHeader();
    }

    @Override
    public boolean isRepresentedAsTab() {
        return this.getStyle().isRepresentedAsTab() && !this.isSimple();
    }

    @Override
    public boolean isRepresentedAsTreeNode() {
        return this.getStyle().isRepresentedAsTreeNode();
    }

    @Override
    public boolean isRequired() {
        boolean isRequired = false;
        if (this.getParent() != null && this.getSchemaType().isMixedContent()) {
            isRequired = false;
        } else if (this.getSchemaElement().isRequired()) {
            if (!this.isSimple() && this.isChoice()) {
                if (this.getSchemaType().getChoiceMinOccurs() > 0) {
                    isRequired = true;
                }
            } else {
                isRequired = true;
            }
        }
        if (!isRequired && this._uiDefinition != null) {
            isRequired = this.getStyle().isApplicationRequired();
        }
        return isRequired;
    }

    @Override
    public boolean isRoot() {
        return !this.isEmpty() && this == this.getDOM().getRootType();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void putClientProperty(String key, Object object) {
        if (key != null && object != null) {
            this.getClientProperties().put(key, object);
        }
    }

    @Override
    public void release() {
        if (!this._isReleased) {
            if (this._DOM != null && this._DOM.hasController()) {
                this._DOM.getController().getErrorController().removeError(this);
                if (this._varName != null) {
                    this._DOM.removeVarToTypeMapping(this._varName);
                }
            }
            this._isReleased = true;
            this._schemaElement = null;
            this._parent = null;
            this._choosen = null;
            this._userObject = null;
            this._template = null;
            this._derivedTypes = null;
            this._template = null;
            if (this._properties != null) {
                this._properties.clear();
                this._properties = null;
            }
            this._parentList = null;
            this._globalXUIDefinitionsChecked = false;
            if (this._uiDefinition != null) {
                this._uiDefinition.release();
                this._uiDefinition = null;
            }
            if (this._DOM != null) {
                this._DOM = null;
            }
        }
    }

    @Override
    public boolean remove() throws ListModificationException {
        block3: {
            try {
                if (this.getParent() != null) {
                    boolean removed = this.getParent().removeChild(this);
                    this.release();
                    return removed;
                }
            }
            catch (DOMException ex) {
                if (!LogRegistry.getInstance().logWarnings()) break block3;
                LogRegistry.getInstance().warn(this.getClass(), new StringBuffer().append("tried to remove: ").append(this.getName()).append(" from: ").append(this.getParent().getName()).toString());
            }
        }
        return false;
    }

    @Override
    public abstract void removeAll() throws ListModificationException;

    @Override
    public abstract boolean removeChild(Type var1) throws ListModificationException;

    @Override
    public StringBuffer serialize() {
        return this.serialize(false);
    }

    @Override
    public StringBuffer serialize(boolean serializeEmptyContent) {
        StringBuffer io = new StringBuffer();
        this.serialize(io, 0, true, true, serializeEmptyContent);
        return io;
    }

    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive) {
        this.serialize(sb, indent, writeName, recursive, false);
    }

    @Override
    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive, boolean serializeEmptyContent) {
        if (this._processingInstructions != null && this._processingInstructions.length > 0) {
            int counter = 0;
            for (int i = 0; i < this._processingInstructions.length / 2; ++i) {
                if (counter > 0) {
                    ++counter;
                }
                String target = this._processingInstructions[counter];
                String data = this._processingInstructions[++counter];
                if (this._varName != null && PI_TARGET_JAXFRONT_VAR.equalsIgnoreCase(target) && data.indexOf(this._varName) != -1) continue;
                sb.append("\n");
                if (indent > 0) {
                    this.makeIndent(sb, indent);
                }
                sb.append(new StringBuffer().append("<?").append(target).append(" ").append(data).append("?>").toString());
            }
        }
    }

    @Override
    public void setApplicationRequired(boolean required) {
        if (!required) {
            this.getDOM().getController().getErrorController().removeMandatoryAndCardinalityValidationErrors(this);
        }
        this.getStyle().setApplicationRequired(required);
    }

    @Override
    public void setCodeSetValues(String url, String codeSetName, String[] values, String defaultSelection) {
        this.setCodeSetValues(url, codeSetName, values, defaultSelection, false, false);
    }

    public void setCodeSetValues(String url, String codeSetName, String[] values, String defaultSelection, boolean syncWithCodeEnum, boolean valueBasedSync) {
        this.getStyle().setCodeSetValuesFromFile(url, codeSetName, values, syncWithCodeEnum, valueBasedSync);
        if (this.isSimple() && ((SimpleType)this).getValue() == null) {
            ((SimpleType)this).setValue(defaultSelection);
        }
    }

    @Override
    public void setDirectChildValue(String childName, String value, boolean temporary) {
        Type child = this.getDirectChild(childName);
        if (child != null && child.isSimple()) {
            ((SimpleType)child).setValue(value, temporary);
        }
    }

    @Override
    public void setDirectChildValue(String childName, String value) {
        this.setDirectChildValue(childName, value, false);
    }

    @Override
    public void setChoosenType(Type type) {
        this.setChoosenType(type, false);
    }

    @Override
    public void setChoosenType(Type type, boolean isTemporary) {
        this.setChoosenType(type, isTemporary, true);
    }

    protected void setChoosenType(Type type, boolean isTemporary, boolean includingData) {
        this.setChoosenType(null, type, isTemporary, includingData);
    }

    public void setChoosenType(Object source, Type type, boolean isTemporary, boolean includingData) {
        this.setChoosenType(source, type, isTemporary, includingData, false);
    }

    public void setChoosenType(Object source, Type type, boolean isTemporary, boolean includingData, boolean isInitializing) {
        boolean hasChanged;
        Document dom = this.getDOM();
        boolean isBinding = dom.isBinding();
        boolean wasCompoundEditState = dom.getUndoManager().isInCompoundEditState();
        if (!wasCompoundEditState && !isBinding) {
            dom.getUndoManager().startCompoundEdit();
        }
        Type oldType = null;
        if (this._choosen != null) {
            oldType = this._choosen;
        }
        if (this._choosen == null && type != null) {
            hasChanged = true;
        } else {
            boolean bl = hasChanged = this._choosen != null && this._choosen != type;
        }
        if (type == null) {
            if (this._choosen != null) {
                try {
                    this.notifyKeyRefChildsForDeletion(this._choosen, true);
                }
                catch (KeyRefException e) {
                    // empty catch block
                }
            }
            this._choosen = null;
            if (this.isComposite() && ((CompositeType)((Object)this)).getEmptyType() != null && !isBinding && includingData && hasChanged) {
                ((CompositeType)((Object)this)).getEmptyType().setParent(this);
                dom.fireDOMChanged(DOMChangeEvent.DOM_REMOVE_NODE(oldType));
                dom.fireDOMChanged(DOMChangeEvent.DOM_ADD_NODE(((CompositeType)((Object)this)).getEmptyType()), isTemporary);
            }
        } else {
            this._choosen = type;
            if (hasChanged) {
                if (!(isTemporary || isBinding || this.getDOM().getController().isBlockDirtyChange())) {
                    this.setHasChanged(true);
                }
                if (type.isEmpty()) {
                    this._choosen = null;
                    if (this.isComposite()) {
                        try {
                            ((CompositeType)((Object)this)).removeChoices();
                        }
                        catch (ListModificationException e) {
                            // empty catch block
                        }
                    }
                }
                if (this._choosen != null && !isBinding && !isTemporary && this.isComposite()) {
                    this.getDOM().checkAutoCreateListItems(this._choosen);
                }
                if (oldType != null && includingData && !isBinding) {
                    dom.fireDOMChanged(DOMChangeEvent.DOM_REMOVE_NODE(oldType), isTemporary);
                }
                if (includingData && !isBinding) {
                    dom.fireDOMChanged(DOMChangeEvent.DOM_ADD_NODE(type), isTemporary);
                }
            }
        }
        if (!(isInitializing || isTemporary || this.getDOM().isBinding())) {
            this.getDOM().getUndoManager().addChoiceChangeUndoableEditEvent(null, this, type, oldType, isTemporary);
            try {
                if (oldType != null) {
                    this.notifyKeyRefChildsForDeletion(oldType, true);
                }
            }
            catch (KeyRefException e) {
                // empty catch block
            }
            if (type != null) {
                this.notifyKeyRefChildsForCreation(type);
            }
        }
        if (!wasCompoundEditState && !isBinding) {
            dom.getUndoManager().stopCompoundEdit();
        }
    }

    @Override
    public void setDOM(Document DOM) {
        this._DOM = DOM;
    }

    protected short[] generateId() {
        int dep = this.getDeepness(this, 0);
        if (this.isList()) {
            ++dep;
        }
        short[] id = new short[dep];
        return this.generateId(this, id, id.length - 1);
    }

    private short[] generateId(Type type, short[] id, int level) {
        Type pt = null;
        if (type != null && (pt = type.getParent()) != null) {
            if (pt.isList()) {
                this.generateId(pt, id, level);
            } else {
                List composites = ((CompositeType)pt).getComposites();
                id[level] = (short)composites.indexOf(type);
                this.generateId(pt, id, --level);
            }
        }
        return id;
    }

    private int getDeepness(Type type, int deepness) {
        if (type != null) {
            if (!type.isList()) {
                ++deepness;
            }
            return this.getDeepness(type.getParent(), deepness);
        }
        return deepness;
    }

    @Override
    public void setId(short[] id) {
        this._id = id;
    }

    @Override
    public void setSerializable(boolean isSerializable) {
        this.setSerializable(isSerializable, true);
    }

    @Override
    public void setSerializable(boolean isSerializable, boolean checkForEmptyContent) {
        this._checkForEmptyContent = new Boolean(checkForEmptyContent);
        boolean oldValue = this._serializable;
        this._serializable = isSerializable;
        this._isSerCache = (byte)-1;
        if (this.getDOM().isXUIInitialized()) {
            this.getDOM().getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent(this, "serializableChanged", new Boolean(oldValue), new Boolean(isSerializable)));
        }
    }

    public void forceSerialization(boolean force) {
        this._changedTS = this._DOM.getLastDomUpdateTimeStamp();
        this._isSerCache = force ? (byte)1 : 0;
    }

    public boolean checkForEmptyContent() {
        if (this._checkForEmptyContent == null) {
            this._checkForEmptyContent = Boolean.TRUE;
        }
        return this._checkForEmptyContent;
    }

    @Override
    public void showLabel(boolean visible) {
        this.getStyle().setLabelVisible(visible);
    }

    @Override
    public void setVisible(boolean visible) {
        this.getStyle().setVisibleAtRuntime(visible);
    }

    @Override
    public void setRenderable(boolean renderable) {
        this._renderable = renderable;
        this.getStyle().setVisible(renderable);
    }

    @Override
    public boolean isRenderable() {
        return this._renderable;
    }

    @Override
    public void setVisibleAndSerializable(boolean visible, boolean isSerializable) {
        this.setVisible(visible);
        this.setSerializable(isSerializable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getStyle().setEnabled(enabled);
        Vector possibleTargetVis = TypeVisualizerFactory.getInstance().getAllVisualizers(this);
        for (int pt = 0; pt < possibleTargetVis.size(); ++pt) {
            Visualizer view = (Visualizer)possibleTargetVis.get(pt);
            if (view == null) continue;
            view.setEnabled(enabled);
        }
    }

    void setName(String name) {
        this._name = name;
    }

    @Override
    public void setParent(Type parent) {
        this._parent = parent;
        this._hasParentListBeenResolved = false;
        this.setDirtyXPath(true);
    }

    @Override
    public void setSchemaElement(SchemaNode element) {
        this._schemaElement = element;
    }

    @Override
    public void setTreeIcon(String gifName) {
        this.getStyle().setTreeIcon(gifName);
    }

    @Override
    public void setUIDefinition(XUIDefinition uiDefinition) {
        this._uiDefinition = uiDefinition;
        this._globalXUIDefinitionsChecked = false;
        if (uiDefinition != null) {
            this.doAtTypeCreation();
        }
    }

    @Override
    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public String toString() {
        return this.getXPathLocation();
    }

    @Override
    public void showMessage(String message, String classification, boolean showDialog, boolean needsUserAcceptance) {
        Object identifier = this.getClientProperty("ACTION_IDENTIFIER");
        Type raiser = (Type)this.getClientProperty("ACTION_SOURCE");
        this.getClientProperties().remove("ACTION_SOURCE");
        this.getClientProperties().remove("ACTION_IDENTIFIER");
        UserError error = new UserError(this, identifier, message, needsUserAcceptance, showDialog, false, classification);
        error.setRaiser(raiser);
        this.getDOM().getController().getErrorController().addError(error);
    }

    public void showHint(String text, boolean isFormula, Color color, boolean isBold) {
        this.getStyle().setHint(text, isFormula, color, isBold);
    }

    public void removeHint() {
        this.getStyle().removeHint();
    }

    @Override
    public void removeMessage() {
        Object identifier = this.getClientProperty("ACTION_IDENTIFIER");
        Type raiser = (Type)this.getClientProperty("ACTION_SOURCE");
        this.removeClientProperty("ACTION_IDENTIFIER");
        this.removeClientProperty("ACTION_SOURCE");
        UserError error = new UserError(identifier, this);
        error.setRaiser(raiser);
        this.getDOM().getController().getErrorController().removeError(error);
    }

    @Override
    public void addTreeNode(boolean shouldBeSerialized) {
        this.setSerializable(shouldBeSerialized);
        Document dom = this.getDOM();
        if (dom.getEditor() != null) {
            dom.getEditor().getTreeModel().insertNode(this);
        } else {
            this.getStyle().setTreeEntry(true);
            dom.fireDOMChanged(DOMChangeEvent.DOM_TREE_CHANGED(this));
        }
    }

    @Override
    public void removeTreeNode(boolean shouldBeSerialized) {
        this.setSerializable(shouldBeSerialized);
        Document dom = this.getDOM();
        if (dom.getEditor() != null) {
            dom.getEditor().getTreeModel().removeNode(this);
        } else {
            this.getStyle().setTreeEntry(false);
            dom.fireDOMChanged(DOMChangeEvent.DOM_TREE_CHANGED(this));
        }
    }

    @Override
    public boolean hasValidationError() {
        if (this.getDOM() != null) {
            return this.getDOM().getController().getErrorController().getErrorsForType(this, 1).size() > 0;
        }
        return false;
    }

    @Override
    public boolean isKeyContext() {
        return this._isKeyContext;
    }

    @Override
    public void setIsKeyContext(boolean isContext) {
        this._isKeyContext = isContext;
    }

    @Override
    public boolean isKey() {
        return false;
    }

    @Override
    public boolean isKeyRef() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        Document dom = this.getDOM();
        if (dom != null && dom.getRootType() != null) {
            if (this.isRoot()) {
                return false;
            }
            return !this.isDerivedFrom(dom.getRootType());
        }
        return true;
    }

    public void checkGlobalUIDefinition() {
        if (this.getDOM() != null) {
            if (this.getDOM().getGlobalXUIDefinitions().size() > 0) {
                Vector globalTypes = new Vector();
                Vector globalTypesXPaths = new Vector();
                DOMHelper.evalGlobalTypes(this, globalTypes, globalTypesXPaths);
                for (int g = globalTypes.size(); g > 0; --g) {
                    XUIDefinition globalXUIDefinition = null;
                    SchemaNode globalNode = (SchemaNode)globalTypes.get(g - 1);
                    String globalXUIKey1 = globalNode.getQName();
                    String globalXUIKey2 = (String)globalTypesXPaths.get(g - 1);
                    if (this.isList()) {
                        globalXUIKey2 = new StringBuffer().append(globalXUIKey2).append(FIELD_LIST_IDENTIFIER).toString();
                    }
                    if ((globalXUIDefinition = (XUIDefinition)this.getDOM().getGlobalXUIDefinitions().get(globalXUIKey1 != null ? globalXUIKey1 : "", globalXUIKey2 != null ? globalXUIKey2 : "")) == null || this.isList() && !globalXUIDefinition.getXUIXPath().endsWith(FIELD_LIST_IDENTIFIER)) continue;
                    XUIDefinition xuiDef = new XUIDefinition(this, null, true, this.isDerivedFromEditingType());
                    if (this.isComposite() && this.getDOM().getSchema().getGlobalEntity(globalNode.getNode().getType(), globalXUIKey1) != null && this.getDOM().getSchema().getGlobalEntity(globalNode.getNode().getType(), globalXUIKey1).isSimple() && ((CompositeType)((Object)this)).getContentType() != null) {
                        ((CompositeType)((Object)this)).getContentType()._uiDefinition = xuiDef;
                        xuiDef.setType(((CompositeType)((Object)this)).getContentType());
                        xuiDef.reinitialize(globalXUIDefinition);
                        this._serializable = xuiDef.getStyle().getSerializable();
                        this._usedGlobalXUI = globalXUIDefinition;
                        break;
                    }
                    this._uiDefinition = xuiDef;
                    xuiDef.reinitialize(globalXUIDefinition);
                    this._usedGlobalXUI = globalXUIDefinition;
                    this._serializable = xuiDef.getStyle().getSerializable();
                    break;
                }
            }
            this._globalXUIDefinitionsChecked = true;
        }
    }

    @Override
    public void setBackground(Color color) {
        this.getStyle().setBackgroundColor(color);
    }

    @Override
    public void setForeground(Color color) {
        this.getStyle().setForegroundColor(color);
    }

    @Override
    public void setLabelColor(Color color) {
        this.getStyle().setLabelColor(color);
    }

    @Override
    public void setLabelText(String text) {
        this.getStyle().setLabelText(text);
    }

    @Override
    public abstract Type getChild(String var1);

    @Override
    public abstract Type getChild(String var1, String var2);

    protected void serializeAttribute(StringBuffer sb, SimpleType simple) {
        boolean serialize = simple.isSerializable(true);
        if (serialize) {
            String attrValue = simple.getValue();
            if (attrValue != null) {
                attrValue = TextTools.replaceGlobalEntities(attrValue);
            } else {
                attrValue = "";
                if (this.getGlobalDefinition().isSerializingEmptyContent() && this.isMandatoryAxis()) {
                    attrValue = simple.getDefaultNullValue();
                }
            }
            sb.append(" ");
            sb.append(simple.getName());
            sb.append("=\"");
            sb.append(attrValue);
            sb.append("\"");
        } else if (this.getGlobalDefinition().isSerializingEmptyContent() && simple.isMandatoryAxis()) {
            String attrValue = simple.getDefaultNullValue();
            sb.append(" ");
            sb.append(simple.getName());
            sb.append("=\"");
            sb.append(attrValue);
            sb.append("\"");
        }
    }

    @Override
    public String getTreeHierarchyContext() {
        String context = "";
        Type treeParent = this.getRepresentedTreeNodeParent();
        if (treeParent != null) {
            context = new StringBuffer().append(treeParent.getStyle().getTreeLabelText()).append("; ").toString();
        }
        context = new StringBuffer().append(context).append(this.getStyle().getLabelText()).toString();
        return context;
    }

    @Override
    public String getFullCaption() {
        return this.getFullCaption(-1);
    }

    @Override
    public String getFullCaption(int labelLength) {
        if (labelLength < 0) {
            labelLength = 30;
        }
        String fullCaption = "";
        String separatorCharacter = " - ";
        String labelOverFlowEnding = "...";
        String currentTypeDescription = null;
        for (Type parentType = this.getParent(); parentType != null; parentType = parentType.getParent()) {
            int currentLength;
            String label = parentType.getVisualName();
            if (label != null && parentType.getParent() != null && parentType.getParent().isList()) {
                int origIndex;
                int index = 0;
                ListType parentList = (ListType)parentType.getParent();
                List list = parentList.getList();
                if (list != null && list.size() > 0 && list.contains(parentType) && (origIndex = list.indexOf(parentType)) >= 0) {
                    index = parentList.getSortIndexes() != null ? parentList.getSortIndexes()[origIndex] + 1 : origIndex + 1;
                }
                label = index > 0 ? new StringBuffer().append(label).append(FIELD_LIST_OPEN_BRACKET).append(index).append(FIELD_LIST_CLOSE_BRACKET).toString() : new StringBuffer().append(label).append("[?]").toString();
            }
            if (label != null && label.length() > 0 && (currentLength = label.length()) > labelLength) {
                String partialLabel = label.substring(0, labelLength);
                label = new StringBuffer().append(partialLabel).append(labelOverFlowEnding).toString();
            }
            if (label == null) continue;
            fullCaption = new StringBuffer().append(label).append(separatorCharacter).append(fullCaption).toString();
        }
        currentTypeDescription = this.getVisualName();
        int currentLength = currentTypeDescription.length();
        if (currentLength > labelLength) {
            String partialLabel = currentTypeDescription.substring(0, labelLength);
            currentTypeDescription = new StringBuffer().append(partialLabel).append(labelOverFlowEnding).toString();
        }
        fullCaption = fullCaption != null && fullCaption.length() > 0 ? new StringBuffer().append(fullCaption).append(currentTypeDescription).toString() : currentTypeDescription;
        return fullCaption;
    }

    @Override
    public String getVisualName() {
        ListType parentList;
        String dialogTitle;
        String label = null;
        XUIDefinition xuiDef = this.getXUIDefinition();
        if (this.isSimple() && xuiDef.getStyle().getLabelText() != null && (label = xuiDef.getStyle().getLabelText()) != null && label.equals(this.getName())) {
            label = null;
        }
        if (label == null && this.isRepresentedAsTreeNode()) {
            label = xuiDef.getStyle().getTreeLabelText();
        }
        if (label == null && this.getParent() != null && this.getParent().isChoice()) {
            label = xuiDef.getStyle().getLabelChoiceText();
        }
        if (label == null) {
            label = xuiDef.getStyle().getCaptionTitleLabel();
        }
        if (label == null && this.getParent() != null && this.getParent().isList() && (dialogTitle = (parentList = (ListType)this.getParent()).getStyle().getDialogLabel()) != null) {
            label = dialogTitle;
        }
        if (label == null) {
            label = this.getName();
        }
        return label;
    }

    @Override
    public void domChanged(DOMChangeEvent event) {
    }

    @Override
    public Type getPreviousSibling() {
        Type previousType = null;
        Type pt = this.getParent();
        if (!this.isRoot() && pt != null) {
            int myIndex;
            int previousIndex;
            List types = null;
            if (pt.isComposite()) {
                types = ((CompositeType)pt).getComposites();
            } else if (pt.isList()) {
                types = ((ListType)pt).getList();
            }
            if (types != null && (previousIndex = (myIndex = types.indexOf(this)) - 1) >= 0) {
                previousType = (Type)types.get(previousIndex);
            }
        }
        return previousType;
    }

    @Override
    public Type getNextSibling() {
        Type nextType = null;
        Type pT = this.getParent();
        if (!this.isRoot() && pT != null) {
            int myIndex;
            int nextIndex;
            List types = null;
            if (pT.isComposite()) {
                types = ((CompositeType)pT).getComposites();
            } else if (pT.isList()) {
                types = ((ListType)pT).getList();
            }
            if (types != null && (nextIndex = (myIndex = types.indexOf(this)) + 1) < types.size()) {
                nextType = (Type)types.get(nextIndex);
            }
        }
        return nextType;
    }

    @Override
    public boolean hasUIDefinition() {
        return this._uiDefinition != null;
    }

    @Override
    public void setEditable(boolean editable) {
        if (!editable || !this.isLocked()) {
            if (this.getStyle().isUnlocked()) {
                editable = true;
            }
            this.getStyle().setEditable(editable);
            Vector allVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(this);
            if (allVisualizers.size() > 0) {
                Visualizer view = null;
                Vector views = allVisualizers;
                for (int i = 0; i < views.size(); ++i) {
                    view = (Visualizer)views.get(i);
                    if (view == null) continue;
                    view.setEditable(editable);
                }
            }
            List childs = null;
            if (this.isComposite()) {
                childs = ((CompositeType)((Object)this)).getComposites();
            } else if (this.isList()) {
                childs = ((ListType)((Object)this)).getList();
            }
            if (childs != null) {
                for (int i = 0; i < childs.size(); ++i) {
                    ((Type)childs.get(i)).setEditable(editable);
                }
            }
        }
    }

    public void setChoiceEnabled(boolean isEnabled) {
        this.getStyle().setChoiceEnabled(isEnabled);
    }

    @Override
    public boolean isIncluded() {
        return this._isIncluded;
    }

    @Override
    public Type getMixedContent() {
        return null;
    }

    protected void makeIndent(StringBuffer sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(indentChars);
        }
    }

    public void setRecursionBuilt(boolean built) {
        this._recursionBuilt = built;
    }

    @Override
    public boolean hasRecursionBeenBuilt() {
        if (this.isComposite()) {
            return this.getDirectChildren().size() > 0;
        }
        return this._recursionBuilt;
    }

    @Override
    public abstract void markAsDirtyXPath();

    public int countSubTypes() {
        return this.countSubTypes(this);
    }

    private int countSubTypes(Type type) {
        int currentNo = 0;
        Vector<Type> children = new Vector<Type>();
        children.addAll(type.getDirectChildren());
        if (type.isList()) {
            children.add(((ListType)type).getEditingType());
        }
        currentNo += children.size();
        Vector<Type> childs = children;
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            currentNo += this.countSubTypes(child);
        }
        return currentNo;
    }

    public XUIDefinition getXUIDefinition(boolean create, boolean isReleasing) {
        if (!create && this._uiDefinition == null) {
            return null;
        }
        if (!isReleasing) {
            if (this._uiDefinition != null && !this._uiDefinition.isLateBuilt()) {
                this._uiDefinition.finishInitialization();
                this._serializable = this._uiDefinition.getStyle().getSerializable();
            }
            if (this.getDOM() != null && this.getDOM().isXUIInitialized() && this.getGlobalDefinition().useGlobalUIDefintions() && !this._globalXUIDefinitionsChecked && (this._uiDefinition == null || this._uiDefinition != null && !this._uiDefinition.hasBeenInitializedFromFile())) {
                this.checkGlobalUIDefinition();
            }
        }
        if (this._uiDefinition == null) {
            this._uiDefinition = new XUIDefinition(this, null);
        }
        if (this._uiDefinition != null && this._needXUIMaintain && !isReleasing) {
            this._needXUIMaintain = false;
            ListType parentList = this.getLastParentList();
            if (parentList != null) {
                parentList.maintainXUIDefinitions(this);
            }
        }
        return this._uiDefinition;
    }

    @Override
    public XUIDefinition getXUIDefinition(boolean create) {
        return this.getXUIDefinition(create, false);
    }

    public ListType getLastParentList() {
        ListType parentList = this.getParentList();
        if (parentList == null) {
            return null;
        }
        return this.getLastParentList(parentList);
    }

    public ListType getLastParentList(ListType listType) {
        ListType parentList = null;
        if (listType.getParent() != null) {
            parentList = listType.getParent().getParentList();
        }
        if (parentList != null) {
            return this.getLastParentList(parentList);
        }
        return listType;
    }

    @Override
    public void removeClientProperty(String key) {
        if (this._properties != null) {
            this.getClientProperties().remove(key);
        }
    }

    @Override
    public boolean isMandatoryAxis() {
        this.checkCache();
        if (this._isMandCache == -1) {
            this._isMandCache = this.isMandatoryAxis(true) ? (byte)1 : 0;
        }
        return this._isMandCache == 1;
    }

    public boolean isMandatoryAxis(boolean checkForEmptyContent) {
        return this.isMandatoryAxis(this, checkForEmptyContent);
    }

    protected boolean isMandatoryAxis(Type type, boolean checkForEmptyContent) {
        boolean parentMandatory;
        if (!type.isRequired()) {
            return false;
        }
        if (type.getSchemaElement().hasUnnamedOptionalParent()) {
            return false;
        }
        Type pT = type.getParent();
        if (pT != null && !pT.isList() && !(parentMandatory = this.isMandatoryAxis(pT, checkForEmptyContent))) {
            if (pT.isComposite()) {
                if (checkForEmptyContent) {
                    return !((CompositeType)pT).hasEmptyContent(true, true);
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void setAnonymous(boolean isAnonymous) {
        this._isAnonymous = new Boolean(isAnonymous);
    }

    @Override
    public boolean isUserInstanciated() {
        return this._userInstanciated;
    }

    @Override
    public void setUserInstanciated(boolean userTriggered) {
        this._userInstanciated = userTriggered;
    }

    public void notifyKeyRefChildsForDeletion(Type childToDelete, boolean check) throws KeyRefException {
        ArrayList<Type> childsToProcess = new ArrayList<Type>();
        ArrayList<Type> keyKontextToProcess = new ArrayList<Type>();
        childsToProcess.add(childToDelete);
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type achild = (Type)childsToProcess.get(c);
            if (achild.isSimple()) {
                if (achild.getSchemaElement().hasSchemaKeys()) {
                    this.getDOM().getKeyKeyRefManager().deRegisterKey(this, (SimpleType)achild, achild.getSchemaElement().getSchemaKeys(), !check);
                }
                if (!achild.getSchemaElement().hasSchemaKeyRefs()) continue;
                this.getDOM().getKeyKeyRefManager().deRegisterKeyRef((SimpleType)achild);
                continue;
            }
            if (((AbstractType)achild).isKeyContext()) {
                keyKontextToProcess.add(achild);
            }
            childsToProcess.addAll(achild.getDirectChildren());
        }
        for (int k = 0; k < keyKontextToProcess.size(); ++k) {
            this.getDOM().getKeyKeyRefManager().removeKeyContainer((Type)keyKontextToProcess.get(k));
        }
    }

    public void notifyChildsForDeletion(List childs, boolean check) throws KeyRefException {
        ArrayList childsToProcess = new ArrayList(childs);
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type achild = (Type)childsToProcess.get(c);
            if (!achild.isSimple()) {
                childsToProcess.addAll(achild.getDirectChildren());
            }
            if (((AbstractType)achild)._pXpath == null) continue;
            this.getDOM().getXPathEncoder().remove(((AbstractType)achild)._pXpath);
        }
    }

    public void notifyKeyRefChildsForCreation(Type createdChild) {
        createdChild.setUserInstanciated(true);
        if (createdChild.isKey()) {
            try {
                createdChild.getDOM().getKeyKeyRefManager().registerKey((SimpleType)createdChild, createdChild.getSchemaElement().getSchemaKeys(), false);
            }
            catch (KeyRefException e) {
                // empty catch block
            }
        }
        if (createdChild.isKeyRef()) {
            createdChild.getDOM().getKeyKeyRefManager().registerKeyRef((SimpleType)createdChild, false);
        }
        if (createdChild.isChoice()) {
            createdChild.getXUIDefinition();
            createdChild.getChoosenType();
        }
        Vector childsToProcess = new Vector(createdChild.getDirectChildren());
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type achild = (Type)childsToProcess.get(c);
            achild.setUserInstanciated(true);
            if (!achild.isSimple()) {
                if (achild.isChoice()) {
                    achild.getXUIDefinition();
                    achild.getChoosenType();
                }
                childsToProcess.addAll(achild.getDirectChildren());
                continue;
            }
            if (achild.isKey()) {
                try {
                    achild.getDOM().getKeyKeyRefManager().registerKey((SimpleType)achild, achild.getSchemaElement().getSchemaKeys(), false);
                }
                catch (KeyRefException e) {
                    // empty catch block
                }
            }
            if (!achild.isKeyRef()) continue;
            achild.getDOM().getKeyKeyRefManager().registerKeyRef((SimpleType)achild, false);
        }
    }

    public void getAllKeyChilds(List found, Type type) {
        List childs = type.getDirectChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            if (child.isSimple()) {
                if (!child.isKey()) continue;
                found.add(child);
                continue;
            }
            this.getAllKeyChilds(found, child);
        }
    }

    public void getAllKeyFieldChilds(List found, Type type) {
        List childs = type.getDirectChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            if (child.isSimple()) {
                if (!child.isKey()) continue;
                found.add(child);
                continue;
            }
            this.getAllKeyFieldChilds(found, child);
        }
    }

    @Override
    public Type getTemplate() {
        if (this._template == null) {
            return this;
        }
        return this._template;
    }

    @Override
    public void setTemplate(Type template) {
        this._template = template;
    }

    public Type getParentEditingTypeClone(ListType parentList, Type choiceType) {
        List posEdList = parentList.getList();
        Type editingClone = null;
        for (int i = 0; i < posEdList.size(); ++i) {
            editingClone = (Type)posEdList.get(i);
            if (choiceType != editingClone && !choiceType.isDerivedFrom(editingClone)) continue;
            return editingClone;
        }
        return null;
    }

    @Override
    public boolean isReleased() {
        return this._isReleased;
    }

    @Override
    public String getRefName() {
        return this.getSchemaElement().getRefName();
    }

    protected void setDirtyXPath(boolean isDirtyXPath) {
        this._isDirtyXPath = isDirtyXPath;
        this._pXpath = null;
    }

    public void setNoneChoosen(boolean noneChoosen) {
        this._noneChoosen = noneChoosen;
    }

    public boolean isNoneChoosen() {
        return this._noneChoosen;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.getSchemaElement().getSchemaType();
    }

    @Override
    public StyleDefinition getStyle() {
        return this.getXUIDefinition().getStyle();
    }

    public Type getFirstNamedParent() {
        if (this.getParent() != null) {
            if (!this.getParent().isAnonymous()) {
                return this.getParent();
            }
            return ((AbstractType)this.getParent()).getFirstNamedParent();
        }
        return null;
    }

    public ImageIcon getMessageContextIcon() {
        if (this == null) {
            return null;
        }
        Type treeParent = this.getRepresentedTreeNodeParent();
        if (treeParent != null) {
            ImageIcon icon;
            String gifName = treeParent.getStyle().getTreeIcon();
            if (gifName != null && gifName.length() > 0) {
                return JAXFrontProperties.getImageIcon(gifName);
            }
            if (treeParent.getParent() != null && (icon = ((AbstractType)treeParent.getParent()).getMessageContextIcon()) != null) {
                return icon;
            }
        }
        return null;
    }

    protected void doAtTypeCreation() {
        if (this.getStyle().useUserModifiedSerialization()) {
            boolean expand;
            GlobalDefinition globDef = this.getGlobalDefinition();
            boolean wasSerialEmptContent = globDef.isSerializingEmptyContent();
            globDef.setSerializingEmptyContent(false);
            boolean elemHasContent = !this.hasEmptyContent(false, true);
            globDef.setSerializingEmptyContent(wasSerialEmptContent);
            boolean serCollapsed = this.getStyle().isUserModifiedSerializationCollapsed();
            boolean bl = expand = !serCollapsed || elemHasContent;
            if (!expand) {
                this.setSerializable(false);
                this.getStyle().setApplicationRequired(false);
            }
        }
    }

    @Override
    public boolean getSerializableFlag() {
        return this._serializable;
    }

    public void setGlobalEdType(boolean isGlobalEdType) {
        this._isGlobalEdType = isGlobalEdType;
    }

    public boolean isGlobalEdType() {
        return this._isGlobalEdType;
    }

    public void setGlobalEdTypeRefCount(int globalEdTypeRefCount) {
        this._globalEdTypeRefCount = globalEdTypeRefCount;
    }

    public int getGlobalEdTypeRefCount() {
        return this._globalEdTypeRefCount;
    }

    public void setHasChanged(boolean changed) {
        this._hasChanged = changed;
        List parents = DOMHelper.getParents(this);
        for (int p = 0; p < parents.size(); ++p) {
            if (parents.get(p) == null) continue;
            ((AbstractType)parents.get(p)).setHasChanged(changed);
        }
    }

    protected boolean isDerivedFromGlobalEditingType(AbstractType type) {
        if (type.isGlobalEdType()) {
            return true;
        }
        if (type.getParent() != null) {
            return this.isDerivedFromGlobalEditingType((AbstractType)type.getParent());
        }
        return false;
    }

    @Override
    public String getVarName() {
        return this._varName;
    }

    public void setVarName(String varName) {
        if (varName == null) {
            if (this._varName != null) {
                this.getDOM().removeVarToTypeMapping(this._varName);
            }
        } else if (!varName.equals(this._varName)) {
            if (this._varName != null) {
                this.getDOM().removeVarToTypeMapping(this._varName);
            }
            if (varName != null) {
                this.getDOM().addVarToTypeMapping(varName, this);
            }
        }
        if (varName != null && this.getClientProperties().get("VAR_NAME_XPATH") == null) {
            this.getClientProperties().put("VAR_NAME_XPATH", this.getXPathLocation());
        }
        this._varName = varName;
    }

    public HashMap<String, String> getUIState() {
        if (this._uiState == null) {
            this._uiState = new HashMap();
        }
        return this._uiState;
    }

    public String getUIState(String id) {
        if (this._uiState != null) {
            return this._uiState.get(id);
        }
        return null;
    }

    public void putUIState(String id, String param) {
        this.getUIState().put(id, param);
    }

    @Override
    public void setViewContextType(Type viewHolder) {
        this.putClientProperty("VIEW_HOLDER_TYPE", viewHolder);
    }

    @Override
    public Type getViewContextType() {
        return (Type)this.getClientProperty("VIEW_HOLDER_TYPE");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

