/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import java.util.List;

public class Recursion {
    public static Visualizer createRecursionVisualizer(RecursionVisualizer recursionVisualizer) {
        AbstractCompositeType composite = (AbstractCompositeType)recursionVisualizer.getModel();
        if (!composite.hasRecursionBeenBuilt()) {
            try {
                composite.completeRecursion();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        Visualizer visualizer = TypeVisualizerFactory.getInstance().createVisualizerFor(composite, recursionVisualizer.getContext(), false);
        if ((visualizer = visualizer.getImplementation()) instanceof RecursionVisualizer) {
            visualizer = visualizer.getImplementation();
        }
        composite.getDOM().getKeyKeyRefManager().registerAllKeyAndKeyRefs(composite);
        composite.getDOM().getUndoManager().addRecursionEventUndoableEditWrapper(recursionVisualizer, composite, (short)2);
        return visualizer;
    }

    public static void deleteRecursion(RecursionVisualizer recursionVisualizer) {
        CompositeType compositeModel = (CompositeType)recursionVisualizer.getModel();
        compositeModel.getDOM().getUndoManager().addRecursionEventUndoableEditWrapper(recursionVisualizer, compositeModel, (short)1);
        compositeModel.getDOM().fireDOMChanged(DOMChangeEvent.DOM_REMOVE_NODE(compositeModel));
        try {
            ((AbstractType)((Object)compositeModel)).notifyKeyRefChildsForDeletion(compositeModel, true);
        }
        catch (KeyRefException e1) {
            // empty catch block
        }
        TypeVisualizerFactory.getInstance().removeVisualizerStructure(compositeModel, false);
        List childs = compositeModel.getComposites();
        for (int c = childs.size() - 1; c >= 0; --c) {
            try {
                ((Type)childs.get(c)).remove();
                continue;
            }
            catch (ListModificationException e) {
                e.printStackTrace();
            }
        }
    }
}

