/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.type.Type;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class RelativeTypePath {
    public static final String S_EMPTY = "";
    public static final String S_DOT = ".";
    public static final String S_DDOT = "..";
    public static final String S_AD = "@";
    public static final String S_SLASH = "/";
    public static final String S_OPENBRACKET = "[";
    public static final String S_CLOSEBRACKET = "]";
    public static final String S_LIST = "[list]";

    public static String createRelativeXPath(Type toType, Type fromType, boolean listTypeIncluded, boolean includeRootList) {
        return RelativeTypePath.createRelativeXPath(toType, fromType, listTypeIncluded, includeRootList, true);
    }

    public static String createRelativeXPath(Type toType, Type fromType, boolean listTypeIncluded, boolean includeRootList, boolean appendUpPath) {
        Vector fromPath = new Vector();
        Vector toPath = new Vector();
        RelativeTypePath.extractAccessPath(fromType, fromPath, listTypeIncluded, true);
        RelativeTypePath.extractAccessPath(toType, toPath, listTypeIncluded, true);
        Type commonRoot = RelativeTypePath.getCommonRoot(fromPath, toPath);
        String upPath = null;
        if (appendUpPath) {
            upPath = RelativeTypePath.getCommonRootPathUp(toPath, commonRoot);
        }
        String downPath = RelativeTypePath.getCommonRootPathDown(fromPath, commonRoot);
        String relativePath = upPath == null || upPath.length() == 0 ? S_DOT + downPath : upPath + downPath;
        return relativePath;
    }

    public static Type getCommonRoot(Type toType, Type fromType, boolean listTypeIncluded) {
        Vector fromPath = new Vector();
        Vector toPath = new Vector();
        RelativeTypePath.extractAccessPath(fromType, fromPath, listTypeIncluded, true);
        RelativeTypePath.extractAccessPath(toType, toPath, listTypeIncluded, true);
        return RelativeTypePath.getCommonRoot(fromPath, toPath);
    }

    public static String createRelativeXPath(Type toType, Type fromType, boolean listTypeIncluded) {
        return RelativeTypePath.createRelativeXPath(toType, fromType, listTypeIncluded, false);
    }

    private static void extractAccessPath(Type type, Vector result, boolean listTypeIncluded, boolean includeRootList) {
        if (!listTypeIncluded && includeRootList && type.isList()) {
            result.add(type);
        }
        RelativeTypePath.extractAccessPath(type, result, listTypeIncluded);
    }

    private static void extractAccessPath(Type type, Vector result, boolean listTypeIncluded) {
        Type parent = type.getParent();
        if (!type.isList() || listTypeIncluded) {
            result.add(type);
        }
        if (parent != null) {
            RelativeTypePath.extractAccessPath(parent, result, listTypeIncluded);
            return;
        }
    }

    private static Type getCommonRoot(Vector fromPath, Vector toPath) {
        Vector longestWay = null;
        Vector shortestWay = null;
        if (fromPath.size() > toPath.size()) {
            longestWay = fromPath;
            shortestWay = toPath;
        } else {
            longestWay = toPath;
            shortestWay = fromPath;
        }
        for (int i = 0; i < longestWay.size(); ++i) {
            Type longType = (Type)longestWay.get(i);
            for (int j = 0; j < shortestWay.size(); ++j) {
                Type shortType = (Type)shortestWay.get(j);
                if (!shortType.equals(longType)) continue;
                return shortType;
            }
        }
        return null;
    }

    private static int getListPosition(Type listItem) {
        if (listItem.getParent().isList()) {
            List childs = listItem.getParent().getDirectChildren();
            for (int i = 0; i < childs.size(); ++i) {
                if (!listItem.equals(childs.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private static String getCommonRootPathDown(Vector path, Type startElement) {
        boolean startElementFound = false;
        StringBuffer result = new StringBuffer();
        for (int i = path.size() - 1; i >= 0; --i) {
            Type pathElement = (Type)path.get(i);
            String name = pathElement.getSerializationName();
            if (pathElement.isDerived()) {
                name = pathElement.getParent().getSerializationName();
            }
            if (startElementFound) {
                result.append(S_SLASH);
                if (pathElement.isAttribute()) {
                    result.append(S_AD);
                    result.append(name);
                } else if (pathElement.isList()) {
                    result.append(name);
                    result.append(S_LIST);
                } else if (pathElement.getParent().isList()) {
                    result.append(name);
                    if (!pathElement.isEditingType()) {
                        int listItemPos = RelativeTypePath.getListPosition(pathElement) + 1;
                        result.append(S_OPENBRACKET);
                        result.append(listItemPos);
                        result.append(S_CLOSEBRACKET);
                    }
                } else {
                    result.append(name);
                }
            }
            if (!pathElement.equals(startElement)) continue;
            startElementFound = true;
        }
        return result.toString();
    }

    private static String getCommonRootPathUp(Vector path, Type element) {
        Type pathElement;
        StringBuffer result = new StringBuffer();
        Enumeration pathEnum = path.elements();
        while (pathEnum.hasMoreElements() && !(pathElement = (Type)pathEnum.nextElement()).equals(element)) {
            result.append("../");
        }
        if (result.length() > 0) {
            return result.delete(result.length() - 1, result.length()).toString();
        }
        return S_EMPTY;
    }
}

