/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import java.util.Iterator;

public class SimpleTypeList
extends AbstractListType {
    public SimpleTypeList(SchemaNode schemaElement, Type editingType) {
        super(schemaElement, editingType);
        this._typeClassification = (short)128;
    }

    public Type add(String content) {
        SimpleType newType = (SimpleType)this.addNewChild();
        newType.setValue(content);
        return newType;
    }

    public void change(Type type, String newContent) {
        ((SimpleType)type).setValue(newContent);
    }

    public String[] getValues() {
        Iterator iterator = this.getList().iterator();
        String[] values = new String[this.getList().size()];
        int index = 0;
        while (iterator.hasNext()) {
            String value = ((SimpleType)iterator.next()).getValue();
            values[index++] = value == null ? "" : value;
        }
        return values;
    }

    public boolean isPrimitiveTypeBoolean() {
        return ((SimpleType)this.getEditingType()).isBoolean();
    }

    public boolean isPrimitiveTypeColor() {
        return ((SimpleType)this.getEditingType()).isColor();
    }

    public boolean isPrimitiveTypeDate() {
        return ((SimpleType)this.getEditingType()).isDate();
    }

    public boolean isPrimitiveTypeDuration() {
        return ((SimpleType)this.getEditingType()).isDuration();
    }

    public boolean isPrimitiveTypeNumber() {
        return ((SimpleType)this.getEditingType()).isNumber();
    }

    public boolean isPrimitiveTypeString() {
        return ((SimpleType)this.getEditingType()).isString();
    }

    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive, boolean serializeEmptyContent) {
        if (this.isSerializable() && recursive && this.size() > 0) {
            Iterator children = this.getList().iterator();
            while (children.hasNext()) {
                Type child = (Type)children.next();
                if (child.isAttribute()) {
                    sb.append("<" + this.getName());
                    this.serializeAttribute(sb, (SimpleType)child);
                    sb.append("/>");
                    continue;
                }
                child.serialize(sb, indent, writeName, recursive, serializeEmptyContent);
            }
        }
    }

    public boolean isUsingPredefinedSelection() {
        return this.getEditingType() != null && this.getEditingType().getStyle().isUsingCodeSet() || this.getEditingType().getStyle().isEnumeration();
    }

    protected boolean shouldFireCardinalityException() {
        return !this.isUsingPredefinedSelection();
    }

    public void autoCreateEntries() {
        String[] enums;
        int startSize = this.size();
        super.autoCreateEntries();
        if (this.isUsingPredefinedSelection() && startSize < this.size() && (enums = this.getEnumeration()) != null) {
            for (int i = startSize; i < this.size(); ++i) {
                if (i >= enums.length) continue;
                ((SimpleType)this.getList().get(i)).setValue(enums[i]);
            }
        }
    }

    private String[] getEnumeration() {
        String codesetName;
        String[] enums = null;
        if (this.getEditingType().getStyle().isEnumeration()) {
            enums = this.getEditingType().getStyle().getEnumeration();
        } else if (this.getEditingType().getStyle().isUsingCodeSet() && (codesetName = this.getEditingType().getStyle().getCodeSetName()) != null && codesetName.length() > 0) {
            enums = this.getDOM().getSchema().getCodeTables().getItems(true, this, codesetName, this.getDOM().getLanguage());
        }
        return enums;
    }
}

