/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.clipboard.CopyTypeWrapper;
import com.jaxfront.core.clipboard.SimpleClipboardSelection;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.keyRef.KeyKeyRefManager;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.xui.NLS;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class ClipBoard {
    private CopyTypeWrapper _copyTypeWrapper;
    private StringSelection _serverStringSelection;

    public void copy(Type type) {
        this.copy(type, null);
    }

    public void copyAsObject(Type type, String xml) {
        CopyTypeWrapper wrapper = null;
        if (type != null) {
            try {
                wrapper = new CopyTypeWrapper(type, xml);
                SimpleClipboardSelection.copy(wrapper, SimpleClipboardSelection.dataFlavor);
            }
            catch (HeadlessException he) {
                LogRegistry.getInstance().error(this.getClass(), he);
            }
            type.getDOM().setRuleEngineBlocked(true);
        }
        if (type != null) {
            type.getDOM().setRuleEngineBlocked(false);
            type.getDOM().fireDOMChanged(DOMChangeEvent.DOM_COPY_CONTENT(type));
        }
    }

    public void copy(Type type, String xml) {
        StringSelection sSelection = null;
        if (type != null) {
            sSelection = new StringSelection(new CopyTypeWrapper(type, xml).toString());
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sSelection, null);
            }
            catch (Throwable t) {
                this._serverStringSelection = sSelection;
            }
            type.getDOM().setRuleEngineBlocked(true);
        }
        if (type != null) {
            type.getDOM().setRuleEngineBlocked(false);
            type.getDOM().fireDOMChanged(DOMChangeEvent.DOM_COPY_CONTENT(type));
        }
    }

    public boolean paste(Type type) {
        return this.paste(type, false);
    }

    public boolean paste(Type type, boolean bruteforce) {
        return this.paste(type, null, bruteforce);
    }

    public boolean paste(Type type, NLS nls, boolean bruteforce) {
        return this.paste(type, nls, bruteforce, true);
    }

    public boolean paste(Type type, NLS nls, boolean bruteforce, boolean releaseVisualizers) {
        return this.paste(this.getCopyTypeWrapper(), type, nls, bruteforce, releaseVisualizers);
    }

    public boolean paste(CopyTypeWrapper wrapper, Type type, NLS nls, boolean bruteforce, boolean releaseVisualizers) {
        boolean pasted;
        if (this._copyTypeWrapper == null) {
            this.createCopyTypeWrapper();
        }
        if (pasted = this.canPaste(type, bruteforce)) {
            boolean wasUndoCompoundState = type.getDOM().getUndoManager().isInCompoundEditState();
            type.getDOM().getUndoManager().startCompoundEdit();
            if (nls != null && type.getDOM().isRunningInXUIEditor()) {
                String xpath = type.getDirectChildValue("xpath");
                this.doPaste(wrapper, type, releaseVisualizers);
                type.setDirectChildValue("xpath", xpath);
                this.pasteNLS(wrapper, type, nls);
            } else {
                this.doPaste(wrapper, type, releaseVisualizers);
            }
            type.getDOM().fireDOMChanged(DOMChangeEvent.DOM_PASTE_CONTENT(type));
            if (!wasUndoCompoundState) {
                type.getDOM().getUndoManager().stopCompoundEdit();
            }
        } else if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "can't paste type:" + (type != null ? type.getXPathLocation() : "null") + " into:" + (wrapper != null ? wrapper.getXPathLocation() : "null"));
        }
        return pasted;
    }

    public void doPaste(CopyTypeWrapper wrapper, Type type, boolean releaseVisualizer) {
        if (wrapper == null || wrapper.getSerializedTypeContent() == null || wrapper.getSerializedTypeContent().length() <= 0) {
            return;
        }
        StringBuffer oldValue = new StringBuffer();
        oldValue.append(type.serialize());
        StringBuffer serToBind = new StringBuffer();
        serToBind.append(wrapper.getSerializedTypeContent());
        if (type.getDOM().isXUIDOMInstance()) {
            this.doPasteInXUIEditor(type, serToBind.toString(), oldValue.toString(), releaseVisualizer, wrapper.isAdd());
        } else {
            this.doPaste(type, serToBind.toString(), oldValue.toString(), releaseVisualizer, wrapper.isAdd());
        }
    }

    public void doPaste(Type target, String serToBind, String oldValue, boolean releaseVisualizer) {
        this.doPaste(target, serToBind, oldValue, releaseVisualizer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPaste(Type target, String serToBind, String oldValue, boolean releaseVisualizer, boolean isAdding) {
        Document dom = target.getDOM();
        TreeNode selectedTreeNode = null;
        if (dom.getEditor() != null) {
            selectedTreeNode = dom.getEditor().getTreeModel().getNode(target);
        }
        boolean wasBlocked = dom.getUndoManager().isBlocked();
        try {
            dom.getUndoManager().blockInput(true);
            try {
                if (dom.getGlobalDefinition().isShowingTree() && dom.getEditor() != null && selectedTreeNode != null && dom.getEditor().getTreeModel() != null) {
                    dom.getEditor().removeTreeNodes(selectedTreeNode.getChildren());
                }
                dom.getKeyKeyRefManager().setBlockEvents(true);
                dom.getController().getErrorController().setBlocked(true);
                dom.setPasteMode(true);
                KeyKeyRefManager.deRegisterKeyKeyRefStructure(target, true);
                if (dom.getGlobalDefinition().isShowingTree() && releaseVisualizer && TypeVisualizerFactory.getInstance().getVisualizer(this.getViewHolderType(target), false) != null) {
                    TypeVisualizerFactory.getInstance().removeVisualizerStructure(TypeVisualizerFactory.getInstance().getVisualizer(this.getViewHolderType(target), false), true);
                }
                dom.itCache = new DoubleKeyHashtableUnsynced(100);
                dom.xpCache = new DoubleKeyHashtableUnsynced(100);
                dom.parentCache = new DoubleKeyHashtableUnsynced(100);
                Element elementToBind = null;
                if (serToBind != null && serToBind.length() > 0) {
                    try {
                        elementToBind = DOMHelper.createDocument(serToBind).getDocumentElement();
                    }
                    catch (Exception e) {
                        elementToBind = DOMHelper.createDocument("<copy>" + serToBind + "</copy>").getDocumentElement();
                    }
                }
                if (target.isList() && isAdding) {
                    ((ListType)target).bind(dom, elementToBind, false, false);
                } else {
                    target.bind(dom, elementToBind, false);
                }
                dom.getKeyKeyRefManager().registerAllKeyAndKeyRefs(dom.getRootType());
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
            finally {
                dom.setPasteMode(false);
                dom.getKeyKeyRefManager().setBlockEvents(false);
                dom.getController().getErrorController().setBlocked(false);
                dom.itCache = null;
                dom.xpCache = null;
                dom.parentCache = null;
            }
        }
        finally {
            if (!wasBlocked) {
                dom.getUndoManager().blockInput(false);
            }
        }
        dom.getUndoManager().addPasteUndoableEditEvent(this, target, serToBind, oldValue, false);
        if (dom.getGlobalDefinition().isShowingTree() && dom.getEditor() != null && selectedTreeNode != null && dom.getEditor().getTreeModel() != null) {
            dom.getEditor().getTreeModel().buildTree(selectedTreeNode, selectedTreeNode.getType());
            dom.getEditor().getTreeModel().reload(selectedTreeNode);
        }
        ClipBoard.removeNotWantedTypeProperties(target);
        dom._lastDomUpdateTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPasteInXUIEditor(Type target, String serToBind, String oldValue, boolean releaseVisualizer, boolean isAdding) {
        if (serToBind == null || serToBind.length() <= 0) {
            return;
        }
        Document dom = target.getDOM();
        Type xuiTargetType = target;
        boolean wasBlocked = dom.getUndoManager().isBlocked();
        dom.getUndoManager().blockInput(true);
        try {
            dom.getKeyKeyRefManager().setBlockEvents(true);
            dom.getController().getErrorController().setBlocked(true);
            dom.setPasteMode(true);
            KeyKeyRefManager.deRegisterKeyKeyRefStructure(xuiTargetType, true);
            if (dom.getGlobalDefinition().isShowingTree() && releaseVisualizer && TypeVisualizerFactory.getInstance().getVisualizer(xuiTargetType, false) != null) {
                TypeVisualizerFactory.getInstance().removeVisualizerStructure(TypeVisualizerFactory.getInstance().getVisualizer(xuiTargetType, false), true);
            }
            dom.itCache = new DoubleKeyHashtableUnsynced(100);
            dom.xpCache = new DoubleKeyHashtableUnsynced(100);
            dom.parentCache = new DoubleKeyHashtableUnsynced(100);
            if (xuiTargetType.isList() && isAdding) {
                ((ListType)xuiTargetType).bind(dom, DOMHelper.createDocument(serToBind).getDocumentElement(), false, false);
            } else {
                xuiTargetType.bind(dom, DOMHelper.createDocument(serToBind).getDocumentElement(), false);
            }
            dom.getKeyKeyRefManager().registerAllKeyAndKeyRefs(dom.getRootType());
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        finally {
            dom.setPasteMode(false);
            dom.getKeyKeyRefManager().setBlockEvents(false);
            dom.getController().getErrorController().setBlocked(false);
            dom.itCache = null;
            dom.xpCache = null;
            dom.parentCache = null;
        }
        if (!wasBlocked) {
            dom.getUndoManager().blockInput(false);
        }
        dom.getUndoManager().addPasteUndoableEditEvent(this, xuiTargetType, serToBind, oldValue, false);
        ClipBoard.removeNotWantedTypeProperties(xuiTargetType);
        dom._lastDomUpdateTime = System.currentTimeMillis();
    }

    public static void removeNotWantedTypeProperties(Type type) {
        Vector<Type> childsToProcess = new Vector<Type>();
        childsToProcess.add(type);
        for (int c = 0; c < childsToProcess.size(); ++c) {
            Type aType = (Type)childsToProcess.get(c);
            if (!aType.isSimple() && aType.getXUIDefinition(true) != null && aType.getStyle().isUserModifiedSerialization()) {
                aType.removeClientProperty("userChangedSerialize");
                aType.setApplicationRequired(false);
            }
            childsToProcess.addAll(aType.getDirectChildren());
        }
    }

    public void pasteNLS(CopyTypeWrapper wrapper, Type targetType, NLS nls) {
        String targetXPath = null;
        String sourceXPath = null;
        targetXPath = targetType.getParent("component").getDirectChildValue("xpath");
        if (targetXPath == null || targetXPath.equals("")) {
            targetXPath = ((Type)targetType.getUserObject()).getXPathLocation();
        }
        if ((sourceXPath = wrapper.getNLSSourceXPathLocation()) == null || sourceXPath.equals("")) {
            sourceXPath = wrapper.getUserObjectXPathLocation();
        }
        if (targetType.getName().equals("component")) {
            nls.copyAllNLS(sourceXPath, targetXPath);
        }
    }

    public void handleStyleNLS(Type sourceType, Type targetType, String sourceXPath, String targetXPath, NLS nls) {
        String sourceNLSKey = null;
        String targetNLSKey = null;
        String nlsContext = NLS.getContext(targetType);
        if ("validationMessage".equals(nlsContext)) {
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "validationMessage", null, null);
            targetNLSKey = NLS.nlsKey(null, targetXPath, "validationMessage", null, null);
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
        } else if ("caption".equals(nlsContext)) {
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "caption", null, null);
            targetNLSKey = NLS.nlsKey(null, targetXPath, "caption", null, null);
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "caption", null, "tooltip");
            targetNLSKey = NLS.nlsKey(null, targetXPath, "caption", null, "tooltip");
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
        } else if (targetType.getName().equals("choice")) {
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "label", null, "tooltip");
            targetNLSKey = NLS.nlsKey(null, targetXPath, "label", null, "tooltip");
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
            Type sourceChoiceTypes = (Type)sourceType.getParent("component").getUserObject();
            List sourceChilds = sourceChoiceTypes.getDirectChildren();
            Type targetChoiceTypes = (Type)targetType.getParent("component").getUserObject();
            List targetChilds = targetChoiceTypes.getDirectChildren();
            for (int i = 0; i < sourceChilds.size(); ++i) {
                Type targetChildType = (Type)targetChilds.get(i);
                Type targetChildXUIType = targetChildType.getXUIDefinition().getXUIType();
                Type sourceChildType = (Type)sourceChilds.get(i);
                Type sourceChildXUIType = sourceChildType.getXUIDefinition().getXUIType();
                targetXPath = targetChildXUIType != null ? targetChildXUIType.getParent("component").getDirectChildValue("xpath") : targetChildType.getXPathLocation();
                sourceXPath = sourceChildXUIType != null ? sourceChildXUIType.getParent("component").getDirectChildValue("xpath") : sourceChildType.getXPathLocation();
                sourceNLSKey = NLS.nlsKey(null, sourceXPath, NLS.getContext(targetType), "choice", null);
                targetNLSKey = NLS.nlsKey(null, targetXPath, NLS.getContext(targetType), "choice", null);
                nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
            }
        } else if ("treeEntry".equals(nlsContext)) {
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "treeEntry", null, null);
            targetNLSKey = NLS.nlsKey(null, targetXPath, "treeEntry", null, null);
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "treeEntry", null, "tooltip");
            targetNLSKey = NLS.nlsKey(null, targetXPath, "treeEntry", null, "tooltip");
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
        } else if ("label".equals(nlsContext)) {
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "label", null, null);
            targetNLSKey = NLS.nlsKey(null, targetXPath, "label", null, null);
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
            sourceNLSKey = NLS.nlsKey(null, sourceXPath, "label", null, "tooltip");
            targetNLSKey = NLS.nlsKey(null, targetXPath, "label", null, "tooltip");
            nls.copyNLSWithKey(sourceNLSKey, targetNLSKey);
        }
    }

    public boolean canPaste(Type type) {
        return this.canPaste(type, true);
    }

    public boolean canPasteInXuiEditor(Type type, boolean bruteforce) {
        CopyTypeWrapper wrapper = this.createCopyTypeWrapper();
        this.setCopyTypeWrapper(wrapper);
        boolean canPaste = true;
        if (type != null) {
            if (!bruteforce) {
                canPaste = this.canPasteInTypeHirachie(wrapper, type);
            }
            canPaste = canPaste && !type.getStyle().isSelectionOnly();
            canPaste = canPaste && !type.getStyle().isReadOnly();
            canPaste = canPaste && type.getStyle().isEditable();
        }
        return canPaste;
    }

    private CopyTypeWrapper createCopyTypeWrapper() {
        CopyTypeWrapper wrapper = null;
        Clipboard sysClip = null;
        try {
            try {
                sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Throwable t) {
                if (this._serverStringSelection != null) {
                    wrapper = new CopyTypeWrapper(this._serverStringSelection.getTransferData(DataFlavor.stringFlavor).toString());
                    return wrapper;
                }
                return null;
            }
            Transferable transferContent = sysClip.getContents(null);
            if (transferContent == null) {
                return null;
            }
            for (int i = 0; i < transferContent.getTransferDataFlavors().length; ++i) {
                if (transferContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    wrapper = new CopyTypeWrapper(transferContent.getTransferData(DataFlavor.stringFlavor).toString());
                } else {
                    if (!transferContent.isDataFlavorSupported(SimpleClipboardSelection.dataFlavor)) continue;
                    wrapper = (CopyTypeWrapper)transferContent.getTransferData(SimpleClipboardSelection.dataFlavor);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wrapper;
    }

    public boolean canPaste(Type type, boolean bruteforce) {
        if (type == null) {
            return false;
        }
        CopyTypeWrapper wrapper = this.createCopyTypeWrapper();
        this.setCopyTypeWrapper(wrapper);
        if (wrapper == null) {
            return false;
        }
        boolean canPaste = true;
        if (!bruteforce) {
            canPaste = this.canPasteInTypeHirachie(wrapper, type);
        }
        canPaste = canPaste && !type.getStyle().isSelectionOnly();
        canPaste = canPaste && !type.getStyle().isReadOnly();
        boolean bl = canPaste = canPaste && type.getStyle().isEditable();
        if (type.getParent() != null && type.getParent().isList()) {
            canPaste = canPaste && !type.getParent().getStyle().isSelectionOnly();
        }
        return canPaste;
    }

    public boolean canPasteInTypeHirachie(CopyTypeWrapper wrapper, Type type) {
        boolean canPaste = false;
        if (type != null && wrapper != null) {
            if (wrapper.isStringOnlyMode()) {
                if (type.getQName().equals(wrapper.getQName())) {
                    canPaste = true;
                }
            } else if (type.getClass().equals(wrapper.getClonedClass())) {
                if (type.getName().equals(wrapper.getQName())) {
                    canPaste = true;
                } else {
                    String scTypeQName = type.getSchemaElement().getSchemaType().getQName();
                    String scTypeRefName = type.getSchemaType().getRefName();
                    String scTypeName = type.getSchemaType().getName();
                    String scElementRefName = type.getSchemaElement().getRefName();
                    if (scTypeQName.equals("(no name)") || scTypeQName.equals("(no name)")) {
                        canPaste = false;
                    } else if (scTypeQName.equals(wrapper.getSchemaTypeQName())) {
                        canPaste = !(scTypeQName.equals("xs:anyType") || scTypeQName.equals("xsd:anyType") || scTypeName.equalsIgnoreCase("anyType"));
                    } else if (scElementRefName != null && scElementRefName.equals(wrapper.getSchemaRefName())) {
                        canPaste = true;
                    } else if (scTypeRefName != null && scTypeRefName.equals(wrapper.getSchemaRefName())) {
                        canPaste = true;
                    } else if (scTypeRefName != null && scTypeRefName.equals(wrapper.getSchemaTypeQName())) {
                        canPaste = true;
                    }
                }
            }
        }
        return canPaste;
    }

    public void release() {
        this._copyTypeWrapper = null;
    }

    public CopyTypeWrapper getCopyTypeWrapper() {
        return this._copyTypeWrapper;
    }

    private void setCopyTypeWrapper(CopyTypeWrapper wrapper) {
        this._copyTypeWrapper = wrapper;
    }

    public Type getViewHolderType(Type smartType) {
        Type viewHolder = null;
        if (smartType != null) {
            if (smartType.getStyle().isParentViewHolder()) {
                if (smartType.isRepresentedAsTab()) {
                    Type representedTabHolder = this.getRepresentedTabHolder(smartType);
                    viewHolder = representedTabHolder == smartType ? smartType : this.getViewHolderType(representedTabHolder);
                } else if (smartType.isRepresentedAsHeader()) {
                    Type parent;
                    if (smartType.getParent() != null && (parent = smartType.getParent()).getRepresentedTreeNodeParent() != null) {
                        viewHolder = this.getViewHolderType(parent);
                    }
                } else {
                    viewHolder = this.checkTableLayoutParentVisualizer(smartType, null);
                }
                if (viewHolder == null) {
                    viewHolder = smartType.getParent() != null ? this.getViewHolderType(smartType.getParent()) : smartType;
                }
            } else if (!smartType.getStyle().isParentViewHolder()) {
                viewHolder = smartType;
            }
        }
        return viewHolder;
    }

    private Type getRepresentedTabHolder(Type tabbedType) {
        Type parent;
        if (tabbedType != null && tabbedType.getParent() != null && (parent = tabbedType.getParent()).getStyle().isTabHolder()) {
            if (parent.isRepresentedAsTab()) {
                return this.getRepresentedTabHolder(parent);
            }
            if (parent.getRepresentedTreeNodeParent() != null) {
                return parent.getRepresentedTreeNodeParent();
            }
        }
        return tabbedType;
    }

    private Type checkTableLayoutParentVisualizer(Type type, Type selection) {
        Type treeParent;
        Type tableParent = type.getRepresentedTableLayoutParent();
        if (tableParent != null && tableParent.getParent() != null && (treeParent = tableParent.getParent().getRepresentedTreeNodeParent()) != null) {
            if (selection == null) {
                selection = type;
            }
            return treeParent;
        }
        return null;
    }

    public static String serializeWithEmpty(Type type) {
        boolean oldValue = type.getDOM().getGlobalDefinition().isSerializingEmptyContent();
        type.getDOM().getGlobalDefinition().setSerializingEmptyContent(true);
        String ser = type.serialize().toString();
        type.getDOM().getGlobalDefinition().setSerializingEmptyContent(oldValue);
        return ser;
    }
}

