/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;

public class RowHeaderRenderer
extends JLabel
implements ListCellRenderer {
    private JTable myTable;
    private Border mySelectedBorder;
    private Border myNormalBorder;
    private Font mySelectedFont;
    private Font myNormalFont;

    public RowHeaderRenderer(JTable table) {
        this.myTable = table;
        this.myNormalBorder = UIManager.getBorder("TableHeader.cellBorder");
        this.mySelectedBorder = BorderFactory.createRaisedBevelBorder();
        JTableHeader header = table.getTableHeader();
        this.myNormalFont = header.getFont();
        this.mySelectedFont = this.myNormalFont.deriveFont(this.myNormalFont.getStyle() | 1);
        this.setForeground(header.getForeground());
        this.setBackground(header.getBackground());
        this.setOpaque(true);
        this.setHorizontalAlignment(4);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.myTable.getSelectionModel().isSelectedIndex(index)) {
            this.setFont(this.mySelectedFont);
            this.setBorder(this.mySelectedBorder);
        } else {
            this.setFont(this.myNormalFont);
            this.setBorder(this.myNormalBorder);
        }
        if (isSelected && cellHasFocus) {
            this.myTable.editingCanceled(new ChangeEvent(this.myTable));
            this.myTable.setSelectionBackground(this.myTable.getSelectionBackground());
            this.myTable.setSelectionForeground(this.myTable.getSelectionForeground());
            if (this.myTable.getColumnCount() > 0) {
                this.myTable.setColumnSelectionInterval(0, this.myTable.getColumnCount() - 1);
            }
        }
        this.setText(value + "");
        return this;
    }
}

