/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.util.Hashtable;

public class CachedHashTable
extends Hashtable {
    static Object[] cache_keys = new Object[128];
    static Object[] cache_values = new Object[128];

    public static void main(String[] args) {
        try {
            CachedHashTable cached = new CachedHashTable();
            System.out.println("started populating");
            cached.populate();
            System.out.println("started accessing");
            cached.access_test();
            cached.access_test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void populate() {
        for (int i = 0; i < 100000; ++i) {
            this.put(new Integer(i), new Integer(i + 5));
        }
    }

    public Object get(Object key) {
        int access = Math.abs(key.hashCode()) & 0x7F;
        Object o = cache_keys[access];
        if (o == null || !o.equals(key)) {
            if (o != null) {
                System.out.println("Collsion between " + o + " and " + key);
            }
            o = super.get(key);
            CachedHashTable.cache_keys[access] = key;
            CachedHashTable.cache_values[access] = o;
            return o;
        }
        return cache_values[access];
    }

    public void access_test() {
        Object o0;
        Object o9;
        Object o8;
        Object o7;
        Object o6;
        Object o5;
        Object o4;
        Object o3;
        Object o2;
        Object o1;
        int i;
        Integer a0 = new Integer(6767676);
        Integer a1 = new Integer(33);
        Integer a2 = new Integer(998);
        Integer a3 = new Integer(3333);
        Integer a4 = new Integer(12348765);
        Integer a5 = new Integer(9999);
        Integer a6 = new Integer(66665);
        Integer a7 = new Integer(1234);
        Integer a8 = new Integer(987654);
        Integer a9 = new Integer(3121219);
        long time = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            o1 = this.get(a0);
            o2 = this.get(a1);
            o3 = this.get(a2);
            o4 = this.get(a3);
            o5 = this.get(a4);
            o6 = this.get(a5);
            o7 = this.get(a6);
            o8 = this.get(a7);
            o9 = this.get(a8);
            o0 = this.get(a9);
        }
        System.out.println("cached access took " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            o1 = super.get(a0);
            o2 = super.get(a1);
            o3 = super.get(a2);
            o4 = super.get(a3);
            o5 = super.get(a4);
            o6 = super.get(a5);
            o7 = super.get(a6);
            o8 = super.get(a7);
            o9 = super.get(a8);
            o0 = super.get(a9);
        }
        System.out.println("plain access took " + (System.currentTimeMillis() - time));
    }
}

