/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.DoubleKeyHashtable;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DoubleKeyHashtableUnsynced
extends DoubleKeyHashtable
implements Cloneable,
Serializable {
    public DoubleKeyHashtableUnsynced(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new DoubleKeyHashtable.Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public DoubleKeyHashtableUnsynced(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleKeyHashtableUnsynced() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return this.getEnumeration(0);
    }

    public Enumeration elements() {
        return this.getEnumeration(1);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        DoubleKeyHashtable.Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            DoubleKeyHashtable.Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(Object key1, Object key2) {
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(key1) && e.key2.equals(key2)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key, Object key2) {
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = key.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(key) && e.key2.equals(key2)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object get(DoubleKeyHashtable.Entry keyEntry) {
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = keyEntry.hash;
        int hash2 = keyEntry.hash2;
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(keyEntry.key) && e.key2.equals(keyEntry.key2)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        DoubleKeyHashtable.Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        DoubleKeyHashtable.Entry[] newMap = new DoubleKeyHashtable.Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            DoubleKeyHashtable.Entry old = oldMap[i];
            while (old != null) {
                DoubleKeyHashtable.Entry e = old;
                old = old.next;
                int index = ((e.hash ^ e.hash2) & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(Object key1, Object key2, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(key1) && e.key2.equals(key2)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (compHash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new DoubleKeyHashtable.Entry(hash1, key1, hash2, key2, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object removeValue(Object value) {
        Iterator entries = this.entrySet().iterator();
        DoubleKeyHashtable.Entry aEntryToRemove = null;
        while (entries.hasNext()) {
            DoubleKeyHashtable.Entry aEntry = (DoubleKeyHashtable.Entry)entries.next();
            if (aEntry.getValue() != value) continue;
            aEntryToRemove = aEntry;
            break;
        }
        if (aEntryToRemove != null) {
            return this.remove(aEntryToRemove);
        }
        return null;
    }

    public Object remove(Object key1, Object key2) {
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        DoubleKeyHashtable.Entry prev = null;
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(key1) && e.key2.equals(key2)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public Object remove(DoubleKeyHashtable.Entry aEntry) {
        DoubleKeyHashtable.Entry[] tab = this.table;
        int hash1 = aEntry.hash;
        int hash2 = aEntry.hash2;
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        DoubleKeyHashtable.Entry e = tab[index];
        DoubleKeyHashtable.Entry prev = null;
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(aEntry.getKey()) && e.key2.equals(aEntry.getKey2())) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int removePrimary(Object key) {
        Vector<DoubleKeyHashtable.Entry> entriesToRemove = new Vector<DoubleKeyHashtable.Entry>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            DoubleKeyHashtable.Entry element = (DoubleKeyHashtable.Entry)compK.nextElement();
            if (!element.key.equals(key)) continue;
            entriesToRemove.add(element);
        }
        for (int e = 0; e < entriesToRemove.size(); ++e) {
            this.remove((DoubleKeyHashtable.Entry)entriesToRemove.get(e));
        }
        return entriesToRemove.size();
    }

    public List getPrimary(Object key) {
        Vector<Object> entriesToRemove = new Vector<Object>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            DoubleKeyHashtable.Entry element = (DoubleKeyHashtable.Entry)compK.nextElement();
            if (element.key != key && !element.key.equals(key)) continue;
            entriesToRemove.add(element.value);
        }
        return entriesToRemove;
    }

    public List getSecondary(Object key) {
        Vector<Object> entriesToRemove = new Vector<Object>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            DoubleKeyHashtable.Entry element = (DoubleKeyHashtable.Entry)compK.nextElement();
            if (element.key2 != key && !element.key2.equals(key)) continue;
            entriesToRemove.add(element.value);
        }
        return entriesToRemove;
    }

    public int removeSecondary(Object key) {
        Vector<DoubleKeyHashtable.Entry> entriesToRemove = new Vector<DoubleKeyHashtable.Entry>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            DoubleKeyHashtable.Entry element = (DoubleKeyHashtable.Entry)compK.nextElement();
            if (!element.key2.equals(key)) continue;
            entriesToRemove.add(element);
        }
        for (int e = 0; e < entriesToRemove.size(); ++e) {
            this.remove((DoubleKeyHashtable.Entry)entriesToRemove.get(e));
        }
        return entriesToRemove.size();
    }

    public void clear() {
        DoubleKeyHashtable.Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            DoubleKeyHashtableUnsynced t = (DoubleKeyHashtableUnsynced)super.clone();
            t.table = new DoubleKeyHashtable.Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (DoubleKeyHashtable.Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Iterator it = this.entrySet().iterator();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            DoubleKeyHashtable.Entry e = (DoubleKeyHashtable.Entry)it.next();
            Object key = e.getKey();
            Object key2 = e.getKey2();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + ";" + (key2 == this ? "(this Map)" : key2) + "=" + (value == this ? "(this Map)" : value));
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public List primaryKeys() {
        Iterator pKeys = this.keySet().iterator();
        Vector<Object> result = new Vector<Object>(this.keySet().size());
        while (pKeys.hasNext()) {
            DoubleKeyHashtable.Entry eObject = (DoubleKeyHashtable.Entry)pKeys.next();
            result.add(eObject.getKey());
        }
        return result;
    }

    public List secondaryKeys(Object primKey) {
        Iterator pKeys = this.keySet().iterator();
        Vector<Object> result = new Vector<Object>(this.keySet().size());
        while (pKeys.hasNext()) {
            DoubleKeyHashtable.Entry eObject = (DoubleKeyHashtable.Entry)pKeys.next();
            if (!eObject.getKey().equals(primKey)) continue;
            result.add(eObject.getKey2());
        }
        return result;
    }

    public List secondaryKeys() {
        Iterator pKeys = this.keySet().iterator();
        Vector<Object> result = new Vector<Object>(this.keySet().size());
        while (pKeys.hasNext()) {
            DoubleKeyHashtable.Entry eObject = (DoubleKeyHashtable.Entry)pKeys.next();
            result.add(eObject.getKey2());
        }
        return result;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new DoubleKeyHashtable.EntrySet();
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new DoubleKeyHashtable.ValueCollection();
        }
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        DoubleKeyHashtable.Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            DoubleKeyHashtable.Entry e = tab[i];
            while (e != null) {
                h += e.key.hashCode() ^ e.key2.hashCode() ^ e.value.hashCode();
                e = e.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    public void test() {
        DoubleKeyHashtableUnsynced dh = new DoubleKeyHashtableUnsynced();
        int length = 4000;
        String[] k1 = new String[length];
        for (int i = 0; i < k1.length; ++i) {
            k1[i] = new String("k1-" + i);
        }
        String[] k2 = new String[length];
        for (int i = 0; i < k2.length; ++i) {
            k2[i] = new String("k2-" + i);
        }
        String[] v = new String[length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new String("v-" + i);
        }
        dh.clear();
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        Hashtable<String, String> ah = new Hashtable<String, String>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < v.length; ++i) {
            ah.put(this.createTestStringKey(k1[i], k2[i]), v[i]);
        }
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v.length; ++i) {
                ah.get(this.createTestStringKey(k1[i], k2[i]));
            }
        }
        long start2 = System.currentTimeMillis();
        System.out.println("ht:" + (start2 - start));
        ah = null;
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        start2 = System.currentTimeMillis();
        for (int i = 0; i < v.length; ++i) {
            dh.put(k1[i], k2[i], v[i]);
        }
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v.length; ++i) {
                dh.get(k1[i], k2[i]);
            }
        }
        long end = System.currentTimeMillis();
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("dt:" + (end - start2));
    }

    public String createTestStringKey(String a, String b) {
        return a + b;
    }

    public static void main(String[] args) {
        new DoubleKeyHashtableUnsynced().test();
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return DoubleKeyHashtableUnsynced.this.getIterator(0);
        }

        public int size() {
            return DoubleKeyHashtableUnsynced.this.count;
        }

        public boolean contains(Object o1, Object o2) {
            return DoubleKeyHashtableUnsynced.this.containsKey(o1, o2);
        }

        public boolean remove(Object o, Object o2) {
            return DoubleKeyHashtableUnsynced.this.remove(o, o2) != null;
        }

        public void clear() {
            DoubleKeyHashtableUnsynced.this.clear();
        }
    }
}

