/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.NLS;

public class GUIComponentNLS {
    private static GUIComponentNLS _singleton;
    private CodeTables _codeTables;

    private GUIComponentNLS() {
    }

    public static synchronized GUIComponentNLS getInstance() {
        if (_singleton == null) {
            _singleton = new GUIComponentNLS();
        }
        return _singleton;
    }

    public String getNLSText(String language, String keyName, String defaultName, String[] variables) {
        String text = JAXFrontProperties.getInstance().getNLS(language).get(null, keyName, variables);
        if (text == null) {
            text = variables != null && defaultName != null ? NLS.replaceVariables(defaultName, variables) : defaultName;
        }
        return text;
    }

    public String getNLSText(Document dom, String keyName, String defaultName, String[] variables) {
        String text = null;
        if (dom != null) {
            if (dom.getUser() != null) {
                text = dom.getUser().getNLS(keyName, variables, false);
            }
            if (text == null) {
                text = this.getNLSText(dom.getLanguage(), keyName, defaultName, variables);
            }
        } else {
            text = this.getNLSText(keyName, defaultName);
        }
        return text;
    }

    public String getNLSText(String language, String keyName, String defaultName) {
        return this.getNLSText(language, keyName, defaultName, null);
    }

    public String getNLSText(Document dom, String keyName, String defaultName) {
        return this.getNLSText(dom, keyName, defaultName, null);
    }

    public String getNLSText(String keyName, String defaultName) {
        return this.getNLSText((String)null, keyName, defaultName, null);
    }

    public String getNLSNoneText(Document dom) {
        String key = "button_none";
        String defaultValue = "None";
        if (dom.isXUIDOMInstance()) {
            key = "xui_" + key;
            defaultValue = "xui_" + defaultValue;
        }
        return GUIComponentNLS.getInstance().getNLSText(dom, key, defaultValue);
    }
}

