/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.util.IntroSpectionHelper;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;

public class IntrospectionMethodParameter
implements Serializable {
    private String _className;
    private String _value;
    public static final String TYPE_BOOLEAN = "java.lang.Boolean";
    public static final String TYPE_STRING = "java.lang.String";
    public static final String TYPE_STRING_ARRAY = "java.lang.String[]";
    public static final String TYPE_INTEGER = "java.lang.Integer";
    public static final String TYPE_BOOLEAN_PRIMITIVE = "boolean";
    public static final String TYPE_INTEGER_PRIMITIVE = "int";
    public static final String TYPE_INT_ARRAY = "int[]";

    public IntrospectionMethodParameter(String className, String value) {
        this._className = className;
        if (value != null) {
            this._value = value;
        }
    }

    private Object createIntArray(String intArrayString) {
        StringTokenizer st = new StringTokenizer(intArrayString, ",");
        int[] intArray = new int[st.countTokens()];
        int counter = 0;
        while (st.hasMoreElements()) {
            String intString = st.nextToken();
            intArray[counter] = new Integer(intString);
            ++counter;
        }
        return intArray;
    }

    private Object createStringArray(String stringArrayString) {
        StringTokenizer st = new StringTokenizer(stringArrayString, ",");
        String[] stringArray = new String[st.countTokens()];
        int counter = 0;
        while (st.hasMoreElements()) {
            stringArray[counter] = st.nextToken();
            ++counter;
        }
        return stringArray;
    }

    public Class getParameterClass() {
        if (this._className != null) {
            Class aClass = IntroSpectionHelper.getParameterClass(this._className);
            if (aClass != null) {
                return aClass;
            }
            LogRegistry.getInstance().error(this.getClass(), "class not found:" + this._className);
        }
        return null;
    }

    public Object getParameterValue() {
        Object returnValue = null;
        if (this._className != null) {
            returnValue = this._value != null && this._value.length() > 0 ? (this._className.equals(TYPE_BOOLEAN) ? new Boolean(this._value) : (this._className.equals(TYPE_BOOLEAN_PRIMITIVE) ? new Boolean(this._value) : (this._className.equals(TYPE_STRING_ARRAY) ? this.createStringArray(this._value) : (this._className.equals(TYPE_STRING) ? new String(this._value) : (this._className.equals(TYPE_INTEGER) ? new Integer(this._value) : (this._className.equals(TYPE_INTEGER_PRIMITIVE) ? new Integer(this._value) : (this._className.equals(TYPE_INT_ARRAY) ? this.createIntArray(this._value) : IntroSpectionHelper.getParameterObject(this._className, this._value)))))))) : (this._className.equals(TYPE_BOOLEAN) ? Boolean.FALSE : (this._className.equals(TYPE_BOOLEAN_PRIMITIVE) ? Boolean.FALSE : (this._className.equals(TYPE_STRING_ARRAY) ? new String[]{} : (this._className.equals(TYPE_STRING) ? new String("") : (this._className.equals(TYPE_INTEGER) ? new Integer(0) : (this._className.equals(TYPE_INTEGER_PRIMITIVE) ? new Integer(0) : (this._className.equals(TYPE_INT_ARRAY) ? (Object)new int[0] : IntroSpectionHelper.getParameterObject(this._className, null))))))));
        }
        return returnValue;
    }

    public static Class[] getParameterClasses(MethodParameter[] _methodParameters) {
        Class[] classes = null;
        if (_methodParameters != null) {
            classes = new Class[_methodParameters.length];
            for (int i = 0; i < _methodParameters.length; ++i) {
                classes[i] = _methodParameters[i].getParameterClass();
            }
        }
        return classes;
    }

    public static Object[] getParameters(MethodParameter[] _methodParameters) {
        Object[] objects = null;
        if (_methodParameters != null) {
            objects = new Object[_methodParameters.length];
            for (int i = 0; i < _methodParameters.length; ++i) {
                objects[i] = _methodParameters[i].getParameterValue();
            }
        }
        return objects;
    }

    public static Class[] getParameterClasses(List methodParameters) {
        Class[] classes = null;
        if (methodParameters != null) {
            classes = new Class[methodParameters.size()];
            for (int i = 0; i < methodParameters.size(); ++i) {
                classes[i] = ((IntrospectionMethodParameter)methodParameters.get(i)).getParameterClass();
            }
        }
        return classes;
    }

    public static Object[] getParameters(List methodParameters) {
        Object[] objects = null;
        if (methodParameters != null) {
            objects = new Object[methodParameters.size()];
            for (int i = 0; i < methodParameters.size(); ++i) {
                objects[i] = ((IntrospectionMethodParameter)methodParameters.get(i)).getParameterValue();
            }
        }
        return objects;
    }
}

