/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.LinkedMapProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;

public class LinkedLanguageEnhancedProperties
extends LinkedMapProperties {
    protected LinkedLanguageEnhancedProperties defaults;
    private static final String keyValueSeparators = "= \t\r\n\f";
    private static final String strictKeyValueSeparators = "=";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LinkedLanguageEnhancedProperties() {
        this((LinkedLanguageEnhancedProperties)null);
    }

    public LinkedLanguageEnhancedProperties(LinkedLanguageEnhancedProperties defaults) {
        this.defaults = defaults;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        String line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            char firstChar;
            int keyStart;
            if (line.length() <= 0) continue;
            int len = line.length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len || (firstChar = line.charAt(keyStart)) == '#' || firstChar == '!') continue;
            while (this.continueLine(line)) {
                int startIndex;
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
                len = line.length();
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            this.put(TextTools.unEscapeNLSEntities(key), TextTools.unEscapeNLSEntities(value));
        }
        return;
    }

    public synchronized void load(Reader input) throws IOException {
        BufferedReader in = new BufferedReader(input);
        String line;
        while ((line = in.readLine()) != null) {
            int valueIndex;
            int separatorIndex;
            char firstChar;
            int keyStart;
            if (line.length() <= 0) continue;
            int len = line.length();
            for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
            }
            if (keyStart == len || (firstChar = line.charAt(keyStart)) == '#' || firstChar == '!') continue;
            while (this.continueLine(line)) {
                int startIndex;
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
                len = line.length();
            }
            for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                    continue;
                }
                if (keyValueSeparators.indexOf(currentChar) != -1) break;
            }
            for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            this.put(TextTools.unEscapeNLSEntities(key), TextTools.unEscapeNLSEntities(value));
        }
        return;
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public synchronized void save(OutputStream out, String header) {
        try {
            this.store(new OutputStreamWriter(out), header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        this.store(new OutputStreamWriter(out, JAXFrontProperties.getDefaultFileEncoding()), header);
    }

    public synchronized void store(Writer out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(out);
        if (header != null) {
            LinkedLanguageEnhancedProperties.writeln(awriter, "#" + header);
        }
        LinkedLanguageEnhancedProperties.writeln(awriter, "#" + new Date().toString());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            LinkedLanguageEnhancedProperties.writeln(awriter, TextTools.escapeNLSEntities(key) + strictKeyValueSeparators + TextTools.escapeNLSEntities(val));
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }
}

