/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IListeEntry;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.NLS;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ListEntry
implements IListeEntry {
    public static final Comparator VALUE_COMPARATOR = new ListEntry("").new ListEntryValueComparator();
    private String[] _resultInfo;
    private Object _key;
    private Object[] _value;

    public ListEntry(Object key, Object value) {
        this(key, value, (String[])null);
    }

    public ListEntry(Object key, Object value, String[] resultInfo) {
        this._key = key;
        this._value = new Object[]{value};
        this._resultInfo = resultInfo;
    }

    public ListEntry(Object key, Object[] values) {
        this(key, values, (String[])null);
    }

    public ListEntry(Object key, Object[] values, String[] resultInfo) {
        this._key = key;
        this._value = values;
        this._resultInfo = resultInfo;
    }

    public ListEntry(String[] values) {
        if (values.length == 1) {
            this._key = values[0];
        } else if (values.length > 1) {
            this._key = values[0];
            this._value = new Object[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                this._value[i - 1] = values[i];
            }
        }
    }

    public ListEntry(String key, String[] values, String[] resultInfo) {
        this._resultInfo = resultInfo;
        this._key = key;
        if (values.length > 0) {
            this._value = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                this._value[i] = values[i];
            }
        }
    }

    public ListEntry(int keyCol, String[] values, String[] resultInfo) {
        this._resultInfo = resultInfo;
        int cols = values.length;
        if (keyCol >= 0 && keyCol < values.length) {
            --cols;
        }
        if (values.length > 0) {
            this._value = new Object[cols];
            int c = 0;
            for (int i = 0; i < values.length; ++i) {
                if (keyCol != i) {
                    this._value[c] = values[i];
                    ++c;
                    continue;
                }
                this._key = values[i];
            }
        }
    }

    public ListEntry(Object key) {
        this._key = key;
    }

    public String getKey() {
        if (this._key != null) {
            return this._key.toString();
        }
        return null;
    }

    public String getValue(String sep) {
        if (this._value == null) {
            return this.getKey();
        }
        if (this._value.length == 0) {
            return "";
        }
        if (this._value.length == 1) {
            return (String)this._value[0];
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this._value.length; ++i) {
            result.append(this._value[i] != null ? this._value[i] : "");
            if (i + 1 >= this._value.length) continue;
            result.append(sep);
        }
        return result.toString();
    }

    public String getValue() {
        return this.getValue(", ");
    }

    public Object getValueObject() {
        if (this._value.length > 0) {
            return this._value[0];
        }
        return null;
    }

    public Object getValue(int index) {
        if (this._value != null && index < this._value.length) {
            return this._value[index];
        }
        return null;
    }

    public String[] getValues() {
        if (this._value != null) {
            return ArrayUtil.toStringArray(this._value);
        }
        return null;
    }

    public String getValueForInfo(String info) {
        int col = this.getIndexForInfo(info);
        if (this._resultInfo != null && this._value != null && this._resultInfo.length > this._value.length) {
            col -= this._resultInfo.length - this._value.length;
        }
        if (col >= 0) {
            return (String)this._value[col];
        }
        return null;
    }

    private int getIndexForInfo(String info) {
        int col = -1;
        for (int i = 0; this._resultInfo != null && i < this._resultInfo.length; ++i) {
            if (!info.equalsIgnoreCase(this._resultInfo[i])) continue;
            col = i;
            break;
        }
        return col;
    }

    public boolean equals(Object obj) {
        if (this._key == obj) {
            return true;
        }
        return obj instanceof ListEntry && this._key.toString().equals(((ListEntry)obj)._key);
    }

    public String toString() {
        return this.getKey();
    }

    public static ListEntry[] toArray(List entries) {
        ListEntry[] res = new ListEntry[entries.size()];
        for (int e = 0; e < res.length; ++e) {
            res[e] = (ListEntry)entries.get(e);
        }
        return res;
    }

    public String toInfo() {
        return this.getKey() + " " + this.getValue();
    }

    public String[] getResultInfo() {
        return this._resultInfo;
    }

    public void setResultInfo(String[] info) {
        this._resultInfo = info;
    }

    public static String getValue(ListEntry[] colums, String name) {
        for (int i = 0; i < colums.length; ++i) {
            ListEntry entry = colums[i];
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static int getIndex(ListEntry[] colums, String name) {
        for (int i = 0; i < colums.length; ++i) {
            ListEntry entry = colums[i];
            if (entry.getKey() == null || !entry.getKey().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static Hashtable toHashtable(List entries, boolean idIsKey) {
        Hashtable<String, String> result = new Hashtable<String, String>(entries.size());
        for (int a = 0; a < entries.size(); ++a) {
            ListEntry le = (ListEntry)entries.get(a);
            if (idIsKey) {
                result.put(le.getKey(), le.getValue());
                continue;
            }
            result.put(le.getValue(), le.getKey());
        }
        return result;
    }

    public static Map addAll(Map aMap, List entries, boolean idIsKey) {
        for (int a = 0; a < entries.size(); ++a) {
            IListeEntry le = (IListeEntry)entries.get(a);
            if (idIsKey) {
                if (le.getKey() == null || le.getValue() == null) continue;
                aMap.put(le.getKey(), le.getValue());
                continue;
            }
            if (le.getKey() == null || le.getValue() == null) continue;
            aMap.put(le.getValue(), le.getKey());
        }
        return aMap;
    }

    public static Hashtable toHashtable(ListEntry[] entries, boolean idIsKey) {
        Hashtable<String, String> result = new Hashtable<String, String>(entries.length);
        for (int a = 0; a < entries.length; ++a) {
            ListEntry le = entries[a];
            if (idIsKey) {
                result.put(le.getKey(), le.getValue());
                continue;
            }
            result.put(le.getValue(), le.getKey());
        }
        return result;
    }

    public static Map toMap(ListEntry[] entries, boolean idIsKey, boolean keepSequence) {
        Map result = null;
        result = keepSequence ? new LinkedHashMap(entries.length) : new Hashtable(entries.length);
        for (int a = 0; a < entries.length; ++a) {
            ListEntry le = entries[a];
            if (idIsKey) {
                result.put(le.getKey(), le.getValue());
                continue;
            }
            result.put(le.getValue(), le.getKey());
        }
        return result;
    }

    public static String[] toStringArray(ListEntry[] entries, boolean useValue) {
        return ListEntry.toStringArray(entries, useValue, null, null);
    }

    public static String[] toStringArray(ListEntry[] entries, boolean useValue, NLS translations, String valPrefix) {
        String[] viStrings = new String[entries.length];
        if (valPrefix == null) {
            valPrefix = "";
        }
        String val = null;
        for (int v = 0; v < entries.length; ++v) {
            if (useValue) {
                val = entries[v].getValue();
                if (translations != null && translations.containsKey(valPrefix + val)) {
                    val = translations.get(valPrefix + val);
                }
                viStrings[v] = val;
                continue;
            }
            val = entries[v].getKey();
            if (translations != null && translations.containsKey(valPrefix + val)) {
                val = translations.get(valPrefix + val);
            }
            viStrings[v] = val;
        }
        return viStrings;
    }

    public static String toString(List entries, boolean useValue, String delim) {
        StringBuffer viStrings = new StringBuffer();
        String val = null;
        for (int v = 0; v < entries.size(); ++v) {
            if (useValue) {
                val = ((ListEntry)entries.get(v)).getValue();
                viStrings.append(val);
            } else {
                val = ((ListEntry)entries.get(v)).getKey();
                viStrings.append(val);
            }
            if (v + 1 >= entries.size()) continue;
            viStrings.append(delim);
        }
        return viStrings.toString();
    }

    public static String toString(ListEntry[] entries, boolean useValue, String delim) {
        StringBuffer viStrings = new StringBuffer();
        String val = null;
        for (int v = 0; v < entries.length; ++v) {
            if (useValue) {
                val = entries[v].getValue();
                viStrings.append(val);
            } else {
                val = entries[v].getKey();
                viStrings.append(val);
            }
            if (v + 1 >= entries.length) continue;
            viStrings.append(delim);
        }
        return viStrings.toString();
    }

    public static String getSearchValue(String name, ListEntry[] searchValues) {
        for (int i = 0; i < searchValues.length; ++i) {
            ListEntry entry = searchValues[i];
            if (entry.getValue() == null || !entry.getValue(1).equals(name)) continue;
            return (String)entry.getValue(0);
        }
        return null;
    }

    public class ListEntryValueComparator
    implements Comparator {
        boolean _asc = true;

        protected int appyDir(int result) {
            if (this._asc) {
                return result;
            }
            return result * -1;
        }

        public int compare(Object o1, Object o2) {
            String val2;
            if (o1 == null && o2 == null) {
                return this.appyDir(0);
            }
            if (o1 == null) {
                return this.appyDir(-1);
            }
            if (o2 == null) {
                return this.appyDir(1);
            }
            int res = 0;
            int pos = 0;
            ++pos;
            String val1 = ((ListEntry)o1).getValue();
            res = val1 == (val2 = ((ListEntry)o2).getValue()) ? 0 : (val1 == null ? -1 : (val2 == null ? 1 : StringUtil.compareNatural(val1, val2)));
            return this.appyDir(res);
        }
    }
}

