/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.DBDOMInput;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontBaseEntityResolver;
import com.jaxfront.core.util.JAXFrontXMLCatalogResolver;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.ls.LSInput;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInfo
implements Cloneable {
    private static final String CONST_DBM = "dbm";
    private static final String CONST_XML = "xml";
    private static final String CONST_UUID = "UUID";
    private static final String CONST_PDF = "pdf";
    private static final String CONST_XUI = "xui";
    private static final String CONST_SLASH = "/";
    private static final String CONST_XSD = "xsd";
    public static final String EFORM_BASE_DBM = "eform_base.dbm";
    public static final String DOM_PROPERTY_RESOURCE_INFO = "resourceInfo";
    public static final String DOM_PROPERTY_INFO_LINK = "infoLink";
    public static final String FORM_INFO_HTML = "formInfo.html";
    public static final String SYSTEM_MANDANT = "SYSTEM";
    public static final String SYSTEM_MANDANT_ID = "0";
    public static final String RESOURCES = "resources";
    public static final String RESOURCES_INTERNAL = "resources/SYSTEM";
    public static final String EFORM_BASE_DBM_LOCATION = "resources/SYSTEM/eform_base.dbm";
    private String _formID;
    private String _groupUUID;
    private String _groupID;
    private String _appGroupID;
    private String _rootNode;
    private String _xsd;
    private String _xml;
    private String _xui;
    private String _xuiPDF;
    private String _dbm;
    private String _domActionControllerClass;
    private LSInput _xsdInput;
    private LSInput _xmlInput;
    private LSInput _xuiInput;
    private LSInput _xuiPdfInput;
    private LSInput _dbmInput;
    private XMLEntityResolver _entityResolver;
    private String _name;
    private String _formVersion;
    private String _category;
    private String _customController;
    private String _resourceMandant;
    private String _resourceMandantID;
    private String _resourceSystemContext;
    private String _basePath;
    private String _systemBaseURI;
    private boolean _active;
    private Date _startDate;
    private Date _expirationDate;
    private org.w3c.dom.Document _resourceDOM;
    private boolean _useStandardDBM;
    private boolean _isSystemForm;
    private boolean _isPublicForm;
    private boolean _showInfoBanner;
    private String _infoBanner;
    private String[][] _fieldAccessRights;
    private boolean _pessimisticLock;
    private boolean _useCustomButtonControls;
    private String _notificationSourceGroup;
    private boolean _isEsurvey = false;
    private HashMap<String, String> _names;
    private HashMap<String, String> _descriptions;
    private String[] _css;

    public ResourceInfo(org.w3c.dom.Document dom, String formID, String groupUUID, String groupID, LSInput xsdInput, LSInput xmlInput, LSInput xuiInput, LSInput xuiPdfInput, LSInput dbmInput, boolean isFileSystemLocation) {
        this._resourceDOM = dom;
        this._formID = formID;
        this._groupUUID = groupUUID;
        this._groupID = groupID;
        this._xsdInput = xsdInput;
        this._xmlInput = xmlInput;
        this._xuiInput = xuiInput;
        this._xuiPdfInput = xuiPdfInput;
        this._dbmInput = dbmInput;
        this._basePath = this.getID();
    }

    public ResourceInfo(org.w3c.dom.Document dom, String formID, String groupUUID, String groupID, String xsd, String xml, String xui, String xuiPDF, String dbm) {
        this._resourceDOM = dom;
        this._formID = formID;
        this._groupUUID = groupUUID;
        this._groupID = groupID;
        this._xsd = xsd;
        this._xml = xml;
        this._xui = xui;
        this._xuiPDF = xuiPDF;
        this._dbm = dbm;
    }

    public void setGeneratedXSD(String xsd) {
        this._xsd = this.getLocation(this.getFormID(), xsd);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getLocation(String formID, String resource) {
        if (resource != null) {
            if (formID == null || formID.length() == 0) {
                return resource;
            }
            return new StringBuffer().append(CONST_SLASH).append(formID).append(CONST_SLASH).append(resource).toString();
        }
        return null;
    }

    public String getFormID() {
        return this._formID;
    }

    public String getFormIDFromResourceDOM() {
        if (this._resourceDOM != null) {
            return DOMHelper.getDocElementValue(this._resourceDOM, CONST_UUID);
        }
        return null;
    }

    public String getDBM() {
        return this._dbm;
    }

    public String getXML() {
        return this._xml;
    }

    public org.w3c.dom.Document getResourceDOM() {
        return this._resourceDOM;
    }

    public String getXSD() {
        return this._xsd;
    }

    public String getXUI() {
        if (this._xui == null && this._xsd != null) {
            this._xui = TextTools.replace(this._xsd, ".xsd", ".xui");
        }
        return this._xui;
    }

    public String getXUIPDF() {
        return this._xuiPDF;
    }

    public String toString() {
        StringBuffer infoString = new StringBuffer();
        infoString.append(StringUtil.newLine);
        infoString.append("formID:");
        infoString.append(this._formID);
        infoString.append("  xsd:");
        infoString.append(this._xsd);
        infoString.append("  xml:");
        infoString.append(this._xml);
        infoString.append("  xui:");
        infoString.append(this._xui);
        infoString.append(StringUtil.newLine);
        infoString.append("xuiPDF:");
        infoString.append(this._xuiPDF);
        infoString.append("  DBM:");
        infoString.append(this._dbm);
        infoString.append("  Base Path:");
        infoString.append(this._basePath);
        infoString.append(StringUtil.newLine);
        return infoString.toString();
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public String getName() {
        return this._name;
    }

    public String getCategory() {
        return this._category;
    }

    public void initFromProcessingInstructions() {
    }

    public String getGroupUUID() {
        return this._groupUUID;
    }

    public String getGroupID() {
        return this._groupID;
    }

    public String getApplicationGroupID() {
        return this._appGroupID;
    }

    public void setApplicationGroupID(String id) {
        this._appGroupID = id;
    }

    public URL buildDBMURL(String realPath, String resourceBase) {
        URL DBMURL = null;
        String relDBMLocation = this.getDBM();
        if (resourceBase != null) {
            if (relDBMLocation == null) {
                String xsdToDBM = this.getXSD();
                xsdToDBM = StringUtil.replace(xsdToDBM, ".xsd", ".dbm");
                DBMURL = URLHelper.getUserURL(new StringBuffer().append(resourceBase).append(xsdToDBM).toString());
                if (DBMURL == null || !URLHelper.urlResourceExist(DBMURL)) {
                    DBMURL = URLHelper.getUserURL(new StringBuffer().append(realPath).append(CONST_SLASH).append(EFORM_BASE_DBM_LOCATION).toString());
                    this._useStandardDBM = true;
                }
            } else {
                URL posDBMURL = URLHelper.getUserURL(new StringBuffer().append(resourceBase).append(relDBMLocation).toString());
                if (posDBMURL == null || !URLHelper.urlResourceExist(posDBMURL)) {
                    DBMURL = URLHelper.getUserURL(new StringBuffer().append(realPath).append(CONST_SLASH).append(EFORM_BASE_DBM_LOCATION).toString());
                    this._useStandardDBM = true;
                }
            }
        } else if (relDBMLocation == null) {
            String xsdToDBM = this.getXSD();
            xsdToDBM = StringUtil.replace(xsdToDBM, ".xsd", ".dbm");
            DBMURL = URLHelper.getUserURL(new StringBuffer().append(realPath).append(xsdToDBM).toString());
            if (DBMURL == null) {
                DBMURL = URLHelper.getUserURL(new StringBuffer().append(realPath).append(CONST_SLASH).append(EFORM_BASE_DBM_LOCATION).toString());
                this._useStandardDBM = true;
            }
        } else {
            DBMURL = URLHelper.getUserURL(new StringBuffer().append(resourceBase).append(relDBMLocation).toString());
            if (DBMURL == null) {
                DBMURL = URLHelper.getUserURL(new StringBuffer().append(realPath).append(CONST_SLASH).append(EFORM_BASE_DBM_LOCATION).toString());
                this._useStandardDBM = true;
            }
        }
        return DBMURL;
    }

    public boolean isUsingStandardDBM() {
        return this._useStandardDBM;
    }

    public void setXUI(String xui) {
        this._xui = xui;
    }

    public void setXSD(String xsd) {
        this._xsd = xsd;
    }

    public void setDOMActionControllerClass(String domActionControllerClassname) {
        this._domActionControllerClass = domActionControllerClassname;
    }

    public String getDOMActionControllerClass() {
        return this._domActionControllerClass;
    }

    public boolean isUsingOwnDefinition() {
        boolean isUsingOwnDefinition = false;
        if (this._resourceDOM != null) {
            try {
                List ownDefinitions = W3CXPathExecuterImpl.getInstance().processXPath(this._resourceDOM.getDocumentElement(), "/FormDefinition/Resource/OwnDefinition");
                if (ownDefinitions.size() > 0) {
                    isUsingOwnDefinition = true;
                }
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return isUsingOwnDefinition;
    }

    public LSInput getDbmInput() {
        String dbmLoc = this.getDBM();
        if (this._dbmInput == null) {
            dbmLoc = this.getDBM() != null ? this.getDBM() : this.convertPathExtension(this.getXSD(), ".xsd", ".dbm");
            this._dbmInput = this.getDBDOMInput(this.buildSystemID(this.getID(), dbmLoc), CONST_DBM);
        }
        return this._dbmInput;
    }

    public static boolean inputExist(LSInput input) {
        Reader aReader = input.getCharacterStream();
        return aReader != null;
    }

    public LSInput getXmlInput() {
        if (this._xmlInput == null && this.getXML() != null) {
            String extension = FileHelper.getFileNameExtension(this.getXML(), false);
            this._xmlInput = this.getDBDOMInput(this.buildSystemID(this.getID(), this.getXML()), extension != null ? extension : CONST_XML);
        }
        return this._xmlInput;
    }

    public LSInput getXsdInput() {
        if (this._xsdInput == null && this.getXSD() != null) {
            String systemID = null;
            String mandantID = this.getResourceMandantID();
            String mandantName = this.getResourceMandant();
            if (this.getXSD() != null && this.getXSD().indexOf("resources/") != -1) {
                systemID = this.getXSD();
                if (TextTools.countCharBetween(this.getXSD(), 0, this.getXSD().length(), '/', 'U') == 1) {
                    mandantID = SYSTEM_MANDANT_ID;
                    mandantName = SYSTEM_MANDANT;
                }
            } else {
                systemID = this.buildSystemID(this.getID(), this.getXSD());
            }
            DBDOMInput input = ResourceInfo.getDBDOMInput(systemID, CONST_XSD, mandantID, mandantName, this.getResourceSystemContext(), this._formVersion, this._systemBaseURI);
            input.setXSDResourceItemName(this.getXSD());
            this._xsdInput = input;
        }
        return this._xsdInput;
    }

    public String getXSDData() throws IOException {
        Reader xsdReader = this.getXsdInput().getCharacterStream();
        return FileHelper.readAsString(xsdReader);
    }

    public String getXUIData() throws IOException {
        Reader xuiReader = this.getXuiInput().getCharacterStream();
        return FileHelper.readAsString(xuiReader);
    }

    private String buildSystemID(String pathPrefix, String name) {
        if (name.startsWith(pathPrefix)) {
            return name;
        }
        if (pathPrefix.endsWith(CONST_SLASH)) {
            return new StringBuffer().append(pathPrefix).append(name).toString();
        }
        return new StringBuffer().append(pathPrefix).append(CONST_SLASH).append(name).toString();
    }

    private String convertPathExtension(String path, String oldExtension, String newExtension) {
        int lastI = path.lastIndexOf(oldExtension);
        if (lastI >= 0) {
            path = new StringBuffer().append(path.substring(0, lastI)).append(newExtension).toString();
        }
        return path;
    }

    public String getID() {
        if (this.getFormID() != null) {
            return new StringBuffer().append("resources/").append(this.getResourceMandant()).append(CONST_SLASH).append(this.getFormID()).append(CONST_SLASH).toString();
        }
        return new StringBuffer().append("resources/").append(this.getResourceMandant()).append(CONST_SLASH).toString();
    }

    public LSInput getXuiInput() {
        if (this._xuiInput == null && this.getXUI() != null) {
            DBDOMInput input = this.getDBDOMInput(this.buildSystemID(this.getID(), this.getXUI()), CONST_XUI);
            this._xuiInput = input;
        }
        return this._xuiInput;
    }

    public LSInput getXuiPdfInput() {
        if (this._xuiPdfInput == null && this.getXUIPDF() != null) {
            DBDOMInput input = this.getDBDOMInput(this.buildSystemID(this.getID(), this.getXUIPDF()), CONST_PDF);
            this._xuiPdfInput = input;
        }
        return this._xuiPdfInput;
    }

    public DBDOMInput getDBDOMInput(String systemID, String type) {
        return ResourceInfo.getDBDOMInput(systemID, type, this.getResourceMandantID(), this.getResourceMandant(), this.getResourceSystemContext(), this._formVersion, this._systemBaseURI);
    }

    public static DBDOMInput getDBDOMInput(String systemID, String type, String mandantID, String mandantName, String systemContext, String version, String baseURI) {
        DBDOMInput input = (DBDOMInput)IntroSpectionHelper.createObject("com.jaxfront.persistency.connection.DBDOMInputImpl", (List)null);
        input.setMandantId(mandantID);
        input.setMandant(mandantName);
        input.setSystemContext(systemContext);
        input.setVersion(version);
        input.setBaseURI(baseURI);
        input.setSystemId(systemID);
        if (type == null) {
            type = FileHelper.getFileNameExtension(systemID, false);
        }
        input.setType(type);
        return input;
    }

    public String[] getCSS() {
        return this._css;
    }

    public void setCSS(String[] css) {
        this._css = css;
    }

    public void setDbmInput(LSInput input) {
        this._dbmInput = input;
    }

    public void setXmlInput(LSInput input) {
        this._xmlInput = input;
    }

    public void setXsdInput(LSInput input) {
        this._xsdInput = input;
    }

    public boolean isSystemForm() {
        return this._isSystemForm;
    }

    public void setXuiInput(LSInput input) {
        this._xuiInput = input;
    }

    public void setXuiPdfInput(LSInput pdfInput) {
        this._xuiPdfInput = pdfInput;
    }

    private void setEntityResolver(XMLEntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public XMLEntityResolver getEntityResolver() {
        if (this._entityResolver == null) {
            Class[] params = new Class[]{this.getClass()};
            Object[] parVals = new Object[]{this};
            JAXFrontBaseEntityResolver resolver = (JAXFrontBaseEntityResolver)((Object)IntroSpectionHelper.createObject("com.jaxfront.persistency.JAXFrontEntityResolver", params, parVals));
            this.setEntityResolver((XMLEntityResolver)new JAXFrontXMLCatalogResolver((XMLEntityResolver)resolver));
        }
        return this._entityResolver;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setExpirationDate(Date expiryDate) {
        this._expirationDate = expiryDate;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public HashMap<String, String> getNames() {
        return this._names;
    }

    public HashMap<String, String> getDescription() {
        return this._descriptions;
    }

    public void setNames(HashMap<String, String> names) {
        this._names = names;
    }

    public void setDescriptions(HashMap<String, String> descriptions) {
        this._descriptions = descriptions;
    }

    public boolean isActive() {
        return this._active;
    }

    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public boolean isExpired() {
        if (this._expirationDate != null) {
            if (this._startDate != null && this._startDate.after(new Date())) {
                return true;
            }
            if (this._expirationDate.before(new Date())) {
                return true;
            }
        } else if (this._startDate != null && this._startDate.after(new Date())) {
            return true;
        }
        return false;
    }

    public String getResourceMandant() {
        return this._resourceMandant;
    }

    public String getResourceMandantID() {
        return this._resourceMandantID;
    }

    public void setResourceMandant(String mandant) {
        if (this._resourceMandant != null && !this._resourceMandant.equals(mandant)) {
            throw new NullPointerException(new StringBuffer().append("not modifiable").append(this._resourceMandant).toString());
        }
        this._resourceMandant = mandant;
    }

    public void setResourceMandantID(String id) {
        if (this._resourceMandantID != null && !this._resourceMandantID.equals(id)) {
            throw new NullPointerException(new StringBuffer().append("not modifiable").append(this._resourceMandantID).toString());
        }
        this._resourceMandantID = id;
    }

    public void setResourceSystemContext(String systemContext) {
        if (this._resourceSystemContext != null && !this._resourceSystemContext.equals(systemContext)) {
            throw new NullPointerException(new StringBuffer().append("not modifiable").append(this._resourceSystemContext).toString());
        }
        this._resourceSystemContext = systemContext;
    }

    public String getResourceSystemContext() {
        return this._resourceSystemContext;
    }

    public String getBasePath() {
        if (this._basePath == null) {
            this._basePath = this.getID();
        }
        return this._basePath;
    }

    public void setBasePath(String basePath) {
        this._basePath = basePath;
    }

    public void setSystemForm(boolean isSystemForm) {
        this._isSystemForm = isSystemForm;
    }

    public String getSystemBaseURI() {
        return this._systemBaseURI;
    }

    public void setSystemBaseURI(String basePath) {
        this._systemBaseURI = basePath;
    }

    public String getFormVersion() {
        return this._formVersion;
    }

    public void setFormVersion(String version) {
        this._formVersion = version;
    }

    public void setIsPublic(boolean isPublic) {
        this._isPublicForm = isPublic;
    }

    public boolean isPublicForm() {
        return this._isPublicForm;
    }

    public void setShowInfoBanner(boolean showBanner) {
        this._showInfoBanner = showBanner;
    }

    public boolean showInfoBanner() {
        return this._showInfoBanner;
    }

    public String getInfoBanner() {
        return this._infoBanner;
    }

    public void setInfoBanner(String banner) {
        this._infoBanner = banner;
    }

    public boolean isFormDefinitionForm() {
        return this.isSystemForm() && "FORM_DEFINITION_FORM".equalsIgnoreCase(this.getFormID());
    }

    public boolean isEsurveyDefinitionForm() {
        return this.isSystemForm() && "ESURVEY_DEFINITION_FORM".equalsIgnoreCase(this.getFormID());
    }

    public void setCustomController(String customController) {
        this._customController = customController;
    }

    public String getCustomController() {
        return this._customController;
    }

    public String getNotificationSourceGroup() {
        return this._notificationSourceGroup;
    }

    public void setNotificationSourceGroup(String group) {
        this._notificationSourceGroup = group;
    }

    public String[][] getFieldAccessRights() {
        return this._fieldAccessRights;
    }

    public void setFieldAccessRights(String[][] fieldAccessRights) {
        this._fieldAccessRights = fieldAccessRights;
    }

    public void setPessimisticLock(boolean isPessimisticLock) {
        this._pessimisticLock = isPessimisticLock;
    }

    public boolean isPessimisticLock() {
        return this._pessimisticLock;
    }

    public void setRootNode(String rootNode) {
        this._rootNode = rootNode;
    }

    public String getRootNode() {
        return this._rootNode;
    }

    public void setUseCustomButtonControls(boolean useCustomButtonControls) {
        this._useCustomButtonControls = useCustomButtonControls;
    }

    public boolean useCustomButtonControls() {
        return this._useCustomButtonControls;
    }

    public boolean isEsurvey() {
        return this._isEsurvey;
    }

    public void setIsEsurvey(boolean isEsurvey) {
        this._isEsurvey = isEsurvey;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public static boolean isEsurvey(Document dom) {
        return dom.getClientProperty("isEsurveyForm") != null && (Boolean)dom.getClientProperty("isEsurveyForm") != false;
    }
}

