/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.ArrayUtil;

public class RollingStack {
    private int startPos;
    private int maxContentSize = -1;
    private Object[] theArray;
    private int currentSize;
    private int actPos;
    private static final int DEFAULT_MAX_CAPACITY = 10;

    public RollingStack() {
        this.theArray = new Object[10];
        this.makeEmpty();
    }

    public RollingStack(int maxSize) {
        this.theArray = new Object[maxSize];
        this.makeEmpty();
    }

    public void clear() {
        this.theArray = new Object[this.theArray.length];
        this.makeEmpty();
    }

    public boolean empty() {
        return this.currentSize == 0;
    }

    private void makeEmpty() {
        this.currentSize = 0;
        this.startPos = 0;
        this.actPos = -1;
    }

    public Object pop() {
        if (this.empty()) {
            throw new UnderflowException("RollingStack pop");
        }
        --this.currentSize;
        Object returnValue = this.theArray[this.actPos];
        this.actPos = this.decrement(this.actPos);
        return returnValue;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        int pos = this.actPos;
        boolean endReached = true;
        for (int i = 0; i < this.currentSize; ++i) {
            if (pos < 0 && endReached) {
                endReached = false;
                pos = this.theArray.length - 1;
            }
            res.append(this.theArray[pos]);
            --pos;
            res.append(",");
        }
        return res.toString();
    }

    public Object pop(Object o) {
        int pos = this.search(o);
        Object returnValue = null;
        if (pos >= 0) {
            returnValue = this.theArray[pos];
            Object[] newArray = new Object[this.theArray.length];
            int nCount = 0;
            for (int c = 0; c < this.theArray.length; ++c) {
                if (c == pos) continue;
                newArray[nCount++] = this.theArray[c];
            }
            this.theArray = newArray;
            int abstand = -1;
            abstand = pos <= this.actPos ? this.actPos - pos : this.theArray.length - pos + this.actPos;
            if (abstand <= this.currentSize) {
                --this.currentSize;
                this.actPos = this.decrement(this.actPos);
            }
        }
        return returnValue;
    }

    private int decrement(int val) {
        val = --val >= 0 ? val : this.theArray.length - 1;
        return val;
    }

    public static void main(String[] args) {
        RollingStack q = new RollingStack(6);
        q.push("11");
        q.push("22");
        q.push("33");
        q.push("44");
        q.push("55");
        q.push("66");
        System.out.println(ArrayUtil.toString(q.theArray));
        q.pop("11");
        while (!q.empty()) {
            System.out.print(q.pop() + ",");
        }
    }

    public Object peek() {
        if (this.empty()) {
            throw new UnderflowException("RollingStack peek");
        }
        return this.theArray[this.actPos];
    }

    public Object first() {
        if (this.empty()) {
            throw new UnderflowException("RollingStack:first");
        }
        return this.theArray[this.startPos];
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void push(Object obj) {
        if (this.currentSize < this.theArray.length) {
            ++this.currentSize;
        }
        this.actPos = this.increment(this.actPos);
        this.theArray[this.actPos] = obj;
    }

    public void push(String val) {
        if (this.maxContentSize != -1 && val.length() > this.maxContentSize) {
            throw new MaxSizeException("RollingStack:maxSize breaked!");
        }
        this.push((Object)val);
    }

    public void pushUnique(Object obj) {
        int pos = this.search(obj);
        if (pos == -1) {
            this.push(obj);
        } else {
            this.pop(obj);
            this.push(obj);
        }
    }

    public int search(Object o) {
        for (int i = 0; i < this.theArray.length; ++i) {
            if (this.theArray[i] != o && (o == null || !o.equals(this.theArray[i]))) continue;
            return i;
        }
        return -1;
    }

    private int increment(int x) {
        if (++x == this.theArray.length) {
            x = 0;
            ++this.startPos;
            if (this.startPos == this.theArray.length) {
                this.startPos = 0;
            }
        }
        return x;
    }

    public void setMaxContentSize(int maxSize) {
        this.maxContentSize = maxSize;
    }

    public class MaxSizeException
    extends RuntimeException {
        public MaxSizeException(String message) {
            super(message);
        }
    }

    public class UnderflowException
    extends RuntimeException {
        public UnderflowException(String message) {
            super(message);
        }
    }
}

