/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

public class SizeOf {
    private static final Runtime s_runtime = Runtime.getRuntime();

    public static void main(String[] args) throws Exception {
        SizeOf.runGC();
        SizeOf.usedMemory();
        int count = 100000;
        Object[] objects = new Object[100000];
        long heap1 = 0L;
        for (int i = -1; i < 100000; ++i) {
            Object object = null;
            object = new Object();
            if (i >= 0) {
                objects[i] = object;
                continue;
            }
            object = null;
            SizeOf.runGC();
            heap1 = SizeOf.usedMemory();
        }
        SizeOf.runGC();
        long heap2 = SizeOf.usedMemory();
        int size = Math.round((float)(heap2 - heap1) / 100000.0f);
        System.out.println("'before' heap: " + heap1 + ", 'after' heap: " + heap2);
        System.out.println("heap delta: " + (heap2 - heap1) + ", {" + objects[0].getClass() + "} size = " + size + " bytes");
        for (int i = 0; i < 100000; ++i) {
            objects[i] = null;
        }
        objects = null;
    }

    private static void runGC() throws Exception {
        for (int r = 0; r < 4; ++r) {
            SizeOf._runGC();
        }
    }

    private static void _runGC() throws Exception {
        long usedMem1 = SizeOf.usedMemory();
        long usedMem2 = Long.MAX_VALUE;
        for (int i = 0; usedMem1 < usedMem2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.yield();
            usedMem2 = usedMem1;
            usedMem1 = SizeOf.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }
}

