/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.util.NoSuchElementException;

public class StringTokenizer
extends java.util.StringTokenizer {
    private int currentPosition = 0;
    private int maxPosition;
    private int minPos = 0;
    private int length;
    private char[] str;
    private String delimiters;
    private boolean retTokens;
    private String emptyReturnTocken = "";

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str, String delim, boolean returnTokens) {
        super(str, delim, returnTokens);
        this.str = str.toCharArray();
        this.length = this.str.length;
        this.maxPosition = this.length - 1;
        this.delimiters = delim;
        this.retTokens = returnTokens;
    }

    public StringTokenizer(String str, String delim, boolean returnTokens, boolean emptyReturnTockenIsNull) {
        super(str, delim, returnTokens);
        this.str = str.toCharArray();
        this.length = this.str.length;
        this.maxPosition = this.length - 1;
        this.delimiters = delim;
        this.retTokens = returnTokens;
        this.emptyReturnTocken = emptyReturnTockenIsNull ? null : "";
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            while (currpos < this.maxPosition && !this.isDelimiter(this.str[currpos])) {
                ++currpos;
            }
            ++currpos;
            ++count;
        }
        return count;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMorePreviousTokens() {
        return this.currentPosition > this.minPos;
    }

    public boolean hasMoreTokens() {
        return this.currentPosition <= this.maxPosition;
    }

    private boolean isDelimiter(char c) {
        return this.delimiters.indexOf(c) >= 0;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        while (this.currentPosition < this.maxPosition && !this.isDelimiter(this.str[this.currentPosition])) {
            ++this.currentPosition;
        }
        int end = this.currentPosition;
        if (!this.isDelimiter(this.str[this.currentPosition])) {
            ++end;
        }
        if (start == end) {
            return this.retTokens ? String.valueOf(this.str[start]) : this.emptyReturnTocken;
        }
        String s = String.valueOf(this.str, start, end - start);
        return s;
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        return this.nextToken();
    }

    public String previousToken() {
        int end;
        int start = this.currentPosition - 1;
        this.currentPosition -= 2;
        if (this.currentPosition < this.minPos) {
            throw new NoSuchElementException();
        }
        while (this.currentPosition > this.minPos && !this.isDelimiter(this.str[this.currentPosition])) {
            --this.currentPosition;
        }
        if (this.currentPosition <= this.minPos) {
            if (this.isDelimiter(this.str[this.currentPosition])) {
                return String.valueOf(this.str, this.currentPosition + 1, start - 1);
            }
            return String.valueOf(this.str, this.currentPosition, start);
        }
        if ((end = this.currentPosition++) > this.minPos) {
            ++end;
        }
        if (start == end) {
            return this.retTokens ? String.valueOf(this.str[start]) : this.emptyReturnTocken;
        }
        String s = String.valueOf(this.str, end, start - end);
        return s;
    }
}

