/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.ListEntry;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.NLS;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.lang.StringEscapeUtils;
import org.nfunk.jep.type.NULL;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class TextTools {
    public static final Font CALC_BASE_FONT = new Font("Verdana", 0, 11);
    private static BASE64Encoder b64Enc = new BASE64Encoder();
    private static BASE64Decoder b64Dec = new BASE64Decoder();
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_EMPTY = '\u0000';
    public static final char CHAR_NEWLINE = '\n';
    private static final String[] _nlsEscapeCharacters = new String[]{"=", ":"};
    private static final String[] _nlsUnEscapeCharacters = new String[]{"&eq;", "&co;"};
    public static final char NATIVE_DECIMAL_SEP = '.';
    public static final String PI_START_TAG = "<?jaxfront";
    public static final String PI_END_TAG = "?>";
    public static final Graphics STRING_LENGTH_GRAPHICS = new BufferedImage(1, 1, 1).getGraphics();
    private static int _refTxtSize = -1;
    public static String _refTxtCalcTemplate = "e";
    public static final DecimalFormat FROM_FLOATINGNUMBER_FORMAT = new DecimalFormat();

    private TextTools() {
    }

    public static String getClassName(Class aClass) {
        return aClass.getName().substring(aClass.getName().lastIndexOf(".") + 1, aClass.getName().length());
    }

    public static void main(String[] args) {
        System.out.println(TextTools.replaceWhiteSpace("das ist ein test", ' ', true));
        System.out.println(TextTools.replaceWhiteSpace("das  ist    ein     test", ' ', true));
        System.out.println(TextTools.replaceWhiteSpace("das  ist    ein  \ra\r  4   4     4  test", ' ', true));
        StringBuffer oldText = new StringBuffer("das ist das ein test das");
        StringBuffer result1 = TextTools.replace(oldText, "das", "a");
        StringBuffer result2 = TextTools.replace(oldText, "das", "");
        System.out.println(result1.toString());
        System.out.println(result2.toString());
        oldText = new StringBuffer("das ist das ein test dasd");
        result1 = TextTools.replace(oldText, "das", "a");
        result2 = TextTools.replace(oldText, "das", "");
        System.out.println("orig:" + oldText.toString());
        System.out.println(result1.toString());
        System.out.println(result2.toString());
        JAXFrontDateTools.hardCoreIsoConverter("yyyy/MM/dd", "1999/9/12");
        System.out.println(TextTools.replaceBetween("das ist ein test ${replaceMe}", null, "test", "${", "}"));
    }

    public static String convertNumbersToNative(String number, DecimalFormatSymbols symbols) {
        if (symbols != null && number != null && !number.equals("")) {
            char decimalSeparator = symbols.getDecimalSeparator();
            char groupingSeparator = symbols.getGroupingSeparator();
            number = TextTools.removeChar(number, groupingSeparator);
            number = number.replace(decimalSeparator, '.');
        }
        return number;
    }

    public static String convertNumbersToView(String number, String language, boolean useGrouping) {
        return TextTools.convertNumbersToView(number, (DecimalFormat)DecimalFormat.getInstance(new Locale(language)), useGrouping);
    }

    public static String convertNumbersToView(String number, DecimalFormat format, boolean useGrouping) {
        if (format != null && number != null && !number.equals("")) {
            int groupSize = format.getGroupingSize();
            char dezimalZeichen = format.getDecimalFormatSymbols().getDecimalSeparator();
            char gruppenZeichen = format.getDecimalFormatSymbols().getGroupingSeparator();
            char minusZeichen = format.getDecimalFormatSymbols().getMinusSign();
            boolean isNegative = number.charAt(0) == minusZeichen;
            char nativeDezimalZeichen = '.';
            char[] numArr = number.toCharArray();
            int dezZFoundPos = numArr.length;
            for (int i = numArr.length - 1; i >= 0; --i) {
                char actChar = numArr[i];
                if (actChar != nativeDezimalZeichen) continue;
                numArr[i] = dezimalZeichen;
                dezZFoundPos = i;
                break;
            }
            if (useGrouping) {
                int releventFoundPos = isNegative ? dezZFoundPos - 1 : dezZFoundPos;
                int anzGroupSep = releventFoundPos / groupSize;
                if (releventFoundPos % groupSize == 0) {
                    --anzGroupSep;
                }
                if (anzGroupSep >= 1) {
                    char[] preMantisse = new char[dezZFoundPos + anzGroupSep];
                    int end = 0;
                    if (isNegative) {
                        end = 1;
                        preMantisse[0] = minusZeichen;
                    }
                    int actPos = dezZFoundPos;
                    int groupCount = 0;
                    for (int i = preMantisse.length - 1; i >= end; --i) {
                        if (groupCount == groupSize) {
                            preMantisse[i] = gruppenZeichen;
                            groupCount = 0;
                            continue;
                        }
                        ++groupCount;
                        preMantisse[i] = numArr[--actPos];
                    }
                    char[] result = new char[numArr.length - dezZFoundPos + preMantisse.length];
                    System.arraycopy(preMantisse, 0, result, 0, preMantisse.length);
                    System.arraycopy(numArr, dezZFoundPos, result, preMantisse.length, numArr.length - dezZFoundPos);
                    numArr = result;
                }
            }
            number = new String(numArr);
        }
        return number;
    }

    public static String colorToHex(Color color) {
        String colorstr = new String("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        str = Integer.toHexString(color.getGreen());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        str = Integer.toHexString(color.getBlue());
        if (str.length() > 2) {
            str = str.substring(0, 2);
        } else {
            colorstr = str.length() < 2 ? colorstr + "0" + str : colorstr + str;
        }
        return colorstr;
    }

    public static String replace(String source, String oldString, String newString) {
        if (source == null) {
            return source;
        }
        if (oldString.length() == 0) {
            return source;
        }
        String text = source;
        int oi = text.indexOf(oldString);
        if (oi >= 0) {
            StringBuffer result = new StringBuffer();
            int pos = 0;
            while ((pos = text.indexOf(oldString)) >= 0) {
                result.append(text.substring(0, pos));
                result.append(newString);
                text = text.substring(pos + oldString.length());
            }
            result.append(text);
            return result.toString();
        }
        return source;
    }

    public static String replaceFirst(String source, String oldString, String newString) {
        if (source == null) {
            return source;
        }
        if (oldString.length() == 0) {
            return source;
        }
        boolean found = false;
        String text = source;
        int oi = text.indexOf(oldString);
        if (oi >= 0) {
            StringBuffer result = new StringBuffer();
            int pos = 0;
            while (!found && (pos = text.indexOf(oldString)) >= 0) {
                result.append(text.substring(0, pos));
                result.append(newString);
                text = text.substring(pos + oldString.length());
                found = true;
            }
            result.append(text);
            return result.toString();
        }
        return source;
    }

    public static StringBuffer replace(StringBuffer source, String oldString, String newString) {
        if (source == null) {
            return source;
        }
        if (oldString.length() == 0) {
            return source;
        }
        int oi = source.indexOf(oldString);
        if (oi >= 0) {
            StringBuffer result = new StringBuffer();
            int start = 0;
            while (oi >= 0) {
                result.append(source.substring(start, oi));
                result.append(newString);
                start = oi + oldString.length();
                oi = source.indexOf(oldString, start);
            }
            if (start != source.length()) {
                result.append(source.substring(start));
            }
            return result;
        }
        return source;
    }

    public static String removeChar(String source, char aChar) {
        int s = source.indexOf(aChar);
        if (s >= 0) {
            StringBuffer buff = new StringBuffer(source.substring(0, s));
            while (s < source.length()) {
                char c = source.charAt(s);
                if (c != aChar) {
                    buff.append(c);
                }
                ++s;
            }
            return buff.toString();
        }
        return source;
    }

    public static String removeSingleOccureChar(String source, char aChar) {
        StringBuffer buff = new StringBuffer();
        for (int s = 0; s < source.length(); ++s) {
            char c = source.charAt(s);
            char nextC = '\u0000';
            if (s + 1 < source.length()) {
                nextC = source.charAt(s + 1);
            }
            if (c != aChar) {
                buff.append(c);
                continue;
            }
            if (nextC != c || nextC == '\u0000') continue;
            buff.append(c);
        }
        return buff.toString();
    }

    public static char[] removeTrailingChar(char[] source, char aChar, int offset, char stopChar) {
        char c;
        int s;
        for (s = offset; s < source.length && (c = source[s]) == aChar && c != stopChar; ++s) {
        }
        if (s == 0 || s == offset) {
            return source;
        }
        if (s == source.length) {
            char[] result = new char[source.length - s + offset];
            System.arraycopy(source, 0, result, 0, offset);
            return result;
        }
        char[] result = new char[source.length - s + offset];
        System.arraycopy(source, 0, result, 0, offset);
        System.arraycopy(source, s, result, offset, source.length - s);
        return result;
    }

    public static String substringAfter(String source, String from) {
        int lastIndex = source.lastIndexOf(from);
        int sourceLength = source.length();
        if (lastIndex > -1 && lastIndex < sourceLength) {
            source = source.substring(lastIndex + from.length(), sourceLength);
        }
        return source;
    }

    public static String replace(String source, String oldString, String newString, String splitCharacter) {
        if (oldString.length() == 0 && splitCharacter.length() == 0) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        String text = source;
        oldString = oldString + splitCharacter;
        newString = newString + splitCharacter;
        int pos = 0;
        while ((pos = text.indexOf(oldString)) >= 0) {
            result.append(text.substring(0, pos));
            result.append(newString);
            text = text.substring(pos + oldString.length());
        }
        result.append(text);
        return result.toString();
    }

    public static String replaceGlobalEntities(String value) {
        if (value == null) {
            return "";
        }
        return StringUtil.escapeXML(value);
    }

    public static String replaceGlobalHTMLEntities(String value) {
        if (value == null) {
            return "";
        }
        return StringEscapeUtils.escapeHtml((String)value);
    }

    public static String escapeNLSEntities(String value) {
        if (value == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(value, _nlsEscapeCharacters[0] + _nlsEscapeCharacters[1], true);
        StringBuffer newString = new StringBuffer();
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            for (int i = 0; i < _nlsEscapeCharacters.length; ++i) {
                if (token.indexOf(_nlsEscapeCharacters[i]) == -1) continue;
                token = TextTools.replace(token, _nlsEscapeCharacters[i], _nlsUnEscapeCharacters[i]);
            }
            newString.append(token);
        }
        return newString.toString();
    }

    public static String unEscapeNLSEntities(String value) {
        if (value == null) {
            return "";
        }
        for (int i = 0; i < _nlsUnEscapeCharacters.length; ++i) {
            value = TextTools.replace(value, _nlsUnEscapeCharacters[i], _nlsEscapeCharacters[i]);
        }
        return value;
    }

    public static String replaceGlobalUserProperties(String value, Document dom) {
        return TextTools.replaceBetween(value, dom.getApplicationProperties(), null, "${", "}");
    }

    public static String replaceBetween(String source, Hashtable vars, String value, String from, String to) {
        if (source == null) {
            return null;
        }
        int varStartIdx = source.indexOf(from);
        if (varStartIdx < 0) {
            return source;
        }
        StringBuffer newValue = new StringBuffer(source.substring(0, varStartIdx));
        int varEndIdx = -1;
        while (varStartIdx >= 0) {
            varEndIdx = source.indexOf(to, varStartIdx);
            String var = source.substring(varStartIdx + from.length(), varEndIdx);
            String variableContent = null;
            if (vars != null) {
                Object aVar = vars.get(var);
                if (aVar != null && aVar != NULL._null) {
                    variableContent = aVar instanceof List ? ArrayUtil.toString((List)aVar, ",") : aVar.toString();
                }
            } else {
                variableContent = value;
            }
            if (variableContent != null) {
                newValue.append(variableContent);
            } else {
                int blStart = varStartIdx;
                String varBlock = source.substring(blStart, varEndIdx + to.length());
                newValue.append(varBlock);
            }
            varStartIdx = source.indexOf(from, varEndIdx);
            if (varStartIdx != -1) {
                String rest = source.substring(varEndIdx + 1, varStartIdx);
                newValue.append(rest);
                continue;
            }
            if (varEndIdx + 1 >= source.length()) continue;
            String tail = source.substring(varEndIdx + to.length());
            newValue.append(tail);
        }
        return newValue.toString();
    }

    public static String replaceVars(String source, Hashtable vars) {
        if (source == null) {
            return null;
        }
        String variableContent = source;
        if (vars != null) {
            Object aVar;
            if (source.startsWith("${") && source.endsWith("}")) {
                source = source.substring(2, source.length() - 1);
            }
            if ((aVar = vars.get(source)) != null && aVar != NULL._null) {
                variableContent = aVar instanceof List ? ArrayUtil.toString((List)aVar, ",") : aVar.toString();
            }
        }
        return variableContent;
    }

    public static String[] tokenize(String s, String delimiter) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiter);
        String[] token = new String[tokenizer.countTokens()];
        int k = 0;
        while (tokenizer.hasMoreTokens()) {
            token[k++] = tokenizer.nextToken();
        }
        return token;
    }

    public static String[] tokenize(String s, char delimiter, boolean returnDelim) {
        int count = 0;
        for (int sl = 0; sl < s.length(); ++sl) {
            if (s.charAt(sl) == delimiter) {
                ++count;
                continue;
            }
            if (sl + 1 != s.length()) continue;
            if (count == 0) {
                return new String[]{s};
            }
            ++count;
        }
        int tokens = count;
        String[] token = new String[tokens];
        int k = 0;
        int oldSL = 0;
        for (int sl = 0; sl < s.length(); ++sl) {
            if (s.charAt(sl) == delimiter) {
                if (oldSL > 0) {
                    ++oldSL;
                }
                token[k] = s.substring(oldSL, sl);
                oldSL = sl;
                ++k;
                continue;
            }
            if (sl + 1 != s.length()) continue;
            token[k] = s.substring(oldSL + 1, s.length());
        }
        return token;
    }

    public static Integer[] tokenizeToInteger(String s, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiter);
        Integer[] token = new Integer[tokenizer.countTokens()];
        int k = 0;
        while (tokenizer.hasMoreTokens()) {
            token[k++] = Integer.valueOf(tokenizer.nextToken());
        }
        return token;
    }

    public static String createDelimited(String[] s, String delimiter) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            result.append(s[i]);
            if (i + 1 >= s.length) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String createDelimited(List s, String delimiter, String fieldSeparator) {
        StringBuffer result = new StringBuffer();
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            result.append(fieldSeparator);
            result.append(s.get(i));
            result.append(fieldSeparator);
            if (i + 1 >= size) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String createDelimited(String[] s, char delimiter, char fieldSeparator) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; s != null && i < s.length; ++i) {
            result.append(fieldSeparator);
            result.append(s[i]);
            result.append(fieldSeparator);
            if (i + 1 >= s.length) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static int hasChar(String source, int pos, char charakter, char direction) {
        int result = -1;
        if (direction == 'U') {
            for (int i = pos - 1; i <= source.length(); ++i) {
                if (source.charAt(i) != charakter) continue;
                return i;
            }
        } else {
            for (int i = pos - 1; i >= 0; --i) {
                if (source.charAt(i) != charakter) continue;
                return i;
            }
        }
        return result;
    }

    public static String reverseText(String text) {
        if (text != null) {
            char[] result = new char[text.length()];
            int j = 0;
            for (int i = text.length() - 1; i >= 0; --i) {
                result[j] = text.charAt(i);
                ++j;
            }
            return new String(result);
        }
        return text;
    }

    public static int countCharBetween(String source, int start, int end, char charakter, char direction) {
        int result = 0;
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (direction == 'U') {
            for (int i = start; i < end; ++i) {
                if (source.charAt(i) != charakter) continue;
                ++result;
            }
        } else {
            for (int i = start - 1; i >= end; --i) {
                if (source.charAt(i) != charakter) continue;
                ++result;
            }
        }
        return result;
    }

    public static int compareTo(char[] string1, int offsetC1, char[] string2, int offsetC2) {
        if (string1 != null && string2 != null) {
            int len1 = string1.length;
            int len2 = string2.length;
            int n = Math.min(len1, len2);
            char[] v1 = string1;
            char[] v2 = string2;
            int i = offsetC1;
            int j = offsetC2;
            if (i == j) {
                int lim = n + i;
                for (int k = i; k < lim; ++k) {
                    char c1 = v1[k];
                    char c2 = v2[k];
                    if (c1 == c2) continue;
                    return c1 - c2;
                }
            } else {
                while (n-- != 0) {
                    char c2;
                    char c1;
                    if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                    return c1 - c2;
                }
            }
            return len1 - len2;
        }
        if (string1 == null) {
            return -1;
        }
        return 1;
    }

    public static String encodeBase64(byte[] b) {
        return b64Enc.encode(b);
    }

    public static byte[] decodeBase64(String text) throws IOException {
        return b64Dec.decodeBuffer(text);
    }

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = ret + Integer.toHexString(value).toUpperCase();
        return ret;
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int value = (bytes[i] & 0x7F) + (bytes[i] < 0 ? 128 : 0);
            result.append(value < 16 ? "0" : "");
            result.append(Integer.toHexString(value).toUpperCase());
        }
        return result.toString();
    }

    public static byte[] fromHexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static int compareTo(char[] string1, char[] string2) {
        return TextTools.compareTo(string1, 0, string2, 0);
    }

    public static String toString(Object[] objects) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < objects.length; ++i) {
            sb.append(objects[i].toString());
            if (i == objects.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String quote(String text) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        if (text == null) {
            result.append("");
        } else {
            result.append(text);
        }
        result.append("\"");
        return result.toString();
    }

    public static String unquote(String text) {
        if (text != null && text.length() > 0 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String getSeasonSplashName() {
        String winter = "winter";
        String sommer = "sommer";
        String automn = "automn";
        String spring = "spring";
        String seasonName = null;
        GregorianCalendar calendar = new GregorianCalendar();
        int monthIndex = calendar.get(2);
        int dayIndex = calendar.get(5);
        seasonName = monthIndex == 0 || monthIndex == 1 ? winter : (monthIndex == 3 || monthIndex == 4 ? spring : (monthIndex == 6 || monthIndex == 7 ? sommer : (monthIndex == 9 || monthIndex == 10 ? automn : (monthIndex == 2 ? (dayIndex < 21 ? winter : spring) : (monthIndex == 5 ? (dayIndex < 21 ? spring : sommer) : (monthIndex == 8 && dayIndex < 21 ? sommer : automn))))));
        return seasonName;
    }

    public static Color createColor(String colorAsString) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (colorAsString == null) {
            return null;
        }
        if (colorAsString.equals("")) {
            return Color.BLACK;
        }
        if (colorAsString.indexOf(",") == -1 && colorAsString.indexOf(".") == -1) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(TextTools.class, "wrong Color Definition for: " + colorAsString);
            }
        } else {
            StringTokenizer st = new StringTokenizer(colorAsString, ",.");
            r = new Integer(st.nextToken());
            g = new Integer(st.nextToken());
            b = new Integer(st.nextToken());
        }
        return new Color(r, g, b);
    }

    public static String getContentFromURL(URL url) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(JAXFrontProperties.getInstance().getURLResolver().resolveURL(url)));
        StringBuffer content = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine + "\n");
        }
        in.close();
        return content.toString();
    }

    public static String[] compactStrings(String[] strings) {
        String[] result = new String[strings.length];
        int offset = 0;
        for (int i = 0; i < strings.length; ++i) {
            offset += strings[i].length();
        }
        char[] allchars = new char[offset];
        offset = 0;
        for (int i = 0; i < strings.length; ++i) {
            strings[i].getChars(0, strings[i].length(), allchars, offset);
            offset += strings[i].length();
        }
        String allstrings = new String(allchars);
        offset = 0;
        for (int i = 0; i < strings.length; ++i) {
            result[i] = allstrings.substring(offset, offset += strings[i].length());
        }
        return result;
    }

    public static String convertExponentialValue(String number) throws NumberFormatException {
        if (number != null && (number.indexOf("e") > -1 || number.indexOf("E") > -1) && (number = FROM_FLOATINGNUMBER_FORMAT.format(Double.parseDouble(number))).endsWith(".0")) {
            number = number.substring(0, number.length() - 2);
        }
        return number;
    }

    public static HashMap getProcessingInstruction(String xml) {
        HashMap<String, String> pi = new HashMap<String, String>();
        int startPI = xml.indexOf(PI_START_TAG) + PI_START_TAG.length();
        if (startPI >= PI_START_TAG.length()) {
            xml = xml.substring(startPI, xml.length());
            int endPI = xml.indexOf(PI_END_TAG);
            xml = xml.substring(0, endPI);
            StringTokenizer st = new StringTokenizer(xml, ";");
            String keyValueToken = null;
            String key = null;
            String value = null;
            while (st.hasMoreElements()) {
                keyValueToken = st.nextToken();
                key = keyValueToken.substring(0, keyValueToken.indexOf("=")).trim();
                value = keyValueToken.substring(keyValueToken.indexOf("=") + 1, keyValueToken.length()).trim();
                pi.put(key, value);
            }
        }
        return pi;
    }

    public static int getNodeEndPos(String content, String nodeName, int start, char nodeStartQualifier, char nodeEndQualifier) {
        int endPos = -1;
        int oBCount = 0;
        int cBCount = 0;
        for (int i = start; i < content.length(); ++i) {
            char posChar = content.charAt(i);
            if (posChar == nodeStartQualifier && (nodeName == null || content.startsWith(nodeName, i + 1))) {
                ++oBCount;
                continue;
            }
            if (oBCount > 0 && posChar == nodeEndQualifier) {
                ++cBCount;
                continue;
            }
            if (oBCount > 0 && oBCount == cBCount) {
                endPos = i;
                break;
            }
            endPos = i + 1;
        }
        if (cBCount > 0) {
            return endPos;
        }
        return 0;
    }

    public static StringBuffer wordOut(String s, BreakIterator iter, int maxLength) {
        StringBuffer result = new StringBuffer();
        int last = iter.first();
        int next = iter.next();
        int lastNext = 0;
        while (next != -1) {
            boolean printNewLine = false;
            CharSequence token = s.subSequence(last, next);
            if (next - lastNext >= maxLength) {
                printNewLine = true;
            }
            if (next - lastNext != 1 || !token.equals(" ")) {
                result.append(token);
            }
            if (printNewLine) {
                result.append("\n");
                lastNext = next;
                printNewLine = false;
            }
            last = next;
            next = iter.next();
        }
        return result;
    }

    public static String splitTextMaxLength(String text, int maxLength) {
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(text);
        return TextTools.wordOut(text, iterator, maxLength).toString();
    }

    public static String splitText(String text) {
        BreakIterator iterator = BreakIterator.getSentenceInstance(Locale.GERMAN);
        iterator.setText(text);
        return TextTools.out(text, iterator).toString();
    }

    public static StringBuffer out(String s, BreakIterator iter) {
        StringBuffer result = new StringBuffer();
        int last = iter.first();
        int next = iter.next();
        while (next != -1) {
            result.append(s.subSequence(last, next));
            last = next;
            next = iter.next();
        }
        return result;
    }

    public static String replaceWhiteSpace(String toClean, char replacement, boolean collapseSpaces) {
        int size = toClean.length();
        StringBuffer result = new StringBuffer(toClean.length());
        char old = '\u0000';
        for (int i = 0; i < size; ++i) {
            boolean skip = false;
            char act = toClean.charAt(i);
            if (Character.isWhitespace(act)) {
                act = replacement;
                if (collapseSpaces && act == old) {
                    skip = true;
                }
            }
            if (!skip) {
                result.append(act);
            }
            old = act;
        }
        return result.toString();
    }

    public static String removeSpecialChars(String toClean) {
        int size = toClean.length();
        StringBuffer result = new StringBuffer(toClean.length());
        block3: for (int i = 0; i < size; ++i) {
            char act = toClean.charAt(i);
            switch (act) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    result.append(' ');
                    continue block3;
                }
                default: {
                    result.append(act);
                }
            }
        }
        return result.toString();
    }

    public static String removeInvalidUnicodeChars(String toClean) {
        int size = toClean.length();
        StringBuffer result = new StringBuffer(size);
        block3: for (int i = 0; i < size; ++i) {
            char act = toClean.charAt(i);
            switch (act) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    continue block3;
                }
                default: {
                    result.append(act);
                }
            }
        }
        return result.toString();
    }

    public static String removeSpaceChars(String result) {
        result = result.replace(' ', '\u0000');
        return result;
    }

    public static String createHTMLString(String content) {
        if (!(content = content.trim()).startsWith("html") && !content.startsWith("HTML")) {
            content = "<html><body>" + content + "</body></html>";
        }
        return content;
    }

    public static String[] getChoicesWithNoneEntry(String[] choices) {
        String[] choicesWithNone = new String[choices.length + 1];
        System.arraycopy(choices, 0, choicesWithNone, 1, choices.length);
        choicesWithNone[0] = "";
        return choicesWithNone;
    }

    public static String replace(String source, char from, char to) {
        return String.valueOf(TextTools.replace(source.toCharArray(), from, to));
    }

    public static char[] replace(char[] source, char from, char to) {
        for (int i = 0; i < source.length; ++i) {
            if (source[i] != from) continue;
            source[i] = to;
        }
        return source;
    }

    public static StringBuffer exportToCSV(int startCol, String[] columnNames, String[][] array) {
        return TextTools.exportToCSV(startCol, columnNames, array, null);
    }

    public static StringBuffer exportToCSV(int startCol, String[] columnNames, String[][] array, Map valueConversions) {
        return TextTools.exportToCSV(new StringBuffer(), startCol, columnNames, array, valueConversions);
    }

    public static StringBuffer exportToCSV(StringBuffer result, int startCol, String[] columnNames, String[][] array, Map valueConversions) {
        char delim = ';';
        int colCount = 0;
        if (array.length > 0) {
            colCount = array[0].length;
        }
        if (array.length > 0) {
            if (columnNames != null) {
                for (int col = startCol; col < columnNames.length; ++col) {
                    String columnText = columnNames[col];
                    result.append("\"");
                    result.append(columnText);
                    result.append("\"");
                    result.append(delim);
                }
                colCount = columnNames.length;
            }
            result.append(StringUtil.newLine);
            for (int row = 0; row < array.length; ++row) {
                for (int col = startCol; col < colCount; ++col) {
                    String value = array[row][col];
                    result.append("\"");
                    TextTools.substituteWithNLSValue(columnNames, valueConversions, result, col, value);
                    result.append("\"");
                    result.append(delim);
                }
                result.append(StringUtil.newLine);
            }
        }
        return result;
    }

    public static void exportToCSV(StringBuffer result, int startCol, String[] columnNames, String[] array, Map codeTables) {
        char delim = ';';
        if (array.length > 0) {
            int col;
            if (columnNames != null) {
                for (col = startCol; col < columnNames.length; ++col) {
                    String columnText = columnNames[col];
                    result.append("\"");
                    result.append(columnText);
                    result.append("\"");
                    result.append(delim);
                }
            }
            result.append(StringUtil.newLine);
            for (col = 0; col < array.length; ++col) {
                String value = array[col];
                result.append("\"");
                TextTools.substituteWithNLSValue(columnNames, codeTables, result, col, value);
                result.append("\"");
                result.append(delim);
            }
            result.append(StringUtil.newLine);
        }
    }

    public static void exportToCSV(StringBuffer result, int startCol, ListEntry[] columnNames, Map codeTables, NLS nls) {
        char delim = ';';
        if (columnNames.length > 0) {
            int col;
            if (columnNames != null) {
                for (col = startCol; col < columnNames.length; ++col) {
                    String columnText = columnNames[col].getValues()[1];
                    if (nls != null && nls.containsKey("searchColumn_" + columnText)) {
                        columnText = nls.get("searchColumn_" + columnText);
                    }
                    result.append("\"");
                    result.append(columnText);
                    result.append("\"");
                    result.append(delim);
                }
            }
            result.append(StringUtil.newLine);
            for (col = 0; col < columnNames.length; ++col) {
                String value = columnNames[col].getValues()[0];
                result.append("\"");
                result.append(TextTools.substituteWithNLSValue(columnNames[col].getKey(), codeTables, value));
                result.append("\"");
                result.append(delim);
            }
            result.append(StringUtil.newLine);
        }
    }

    public static void substituteWithNLSValue(String[] columnNames, Map nlsMaps, StringBuffer result, int col, String value) {
        String subst = null;
        subst = columnNames != null ? TextTools.substituteWithNLSValue(columnNames[col], nlsMaps, value) : TextTools.substituteWithNLSValue(null, nlsMaps, value);
        result.append(StringUtil.replace(subst, "\"", "\"\""));
    }

    public static String substituteWithNLSValue(String columnName, Map nlsMaps, String value) {
        if (value != null) {
            StringBuffer result = new StringBuffer(value.length());
            String[] vals = null;
            vals = value.indexOf("_;_") >= 0 ? TextTools.tokenize(value, "_;_") : TextTools.tokenize(value, ",");
            for (int i = 0; i < vals.length; ++i) {
                String codeValue;
                Map codes;
                String aVal = vals[i];
                if (nlsMaps != null && columnName != null && (codes = (Map)nlsMaps.get(columnName)) != null && (codeValue = (String)codes.get(aVal)) != null) {
                    aVal = codeValue;
                }
                if (aVal == null) {
                    aVal = "";
                }
                result.append(aVal);
                if (i + 1 >= vals.length) continue;
                result.append(", ");
            }
            return result.toString();
        }
        return "";
    }

    public static int calculateTextLength(Font aFont, String text) {
        if (text == null) {
            return 0;
        }
        FontMetrics metrics = STRING_LENGTH_GRAPHICS.getFontMetrics(aFont);
        return metrics.stringWidth(text);
    }

    public static String extractHTMLDocType(String html) {
        int docTypeEnd;
        int docTypeStart;
        String docType = null;
        if (html != null && (docTypeStart = StringUtil.indexOfIgnoreCase(html, "<!DOCTYPE", 0)) >= 0 && (docTypeEnd = html.indexOf(">")) > 0 && docTypeEnd + 1 >= docTypeStart) {
            docType = html.substring(docTypeStart, docTypeEnd + 1);
        }
        return docType;
    }

    public static int getReferenceTextLength() {
        if (_refTxtSize == -1) {
            _refTxtSize = TextTools.calculateTextLength(CALC_BASE_FONT, _refTxtCalcTemplate) / _refTxtCalcTemplate.length();
        }
        return _refTxtSize;
    }

    public static int calculateTextLength(int size) {
        return TextTools.getReferenceTextLength() * size;
    }

    public static String calculateTextLengthInEM(int size) {
        return TextTools.convertToEM(TextTools.getReferenceTextLength() * size);
    }

    public static String convertToEM(int width) {
        return TextTools.convertToEM(width, 0.5);
    }

    public static String convertToEM(int width, double offset) {
        return TextTools.calculateEM(width, offset) + "em";
    }

    public static long calculateEM(int width, double offset) {
        return Math.round((double)(width / 10) + offset);
    }

    public static long calculateMaxTextLength(String[] data) {
        int maxLength = 0;
        int oldLength = 0;
        for (int j = 0; j < data.length; ++j) {
            String aVal = data[j];
            int vLength = 0;
            if (aVal != null) {
                vLength = TextTools.calculateTextLength(CALC_BASE_FONT, aVal.trim());
            }
            maxLength = Math.max(oldLength, vLength);
            oldLength = vLength;
        }
        return Math.round((double)(maxLength / 10) + 0.5);
    }

    public static int getWidthInPixel(int characters, Font aFont) {
        int charWidth = TextTools.charWidth(aFont, 'm');
        return characters * charWidth;
    }

    private static int charWidth(Font aFont, char character) {
        FontMetrics metrics = STRING_LENGTH_GRAPHICS.getFontMetrics(aFont);
        return metrics.charWidth(character);
    }

    public static int parseInt(String value, int defaultValue) {
        int result = defaultValue;
        try {
            if (value != null) {
                result = Integer.parseInt(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long parseLong(String value, long defaultValue) {
        long result = defaultValue;
        try {
            if (value != null) {
                result = Long.parseLong(value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            if (value != null) {
                result = Boolean.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static byte parseByte(String value, byte defaultValue) {
        byte result = defaultValue;
        try {
            if (value != null) {
                result = Byte.parseByte(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {}
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] input, int level) {
        Deflater compressor = new Deflater();
        compressor.setLevel(level);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static String translateVar(String aValue, Document dom) {
        Hashtable vars = dom.getApplicationProperties();
        return TextTools.translateVar(aValue, dom, vars);
    }

    public static String translateVar(String aValue, Map vars) {
        return TextTools.translateVar(aValue, null, vars);
    }

    public static String translateVar(String aValue, Document dom, Map vars) {
        if (vars != null && aValue != null) {
            if (dom != null && dom.getRootType() != null && aValue.indexOf("$xpath{") >= 0) {
                int from = aValue.indexOf("$xpath{");
                int to = aValue.indexOf("}", from);
                String varDef = aValue.substring(from, to + 1);
                String var = aValue.substring(from + "$xpath{".length(), to);
                Type foundType = dom.getType(var);
                if (foundType != null) {
                    if (foundType.isSimple()) {
                        String varValue = ((SimpleType)foundType).getValue();
                        aValue = TextTools.replace(aValue, var, varValue);
                        return aValue;
                    }
                    String varValue = foundType.getName();
                    aValue = TextTools.replace(aValue, var, varValue);
                    return aValue;
                }
                return aValue;
            }
            if (aValue.indexOf("${") >= 0) {
                String varValue;
                int from = aValue.indexOf("${");
                int to = aValue.indexOf("}", from);
                String varDef = aValue.substring(from, to + 1);
                String var = aValue.substring(from + "${".length(), to);
                Object varObj = vars.get(var);
                String string = varValue = varObj == null || varObj == NULL._null ? null : varObj.toString();
                if (dom != null && varValue == null && "domId".equals(var)) {
                    varValue = dom.getDocumentID();
                }
                aValue = TextTools.replace(aValue, varDef, varValue);
                return aValue;
            }
        }
        return aValue;
    }

    public static String translateXPathVar(String startIdentifier, String endIdentifier, String aValue, Type aType) {
        if (aType != null && aValue != null && startIdentifier != null && endIdentifier != null) {
            int varStart = aValue.length() - 1;
            while (varStart >= 0 && (varStart = aValue.lastIndexOf(startIdentifier, varStart)) >= 0) {
                int varEnd = aValue.indexOf(endIdentifier, varStart);
                String aVarDef = aValue.substring(varStart + startIdentifier.length(), varEnd);
                Type aXType = TypePathExecuter.getInstance().getTypeForXPath(aType, aVarDef);
                String aVar = null;
                if (aXType != null) {
                    aVar = aXType.getDisplayValue();
                }
                aValue = aValue.substring(0, varStart) + aVar + aValue.substring(varEnd + endIdentifier.length());
            }
        }
        return aValue;
    }

    public static String translateVar(String startIdentifier, String endIdentifier, String aValue, Hashtable vars) {
        if (vars != null && aValue != null && startIdentifier != null && endIdentifier != null) {
            int varStart = aValue.length() - 1;
            while (varStart >= 0 && (varStart = aValue.lastIndexOf(startIdentifier, varStart)) >= 0) {
                int varEnd = aValue.indexOf(endIdentifier, varStart);
                String aVarDef = aValue.substring(varStart + startIdentifier.length(), varEnd);
                String aVar = (String)vars.get(aVarDef);
                aValue = aValue.substring(0, varStart) + aVar + aValue.substring(varEnd + endIdentifier.length());
            }
        }
        return aValue;
    }

    public static String escapeHTMLForJavaScriptVar(String previewHTML) {
        previewHTML = TextTools.replace(previewHTML, "\"", "\\\"");
        previewHTML = TextTools.replace(previewHTML, "'", "\\'");
        previewHTML = TextTools.replace(previewHTML, "\n", "");
        previewHTML = TextTools.replace(previewHTML, "\r", "");
        previewHTML = TextTools.replace(previewHTML, "\t", "");
        return previewHTML;
    }

    public static String escapeHTMLForJavaScriptQuotes(String previewHTML) {
        previewHTML = TextTools.replace(previewHTML, "\"", "\\\"");
        previewHTML = TextTools.replace(previewHTML, "'", "\\'");
        previewHTML = TextTools.replace(previewHTML, "\n", "<br/>");
        previewHTML = TextTools.replace(previewHTML, "\r", "<br/>");
        previewHTML = TextTools.replace(previewHTML, "\t", "");
        return previewHTML;
    }

    public static String encodeBase64Ziped(InputStream is) throws IOException {
        BASE64Encoder enc = new BASE64Encoder();
        int read = 0;
        byte[] data = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bos);
        while ((read = is.read(data, 0, 1024)) != -1) {
            out.write(data, 0, read);
        }
        is.close();
        out.close();
        bos.close();
        bos.flush();
        return enc.encode(bos.toByteArray());
    }

    public static String encodeBase64Ziped(byte[] value) throws IOException {
        return TextTools.encodeBase64Ziped(new ByteArrayInputStream(value));
    }

    public static byte[] decodeBase64Ziped(String value) throws IOException {
        BASE64Decoder dec = new BASE64Decoder();
        byte[] test = dec.decodeBuffer(value);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(test);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPInputStream zipIn = new GZIPInputStream(byteIn);
        byte[] rgb = new byte[1024];
        int readCounter = 0;
        while ((readCounter = zipIn.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos.toByteArray();
    }

    public static String getRequestURLPatched(String requestedURL) {
        if (requestedURL != null && requestedURL.indexOf(":80/") != -1) {
            requestedURL = TextTools.replace(requestedURL, ":80/", "/");
            requestedURL = TextTools.replace(requestedURL, "http:", "https:");
        }
        return requestedURL;
    }

    public static String applyWhiteSpaceRestriction(String newValue, int type) {
        if (newValue != null) {
            switch (type) {
                case 2: {
                    newValue = newValue.trim();
                    newValue = TextTools.replaceWhiteSpace(newValue, ' ', true);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    newValue = TextTools.replaceWhiteSpace(newValue, ' ', false);
                    break;
                }
            }
        }
        return newValue;
    }

    public static int getCharsForWidth(int width) {
        return (width + 35) / TextTools.getReferenceTextLength();
    }

    public static boolean includesAnchorHref(String captionTooltip) {
        if (captionTooltip == null) {
            return false;
        }
        return captionTooltip.indexOf("<a href") != -1;
    }

    public static String encodeAJAXDelimiter(String value) {
        String encoded = TextTools.replace(value, "&", "%26");
        encoded = TextTools.replace(encoded, "=", "%3D");
        return encoded;
    }

    public static int getWidthFromEM(String width) {
        if (width == null) {
            return -1;
        }
        if (width.toLowerCase().endsWith("em")) {
            return StringUtil.getInt(width.substring(0, width.length() - 2));
        }
        return -1;
    }

    static {
        FROM_FLOATINGNUMBER_FORMAT.setGroupingUsed(false);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        FROM_FLOATINGNUMBER_FORMAT.setDecimalFormatSymbols(symbols);
        FROM_FLOATINGNUMBER_FORMAT.setMaximumFractionDigits(340);
    }
}

